/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.tools.ant;

import java.util.ArrayList;
import org.apache.tools.ant.taskdefs.condition.Os;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PythonEnvironment {
    PYTHONCMD,
    PYTHONPATH,
    PYTHONHOME,
    DYLD_LIBRARY_PATH,
    LD_LIBRARY_PATH;


    public String getValue(String aPythonHome) {
        return this.getValue(aPythonHome, null);
    }

    public String getValue(String aPythonHome, String aPkgBasedir) {
        String theFileSeparator = System.getProperty("file.separator");
        if (aPythonHome == null) {
            aPythonHome = aPkgBasedir + theFileSeparator + ".." + theFileSeparator + "python2.4-minimal";
        }
        if (aPythonHome.trim().endsWith(theFileSeparator)) {
            aPythonHome = aPythonHome.substring(0, aPythonHome.lastIndexOf(theFileSeparator));
        }
        boolean isWindows = Os.isFamily((String)"windows");
        switch (this) {
            case PYTHONPATH: {
                if (isWindows) {
                    return "";
                }
                return "";
            }
            case PYTHONHOME: {
                if (isWindows) {
                    return "\"" + aPythonHome + "\"";
                }
                return aPythonHome;
            }
            case DYLD_LIBRARY_PATH: 
            case LD_LIBRARY_PATH: {
                if (isWindows) {
                    return "\"" + aPythonHome + theFileSeparator + "lib\"";
                }
                return aPythonHome + theFileSeparator + "lib";
            }
            case PYTHONCMD: {
                if (isWindows) {
                    return "\"" + aPythonHome + theFileSeparator + "python\"";
                }
                return aPythonHome + theFileSeparator + "bin" + theFileSeparator + "python";
            }
        }
        return "";
    }

    public static String[] getValues(String aPythonHome) {
        return PythonEnvironment.getValues(aPythonHome, null);
    }

    public static String[] getValues(String aPythonHome, String aPkgBasedir) {
        ArrayList<String> theEnvList = new ArrayList<String>();
        for (PythonEnvironment theEnv : PythonEnvironment.values()) {
            theEnvList.add((Object)((Object)theEnv) + "=" + theEnv.getValue(aPythonHome, aPkgBasedir));
        }
        return theEnvList.toArray(new String[0]);
    }
}

