/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class AsyncStompOutputHandler
implements StompOutputHandler {
    private Logger _logger = StompServer.getLogger();
    private FilterChainContext _context = null;
    private StompProtocolHandler _sph = null;
    private BridgeContext _bc = null;
    private StompBridgeResources _sbr = null;

    public AsyncStompOutputHandler(FilterChainContext ctx, StompProtocolHandler sph, BridgeContext bc) {
        this._context = ctx;
        this._sbr = StompServer.getStompBridgeResources();
        this._sph = sph;
        this._bc = bc;
    }

    @Override
    public void sendToClient(StompFrameMessage msg, FilterChainContext ctx, StompProtocolHandler sph) throws Exception {
        throw new UnsupportedOperationException("sendToClient(msg, ctx, sph)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToClient(StompFrameMessage msg) throws Exception {
        boolean closechannel = false;
        if (msg.getCommand() == StompFrameMessage.Command.ERROR && msg.isFatalERROR()) {
            closechannel = true;
        }
        try {
            this._context.write((Object)msg, true);
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException || e.getCause() instanceof ClosedChannelException) {
                StompBridgeResources stompBridgeResources = StompServer.getStompBridgeResources();
                StompServer.getStompBridgeResources();
                this._logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2000", msg.toString(), e.toString()));
                this._sph.close(true);
                throw e;
            }
        }
        finally {
            if (closechannel) {
                GrizzlyFuture<Closeable> f = this._context.getConnection().close();
                try {
                    f.get();
                }
                catch (Exception ee) {
                    this._logger.log(Level.WARNING, ee.getMessage(), ee);
                }
            }
        }
    }
}

