/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.Bridge;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.api.BridgeUtil;
import com.sun.messaging.bridge.service.stomp.StompServer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="STOMP")
@PerLookup
public class StompBridge
implements Bridge {
    private final String _type = "STOMP";
    private String _name = null;
    private Bridge.State _state = Bridge.State.STOPPED;
    private StompServer _stompServer = null;

    @Override
    public synchronized boolean start(BridgeContext bc, String[] args) throws Exception {
        if (args != null) {
            Object[] params = new String[]{BridgeUtil.toString(args), this.getType()};
            bc.logInfo(StompServer.getStompBridgeResources().getString("BSS2001", params), null);
        }
        if (this._state == Bridge.State.STARTED) {
            return true;
        }
        this._state = Bridge.State.STARTING;
        boolean inited = false;
        try {
            this._stompServer = new StompServer();
            this._stompServer.init(bc);
            inited = true;
            this._stompServer.start();
            this._state = Bridge.State.STARTED;
            return true;
        }
        catch (Exception e) {
            bc.logError(e.getMessage(), e);
            try {
                if (inited) {
                    this.stop(bc, null);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!inited) {
                this._stompServer = null;
                throw e;
            }
            throw new BridgeException(e.getMessage(), e, 201);
        }
    }

    @Override
    public void pause(BridgeContext bc, String[] args) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("pause"), this.getType()));
    }

    @Override
    public void resume(BridgeContext bc, String[] args) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("resume"), this.getType()));
    }

    @Override
    public synchronized void stop(BridgeContext bc, String[] args) throws Exception {
        if (args != null) {
            throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("stop(.., " + BridgeUtil.toString(args) + ")"), this.getType()));
        }
        if (this._stompServer == null) {
            this._state = Bridge.State.STOPPED;
            throw new IllegalStateException(StompServer.getStompBridgeResources().getKString("BSS4001", this.getType(), this.getName()));
        }
        this._state = Bridge.State.STOPPING;
        this._stompServer.stop();
        this._state = Bridge.State.STOPPED;
    }

    @Override
    public ArrayList<BridgeCmdSharedReplyData> list(BridgeContext bc, String[] args, ResourceBundle rb) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("list"), this.getType()));
    }

    @Override
    public String getType() {
        return "STOMP";
    }

    @Override
    public boolean isMultipliable() {
        return false;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Bridge.State getState() {
        return this._state;
    }

    @Override
    public Object getExportedService(String className, Properties props) throws Exception {
        throw new UnsupportedOperationException(StompServer.getStompBridgeResources().getKString("BSS4000", String.valueOf("getExportedService"), this.getType()));
    }
}

