/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompSenderSessionImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public class StompConnection
implements ExceptionListener {
    private Logger _logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private Connection _connection = null;
    private String _connectionUID = "";
    private boolean _connectionException = false;
    private StompSenderSession _pubSession = null;
    private String _clientid = null;
    private StompBridgeResources _sbr = null;
    private Map<String, StompSubscriberSession> _subSessions = Collections.synchronizedMap(new HashMap());
    private StompTransactedSession _txSession = null;
    private StompProtocolHandler _sph = null;

    public StompConnection(BridgeContext bc, Properties jmsprop, StompProtocolHandler sph) {
        this._logger = StompServer.logger();
        this._bc = bc;
        this._jmsprop = jmsprop;
        this._sph = sph;
        this._sbr = StompServer.getStompBridgeResources();
    }

    public synchronized String connect(String login, String passcode, String clientid) throws Exception {
        if (this._connection != null) {
            throw new IllegalStateException("Unexpected " + (Object)((Object)StompFrameMessage.Command.CONNECT) + ", already connected");
        }
        if (clientid == null) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1000", login));
        } else {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1001", login, clientid));
        }
        this._connection = login != null ? this._bc.getConnectionFactory(this._jmsprop).createConnection(login, passcode) : this._bc.getConnectionFactory(this._jmsprop).createConnection();
        if (clientid != null) {
            this._clientid = clientid;
            this._connection.setClientID(clientid);
        }
        ((ConnectionImpl)this._connection)._setAppTransactedAck();
        this._connectionUID = ((ConnectionImpl)this._connection)._getConnectionID() + "[" + this._connection.getClientID() + "]";
        this._connection.start();
        this._logger.log(Level.INFO, this._sbr.getString("BSS1002", this._connectionUID, login));
        return this._connectionUID;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        String s = this._connectionUID;
        return s == null ? "" : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean check) throws Exception {
        if (check) {
            this.checkConnection();
        }
        if (this._connection != null) {
            try {
                if (this._pubSession != null) {
                    this._pubSession.close();
                    this._pubSession = null;
                }
                if (this._txSession != null) {
                    this._txSession.close();
                    this._txSession = null;
                }
                Map<String, StompSubscriberSession> map = this._subSessions;
                synchronized (map) {
                    for (String subid : this._subSessions.keySet()) {
                        StompSubscriberSession ss = this._subSessions.get(subid);
                        ss.close();
                    }
                    this._subSessions.clear();
                }
                this._connection.close();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this._connection = null;
                this._connectionException = false;
            }
            this._logger.log(Level.INFO, this._sbr.getString("BSS1003", this._connectionUID));
        } else {
            this._logger.log(Level.FINE, this._sbr.getString("BSS1004", this._connectionUID));
        }
    }

    public synchronized void beginTransactedSession(String tid) throws Exception {
        String currtid;
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            this._txSession = new StompTransactedSession(this);
        }
        if ((currtid = this._txSession.getTransactionID()) != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4002", currtid, tid));
        }
        this._txSession.setTransactionID(tid);
    }

    public synchronized void commitTransactedSession(String tid) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getTransactionID();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        this._txSession.commit();
    }

    public synchronized void abortTransactedSession(String tid) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getTransactionID();
        String lastrb = this._txSession.getLastRolledbackTID();
        if (currtid == null && lastrb != null && lastrb.equals(tid)) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1006", tid));
            return;
        }
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        this._txSession.rollback();
    }

    public synchronized StompTransactedSession getTransactedSession(String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", tid));
        }
        String currtid = this._txSession.getTransactionID();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", tid) + (currtid == null ? "" : " " + this._sbr.getString("BSS1005", currtid)));
        }
        return this._txSession;
    }

    public synchronized StompTransactedSession getTransactedSession() throws Exception {
        this.checkConnection();
        if (this._txSession == null) {
            return null;
        }
        if (this._txSession.getTransactionID() == null) {
            return null;
        }
        return this._txSession;
    }

    public synchronized StompSenderSession getSenderSession() throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (this._pubSession == null) {
            this._pubSession = new StompSenderSessionImpl(conn);
        }
        return this._pubSession;
    }

    public synchronized StompSubscriberSession createSubscriberSession(String subid, int ackMode) throws Exception {
        Connection conn = this._connection;
        this.checkConnection(conn);
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this._subSessions.get(subid);
        if (ss != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4005", subid));
        }
        ss = new StompSubscriberSession(subid, ackMode, this);
        this._subSessions.put(subid, ss);
        return ss;
    }

    public synchronized StompSubscriberSession getSubscriberSession(String subid) throws Exception {
        this.checkConnection();
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this._subSessions.get(subid);
        return ss;
    }

    public synchronized String closeSubscriber(String subid, String duraname) throws Exception {
        this.checkConnection();
        StompSubscriberSession ss = null;
        if (duraname == null) {
            ss = this._subSessions.get(subid);
            if (ss != null) {
                ss.close();
                this._subSessions.remove(subid);
                return null;
            }
        } else {
            if (this._clientid == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4006", duraname));
            }
            String dn = null;
            for (String sid : this._subSessions.keySet()) {
                ss = this._subSessions.get(sid);
                dn = ss.getDuraName();
                if (dn == null || !dn.equals(duraname)) continue;
                ss.closeSubscriber();
                ss.getJMSSession().unsubscribe(duraname);
                ss.close();
                this._subSessions.remove(sid);
                return sid;
            }
        }
        if (this._txSession != null) {
            String sid = this._txSession.closeSubscriber(subid, duraname);
            if (duraname != null) {
                return sid;
            }
            if (sid != null) {
                return sid;
            }
        } else if (duraname != null) {
            this.getSenderSession().getJMSSession().unsubscribe(duraname);
            return null;
        }
        throw new StompProtocolException(this._sbr.getKString("BSS4007", subid));
    }

    public synchronized void ackNonTransacted(String subidPrefix, String msgid) throws Exception {
        this.checkConnection();
        StompSubscriberSession ss = null;
        for (String subid : this._subSessions.keySet()) {
            if (!subid.startsWith(subidPrefix)) continue;
            ss = this._subSessions.get(subid);
            ss.ack(msgid);
            return;
        }
        throw new StompProtocolException(this._sbr.getKString("BSS4008", msgid, "subscription".toString()));
    }

    private synchronized void checkConnection() throws Exception {
        this.checkConnection(this._connection);
        if (this._connectionException) {
            this.disconnect(false);
            this._connectionException = false;
        }
    }

    private synchronized void checkConnection(Connection conn) throws Exception {
        if (conn == null) {
            throw new NotConnectedException(this._sbr.getKString("BSS4009"));
        }
    }

    @Override
    public void onException(JMSException e) {
        this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3000", this._connectionUID, e.getMessage()), e);
        this._connectionException = true;
    }

    protected StompFrameMessage toStompFrameMessage(Message jmsmsg, String subid, Session ss) throws Exception {
        return this._sph.toStompFrameMessage(jmsmsg, subid, ss);
    }
}

