/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class GetCRL
implements ASN1Value {
    public static final int unused = 0;
    public static final int keyCompromise = 1;
    public static final int cACompromise = 2;
    public static final int affiliationChanged = 3;
    public static final int superseded = 4;
    public static final int cessationOfOperation = 5;
    public static final int certificateHold = 6;
    private ANY issuerName;
    private ANY cRLName;
    private GeneralizedTime time;
    private BIT_STRING reasons;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ANY getIssuerName() {
        return this.issuerName;
    }

    public ANY getCRLName() {
        return this.cRLName;
    }

    public GeneralizedTime getTime() {
        return this.time;
    }

    public BIT_STRING getReasons() {
        return this.reasons;
    }

    private GetCRL() {
    }

    public GetCRL(ANY aNY, ANY aNY2, GeneralizedTime generalizedTime, BIT_STRING bIT_STRING) {
        if (aNY == null) {
            throw new IllegalArgumentException("issuerName parameter to GetCRL constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuerName = aNY;
        this.sequence.addElement(aNY);
        this.cRLName = aNY2;
        this.sequence.addElement(aNY2);
        this.time = generalizedTime;
        this.sequence.addElement(generalizedTime);
        this.reasons = bIT_STRING;
        bIT_STRING.setRemoveTrailingZeroes(true);
        this.sequence.addElement(bIT_STRING);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addOptionalElement(ANY.getTemplate());
            this.seqt.addOptionalElement(GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new GetCRL((ANY)sEQUENCE.elementAt(0), (ANY)sEQUENCE.elementAt(1), (GeneralizedTime)sEQUENCE.elementAt(2), (BIT_STRING)sEQUENCE.elementAt(3));
        }
    }
}

