/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TakingoverEntry {
    private static boolean DEBUG = false;
    protected String brokerID;
    protected UID storeSession;
    private boolean takeoverComplete = false;
    private Map xids = null;
    private long timeout = 0L;
    private static int DEFAULT_TAKEOVER_PENDING_TIMEOUT = 60;

    protected static int getTakeoverTimeout() {
        HAMonitorService hams = Globals.getHAMonitorService();
        if (hams == null) {
            return DEFAULT_TAKEOVER_PENDING_TIMEOUT;
        }
        int to = 2 * hams.getMonitorInterval();
        if (to < DEFAULT_TAKEOVER_PENDING_TIMEOUT) {
            return DEFAULT_TAKEOVER_PENDING_TIMEOUT;
        }
        return to;
    }

    public String toString() {
        return "brokerID=" + this.brokerID + ", storeSession=" + this.storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append("brokerID=" + this.brokerID + ", storeSession=" + this.storeSession + ", takeoverComplete=" + this.takeoverComplete + ", timeout=" + this.timeout);
        ArrayList al = null;
        Map map = this.xids;
        synchronized (map) {
            al = new ArrayList(this.xids.keySet());
        }
        sb.append(", xidsSize=" + al.size());
        for (Long xid : al) {
            XidEntry xe = (XidEntry)this.xids.get(xid);
            sb.append("\nxid - ").append(xid).append(": ").append(xe);
        }
        return "[" + sb.toString() + "]";
    }

    protected TakingoverEntry(String brokerID, UID storeSession) {
        this(brokerID, storeSession, 0);
    }

    private TakingoverEntry(String brokerID, UID storeSession, int timeout) {
        this.brokerID = brokerID;
        this.storeSession = storeSession;
        this.timeout = (long)timeout * 1000L;
        this.xids = Collections.synchronizedMap(new LinkedHashMap());
    }

    private synchronized boolean addXid(Long xid, String brokerHost, UID brokerSession, boolean timedout) {
        if (xid == null) {
            return false;
        }
        XidEntry x = (XidEntry)this.xids.get(xid);
        if (x != null) {
            if (timedout) {
                x.expire = System.currentTimeMillis();
            }
            return false;
        }
        XidEntry xe = new XidEntry(brokerHost, brokerSession, timedout);
        this.xids.put(xid, xe);
        return true;
    }

    protected synchronized boolean isTakeoverTarget(BrokerAddress ba) {
        if (!ba.getBrokerID().equals(this.brokerID) || !ba.getStoreSessionUID().equals(this.storeSession)) {
            return false;
        }
        if (this.takeoverComplete) {
            return true;
        }
        if (this.xids.size() == 0) {
            return false;
        }
        long expireTime = 0L;
        Collection c = this.xids.values();
        ArrayList l = new ArrayList(c);
        Collections.sort(l, new ExpireComparator());
        expireTime = ((XidEntry)l.get((int)0)).expire;
        if (expireTime != 0L) {
            expireTime = ((XidEntry)l.get((int)(l.size() - 1))).expire;
        }
        if (expireTime == 0L) {
            return true;
        }
        if (System.currentTimeMillis() <= expireTime) {
            return true;
        }
        if (Globals.getHAMonitorService().isTakingoverTarget(ba.getBrokerID(), ba.getStoreSessionUID())) {
            return true;
        }
        ArrayList<XidEntry> sl = new ArrayList<XidEntry>();
        XidEntry x2 = null;
        for (XidEntry x2 : l) {
            if (!x2.brokerHost.equals(ba.getMQAddress().getHost().getHostAddress())) continue;
            sl.add(x2);
        }
        if (sl.size() == 0) {
            return !this.ifOwnStoreSession(ba);
        }
        Collections.sort(sl, new SessionComparator());
        if (ba.getBrokerSessionUID().getTimestamp() <= ((XidEntry)sl.get((int)(sl.size() - 1))).brokerSession.getTimestamp()) {
            return true;
        }
        return !this.ifOwnStoreSession(ba);
    }

    private boolean ifOwnStoreSession(BrokerAddress ba) {
        try {
            if (!Globals.getSFSHAEnabled()) {
                return Globals.getStore().ifOwnStoreSession(ba.getStoreSessionUID().longValue(), ba.getBrokerID());
            }
            HAClusterManagerImpl cm = (HAClusterManagerImpl)Globals.getClusterManager();
            String owner = cm.lookupStoreSessionOwner(ba.getStoreSessionUID());
            if (owner != null && owner.equals(ba.getBrokerID())) {
                return true;
            }
        }
        catch (Exception e) {
            Globals.getLogger().log(16, e.getMessage(), e);
        }
        return false;
    }

    protected synchronized void preTakeoverDone(Long xid) {
        XidEntry x = (XidEntry)this.xids.get(xid);
        if (x == null) {
            return;
        }
        if (x.expire != 0L) {
            return;
        }
        x.expire = System.currentTimeMillis() + this.timeout;
    }

    protected synchronized boolean takeoverComplete() {
        boolean ret = this.takeoverComplete;
        this.takeoverComplete = true;
        return ret;
    }

    protected synchronized boolean takeoverAbort(Long xid) {
        XidEntry x = (XidEntry)this.xids.remove(xid);
        if (x != null) {
            x.expire = System.currentTimeMillis();
        }
        return this.xids.size() == 0;
    }

    private XidEntry getLastNotExpiredXidEntry() {
        if (this.xids.size() == 0) {
            return null;
        }
        Collection c = this.xids.values();
        ArrayList l = new ArrayList(c);
        Collections.sort(l, new ExpireComparator());
        long expireTime = ((XidEntry)l.get((int)0)).expire;
        XidEntry x = (XidEntry)l.get(l.size() - 1);
        if (expireTime != 0L) {
            expireTime = x.expire;
        }
        if (expireTime == 0L || System.currentTimeMillis() <= expireTime) {
            return x;
        }
        return null;
    }

    protected synchronized GPacket[] getNotificationGPackets() {
        List<XidEntry> hostl;
        ArrayList<GPacket> gps = new ArrayList<GPacket>();
        ClusterTakeoverInfo cti = null;
        if (this.takeoverComplete) {
            cti = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession);
            try {
                gps.add(cti.getGPacket((short)41));
            }
            catch (BrokerException e) {
                // empty catch block
            }
            return gps.toArray(new GPacket[0]);
        }
        Long xid2 = null;
        XidEntry x = null;
        LinkedHashMap<String, ArrayList<XidEntry>> hosts = new LinkedHashMap<String, ArrayList<XidEntry>>();
        for (Long xid2 : this.xids.keySet()) {
            x = (XidEntry)this.xids.get(xid2);
            boolean timedout = false;
            if (x.expire != 0L && System.currentTimeMillis() >= x.expire) {
                if (!DEBUG) continue;
                Globals.getLogger().log(8, "TakeingoverEntry.getNotificationGPacket(): ignore expired entry: " + x);
                continue;
            }
            hostl = (List)hosts.get(x.brokerHost);
            if (hostl == null) {
                hostl = new ArrayList<XidEntry>();
                hosts.put(x.brokerHost, (ArrayList<XidEntry>)hostl);
            }
            hostl.add(x);
        }
        Iterator itr1 = hosts.values().iterator();
        hostl = null;
        while (itr1.hasNext()) {
            hostl = (ArrayList<XidEntry>)itr1.next();
            if (hostl.size() == 0) continue;
            Collections.sort(hostl, new SessionComparator());
            x = (XidEntry)hostl.get(hostl.size() - 1);
            cti = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession, x.brokerHost, x.brokerSession, xid2, false, false);
            try {
                gps.add(cti.getGPacket((short)39));
            }
            catch (BrokerException e) {}
        }
        return gps.toArray(new GPacket[0]);
    }

    protected synchronized GPacket getNotificationGPacket(BrokerAddress ba) {
        if (!ba.getBrokerID().equals(this.brokerID) || !ba.getStoreSessionUID().equals(this.storeSession)) {
            return null;
        }
        ClusterTakeoverInfo cti = null;
        if (this.takeoverComplete) {
            cti = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession);
            try {
                return cti.getGPacket((short)41);
            }
            catch (BrokerException e) {
                return null;
            }
        }
        Long xid2 = null;
        XidEntry x = null;
        ArrayList<XidEntry> entries = new ArrayList<XidEntry>();
        for (Long xid2 : this.xids.keySet()) {
            x = (XidEntry)this.xids.get(xid2);
            if (!x.brokerHost.equals(ba.getMQAddress().getHost().getHostAddress())) continue;
            if (x.expire != 0L && System.currentTimeMillis() >= x.expire) {
                if (!DEBUG) continue;
                Globals.getLogger().log(8, "TakeingoverEntry.getNotificationGPacket(" + ba + "): ignore expired entry: " + x);
                continue;
            }
            entries.add(x);
        }
        if (entries.size() > 0) {
            Collections.sort(entries, new SessionComparator());
            x = (XidEntry)entries.get(entries.size() - 1);
            if (DEBUG) {
                Globals.getLogger().log(8, "TakeingoverEntry.getNotificationGPacket(" + ba + "): select entry " + x.toString() + " from " + entries.size() + " entries");
            }
            cti = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession, x.brokerHost, x.brokerSession, xid2, false);
            try {
                return cti.getGPacket((short)39);
            }
            catch (BrokerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TakingoverEntry)) {
            return false;
        }
        TakingoverEntry toe = (TakingoverEntry)obj;
        return this.brokerID.equals(toe.brokerID) && this.storeSession.equals(toe.storeSession);
    }

    public int hashCode() {
        return this.brokerID.hashCode() + (int)(this.storeSession.longValue() ^ this.storeSession.longValue() >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TakingoverEntry addTakingoverEntry(Map<TakingoverEntry, TakingoverEntry> takingoverBrokers, ClusterTakeoverInfo cti) {
        boolean exist = false;
        TakingoverEntry toe = new TakingoverEntry(cti.getBrokerID(), cti.getStoreSession(), TakingoverEntry.getTakeoverTimeout());
        Map<TakingoverEntry, TakingoverEntry> map = takingoverBrokers;
        synchronized (map) {
            TakingoverEntry v = takingoverBrokers.get(toe);
            if (v != null) {
                toe = v;
            } else {
                takingoverBrokers.put(toe, toe);
            }
            if (toe.addXid(cti.getXid(), cti.getBrokerHost(), cti.getBrokerSession(), cti.isTimedout())) {
                return toe;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeTakingoverEntry(Map<TakingoverEntry, TakingoverEntry> takingoverBrokers, ClusterTakeoverInfo cti) {
        TakingoverEntry toe = new TakingoverEntry(cti.getBrokerID(), cti.getStoreSession());
        Map<TakingoverEntry, TakingoverEntry> map = takingoverBrokers;
        synchronized (map) {
            TakingoverEntry v = takingoverBrokers.get(toe);
            if (v != null && v.takeoverAbort(cti.getXid())) {
                takingoverBrokers.remove(toe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TakingoverEntry takeoverComplete(Map<TakingoverEntry, TakingoverEntry> takingoverBrokers, ClusterTakeoverInfo cti) {
        Map<TakingoverEntry, TakingoverEntry> map = takingoverBrokers;
        synchronized (map) {
            TakingoverEntry toe = takingoverBrokers.get(new TakingoverEntry(cti.getBrokerID(), cti.getStoreSession()));
            if (toe == null) {
                toe = new TakingoverEntry(cti.getBrokerID(), cti.getStoreSession(), TakingoverEntry.getTakeoverTimeout());
                takingoverBrokers.put(toe, toe);
            }
            if (toe.takeoverComplete()) {
                return null;
            }
            return toe;
        }
    }

    public static void main(String[] args) throws Exception {
        Map<TakingoverEntry, TakingoverEntry> map = Collections.synchronizedMap(new LinkedHashMap());
        String broker1 = "broker1";
        String broker2 = "broker2";
        String broker3 = "broker3";
        String host1 = "10.133.184.56";
        String host2 = "10.133.184.56";
        String host3 = "10.133.169.141";
        UID ssuid = new UID();
        UID buid = new UID();
        Long xid1 = new Long(UniqueID.generateID(UID.getPrefix()));
        ClusterTakeoverInfo cti1 = ClusterTakeoverInfo.newInstance(broker2, ssuid, host2, buid, xid1, true);
        Thread.sleep(10L);
        buid = new UID();
        Long xid2 = new Long(UniqueID.generateID(UID.getPrefix()));
        ClusterTakeoverInfo cti2 = ClusterTakeoverInfo.newInstance(broker2, ssuid, host2, buid, xid2, true);
        Thread.sleep(10L);
        buid = new UID();
        Long xid3 = new Long(UniqueID.generateID(UID.getPrefix()));
        ClusterTakeoverInfo cti3 = ClusterTakeoverInfo.newInstance(broker2, ssuid, host2, buid, xid3, true);
        TakingoverEntry toe = TakingoverEntry.addTakingoverEntry(map, cti2);
        toe.preTakeoverDone(xid2);
        System.out.println("Added entry " + toe.toLongString());
        toe = TakingoverEntry.addTakingoverEntry(map, cti3);
        toe.preTakeoverDone(xid3);
        System.out.println("Added entry " + toe.toLongString());
        toe = TakingoverEntry.addTakingoverEntry(map, cti1);
        toe.preTakeoverDone(xid1);
        System.out.println("Added entry " + toe.toLongString());
        toe = new TakingoverEntry(broker2, ssuid);
        toe = map.get(toe);
        System.out.println("getNotificationGPackets() for " + toe.toLongString());
        GPacket[] gps = toe.getNotificationGPackets();
        for (int i = 0; i < gps.length; ++i) {
            System.out.println("returned: " + ClusterTakeoverInfo.newInstance(gps[i]).toString());
        }
        BrokerAddressImpl addr = new BrokerAddressImpl("joe-s10-3", broker2, 7677, true, broker2, ssuid, ssuid);
        System.out.println("getNotificationGPacket(" + addr + ") for " + toe.toLongString());
        GPacket gp = toe.getNotificationGPacket(addr);
        if (gp != null) {
            System.out.println("returned: " + ClusterTakeoverInfo.newInstance(gp).toString());
        } else {
            System.out.println("returned null");
        }
    }

    class SessionComparator
    implements Comparator {
        SessionComparator() {
        }

        public int compare(Object o1, Object o2) {
            XidEntry x1 = (XidEntry)o1;
            XidEntry x2 = (XidEntry)o2;
            return new Long(x1.brokerSession.getTimestamp()).compareTo(new Long(x2.brokerSession.getTimestamp()));
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    class ExpireComparator
    implements Comparator {
        ExpireComparator() {
        }

        public int compare(Object o1, Object o2) {
            XidEntry x1 = (XidEntry)o1;
            XidEntry x2 = (XidEntry)o2;
            return new Long(x1.expire).compareTo(new Long(x2.expire));
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    class XidEntry {
        String brokerHost = null;
        UID brokerSession = null;
        long expire = 0L;

        public XidEntry(String brokerHost, UID brokerSession, boolean timedout) {
            this.brokerHost = brokerHost;
            this.brokerSession = brokerSession;
            this.expire = 0L;
            if (timedout) {
                this.expire = System.currentTimeMillis();
            }
        }

        public String toString() {
            return "brokerHost=" + this.brokerHost + ", brokerSession=" + this.brokerSession + ", expire=" + this.expire;
        }
    }
}

