/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import javax.jms.JMSException;

public abstract class ConsumerReader
implements Runnable,
Traceable {
    protected Thread sessionThread = null;
    protected ProtocolHandler protocolHandler = null;
    protected ConnectionImpl connection = null;
    protected SessionQueue sessionQueue = null;
    protected boolean isSuspended = false;
    protected boolean isAlive = false;
    protected boolean isPaused = false;
    protected static int nextReaderID = 0;
    protected int readerID = 0;
    protected static final String imqConsumerReader = "imqConsumerReader-";
    protected boolean debug = Debug.debug;
    protected long timeout = 0L;

    public ConsumerReader(ConnectionImpl connection, SessionQueue readQueue) {
        this.connection = connection;
        this.sessionQueue = readQueue;
        this.readerID = ConsumerReader.getNextReaderID();
        this.init();
    }

    protected static synchronized int getNextReaderID() {
        return nextReaderID++;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void init() {
        this.protocolHandler = this.connection.getProtocolHandler();
    }

    public synchronized void start() {
        if (this.sessionThread == null) {
            if (this.debug) {
                Debug.println("starting new sessionThread ...");
            }
            this.sessionThread = new Thread(this);
            if (this.connection.hasDaemonThreads()) {
                this.sessionThread.setDaemon(true);
            }
            this.sessionThread.setName(imqConsumerReader + this.connection.getLocalID() + "-" + this.connection.getConnectionID() + "-" + this.readerID);
            this.setIsAlive(true);
            this.setIsSuspended(false);
            this.sessionThread.start();
        } else {
            if (this.debug) {
                Debug.println("sessionThread was started already ...");
            }
            this.resume();
        }
    }

    @Override
    public void run() {
        ReadOnlyPacket packet = null;
        Thread currentThread = Thread.currentThread();
        if (this.debug) {
            Debug.println("**** Consumer Reader wait timeout: " + this.timeout);
        }
        while (this.sessionThread == currentThread) {
            try {
                packet = (ReadOnlyPacket)this.sessionQueue.dequeueWait(this.timeout);
                if (this.connection.isBroken()) {
                    this.sessionThread = null;
                    this.sessionQueue.close();
                    continue;
                }
                if (packet != null) {
                    if (!this.getIsAlive()) continue;
                    if (this.debug) {
                        Debug.println(this);
                    }
                    this.deliver(packet);
                    continue;
                }
                this.deliver();
            }
            catch (Exception e) {
                if (this.connection.isBroken()) {
                    this.sessionThread = null;
                    this.sessionQueue.close();
                    continue;
                }
                if (this.connection.getRecoverInProcess()) {
                    this.sessionQueue.clear();
                    continue;
                }
                ExceptionHandler.rootLogger.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Error err) {
                this.connection.readChannel.setFatalError(err);
                return;
            }
        }
        if (this.debug) {
            Debug.println("sessionReader closed ...");
        }
    }

    protected abstract void deliver(ReadOnlyPacket var1) throws IOException, JMSException;

    protected abstract void deliver() throws IOException, JMSException;

    protected synchronized void stop() {
        if (this.debug) {
            Debug.println("session reader stopped ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void suspend() {
        if (this.debug) {
            Debug.println("session reader suspended ...");
        }
        this.setIsSuspended(true);
    }

    protected synchronized void resume() {
        if (this.debug) {
            Debug.println("session reader resumed ...");
        }
        this.setIsSuspended(false);
        this.notifyAll();
    }

    protected synchronized void close() {
        this.setIsAlive(false);
        this.setIsSuspended(false);
        this.sessionThread = null;
        this.sessionQueue.close();
    }

    protected synchronized boolean getIsSuspended() {
        return this.isSuspended;
    }

    protected synchronized boolean getIsAlive() {
        return this.isAlive;
    }

    protected synchronized void setIsSuspended(boolean state) {
        this.isSuspended = state;
    }

    protected synchronized void setIsAlive(boolean state) {
        this.isAlive = state;
    }

    protected synchronized void setIsPaused(boolean state) {
        this.isPaused = state;
    }

    protected synchronized boolean getIsPaused() {
        return this.isPaused;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("is alive: " + this.isAlive);
        ps.println("is suspended: " + this.isSuspended);
    }
}

