/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.api.LogSimpleFormatter;
import com.sun.messaging.bridge.service.jms.AsyncStartListener;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.ConnectionFactoryImpl;
import com.sun.messaging.bridge.service.jms.DMQ;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.Link;
import com.sun.messaging.bridge.service.jms.NotXAConnectionFactoryException;
import com.sun.messaging.bridge.service.jms.PooledConnectionFactory;
import com.sun.messaging.bridge.service.jms.ProviderConnectException;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnectionFactory;
import com.sun.messaging.bridge.service.jms.XAConnectionFactoryImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerAdapter;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl;
import com.sun.messaging.bridge.service.jms.tx.log.FileTxLogImpl;
import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeReader;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class JMSBridge {
    private static final String PROP_XMLURL_SUFFIX = ".xmlurl";
    private static final String PROP_LOGFILE_LIMIT_SUFFIX = ".logfile.limit";
    private static final String PROP_LOGFILE_COUNT_SUFFIX = ".logfile.count";
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    Map<Object, Object> _spcfs = Collections.synchronizedMap(new LinkedHashMap());
    LinkedHashMap<String, Object> _allCF = new LinkedHashMap();
    LinkedHashMap<String, Object> _localCFs = new LinkedHashMap();
    LinkedHashMap<String, Object> _localXACFs = new LinkedHashMap();
    LinkedHashMap<String, Link> _links = new LinkedHashMap();
    LinkedHashMap<String, DMQ> _dmqs = new LinkedHashMap();
    private static Logger _logger = null;
    private String _name = null;
    private BridgeContext _bc = null;
    private String _xmlurl = null;
    private JMSBridgeElement _jmsbridge = null;
    protected final EventNotifier _notifier = new EventNotifier();
    private TransactionManagerAdapter _tma = null;
    private TransactionManager _tm = null;
    private int _transactionTimeout = 180;
    private boolean _supportTransactionTimeout = false;
    private boolean _reset = false;
    private Object _initLock = new Object();
    public static final String BRIDGE_NAME_PROPERTY = "JMS_SUN_JMSBRIDGE_NAME";
    private ExecutorService _asyncStartExecutor = null;
    private Object _startFutureLock = new Object();
    private LinkedHashMap _startFutures = new LinkedHashMap();
    private final CountDownLatch _startLatch = new CountDownLatch(1);

    public void init(BridgeContext bc, String name, boolean reset) throws Exception {
        String counts;
        String var;
        File dir;
        this._bc = bc;
        this._name = name;
        this._reset = reset;
        Properties props = bc.getConfig();
        String domain = props.getProperty("BRIDGE_PROP_PREFIX");
        this._xmlurl = props.getProperty(domain + PROP_XMLURL_SUFFIX);
        if (this._xmlurl == null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4008", this._name, domain + PROP_XMLURL_SUFFIX));
        }
        _logger = Logger.getLogger(domain);
        if (bc.isSilentMode()) {
            _logger.setUseParentHandlers(false);
        }
        if (!(dir = new File(var = bc.getRootDir())).exists()) {
            dir.mkdirs();
        }
        String logfile = var + File.separator + "jms%g.log";
        int limit = 0;
        int count = 1;
        String limits = props.getProperty(domain + PROP_LOGFILE_LIMIT_SUFFIX);
        if (limits != null) {
            limit = Integer.parseInt(limits);
        }
        if ((counts = props.getProperty(domain + PROP_LOGFILE_COUNT_SUFFIX)) != null) {
            count = Integer.parseInt(counts);
        }
        FileHandler h = new FileHandler(logfile, limit, count, true);
        h.setFormatter(new LogSimpleFormatter(_logger));
        _logger.addHandler(h);
        _logger.log(Level.INFO, _jbr.getString("BSJ1002", this._name, domain));
        _logger.log(Level.INFO, _jbr.getString("BSJ1003", this._name, logfile) + "[" + limit + "," + count + "]");
        String lib = bc.getLibDir();
        if (lib == null) {
            throw new IllegalArgumentException("JMS bridge " + this._name + " lib dir not specified");
        }
        String dtdd = lib + File.separator + "dtd" + File.separator;
        File dtddir = new File(dtdd);
        if (!dtddir.exists()) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4009", this._name, dtdd));
        }
        String sysid = dtddir.toURI().toURL().toString();
        Object[] param = new String[]{this._name, this._xmlurl, sysid};
        _logger.log(Level.INFO, _jbr.getString("BSJ1004", param));
        JMSBridgeReader reader = new JMSBridgeReader(this._xmlurl, sysid, _logger);
        this._jmsbridge = reader.getJMSBridgeElement();
        if (!this._name.equals(this._jmsbridge.getName())) {
            Object[] eparam = new String[]{this._name, this._jmsbridge.getName(), this._xmlurl};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4010", eparam));
        }
        this.createBuiltInDMQ(this._jmsbridge);
        Map edmqs = this._jmsbridge.getDMQs();
        for (Map.Entry pair : edmqs.entrySet()) {
            if (((String)pair.getKey()).equals("built-in-dmq")) continue;
            this.createDMQ((DMQElement)pair.getValue(), this._jmsbridge);
        }
        boolean xa = false;
        Map elinks = this._jmsbridge.getLinks();
        for (Map.Entry pair : elinks.entrySet()) {
            xa |= this.createLink((LinkElement)pair.getValue(), this._jmsbridge);
        }
        if (xa) {
            TransactionManagerAdapter tma = this.getTransactionManagerAdapter();
            if (tma.registerRM()) {
                LinkedHashMap<String, Object> xacfs = new LinkedHashMap<String, Object>(this._localXACFs);
                for (Map.Entry<String, Object> pair : this._allCF.entrySet()) {
                    if (xacfs.get(pair.getKey()) != null || !(pair.getValue() instanceof XAConnectionFactory)) continue;
                    xacfs.put(pair.getKey(), (XAConnectionFactoryImpl)pair.getValue());
                }
                String cfref = null;
                Object cf = null;
                Map cfs = this._jmsbridge.getAllCF();
                for (Map.Entry pair : cfs.entrySet()) {
                    cfref = (String)pair.getKey();
                    if (xacfs.get(cfref) != null) continue;
                    try {
                        cf = this.createConnectionFactory((ConnectionFactoryElement)pair.getValue(), true);
                    }
                    catch (NotXAConnectionFactoryException e) {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1005", pair.getKey(), "XAConnectionFactory"));
                        continue;
                    }
                    if (cf == null) {
                        cf = new XAConnectionFactoryImpl(this._bc, this._jmsbridge.getCF(cfref).getProperties(), this._bc.isEmbeded(), cfref, ((ConnectionFactoryElement)pair.getValue()).isMultiRM());
                    }
                    xacfs.put(cfref, (XAConnectionFactoryImpl)cf);
                }
                this.registerXAResources(xacfs);
            } else {
                Link link = null;
                for (Map.Entry<String, Link> pair : this._links.entrySet()) {
                    link = pair.getValue();
                    if (!link.isTransacted()) continue;
                    link.registerXAResources();
                }
            }
        }
        this._asyncStartExecutor = Executors.newSingleThreadExecutor();
    }

    protected String getBridgeName() {
        return this._name;
    }

    protected boolean needTagBridgeName() {
        return this._jmsbridge.tagBridgeName();
    }

    protected boolean logMessageTransfer() {
        return this._jmsbridge.logMessageTransfer();
    }

    protected void tagBridgeName(Message msg, Message holder) throws Exception {
        Enumeration en = msg.getPropertyNames();
        String key = null;
        Object value = null;
        while (en != null && en.hasMoreElements()) {
            key = (String)en.nextElement();
            value = msg.getObjectProperty(key);
            holder.setObjectProperty(key, value);
        }
        msg.clearProperties();
        Exception ex = null;
        en = holder.getPropertyNames();
        while (en != null && en.hasMoreElements()) {
            key = (String)en.nextElement();
            try {
                value = holder.getObjectProperty(key);
                msg.setObjectProperty(key, value);
            }
            catch (Exception e) {
                if (ex == null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        msg.setStringProperty(BRIDGE_NAME_PROPERTY, this._name);
    }

    private boolean createLink(LinkElement el, JMSBridgeElement eb) throws Exception {
        _logger.log(Level.INFO, _jbr.getString("BSJ1006", el.getName(), eb.getName()));
        if (this._links.get(el.getName()) != null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4011", el.getName(), eb.getName()));
        }
        Properties esource = el.getSource();
        String scfref = esource.getProperty("connection-factory-ref");
        Object scf = this._allCF.get(scfref);
        if (scf == null && (scf = this.createConnectionFactory(eb.getCF(scfref), el.isTransacted())) != null) {
            this._allCF.put(scfref, scf);
        }
        String dref = esource.getProperty("destination-ref");
        Object sd = this.createDestination(eb.getDestination(dref));
        Properties etarget = el.getTarget().getAttributes();
        String tcfref = etarget.getProperty("connection-factory-ref");
        Object tcf = this._allCF.get(tcfref);
        if (tcf == null && (tcf = this.createConnectionFactory(eb.getCF(tcfref), el.isTransacted())) != null) {
            this._allCF.put(tcfref, tcf);
        }
        dref = etarget.getProperty("destination-ref");
        Object td = null;
        td = !dref.equals("AS_SOURCE") ? this.createDestination(eb.getDestination(dref)) : "AS_SOURCE";
        if (scf == null) {
            if (el.isTransacted()) {
                scf = this._localXACFs.get(scfref);
                if (scf == null) {
                    scf = new XAConnectionFactoryImpl(this._bc, eb.getCF(scfref).getProperties(), this._bc.isEmbeded(), scfref, eb.getCF(scfref).isMultiRM());
                    this._localXACFs.put(scfref, scf);
                }
            } else {
                scf = this._localCFs.get(scfref);
                if (scf == null) {
                    scf = new ConnectionFactoryImpl(this._bc, eb.getCF(scfref).getProperties(), this._bc.isEmbeded(), scfref);
                    this._localCFs.put(scfref, scf);
                }
            }
            this._allCF.put(scfref, scf);
        }
        if (tcf == null) {
            if (el.isTransacted()) {
                tcf = this._localXACFs.get(tcfref);
                if (tcf == null) {
                    tcf = new XAConnectionFactoryImpl(this._bc, eb.getCF(tcfref).getProperties(), this._bc.isEmbeded(), tcfref, eb.getCF(tcfref).isMultiRM());
                    this._localXACFs.put(tcfref, tcf);
                }
            } else {
                tcf = this._localCFs.get(tcfref);
                if (tcf == null) {
                    tcf = new ConnectionFactoryImpl(this._bc, eb.getCF(tcfref).getProperties(), this._bc.isEmbeded(), tcfref);
                    this._localCFs.put(tcfref, tcf);
                }
            }
            this._allCF.put(tcfref, tcf);
        }
        if (scf == null) {
            throw new IllegalArgumentException("Source connection factory " + scfref + " object is null");
        }
        if (tcf == null) {
            throw new IllegalArgumentException("Target connection factory " + tcfref + " object is null");
        }
        if (!((Refable)scf).getRefed().getClass().getName().startsWith("com.sun.messaging") && !((Refable)tcf).getRefed().getClass().getName().startsWith("com.sun.messaging")) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4012", ((Refable)scf).getRefed().getClass().getName(), ((Refable)tcf).getRefed().getClass().getName()));
        }
        if (scf instanceof ConnectionFactory && tcf instanceof XAConnectionFactory) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4013", scfref, tcfref));
        }
        if (scf instanceof XAConnectionFactory && tcf instanceof ConnectionFactory) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4014", scfref, tcfref));
        }
        Properties srcAttrs = el.getSource();
        Properties tgtAttrs = el.getTarget().getAttributes();
        Properties tgtProps = el.getTarget().getProperties();
        Link l = new Link();
        l.setName(el.getName());
        l.setLogger(_logger);
        l.setSourceConnectionFactory(scf);
        l.setTargetConnectionFactory(tcf);
        l.setSourceDestination(sd);
        l.setTargetDestination(td);
        l.init(el.getAttributes(), srcAttrs, tgtAttrs, tgtProps, this);
        this._links.put(el.getName(), l);
        return scf instanceof XAConnectionFactory;
    }

    private void createDMQ(DMQElement edmq, JMSBridgeElement eb) throws Exception {
        _logger.log(Level.INFO, _jbr.getKString("BSJ1007", edmq.getName(), eb.getName()));
        if (this._dmqs.get(edmq.getName()) != null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4015", edmq.getName(), eb.getName()));
        }
        String cfref = edmq.getCFRef();
        Object cf = this._allCF.get(cfref);
        if (cf == null) {
            cf = this.createConnectionFactory(eb.getCF(cfref), false);
        }
        Object dest = this.createDestination(eb.getDestination(edmq.getDestinationRef()));
        if (cf == null && (cf = this._localCFs.get(cfref)) == null) {
            cf = new ConnectionFactoryImpl(this._bc, eb.getCF(cfref).getProperties(), this._bc.isEmbeded(), cfref);
            this._localCFs.put(cfref, cf);
        }
        if (cf instanceof XAConnectionFactory) {
            Object[] eparam = new String[]{"XAConnectionFactory", cf.getClass().getName(), cfref, edmq.getName()};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4016", eparam));
        }
        Properties dmqAttrs = edmq.getAttributes();
        DMQ dmq = new DMQ();
        dmq.setName(edmq.getName());
        dmq.setLogger(_logger);
        dmq.setConnectionFactory(cf);
        dmq.setDestination(dest);
        dmq.init(edmq.getAttributes(), edmq.getProperties(), this);
        this._dmqs.put(edmq.getName(), dmq);
    }

    private void createBuiltInDMQ(JMSBridgeElement eb) throws Exception {
        DMQElement edmq = eb.getBuiltInDMQ();
        String name = edmq.getName();
        _logger.log(Level.INFO, _jbr.getString("BSJ1008", name, eb.getName()));
        AutoDestination dest = new AutoDestination("imq.bridge.jms.dmq", true);
        ConnectionFactoryImpl cf = new ConnectionFactoryImpl(this._bc, edmq.getProperties(), true, this._bc.isEmbeded(), "built-in-dmq");
        if (cf instanceof XAConnectionFactory) {
            Object[] eparam = new String[]{"XAConnectionFactory", cf.getClass().getName(), name, name};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4016", eparam));
        }
        DMQ dmq = new DMQ();
        dmq.setName(name);
        dmq.setLogger(_logger);
        dmq.setConnectionFactory(cf);
        dmq.setDestination(dest);
        dmq.init(edmq.getAttributes(), edmq.getProperties(), this);
        this._dmqs.put(name, dmq);
    }

    private Object createConnectionFactory(ConnectionFactoryElement ecf, boolean transacted) throws Exception {
        String lookup;
        Properties props = ecf.getProperties();
        if (props == null) {
            props = new Properties();
        }
        if ((lookup = ecf.getLookupName()) == null) {
            return null;
        }
        _logger.log(Level.INFO, _jbr.getString("BSJ1009", lookup, ecf.getRefName()));
        InitialContext cxt = new InitialContext(props);
        Object o = cxt.lookup(lookup);
        if (o == null) {
            Object[] eparam = new String[]{lookup, "connection-factory".toString(), ecf.getRefName()};
            throw new NamingException(_jbr.getKString("BSJ4020", eparam));
        }
        if (o instanceof XAConnectionFactory) {
            if (!transacted) {
                Object[] eparam = new String[]{"ConnectionFactory", ecf.getRefName(), o.getClass().getName()};
                throw new IllegalArgumentException(_jbr.getKString("BSJ4017", eparam));
            }
            return new XAConnectionFactoryImpl((XAConnectionFactory)o, ecf.getRefName(), ecf.isMultiRM());
        }
        if (o instanceof ConnectionFactory) {
            if (transacted) {
                Object[] eparam = new String[]{"XAConnectionFactory", ecf.getRefName(), o.getClass().getName()};
                throw new NotXAConnectionFactoryException(_jbr.getKString("BSJ4017", eparam));
            }
            return new ConnectionFactoryImpl((ConnectionFactory)o, ecf.getRefName());
        }
        if (transacted) {
            Object[] eparam = new String[]{"XAConnectionFactory", ecf.getRefName(), o.getClass().getName()};
            throw new NotXAConnectionFactoryException(_jbr.getKString("BSJ4017", eparam));
        }
        Object[] eparam = new String[]{"ConnectionFactory", ecf.getRefName(), o.getClass().getName()};
        throw new IllegalArgumentException(_jbr.getKString("BSJ4017", eparam));
    }

    public Object createDestination(String dref) throws Exception {
        return this.createDestination(this._jmsbridge.getDestination(dref));
    }

    private Object createDestination(DestinationElement ed) throws Exception {
        String lookup;
        Properties props = ed.getProperties();
        if (props == null) {
            props = new Properties();
        }
        if ((lookup = ed.getLookupName()) == null) {
            String name = ed.getName();
            if (name == null) {
                Object[] eparam = new String[]{"lookup-name", "name", ed.getRefName(), this._xmlurl};
                throw new IllegalArgumentException(_jbr.getKString("BSJ4018", eparam));
            }
            return new AutoDestination(name, ed.isQueue());
        }
        _logger.log(Level.INFO, _jbr.getKString("BSJ1010", lookup, ed.getRefName()));
        InitialContext cxt = new InitialContext(props);
        Destination o = (Destination)cxt.lookup(lookup);
        if (o == null) {
            Object[] eparam = new String[]{lookup, "destination".toString(), ed.getRefName()};
            throw new NamingException(_jbr.getKString("BSJ4020", eparam));
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStartFuture(String cmd, String linkName, boolean cancelWait) throws Exception {
        Object object = this._startFutureLock;
        synchronized (object) {
            if (this._startFutures.size() > 0) {
                String[] keys = this._startFutures.keySet().toArray(new String[0]);
                Future future = (Future)this._startFutures.get(keys[0]);
                if (future.isDone()) {
                    this._startFutures.remove(keys[0]);
                    this.checkStartFuture(cmd, linkName, cancelWait);
                }
                String oldreq = _jbr.getString("BSJ0010") + (keys[0].equals(BRIDGE_NAME_PROPERTY) ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + keys[0]);
                String newreq = cmd + (linkName == null ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + linkName);
                if (cancelWait && future.cancel(true)) {
                    _logger.log(Level.WARNING, _jbr.getKString("BSJ2024", oldreq));
                }
                String emsg = _jbr.getKString("BSJ2023", newreq, oldreq);
                _logger.log(Level.WARNING, emsg);
                throw new RejectedExecutionException(emsg);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(String linkName, AsyncStartListener asl) throws Exception {
        Object object = this._startFutureLock;
        synchronized (object) {
            String cmd = _jbr.getString("BSJ0010");
            this.checkStartFuture(cmd, linkName, false);
            Starter starter = new Starter(linkName, this, asl);
            try {
                starter.setAsync(false);
                starter.call();
                return true;
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof ProviderConnectException) && !(e instanceof ProviderConnectException)) {
                    throw e;
                }
                String req = cmd + (linkName == null ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + linkName);
                _logger.log(Level.INFO, _jbr.getKString("BSJ1076", req, "ProviderConnectException"));
                starter.setAsync(true);
                Future<Void> future = this._asyncStartExecutor.submit(starter);
                if (linkName != null) {
                    this._startFutures.put(linkName, future);
                } else {
                    this._startFutures.put(BRIDGE_NAME_PROPERTY, future);
                }
                try {
                    this._startLatch.await();
                }
                catch (InterruptedException e2) {
                    _logger.log(Level.WARNING, "Waiting for async start task to run interrupted ");
                    throw e2;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BridgeCmdSharedReplyData> list(String linkName, ResourceBundle rb, boolean all) throws Exception {
        ArrayList<BridgeCmdSharedReplyData> replys = new ArrayList<BridgeCmdSharedReplyData>();
        BridgeCmdSharedReplyData reply = new BridgeCmdSharedReplyData(5, 3, "-");
        Object[] oneRow = new String[]{rb.getString("BS1004"), rb.getString("BS1005"), rb.getString("BS1006"), rb.getString("BS1007"), rb.getString("BS1008")};
        reply.addTitle((String[])oneRow);
        Link l = null;
        if (linkName != null) {
            l = this._links.get(linkName);
            if (l == null || !l.isEnabled()) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", linkName, this._name));
            }
            oneRow[0] = l.getName();
            oneRow[1] = l.getState().toString();
            oneRow[2] = l.getSourceString();
            oneRow[3] = l.getTargetString();
            oneRow[4] = String.valueOf(l.isTransacted());
            reply.add(oneRow);
            replys.add(reply);
            if (!all) {
                return replys;
            }
            if (l.isTransacted()) {
                BridgeCmdSharedReplyData rep = new BridgeCmdSharedReplyData(1, 3, "-");
                Object[] toneRow = new String[]{rb.getString("BS1009")};
                rep.addTitle((String[])toneRow);
                if (this._tma != null) {
                    try {
                        String[] txns = this._tma.getAllTransactions();
                        if (txns != null) {
                            for (int i = 0; i < txns.length; ++i) {
                                toneRow[0] = txns[i];
                                rep.add(toneRow);
                            }
                        }
                    }
                    catch (Exception e) {
                        _logger.log(Level.WARNING, _jbr.getKString("BSJ2009", this._name));
                    }
                }
                replys.add(rep);
            }
            return replys;
        }
        Link[] ls = null;
        LinkedHashMap<String, Link> toneRow = this._links;
        synchronized (toneRow) {
            ls = this._links.values().toArray(new Link[0]);
        }
        for (int i = 0; i < ls.length; ++i) {
            l = ls[i];
            if (!l.isEnabled()) continue;
            oneRow[0] = l.getName();
            oneRow[1] = l.getState().toString();
            oneRow[2] = l.getSourceString();
            oneRow[3] = l.getTargetString();
            oneRow[4] = String.valueOf(l.isTransacted());
            reply.add(oneRow);
        }
        replys.add(reply);
        if (!all) {
            return replys;
        }
        BridgeCmdSharedReplyData pcfreply = new BridgeCmdSharedReplyData(7, 3, "-", 1);
        pcfreply.setTitleAlign(1);
        Object[] poneRow = new String[]{rb.getString("BS1010"), "XA", rb.getString("BS1011"), rb.getString("BS1012"), rb.getString("BS1013"), rb.getString("BS1015"), rb.getString("BS1017")};
        pcfreply.addTitle((String[])poneRow);
        poneRow[0] = "ConnectionFactory";
        poneRow[1] = "";
        poneRow[2] = "";
        poneRow[3] = "";
        poneRow[4] = rb.getString("BS1014");
        poneRow[5] = rb.getString("BS1016");
        poneRow[6] = rb.getString("BS1018");
        pcfreply.addTitle((String[])poneRow);
        BridgeCmdSharedReplyData scfreply = new BridgeCmdSharedReplyData(6, 3, "-", 1);
        scfreply.setTitleAlign(1);
        Object[] soneRow = new String[]{rb.getString("BS1019"), "XA", rb.getString("BS1020"), rb.getString("BS1013"), rb.getString("BS1015"), rb.getString("BS1017")};
        scfreply.addTitle((String[])soneRow);
        soneRow[0] = "ConnectionFactory";
        soneRow[1] = "";
        soneRow[2] = rb.getString("BS1021");
        soneRow[3] = rb.getString("BS1014");
        soneRow[4] = rb.getString("BS1016");
        soneRow[5] = rb.getString("BS1018");
        scfreply.addTitle((String[])soneRow);
        Object[] spcfs = null;
        Map<Object, Object> map = this._spcfs;
        synchronized (map) {
            spcfs = this._spcfs.values().toArray();
        }
        PooledConnectionFactory pcf = null;
        SharedConnectionFactory scf = null;
        for (int i = 0; i < spcfs.length; ++i) {
            if (spcfs[i] instanceof PooledConnectionFactory) {
                pcf = (PooledConnectionFactory)spcfs[i];
                poneRow[0] = ((Refable)pcf.getCF()).getRef();
                poneRow[1] = String.valueOf(pcf.getCF() instanceof XAConnectionFactory);
                poneRow[2] = String.valueOf(pcf.getNumInUseConns());
                poneRow[3] = String.valueOf(pcf.getNumIdleConns());
                poneRow[4] = String.valueOf(pcf.getIdleTimeout());
                poneRow[5] = String.valueOf(pcf.getMaxRetries());
                poneRow[6] = String.valueOf(pcf.getRetryInterval());
                pcfreply.add(poneRow);
                continue;
            }
            if (!(spcfs[i] instanceof SharedConnectionFactory)) continue;
            scf = (SharedConnectionFactory)spcfs[i];
            soneRow[0] = ((Refable)scf.getCF()).getRef();
            soneRow[1] = String.valueOf(scf.getCF() instanceof XAConnectionFactory);
            soneRow[2] = String.valueOf(scf.getRefCount());
            soneRow[3] = String.valueOf(scf.getIdleTimeout());
            soneRow[4] = String.valueOf(scf.getMaxRetries());
            soneRow[5] = String.valueOf(scf.getRetryInterval());
            scfreply.add(soneRow);
        }
        if (pcfreply != null) {
            replys.add(pcfreply);
        }
        if (scfreply != null) {
            replys.add(scfreply);
        }
        return replys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLinks() {
        Link[] ls = null;
        LinkedHashMap<String, Link> linkedHashMap = this._links;
        synchronized (linkedHashMap) {
            ls = this._links.values().toArray(new Link[0]);
        }
        int n = 0;
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].isEnabled()) continue;
            ++n;
        }
        return n;
    }

    public void pause(String linkName) throws Exception {
        String cmd = _jbr.getString("BSJ0014");
        this.checkStartFuture(cmd, linkName, false);
        this.internalPause(linkName);
    }

    private synchronized void internalPause(String linkName) throws Exception {
        if (linkName != null) {
            Link l = this._links.get(linkName);
            if (l == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", linkName, this._name));
            }
            l.pause();
            return;
        }
        for (Map.Entry<String, Link> pair : this._links.entrySet()) {
            try {
                pair.getValue().pause();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3005", pair.getKey(), this._name), e);
                throw e;
            }
        }
    }

    public void resume(String linkName) throws Exception {
        String cmd = _jbr.getString("BSJ0009");
        this.checkStartFuture(cmd, linkName, false);
        this.internalResume(linkName);
    }

    private synchronized void internalResume(String linkName) throws Exception {
        if (linkName != null) {
            Link l = this._links.get(linkName);
            if (l == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", linkName, this._name));
            }
            l.resume(true);
            return;
        }
        for (Map.Entry<String, Link> pair : this._links.entrySet()) {
            try {
                pair.getValue().resume(true);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3006", pair.getKey(), this._name), e);
                throw e;
            }
        }
    }

    public void stop(String linkName) throws Exception {
        String cmd = _jbr.getString("BSJ0015");
        this.checkStartFuture(cmd, linkName, true);
        this.internalStop(linkName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalStop(String linkName, boolean stayInited) throws Exception {
        if (linkName != null) {
            Link l = this._links.get(linkName);
            if (l == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", linkName, this._name));
            }
            l.stop(stayInited);
            return;
        }
        this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
        for (Map.Entry<String, Link> entry : this._links.entrySet()) {
            try {
                this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
                entry.getValue().stop();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3007", entry.getKey(), this._name), e);
            }
        }
        for (Map.Entry<String, Object> entry : this._dmqs.entrySet()) {
            try {
                this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
                ((DMQ)entry.getValue()).stop();
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3008", entry.getKey(), this._name), t);
            }
        }
        for (Map.Entry<Object, Object> entry : this._spcfs.entrySet()) {
            try {
                Object o = entry.getValue();
                if (o instanceof PooledConnectionFactory) {
                    ((PooledConnectionFactory)o).close();
                    continue;
                }
                if (!(o instanceof SharedConnectionFactory)) continue;
                ((SharedConnectionFactory)o).close();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2010", entry.getKey()), e);
            }
        }
        this._spcfs.clear();
        if (stayInited) {
            return;
        }
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                try {
                    this._tma.shutdown();
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, _jbr.getKString("BSJ2011", throwable.getMessage()), throwable);
                }
            }
        }
    }

    public Connection obtainConnection(Object cf, String logstr, Object caller) throws Exception {
        return this.obtainConnection(cf, logstr, caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Object cf, String logstr, Object caller, boolean doReconnect) throws Exception {
        Object[] param;
        Object spcf = null;
        Connection c = null;
        Map<Object, Object> map = this._spcfs;
        synchronized (map) {
            spcf = this._spcfs.get(cf);
            if (spcf == null) {
                Properties attrs = this._jmsbridge.getCF(((Refable)cf).getRef()).getAttributes();
                EventListener l = new EventListener(caller);
                try {
                    this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, l);
                    this._notifier.addEventListener(EventListener.EventType.LINK_STOP, l);
                    c = JMSBridge.openConnection(cf, attrs, logstr, caller, l, _logger);
                }
                finally {
                    this._notifier.removeEventListener(l);
                }
                try {
                    if (c.getClientID() == null) {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1011", ((Refable)cf).getRef()));
                        spcf = new PooledConnectionFactory(cf, attrs, _logger);
                    } else {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1012", ((Refable)cf).getRef()));
                        spcf = new SharedConnectionFactory(cf, attrs, _logger);
                    }
                    this._spcfs.put(cf, spcf);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, _jbr.getKString("BSJ3009", ((Refable)cf).getRef(), e.getMessage()));
                    try {
                        c.close();
                        c = null;
                    }
                    catch (Exception e1) {
                        _logger.log(Level.FINE, "Exception in closing connection from connection factory" + ((Refable)cf).getRef() + ": " + e1.getMessage());
                    }
                    throw e;
                }
            }
        }
        if (spcf instanceof PooledConnectionFactory) {
            param = new String[]{spcf.toString(), logstr, caller.toString()};
            _logger.log(Level.INFO, _jbr.getString("BSJ1013", param));
            return ((PooledConnectionFactory)spcf).obtainConnection(c, logstr, caller, doReconnect);
        }
        param = new String[]{spcf.toString(), logstr, caller.toString()};
        _logger.log(Level.INFO, _jbr.getString("BSJ1014", param));
        return ((SharedConnectionFactory)spcf).obtainConnection(c, logstr, caller, doReconnect);
    }

    public void returnConnection(Connection c, Object cf) throws Exception {
        Object spcf = this._spcfs.get(cf);
        if (spcf == null) {
            throw new IllegalStateException("Nowhere to return connection " + c + " from connection factory " + cf);
        }
        if (spcf instanceof PooledConnectionFactory) {
            _logger.log(Level.INFO, _jbr.getString("BSJ1015", spcf.toString()));
            ((PooledConnectionFactory)spcf).returnConnection(c);
        } else if (spcf instanceof SharedConnectionFactory) {
            _logger.log(Level.INFO, _jbr.getString("BSJ1016", spcf.toString()));
            ((SharedConnectionFactory)spcf).returnConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toDMQ(Message msg, String mid, DMQ.DMQReason reason, Throwable ex, Link l) throws Exception {
        DMQ.logMessage(msg, mid, l, _logger);
        DMQ[] dmqs = null;
        LinkedHashMap<String, DMQ> linkedHashMap = this._dmqs;
        synchronized (linkedHashMap) {
            dmqs = this._dmqs.values().toArray(new DMQ[0]);
        }
        Exception ee = null;
        boolean sent = false;
        for (int i = 0; i < dmqs.length; ++i) {
            Object[] param = new String[]{mid, dmqs[i].toString(), l.toString()};
            try {
                _logger.log(Level.INFO, _jbr.getString("BSJ1017", param));
                dmqs[i].sendMessage(msg, mid, reason, ex, l);
                sent = true;
                _logger.log(Level.INFO, _jbr.getString("BSJ1018", param));
                if (!dmqs[i].getName().equals("built-in-dmq")) break;
                continue;
            }
            catch (Exception e) {
                ee = e;
                _logger.log(Level.WARNING, _jbr.getString("BSJ2012", param), e);
            }
        }
        if (sent) {
            return;
        }
        throw ee;
    }

    protected Properties getCFAttributes(Object cf) throws Exception {
        if (((Refable)cf).getRef().equals("built-in-dmq")) {
            return new Properties();
        }
        return this._jmsbridge.getCF(((Refable)cf).getRef()).getAttributes();
    }

    public static Connection openConnection(Object cf, Properties attrs, String logstr, Object caller, EventListener l, Logger logger) throws Exception {
        return JMSBridge.openConnection(cf, attrs, logstr, caller, l, logger, false);
    }

    public static Connection openConnection(Object cf, Properties attrs, String logstr, Object caller, EventListener l, Logger logger, boolean doReconnect) throws Exception {
        int maxAttempts = 0;
        long attemptInterval = 0L;
        String val = attrs.getProperty("connect-attempts", "-1");
        if (val != null) {
            maxAttempts = Integer.valueOf(val);
        }
        if ((val = attrs.getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            attemptInterval = Integer.valueOf(val).intValue();
        }
        if (attemptInterval < 0L) {
            attemptInterval = 0L;
        }
        attemptInterval *= 1000L;
        String username = null;
        String password = null;
        val = attrs.getProperty("username");
        if (val != null) {
            username = val.trim();
            password = attrs.getProperty("password");
        }
        return JMSBridge.openConnection(cf, maxAttempts, attemptInterval, username, password, logstr, caller, l, logger, doReconnect);
    }

    public static Connection openConnection(Object cf, int maxAttempts, long attemptInterval, String username, String password, String logstr, Object caller, EventListener l, Logger logger) throws Exception {
        return JMSBridge.openConnection(cf, maxAttempts, attemptInterval, username, password, logstr, caller, l, logger, false);
    }

    public static Connection openConnection(Object cf, int maximumAttempts, long attemptInterval, String username, String password, String logstr, Object caller, EventListener l, Logger logger, boolean doReconnect) throws Exception {
        if (l.hasEventOccurred()) {
            throw new JMSException("" + (Object)((Object)l.occurredEvent()));
        }
        int maxAttempts = maximumAttempts;
        Connection conn = null;
        int attempts = 0;
        JMSException ee = null;
        int invalidClientIDExceptionCnt = 0;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException(_jbr.getKString("BSJ4037", cf.toString(), caller.toString()));
            }
            if (attempts > 0 && attemptInterval > 0L) {
                Thread.sleep(attemptInterval);
            }
            try {
                Object[] param = new String[]{username == null ? "" : "[" + username + "]", cf.toString(), caller.toString()};
                if (cf instanceof XAConnectionFactory) {
                    logger.log(Level.INFO, _jbr.getString("BSJ1019", param));
                    conn = username == null ? ((XAConnectionFactory)cf).createXAConnection() : ((XAConnectionFactory)cf).createXAConnection(username, password);
                } else {
                    logger.log(Level.INFO, _jbr.getString("BSJ1020", param));
                    conn = username == null ? ((ConnectionFactory)cf).createConnection() : ((ConnectionFactory)cf).createConnection(username, password);
                }
                return conn;
            }
            catch (JMSException e) {
                Object[] eparam;
                ++attempts;
                ee = e;
                Exception le = e.getLinkedException();
                if (e instanceof InvalidClientIDException) {
                    ++invalidClientIDExceptionCnt;
                }
                if (e instanceof JMSSecurityException || le instanceof JMSSecurityException || e instanceof InvalidClientIDException && invalidClientIDExceptionCnt > 1) {
                    eparam = new String[]{logstr, caller.toString(), attempts + "(" + attemptInterval + ")"};
                    _logger.log(Level.SEVERE, _jbr.getKString("BSJ2013", eparam), e);
                    throw e;
                }
                eparam = new String[]{logstr, caller.toString(), attempts + "(" + attemptInterval + "): " + e.getMessage() + (le == null ? "" : " - " + le.getMessage())};
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2013", eparam));
                if (doReconnect || maxAttempts <= 1 && maxAttempts >= 0) continue;
                throw new ProviderConnectException("Failed to connect to " + cf + ": " + e.getMessage() + (le == null ? "" : " - " + le.getMessage()));
                if ((maxAttempts < 0 || attempts < maxAttempts) && !l.hasEventOccurred()) continue;
                if (l.hasEventOccurred()) {
                    throw new JMSException("" + (Object)((Object)l.occurredEvent()));
                }
                throw ee;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tm != null) {
                return this._tm;
            }
            this.initTransactionManager();
            return this._tm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManagerAdapter getTransactionManagerAdapter() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                return this._tma;
            }
            this.initTransactionManager();
            return this._tma;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransactionManager() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                return;
            }
            String c = this._bc.getTransactionManagerClass();
            if (c == null) {
                c = "com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl";
            }
            _logger.log(Level.INFO, _jbr.getString("BSJ1021", c.toString()));
            Class<?> cs = Class.forName(c);
            this._tma = (TransactionManagerAdapter)cs.newInstance();
            this._tma.setLogger(_logger);
            Properties props = this._bc.getTransactionManagerProps();
            if (props == null) {
                props = new Properties();
            }
            if (this._tma instanceof TransactionManagerImpl) {
                props.setProperty("tmname", this._bc.getIdentityName() + ":" + this._name);
                props.setProperty("txlogDir", this._bc.getRootDir());
                props.setProperty("txlogSuffix", this._name);
                props.setProperty("jmsbridge", this._name);
                if (this._bc.isJDBCStoreType()) {
                    props.setProperty("txlogType", "jdbc");
                    ((TransactionManagerImpl)this._tma).setJDBCStore((JMSBridgeStore)this._bc.getJDBCStore("JMS"));
                }
                this._supportTransactionTimeout = false;
            }
            _logger.log(Level.INFO, _jbr.getString("BSJ1022", props.toString()));
            this._tma.init(props, this._reset);
            this._tm = this._tma.getTransactionManager();
            if (!(this._tma instanceof TransactionManagerImpl)) {
                _logger.log(Level.INFO, _jbr.getString("BSJ1023", this._transactionTimeout));
                this._tm.setTransactionTimeout(this._transactionTimeout);
                this._supportTransactionTimeout = true;
            }
        }
    }

    public int getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public boolean supportTransactionTimeout() {
        return this._supportTransactionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerXAResources(Map<String, ? extends Object> cfs) throws Exception {
        TransactionManagerAdapter tma = this.getTransactionManagerAdapter();
        if (!tma.registerRM()) {
            return;
        }
        String cfref = null;
        Object cf = null;
        Connection conn = null;
        for (Map.Entry<String, ? extends Object> pair : cfs.entrySet()) {
            cfref = pair.getKey();
            cf = pair.getValue();
            if (!(cf instanceof XAConnectionFactory)) continue;
            if (((Refable)cf).isMultiRM()) {
                _logger.log(Level.INFO, _jbr.getString("BSJ1024", "multi-rm", cfref.toString()));
                continue;
            }
            Object xar = null;
            EventListener l = new EventListener(this);
            try {
                String username = this._jmsbridge.getCF(((Refable)cf).getRef()).getUsername();
                String password = this._jmsbridge.getCF(((Refable)cf).getRef()).getPassword();
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, l);
                conn = (XAConnection)JMSBridge.openConnection(cf, 1, 0L, username, password, "", this, l, _logger);
                XASession ss = conn.createXASession();
                xar = ss.getXAResource();
                _logger.log(Level.INFO, _jbr.getString("BSJ1025", cfref.toString(), xar.toString()));
                tma.registerRM(cfref, (XAResource)xar);
            }
            catch (Throwable t) {
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2014", cfref.toString(), xar == null ? "" : xar.toString()), t);
            }
            finally {
                this._notifier.removeEventListener(l);
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String toString() {
        return "jmsbridge(" + this._name + ")";
    }

    public static Object exportJMSBridgeStoreService(Properties props) throws Exception {
        String bname = props.getProperty("jmsbridge");
        String instanceRootDir = props.getProperty("instanceRootDir");
        String reset = props.getProperty("reset", "true");
        String logdomain = props.getProperty("logdomain");
        if (instanceRootDir == null) {
            throw new IllegalArgumentException("instanceRootDir not found in " + props);
        }
        if (logdomain == null) {
            throw new IllegalArgumentException("logdomain property not found in " + props);
        }
        String rootDir = instanceRootDir + File.separator + "bridges";
        props.setProperty("txlogDirParent", rootDir);
        boolean doreset = Boolean.valueOf(reset);
        File dir = new File(rootDir);
        if (doreset && bname == null) {
            if (dir.exists() && !dir.renameTo(new File(rootDir + ".save"))) {
                throw new IOException("Unable to rename existing directory " + rootDir + " to " + rootDir + ".save");
            }
            return null;
        }
        if (bname == null) {
            if (!dir.exists()) {
                return null;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                throw new IOException("Can't list files in " + rootDir);
            }
            if (files.length == 0) {
                return null;
            }
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                bname = files[i].getName();
                break;
            }
            if (bname == null) {
                return null;
            }
            props.setProperty("jmsbridge", bname);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Logger logger = Logger.getLogger(logdomain);
        props.setProperty("txlogDir", rootDir);
        props.setProperty("tmname", props.getProperty("identityName") + ":" + bname);
        props.setProperty("txlogSuffix", bname);
        String txlogDir = rootDir + File.separator + bname;
        props.setProperty("txlogDir", txlogDir);
        dir = new File(txlogDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String logfile = dir + File.separator + "jms%g.log";
        FileHandler h = new FileHandler(logfile, true);
        h.setFormatter(new LogSimpleFormatter(logger));
        logger.addHandler(h);
        logger.log(Level.INFO, "Exported JMSBridgeStore txlogDir is " + txlogDir);
        logger.log(Level.INFO, "Exported JMSBridgeStore uses log domain: " + logdomain);
        logger.log(Level.INFO, "Exported JMSBridgeStore uses log file: " + logfile);
        FileTxLogImpl txlog = new FileTxLogImpl();
        txlog.setLogger(logger);
        txlog.init(props, doreset);
        return txlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JMSBridgeResources getJMSBridgeResources() {
        if (_jbr != null) return _jbr;
        Class<JMSBridge> clazz = JMSBridge.class;
        synchronized (JMSBridge.class) {
            if (_jbr != null) return _jbr;
            _jbr = JMSBridgeResources.getResources(Locale.getDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _jbr;
        }
    }

    class Starter
    implements Callable<Void> {
        private String linkName = null;
        private boolean async = true;
        private JMSBridge parent = null;
        private AsyncStartListener asl = null;

        public Starter(String linkName, JMSBridge parent, AsyncStartListener asl) {
            this.linkName = linkName;
            this.parent = parent;
            this.asl = asl;
        }

        public void setAsync(boolean b) {
            this.async = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                JMSBridge jMSBridge = this.parent;
                synchronized (jMSBridge) {
                    block44: {
                        if (this.async) {
                            JMSBridge.this._startLatch.countDown();
                        }
                        if (this.linkName == null) break block44;
                        Link l = JMSBridge.this._links.get(this.linkName);
                        if (l == null) {
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            throw new IllegalArgumentException(jMSBridgeResources.getKString("BSJ4019", this.linkName, JMSBridge.this._name));
                        }
                        l.start(this.async);
                        l.postStart();
                        Void void_ = null;
                        return void_;
                    }
                    DMQ dmq = null;
                    for (Map.Entry<String, DMQ> pair : JMSBridge.this._dmqs.entrySet()) {
                        dmq = pair.getValue();
                        try {
                            if (!dmq.isEnabled()) continue;
                            dmq.start(this.async);
                        }
                        catch (Exception e) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3002", dmq.toString(), JMSBridge.this._name), e);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && e instanceof ProviderConnectException);
                            }
                            catch (Exception e1) {
                                Logger logger2 = _logger;
                                JMSBridgeResources jMSBridgeResources2 = _jbr;
                                _jbr;
                                logger2.log(Level.WARNING, jMSBridgeResources2.getKString("BSJ2006", JMSBridge.this._name), e1);
                            }
                            throw e;
                        }
                    }
                    ArrayList<Link> list = new ArrayList<Link>();
                    Link link = null;
                    for (Map.Entry<String, Link> pair : JMSBridge.this._links.entrySet()) {
                        link = pair.getValue();
                        try {
                            if (!link.isEnabled()) continue;
                            link.start(this.async);
                            list.add(link);
                        }
                        catch (Exception e) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3003", link.toString(), JMSBridge.this._name), e);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && (e.getCause() instanceof ProviderConnectException || e instanceof ProviderConnectException));
                            }
                            catch (Exception e1) {
                                Logger logger3 = _logger;
                                JMSBridgeResources jMSBridgeResources3 = _jbr;
                                _jbr;
                                logger3.log(Level.WARNING, jMSBridgeResources3.getKString("BSJ2007", JMSBridge.this._name), e1);
                            }
                            throw e;
                        }
                    }
                    for (Link l : list) {
                        try {
                            l.postStart();
                        }
                        catch (Exception e) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3004", l.toString()), e);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && (e.getCause() instanceof ProviderConnectException || e instanceof ProviderConnectException));
                            }
                            catch (Exception e1) {
                                Logger logger4 = _logger;
                                JMSBridgeResources jMSBridgeResources4 = _jbr;
                                _jbr;
                                logger4.log(Level.WARNING, jMSBridgeResources4.getKString("BSJ2008", JMSBridge.this._name), e1);
                            }
                            throw e;
                        }
                    }
                }
                try {
                    if (this.async) {
                        this.asl.asyncStartCompleted();
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, e.getMessage());
                    try {
                        JMSBridge.this.internalStop(null, false);
                    }
                    catch (Exception e1) {
                        _logger.log(Level.WARNING, "Stop bridge " + JMSBridge.this._name + " failed: " + e1.getMessage(), e1);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (this.async) {
                    this.asl.asyncStartFailed();
                }
                throw e;
            }
            finally {
                Object object = JMSBridge.this._startFutureLock;
                synchronized (object) {
                    if (this.linkName != null) {
                        JMSBridge.this._startFutures.remove(this.linkName);
                    } else {
                        JMSBridge.this._startFutures.remove(JMSBridge.BRIDGE_NAME_PROPERTY);
                    }
                }
            }
            return null;
        }
    }
}

