/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TransactionReaper;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class TxLog {
    public static final String FILETYPE = "file";
    public static final String JDBCTYPE = "jdbc";
    public static final String FILECLASS = "com.sun.messaging.bridge.service.jms.tx.log.FileTxLogImpl";
    public static final String JDBCCLASS = "com.sun.messaging.bridge.service.jms.tx.log.JDBCTxLogImpl";
    public static final int DEFAULT_REAPLIMIT = 50;
    public static final int DEFAULT_REAPINTERVAL = 60;
    Logger _logger = null;
    private boolean _closed = false;
    private Object _closedLock = new Object();
    private int _inprogressCount = 0;
    private Object _inprogressLock = new Object();
    private TransactionReaper _reaper = null;
    private int _reapLimit = 50;
    private int _reapInterval = 60;
    protected String _tmname = null;
    protected String _jmsbridge = null;

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void init(Properties props, boolean reset) throws Exception {
        this._jmsbridge = props.getProperty("jmsbridge");
        if (this._jmsbridge == null) {
            throw new IllegalArgumentException("Property 'jmsbridge' not set");
        }
        this._tmname = props.getProperty("tmname");
        if (this._tmname == null) {
            throw new IllegalStateException("Property 'tmname' not set");
        }
        String v = props.getProperty("txlogReapLimit");
        if (v != null) {
            this._reapLimit = Integer.parseInt(v);
        }
        if ((v = props.getProperty("txlogReapInterval")) != null) {
            this._reapInterval = Integer.parseInt(v);
        }
        this._reaper = new TransactionReaper(this, this._reapLimit, this._reapInterval);
    }

    public String getTMName() {
        return this._tmname;
    }

    public abstract String getType();

    public abstract void logGlobalDecision(LogRecord var1) throws Exception;

    public abstract void logHeuristicBranch(BranchXid var1, LogRecord var2) throws Exception;

    public abstract LogRecord getLogRecord(GlobalXid var1) throws Exception;

    public abstract List getAllLogRecords() throws Exception;

    public void remove(GlobalXid gxid) throws Exception {
        this._reaper.addTransaction(gxid);
    }

    public abstract void reap(String var1) throws Exception;

    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this._closedLock;
        synchronized (object) {
            if (!this.isClosed()) {
                this._closed = true;
            }
        }
        if (this._reaper != null) {
            this._reaper.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosedAndWait() {
        Object object = this._closedLock;
        synchronized (object) {
            this._closed = true;
        }
        object = this._inprogressLock;
        synchronized (object) {
            while (this._inprogressCount > 0) {
                try {
                    this._inprogressLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClosedAndSetInProgress() throws Exception {
        Object object = this._closedLock;
        synchronized (object) {
            if (this._closed) {
                String emsg = "Accessing TM txLog after store closed";
                throw new BridgeException(emsg, 503);
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInProgress(boolean flag) {
        Object object = this._inprogressLock;
        synchronized (object) {
            this._inprogressCount = flag ? ++this._inprogressCount : --this._inprogressCount;
            if (this._inprogressCount == 0) {
                this._inprogressLock.notify();
            }
        }
    }
}

