/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ExplorerMouseAdapter;
import com.sun.messaging.jmq.admin.apps.console.ExplorerTreeCellRenderer;
import com.sun.messaging.jmq.admin.apps.console.ExplorerTreeModel;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.event.SelectionEvent;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AExplorer
extends JScrollPane
implements TreeSelectionListener {
    private ActionManager actionMgr;
    private EventListenerList aListeners = new EventListenerList();
    private JTree tree;
    private ExplorerTreeModel model;
    private Object temp;
    private DefaultMutableTreeNode root;
    private ObjStoreListCObj objStoreListCObj;
    private BrokerListCObj brokerListCObj;
    private boolean scrollToPath;

    public AExplorer(ActionManager actionMgr, ObjStoreListCObj objStoreListCObj, BrokerListCObj brokerListCObj) {
        this.objStoreListCObj = objStoreListCObj;
        this.brokerListCObj = brokerListCObj;
        this.actionMgr = actionMgr;
        this.initGui();
    }

    public void select(ConsoleObj cObj) {
        ConsoleObj node = cObj;
        this.tree.setSelectionPath(new TreePath(node.getPath()));
        SelectionEvent se = new SelectionEvent(this, 0);
        se.setSelectedObj(node);
        this.fireAdminEventDispatched(se);
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public void addObjStore(ConsoleObj objStoreCObj) {
        this.insertNewNode(this.objStoreListCObj, objStoreCObj);
    }

    public void loadObjStores(ConsoleObj[] objStoreCObj) {
    }

    public void deleteObjStore(ConsoleObj objStoreCObj) {
    }

    public void addToParent(ConsoleObj parent, ConsoleObj child) {
        this.insertNewNode(parent, child);
    }

    public void removeFromParent(ConsoleObj child) {
        if (child.getParent() != null) {
            this.model.removeNodeFromParent(child);
        }
    }

    public void addBroker(ConsoleObj brokerCObj) {
        this.insertNewNode(this.brokerListCObj, brokerCObj);
    }

    public void removeBroker() {
    }

    public void addAdminEventListener(AdminEventListener l) {
        this.aListeners.add(AdminEventListener.class, l);
    }

    public void removeAdminEventListener(AdminEventListener l) {
        this.aListeners.remove(AdminEventListener.class, l);
    }

    public void expandAll() {
        int rowCount = this.tree.getRowCount();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void collapseAll() {
        int rowCount = this.tree.getRowCount();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.collapseRow(i);
        }
    }

    public void nodeChanged(DefaultMutableTreeNode node) {
        this.model.nodeChanged(node);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            SelectionEvent se = new SelectionEvent(this, 0);
            se.setSelectedObj((ConsoleObj)node);
            this.fireAdminEventDispatched(se);
        }
    }

    private void fireAdminEventDispatched(AdminEvent ae) {
        Object[] l = this.aListeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != AdminEventListener.class) continue;
            ((AdminEventListener)l[i + 1]).adminEventDispatched(ae);
        }
    }

    private void initGui() {
        this.root = new DefaultMutableTreeNode("JMQ Administration");
        this.model = new ExplorerTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        String lineStyle = "Angled";
        this.tree.putClientProperty("JTree.lineStyle", lineStyle);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new ExplorerTreeCellRenderer());
        ExplorerMouseAdapter ml = new ExplorerMouseAdapter(this.actionMgr, this.tree);
        this.tree.addMouseListener(ml);
        this.model.insertNodeInto(this.objStoreListCObj, this.root, 0);
        this.model.insertNodeInto(this.brokerListCObj, this.root, 1);
        this.model.reload();
        this.setViewportView(this.tree);
        this.setPreferredSize(new Dimension(210, 50));
    }

    public void setScrollToPath(boolean scroll) {
        this.scrollToPath = scroll;
    }

    private void insertNewNode(ConsoleObj parent, ConsoleObj child) {
        int newIndex = this.model.getChildCount(parent);
        this.model.insertNodeInto(child, parent, newIndex);
        Enumeration<TreeNode> e = child.children();
        if (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (this.scrollToPath) {
                this.tree.scrollPathToVisible(new TreePath(node.getPath()));
            }
        }
    }
}

