/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class ActionManager {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int PREFERENCES = 4;
    public static final int EXIT = 8;
    public static final int ABOUT = 16;
    public static final int PROPERTIES = 32;
    public static final int SHUTDOWN = 64;
    public static final int RESTART = 128;
    public static final int PAUSE = 256;
    public static final int RESUME = 512;
    public static final int CONNECT = 1024;
    public static final int DISCONNECT = 2048;
    public static final int EXPAND_ALL = 4096;
    public static final int COLLAPSE_ALL = 8192;
    public static final int REFRESH = 16384;
    public static final int PURGE = 32768;
    public static final int QUERY_BROKER = 65536;
    private Hashtable actionTable = new Hashtable(20);
    private int currentlyActive = 0;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private EventListenerList aListeners = new EventListenerList();

    public ActionManager() {
        this.initActions();
    }

    public Action getAction(int actionFlag) {
        Action a = (Action)this.actionTable.get(new Integer(actionFlag));
        return a;
    }

    public void setEnabled(int actionFlag, boolean b) {
        Action a = this.getAction(actionFlag);
        if (a == null) {
            return;
        }
        if (b) {
            if (this.isActive(this.currentlyActive, actionFlag)) {
                return;
            }
            a.setEnabled(b);
            this.currentlyActive |= actionFlag;
        } else {
            if (!this.isActive(this.currentlyActive, actionFlag)) {
                return;
            }
            a.setEnabled(b);
            this.currentlyActive &= ~actionFlag;
        }
    }

    public void setActiveActions(int mask) {
        if (mask == this.currentlyActive) {
            return;
        }
        this.matchActions(mask, 1);
        this.matchActions(mask, 2);
        this.matchActions(mask, 32);
        this.matchActions(mask, 64);
        this.matchActions(mask, 128);
        this.matchActions(mask, 256);
        this.matchActions(mask, 512);
        this.matchActions(mask, 1024);
        this.matchActions(mask, 2048);
        this.matchActions(mask, 16384);
        this.matchActions(mask, 32768);
        this.matchActions(mask, 65536);
    }

    public char getCharMnemonic(int actionFlag) {
        if (actionFlag == 1) {
            return acr.getChar("A1051");
        }
        if (actionFlag == 2) {
            return acr.getChar("A1052");
        }
        if (actionFlag == 8) {
            return acr.getChar("A1041");
        }
        if (actionFlag == 16) {
            return acr.getChar("A1050");
        }
        if (actionFlag == 32) {
            return acr.getChar("A1044");
        }
        if (actionFlag == 64) {
            return acr.getChar("A1057");
        }
        if (actionFlag == 128) {
            return acr.getChar("A1058");
        }
        if (actionFlag == 256) {
            return acr.getChar("A1055");
        }
        if (actionFlag == 512) {
            return acr.getChar("A1056");
        }
        if (actionFlag == 1024) {
            return acr.getChar("A1053");
        }
        if (actionFlag == 2048) {
            return acr.getChar("A1054");
        }
        if (actionFlag == 4096) {
            return acr.getChar("A1046");
        }
        if (actionFlag == 8192) {
            return acr.getChar("A1047");
        }
        if (actionFlag == 16384) {
            return acr.getChar("A1048");
        }
        if (actionFlag == 32768) {
            return acr.getChar("A1059");
        }
        if (actionFlag == 65536) {
            return acr.getChar("A1506");
        }
        return '\u0000';
    }

    private void matchActions(int mask, int actionFlag) {
        if (this.isActive(mask, actionFlag)) {
            this.setEnabled(actionFlag, true);
        } else {
            this.setEnabled(actionFlag, false);
        }
    }

    private boolean isActive(int mask, int actionFlag) {
        return (mask & actionFlag) == actionFlag;
    }

    public void addAdminEventListener(AdminEventListener l) {
        this.aListeners.add(AdminEventListener.class, l);
    }

    public void removeAdminEventListener(AdminEventListener l) {
        this.aListeners.remove(AdminEventListener.class, l);
    }

    private void fireAdminEventDispatched(AdminEvent ae) {
        Object[] l = this.aListeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != AdminEventListener.class) continue;
            ((AdminEventListener)l[i + 1]).adminEventDispatched(ae);
        }
    }

    private void initActions() {
        AbstractAction tmpAction = new AbstractAction(acr.getString("A1127"), AGraphics.adminImages[20]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(0);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(1, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1133"), AGraphics.adminImages[21]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(1);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(2, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1120"), AGraphics.adminImages[22]){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Preferences");
            }
        };
        this.addAction(4, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1121")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleActionEvent cae = new ConsoleActionEvent(this, 4);
                ActionManager.this.fireAdminEventDispatched(cae);
            }
        };
        this.addAction(8, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1126")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleActionEvent cae = new ConsoleActionEvent(this, 0);
                ActionManager.this.fireAdminEventDispatched(cae);
            }
        };
        this.addAction(16, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1122"), AGraphics.adminImages[25]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(3);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(32, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1151"), AGraphics.adminImages[28]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(4);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(64, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1152"), AGraphics.adminImages[27]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(5);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(128, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1145"), AGraphics.adminImages[23]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(6);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(256, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1148"), AGraphics.adminImages[24]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(7);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(512, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1139"), AGraphics.adminImages[31]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(8);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(1024, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1142"), AGraphics.adminImages[33]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(9);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(2048, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1123"), AGraphics.adminImages[29]){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleActionEvent cae = new ConsoleActionEvent(this, 2);
                ActionManager.this.fireAdminEventDispatched(cae);
            }
        };
        this.addAction(4096, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1124"), AGraphics.adminImages[30]){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleActionEvent cae = new ConsoleActionEvent(this, 3);
                ActionManager.this.fireAdminEventDispatched(cae);
            }
        };
        this.addAction(8192, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1125"), AGraphics.adminImages[26]){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleActionEvent cae = new ConsoleActionEvent(this, 5);
                ActionManager.this.fireAdminEventDispatched(cae);
            }
        };
        this.addAction(16384, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1153"), AGraphics.adminImages[35]){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEvent de = new DialogEvent(this);
                de.setDialogType(2);
                ActionManager.this.fireAdminEventDispatched(de);
            }
        };
        this.addAction(32768, tmpAction);
        tmpAction = new AbstractAction(acr.getString("A1159"), AGraphics.adminImages[36]){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrokerAdminEvent bae = new BrokerAdminEvent(this, 8);
                ActionManager.this.fireAdminEventDispatched(bae);
            }
        };
        this.addAction(65536, tmpAction);
    }

    private void addAction(int actionFlag, Action a) {
        this.actionTable.put(new Integer(actionFlag), a);
        this.currentlyActive |= actionFlag;
    }
}

