/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SpecialValueField
extends JPanel
implements ActionListener {
    private JComponent comp;
    private JLabel specialValueLabel;
    private JRadioButton specialValueRB;
    private JRadioButton normalValueRB;
    private String specialValueStr;
    private boolean specialValueSet = true;

    public SpecialValueField(JComponent comp, String specialValueStr) {
        this.comp = comp;
        this.specialValueStr = specialValueStr;
        this.initGui();
        this.setSpecialValueSet(true);
    }

    public boolean isSpecialValueSet() {
        return this.specialValueSet;
    }

    public void setSpecialValueSet(boolean b) {
        if (b) {
            this.specialValueRB.setSelected(true);
            this.doSpecialValueRBSelected();
        } else {
            this.normalValueRB.setSelected(true);
            this.doNormalValueRBSelected();
        }
    }

    public JComponent getComponent() {
        return this.comp;
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.comp != null) {
            this.comp.setEnabled(b);
        }
        if (this.specialValueLabel != null) {
            this.specialValueLabel.setEnabled(b);
        }
        if (this.specialValueRB != null) {
            this.specialValueRB.setEnabled(b);
        }
        if (this.normalValueRB != null) {
            this.normalValueRB.setEnabled(b);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.specialValueRB) {
            this.doSpecialValueRBSelected();
        } else if (source == this.normalValueRB) {
            this.doNormalValueRBSelected();
        }
    }

    private void doSpecialValueRBSelected() {
        this.specialValueLabel.setEnabled(true);
        this.comp.setEnabled(false);
        this.specialValueSet = true;
    }

    private void doNormalValueRBSelected() {
        this.specialValueLabel.setEnabled(false);
        this.comp.setEnabled(true);
        this.specialValueSet = false;
    }

    private void initGui() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.anchor = 10;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.specialValueRB = new JRadioButton();
        this.specialValueRB.addActionListener(this);
        gbl.setConstraints(this.specialValueRB, gbc);
        this.add(this.specialValueRB);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        this.specialValueLabel = new JLabel(this.specialValueStr, 2);
        gbl.setConstraints(this.specialValueLabel, gbc);
        this.add(this.specialValueLabel);
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.normalValueRB = new JRadioButton();
        this.normalValueRB.addActionListener(this);
        gbl.setConstraints(this.normalValueRB, gbc);
        this.add(this.normalValueRB);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbl.setConstraints(this.comp, gbc);
        this.add(this.comp);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.specialValueRB);
        bg.add(this.normalValueRB);
    }
}

