/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SignatureSpi;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Assert;

public class Signature {
    protected SignatureAlgorithm algorithm;
    protected SignatureSpi engine;

    protected Signature() {
    }

    Signature(SignatureAlgorithm signatureAlgorithm, SignatureSpi signatureSpi) {
        this.algorithm = signatureAlgorithm;
        this.engine = signatureSpi;
    }

    public Provider getProvider() {
        Assert.notYetImplemented("Signature.getProvider");
        return null;
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException, TokenException {
        this.engine.engineInitSign(privateKey);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException, TokenException {
        this.engine.engineInitVerify(publicKey);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, TokenException {
        this.engine.engineSetParameter(algorithmParameterSpec);
    }

    public byte[] sign() throws SignatureException, TokenException {
        return this.engine.engineSign();
    }

    public int sign(byte[] byArray, int n, int n2) throws SignatureException, TokenException {
        return this.engine.engineSign(byArray, n, n2);
    }

    public boolean verify(byte[] byArray) throws SignatureException, TokenException {
        return this.engine.engineVerify(byArray);
    }

    public void update(byte by) throws SignatureException, TokenException {
        this.engine.engineUpdate(by);
    }

    public void update(byte[] byArray) throws SignatureException, TokenException {
        this.engine.engineUpdate(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException, TokenException {
        this.engine.engineUpdate(byArray, n, n2);
    }

    public String getAlgorithm() {
        return this.algorithm.toString();
    }

    public SignatureAlgorithm getAlgorithmID() {
        return this.algorithm;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

