/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TimeBase;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

public class CertificateInfo
implements ASN1Value {
    public static final Version v1 = Version.v1;
    public static final Version v2 = Version.v2;
    public static final Version v3 = Version.v3;
    static final int UTCTIME_CUTOFF_YEAR = 2049;
    private Version version = v1;
    private INTEGER serialNumber;
    private AlgorithmIdentifier signatureAlgId;
    private Name issuer;
    private Date notBefore;
    private Date notAfter;
    private Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private BIT_STRING issuerUniqueIdentifier;
    private BIT_STRING subjectUniqueIdentifier;
    private SEQUENCE extensions;
    static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CertificateInfo(Version version, INTEGER iNTEGER, AlgorithmIdentifier algorithmIdentifier, Name name, Date date, Date date2, Name name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.setVersion(version);
        this.setSerialNumber(iNTEGER);
        this.setSignatureAlgId(algorithmIdentifier);
        this.setIssuer(name);
        this.setNotBefore(date);
        this.setNotAfter(date2);
        this.setSubject(name2);
        this.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extensions = new SEQUENCE();
    }

    public void setVersion(Version version) {
        this.verifyNotNull(version);
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setSerialNumber(INTEGER iNTEGER) {
        this.verifyNotNull(iNTEGER);
        this.serialNumber = iNTEGER;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public void setSignatureAlgId(AlgorithmIdentifier algorithmIdentifier) {
        this.verifyNotNull(algorithmIdentifier);
        this.signatureAlgId = algorithmIdentifier;
    }

    public AlgorithmIdentifier getSignatureAlgId() {
        return this.signatureAlgId;
    }

    public void setIssuer(Name name) {
        this.verifyNotNull(name);
        this.issuer = name;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public void setNotBefore(Date date) {
        this.verifyNotNull(date);
        this.notBefore = date;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotAfter(Date date) {
        this.verifyNotNull(date);
        this.notAfter = date;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setSubject(Name name) {
        this.verifyNotNull(name);
        this.subject = name;
    }

    public Name getSubject() {
        return this.subject;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.verifyNotNull(subjectPublicKeyInfo);
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidBERException, IOException {
        this.verifyNotNull(publicKey);
        this.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo(publicKey));
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setIssuerUniqueIdentifier(BIT_STRING bIT_STRING) throws CertificateException {
        if (this.version == v1) {
            throw new CertificateException("issuerUniqueIdentifier cannot be specified for v1 certificate");
        }
        this.verifyNotNull(bIT_STRING);
        this.issuerUniqueIdentifier = bIT_STRING;
    }

    public boolean hasIssuerUniqueIdentifier() {
        return this.issuerUniqueIdentifier != null;
    }

    public BIT_STRING getIssuerUniqueIdentifier() {
        Assert._assert(this.issuerUniqueIdentifier != null);
        return this.issuerUniqueIdentifier;
    }

    public void setSubjectUniqueIdentifier(BIT_STRING bIT_STRING) throws CertificateException {
        if (this.version == v1) {
            throw new CertificateException("subjectUniqueIdentifier cannot be specified for v1 certificate");
        }
        this.verifyNotNull(bIT_STRING);
        this.subjectUniqueIdentifier = bIT_STRING;
    }

    public boolean hasSubjectUniqueIdentifier() {
        return this.subjectUniqueIdentifier != null;
    }

    public BIT_STRING getSubjectUniqueIdentifier() {
        Assert._assert(this.subjectUniqueIdentifier != null);
        return this.subjectUniqueIdentifier;
    }

    public boolean hasExtensions() {
        return this.extensions.size() > 0;
    }

    public SEQUENCE getExtensions() {
        return this.extensions;
    }

    public boolean isExtensionPresent(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        return this.getExtension(oBJECT_IDENTIFIER) != null;
    }

    public Extension getExtension(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        int n = this.extensions.size();
        for (int i = 0; i < n; ++i) {
            Extension extension = (Extension)this.extensions.elementAt(i);
            if (!oBJECT_IDENTIFIER.equals(extension.getExtnId())) continue;
            return extension;
        }
        return null;
    }

    public void setExtensions(SEQUENCE sEQUENCE) throws CertificateException {
        if (this.version != v3) {
            throw new CertificateException("extensions can only be added to v3 certificates");
        }
        this.verifyNotNull(sEQUENCE);
        this.extensions = sEQUENCE;
    }

    public void addExtension(Extension extension) throws CertificateException {
        if (this.version != v3) {
            throw new CertificateException("extensions can only be added to v3 certificates");
        }
        this.extensions.addElement(extension);
    }

    private void verifyNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.version != v1) {
            sEQUENCE.addElement(new EXPLICIT(new Tag(0L), new INTEGER(this.version.getNumber())));
        }
        sEQUENCE.addElement(this.serialNumber);
        sEQUENCE.addElement(this.signatureAlgId);
        sEQUENCE.addElement(this.issuer);
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addElement(CertificateInfo.encodeValidityDate(this.notBefore));
        sEQUENCE2.addElement(CertificateInfo.encodeValidityDate(this.notAfter));
        sEQUENCE.addElement(sEQUENCE2);
        sEQUENCE.addElement(this.subject);
        sEQUENCE.addElement(this.subjectPublicKeyInfo);
        if (this.issuerUniqueIdentifier != null) {
            sEQUENCE.addElement(new Tag(1L), this.issuerUniqueIdentifier);
        }
        if (this.subjectUniqueIdentifier != null) {
            sEQUENCE.addElement(new Tag(2L), this.subjectUniqueIdentifier);
        }
        if (this.extensions.size() > 0) {
            sEQUENCE.addElement(new EXPLICIT(new Tag(3L), this.extensions));
        }
        sEQUENCE.encode(tag, outputStream);
    }

    private static ASN1Value encodeValidityDate(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        if (calendar.get(1) <= 2049) {
            return new UTCTime(date);
        }
        return new GeneralizedTime(date);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void print(PrintStream printStream) throws IOException, InvalidBERException {
        printStream.println("CertificateInfo:");
        printStream.println("Version: " + this.version);
        printStream.println("Serial Number: " + this.serialNumber);
        printStream.println("Sig OID: " + this.signatureAlgId.getOID());
        printStream.println("Issuer: " + this.issuer.getRFC1485());
        printStream.println("Not Before: " + this.notBefore);
        printStream.println("Not After: " + this.notAfter);
        printStream.println("Subject: " + this.subject.getRFC1485());
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            EXPLICIT.Template template = EXPLICIT.getTemplate(new Tag(0L), INTEGER.getTemplate());
            EXPLICIT eXPLICIT = new EXPLICIT(new Tag(0L), new INTEGER(v1.getNumber()));
            this.seqt.addElement(template, eXPLICIT);
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(Name.getTemplate());
            SEQUENCE.Template template2 = new SEQUENCE.Template();
            CHOICE.Template template3 = CHOICE.getTemplate();
            template3.addElement(UTCTime.getTemplate());
            template3.addElement(GeneralizedTime.getTemplate());
            template2.addElement(template3);
            template2.addElement(template3);
            this.seqt.addElement(template2);
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(SubjectPublicKeyInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), BIT_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(2L), BIT_STRING.getTemplate());
            SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template(Extension.getTemplate());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(3L), oF_Template));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
                EXPLICIT eXPLICIT = (EXPLICIT)sEQUENCE.elementAt(0);
                Version version = Version.fromInt(((INTEGER)eXPLICIT.getContent()).intValue());
                SEQUENCE sEQUENCE2 = (SEQUENCE)sEQUENCE.elementAt(4);
                CHOICE cHOICE = (CHOICE)sEQUENCE2.elementAt(0);
                Date date = ((TimeBase)cHOICE.getValue()).toDate();
                cHOICE = (CHOICE)sEQUENCE2.elementAt(1);
                Date date2 = ((TimeBase)cHOICE.getValue()).toDate();
                CertificateInfo certificateInfo = new CertificateInfo(version, (INTEGER)sEQUENCE.elementAt(1), (AlgorithmIdentifier)sEQUENCE.elementAt(2), (Name)sEQUENCE.elementAt(3), date, date2, (Name)sEQUENCE.elementAt(5), (SubjectPublicKeyInfo)sEQUENCE.elementAt(6));
                if (sEQUENCE.elementAt(7) != null) {
                    certificateInfo.setIssuerUniqueIdentifier((BIT_STRING)sEQUENCE.elementAt(7));
                }
                if (sEQUENCE.elementAt(8) != null) {
                    certificateInfo.setSubjectUniqueIdentifier((BIT_STRING)sEQUENCE.elementAt(8));
                }
                if (sEQUENCE.elementAt(9) != null) {
                    eXPLICIT = (EXPLICIT)sEQUENCE.elementAt(9);
                    certificateInfo.setExtensions((SEQUENCE)eXPLICIT.getContent());
                }
                return certificateInfo;
            }
            catch (CertificateException certificateException) {
                throw new InvalidBERException(certificateException.getMessage());
            }
        }
    }

    public static class Version {
        int versionNumber;
        String string;
        public static final Version v1 = new Version(0, "v1");
        public static final Version v2 = new Version(1, "v2");
        public static final Version v3 = new Version(2, "v3");

        private Version() {
        }

        private Version(int n, String string) {
            this.versionNumber = n;
            this.string = string;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Version)) {
                return false;
            }
            return ((Version)object).versionNumber == this.versionNumber;
        }

        public int getNumber() {
            return this.versionNumber;
        }

        public static Version fromInt(int n) throws InvalidBERException {
            if (n == 0) {
                return v1;
            }
            if (n == 1) {
                return v2;
            }
            if (n == 2) {
                return v3;
            }
            throw new InvalidBERException("Unrecognized version number");
        }

        public String toString() {
            return this.string;
        }
    }
}

