/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.util.Assert;

public class SignerInfo
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CONTENT_TYPE = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(3L);
    private static final OBJECT_IDENTIFIER MESSAGE_DIGEST = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(4L);
    private INTEGER version;
    private SignerIdentifier signerIdentifier;
    private AlgorithmIdentifier digestAlgorithm;
    private SET signedAttributes;
    private AlgorithmIdentifier digestEncryptionAlgorithm;
    private OCTET_STRING encryptedDigest;
    private SET unsignedAttributes;
    private static final INTEGER VERSION = new INTEGER(3L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.signerIdentifier;
    }

    public DigestAlgorithm getDigestAlgorithm() throws NoSuchAlgorithmException {
        return DigestAlgorithm.fromOID(this.digestAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifer() {
        return this.digestAlgorithm;
    }

    public SET getSignedAttributes() {
        return this.signedAttributes;
    }

    public boolean hasSignedAttributes() {
        return this.signedAttributes != null;
    }

    public SignatureAlgorithm getDigestEncryptionAlgorithm() throws NoSuchAlgorithmException {
        return SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithmIdentifier() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest.toByteArray();
    }

    public SET getUnsignedAttributes() {
        return this.unsignedAttributes;
    }

    public boolean hasUnsignedAttributes() {
        return this.unsignedAttributes != null;
    }

    public SignerInfo(SignerIdentifier signerIdentifier, SET sET, SET sET2, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, byte[] byArray, SignatureAlgorithm signatureAlgorithm, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, CryptoManager.NotInitializedException, SignatureException, TokenException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.version = VERSION;
        this.signerIdentifier = signerIdentifier;
        this.digestAlgorithm = new AlgorithmIdentifier(signatureAlgorithm.getDigestAlg().toOID(), null);
        if (!oBJECT_IDENTIFIER.equals(ContentInfo.DATA)) {
            if (sET == null) {
                sET = new SET();
            }
            object4 = new Attribute(CONTENT_TYPE, oBJECT_IDENTIFIER);
            sET.addElement((ASN1Value)object4);
            object4 = new Attribute(MESSAGE_DIGEST, new OCTET_STRING(byArray));
            sET.addElement((ASN1Value)object4);
        }
        this.digestEncryptionAlgorithm = new AlgorithmIdentifier(signatureAlgorithm.getRawAlg().toOID(), null);
        if (sET != null) {
            Assert._assert(sET.size() >= 2);
            this.signedAttributes = sET;
        }
        object4 = null;
        DigestAlgorithm digestAlgorithm = signatureAlgorithm.getDigestAlg();
        if (sET == null) {
            object4 = byArray;
        } else {
            object3 = ASN1Util.encode(sET);
            object2 = MessageDigest.getInstance(digestAlgorithm.toString());
            object4 = ((MessageDigest)object2).digest((byte[])object3);
        }
        if (signatureAlgorithm.getRawAlg() == SignatureAlgorithm.RSASignature) {
            object2 = new SEQUENCE();
            object = new AlgorithmIdentifier(digestAlgorithm.toOID(), null);
            ((SET)object2).addElement((ASN1Value)object);
            ((SET)object2).addElement(new OCTET_STRING((byte[])object4));
            object3 = ASN1Util.encode((ASN1Value)object2);
        } else {
            object3 = object4;
        }
        object2 = privateKey.getOwningToken();
        object = object2.getSignatureContext(signatureAlgorithm.getRawAlg());
        ((Signature)object).initSign(privateKey);
        ((Signature)object).update((byte[])object3);
        this.encryptedDigest = new OCTET_STRING(((Signature)object).sign());
        if (sET2 != null) {
            this.unsignedAttributes = sET2;
        }
    }

    SignerInfo(INTEGER iNTEGER, SignerIdentifier signerIdentifier, AlgorithmIdentifier algorithmIdentifier, SET sET, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, SET sET2) {
        this.version = iNTEGER;
        this.signerIdentifier = signerIdentifier;
        this.digestAlgorithm = algorithmIdentifier;
        this.signedAttributes = sET;
        this.digestEncryptionAlgorithm = algorithmIdentifier2;
        this.encryptedDigest = new OCTET_STRING(byArray);
        this.unsignedAttributes = sET2;
    }

    public void verify(byte[] byArray, OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException, ObjectNotFoundException {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        if (this.signerIdentifier.getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) {
            IssuerAndSerialNumber issuerAndSerialNumber = this.signerIdentifier.getIssuerAndSerialNumber();
            X509Certificate x509Certificate = cryptoManager.findCertByIssuerAndSerialNumber(ASN1Util.encode(issuerAndSerialNumber.getIssuer()), issuerAndSerialNumber.getSerialNumber());
            this.verify(byArray, oBJECT_IDENTIFIER, x509Certificate.getPublicKey());
        } else {
            Assert._assert(this.signerIdentifier.getType().equals(SignerIdentifier.SUBJECT_KEY_IDENTIFIER));
        }
    }

    public void verify(byte[] byArray, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, PublicKey publicKey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        if (this.signedAttributes == null) {
            this.verifyWithoutSignedAttributes(byArray, oBJECT_IDENTIFIER, publicKey);
        } else {
            this.verifyWithSignedAttributes(byArray, oBJECT_IDENTIFIER, publicKey);
        }
    }

    private void verifyWithoutSignedAttributes(byte[] byArray, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, PublicKey publicKey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        byte[] byArray2;
        Object object;
        if (!oBJECT_IDENTIFIER.equals(ContentInfo.DATA)) {
            throw new SignatureException("Content-Type is not DATA, but there are no signed attributes");
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        if (signatureAlgorithm.getRawAlg() == SignatureAlgorithm.RSASignature) {
            object = new SEQUENCE();
            ((SET)object).addElement(new AlgorithmIdentifier(this.digestAlgorithm.getOID(), null));
            ((SET)object).addElement(new OCTET_STRING(byArray));
            byArray2 = ASN1Util.encode((ASN1Value)object);
        } else {
            byArray2 = byArray;
        }
        object = CryptoManager.getInstance().getInternalCryptoToken();
        Signature signature = object.getSignatureContext(signatureAlgorithm);
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (signature.verify(this.encryptedDigest.toByteArray())) {
            return;
        }
        throw new SignatureException("Encrypted message digest parameter does not match encrypted digest in SignerInfo");
    }

    private void verifyWithSignedAttributes(byte[] byArray, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, PublicKey publicKey) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, TokenException, SignatureException {
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = this.signedAttributes.size();
        if (n < 2) {
            throw new SignatureException("At least two signed attributes must be present: content-type and message-digest");
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            block22: {
                if (!(this.signedAttributes.elementAt(i) instanceof Attribute)) {
                    throw new SignatureException("Element of signedAttributes is not an Attribute");
                }
                object5 = (Attribute)this.signedAttributes.elementAt(i);
                if (((Attribute)object5).getType().equals(CONTENT_TYPE)) {
                    block21: {
                        object4 = ((Attribute)object5).getValues();
                        if (((SET)object4).size() != 1) {
                            throw new SignatureException("Content-Type attribute  does not have exactly one value");
                        }
                        object3 = ((SET)object4).elementAt(0);
                        try {
                            if (object3 instanceof OBJECT_IDENTIFIER) {
                                object2 = (OBJECT_IDENTIFIER)object3;
                                break block21;
                            }
                            if (object3 instanceof ANY) {
                                object2 = (OBJECT_IDENTIFIER)((ANY)object3).decodeWith(OBJECT_IDENTIFIER.getTemplate());
                                break block21;
                            }
                            throw new InvalidBERException("Content-Type signed attribute has unexpected content type");
                        }
                        catch (InvalidBERException invalidBERException) {
                            throw new SignatureException("Content-Type signed attribute does not have OBJECT IDENTIFIER value");
                        }
                    }
                    if (!((OBJECT_IDENTIFIER)object2).equals(oBJECT_IDENTIFIER)) {
                        throw new SignatureException("Content-type in signed attributes does not match content-type being verified");
                    }
                    bl = true;
                    continue;
                }
                if (!((Attribute)object5).getType().equals(MESSAGE_DIGEST)) continue;
                object4 = ((Attribute)object5).getValues();
                if (((SET)object4).size() != 1) {
                    throw new SignatureException("Message-digest attribute does not have exactly one value");
                }
                object3 = ((SET)object4).elementAt(0);
                try {
                    if (object3 instanceof OCTET_STRING) {
                        object2 = ((OCTET_STRING)object3).toByteArray();
                        break block22;
                    }
                    if (object3 instanceof ANY) {
                        object = (OCTET_STRING)((ANY)object3).decodeWith(OCTET_STRING.getTemplate());
                        object2 = ((OCTET_STRING)object).toByteArray();
                        break block22;
                    }
                    throw new InvalidBERException("Content-Type signed attribute has unexpected content type");
                }
                catch (InvalidBERException invalidBERException) {
                    throw new SignatureException("Message-digest attribute does not have OCTET STRING value");
                }
            }
            if (!SignerInfo.byteArraysAreSame((byte[])object2, byArray)) {
                throw new SignatureException("Message-digest attribute does not match message digest being verified");
            }
            bl2 = true;
        }
        if (!bl) {
            throw new SignatureException("Signed attributes does not contain PKCS #9 content-type attribute");
        }
        if (!bl2) {
            throw new SignatureException("Signed attributes does not contain PKCS #9 message-digest attribute");
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromOID(this.digestEncryptionAlgorithm.getOID());
        object5 = CryptoManager.getInstance().getInternalCryptoToken();
        object4 = object5.getSignatureContext(signatureAlgorithm);
        ((Signature)object4).initVerify(publicKey);
        object3 = ASN1Util.encode(this.signedAttributes);
        object2 = MessageDigest.getInstance(DigestAlgorithm.fromOID(this.digestAlgorithm.getOID()).toString());
        object = ((MessageDigest)object2).digest((byte[])object3);
        if (signatureAlgorithm.getRawAlg() == SignatureAlgorithm.RSASignature) {
            SEQUENCE sEQUENCE = new SEQUENCE();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.digestAlgorithm.getOID(), null);
            sEQUENCE.addElement(algorithmIdentifier);
            sEQUENCE.addElement(new OCTET_STRING((byte[])object));
            byArray2 = ASN1Util.encode(sEQUENCE);
        } else {
            byArray2 = object;
        }
        ((Signature)object4).update(byArray2);
        if (!((Signature)object4).verify(this.encryptedDigest.toByteArray())) {
            throw new SignatureException("encryptedDigest was not the correct signature of the contents octets of the DER-encoded signed attributes");
        }
    }

    private static boolean byteArraysAreSame(byte[] byArray, byte[] byArray2) {
        Assert._assert(byArray != null && byArray2 != null);
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.version);
        sEQUENCE.addElement(this.signerIdentifier);
        sEQUENCE.addElement(this.digestAlgorithm);
        if (this.signedAttributes != null) {
            sEQUENCE.addElement(new Tag(0L), this.signedAttributes);
        }
        sEQUENCE.addElement(this.digestEncryptionAlgorithm);
        sEQUENCE.addElement(this.encryptedDigest);
        if (this.unsignedAttributes != null) {
            sEQUENCE.addElement(new Tag(1L), this.unsignedAttributes);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(SignerIdentifier.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Attribute.getTemplate()));
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 7);
            return new SignerInfo((INTEGER)sEQUENCE.elementAt(0), (SignerIdentifier)sEQUENCE.elementAt(1), (AlgorithmIdentifier)sEQUENCE.elementAt(2), (SET)sEQUENCE.elementAt(3), (AlgorithmIdentifier)sEQUENCE.elementAt(4), ((OCTET_STRING)sEQUENCE.elementAt(5)).toByteArray(), (SET)sEQUENCE.elementAt(6));
        }
    }
}

