/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.tests.FilePasswordCallback;

public class HMACTest {
    private CryptoManager cm;
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    static final String[] JSS_HMAC_Algs = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA384", "HmacSHA512"};

    public HMACTest(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Usage: java org.mozilla.jss.tests.HMACTest <dbdir> [password file only needed in FIPS mode]");
            System.exit(1);
        }
        CryptoManager.initialize(stringArray[0]);
        this.cm = CryptoManager.getInstance();
        if (this.cm.FIPSEnabled()) {
            System.out.println("\n\t\tFIPS enabled.\n");
            if (stringArray.length == 2) {
                CryptoToken cryptoToken = this.cm.getInternalCryptoToken();
                System.out.println("logging in to token: " + cryptoToken.getName());
                FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
                cryptoToken.login(filePasswordCallback);
            }
        }
    }

    public boolean compareHMAC(String string, SecretKeyFacade secretKeyFacade, String string2) throws Exception {
        boolean bl = false;
        Mac mac = Mac.getInstance(string, MOZ_PROVIDER_NAME);
        mac.init(secretKeyFacade);
        mac.update(string2.getBytes());
        byte[] byArray = mac.doFinal();
        Provider[] providerArray = Security.getProviders("Mac." + string);
        String string3 = null;
        for (int i = 0; i < providerArray.length; ++i) {
            string3 = providerArray[i].getName();
            if (string3.equals(MOZ_PROVIDER_NAME)) continue;
            Mac mac2 = Mac.getInstance(string, string3);
            mac2.init(secretKeyFacade);
            mac2.update(string2.getBytes());
            byte[] byArray2 = mac2.doFinal();
            if (MessageDigest.isEqual(byArray, byArray2)) {
                System.out.println(string3 + " and " + MOZ_PROVIDER_NAME + " give same " + string);
                bl = true;
                continue;
            }
            throw new Exception("ERROR: " + string3 + " and " + MOZ_PROVIDER_NAME + " give different " + string);
        }
        return bl;
    }

    public void doHMAC(String string, SecretKeyFacade secretKeyFacade, String string2) throws Exception {
        Mac mac = Mac.getInstance(string, MOZ_PROVIDER_NAME);
        mac.init(secretKeyFacade);
        byte[] byArray = mac.doFinal(string2.getBytes());
        if (byArray.length != mac.getMacLength()) {
            throw new Exception("ERROR: hmac output size is " + byArray.length + ", should be " + mac.getMacLength());
        }
        System.out.println("Mozilla-JSS supports " + mac.getAlgorithm() + "  and the output size is " + mac.getMacLength());
    }

    public boolean fipsMode() {
        return this.cm.FIPSEnabled();
    }

    public static void main(String[] stringArray) {
        try {
            HMACTest hMACTest = new HMACTest(stringArray);
            byte[] byArray = new byte[]{10, 109, 7, -70, 30, -67, 114, -15};
            int n = 7;
            PBEKeySpec pBEKeySpec = new PBEKeySpec("password".toCharArray(), byArray, n);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithSHA1AndDES3", MOZ_PROVIDER_NAME);
            SecretKeyFacade secretKeyFacade = (SecretKeyFacade)secretKeyFactory.generateSecret(pBEKeySpec);
            String string = new String("FireFox and Thunderbird rule");
            for (int i = 0; i < JSS_HMAC_Algs.length; ++i) {
                if (hMACTest.fipsMode()) {
                    if (JSS_HMAC_Algs[i].equals("HmacSHA512")) continue;
                    hMACTest.doHMAC(JSS_HMAC_Algs[i], secretKeyFacade, string);
                    continue;
                }
                if (hMACTest.compareHMAC(JSS_HMAC_Algs[i], secretKeyFacade, string)) continue;
                hMACTest.doHMAC(JSS_HMAC_Algs[i], secretKeyFacade, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

