/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSSE_SSLServer {
    private int DefaultServerPort;
    private int port;
    private String type;
    private String configDir;
    private boolean bClientAuth;
    private boolean bVerbose;
    private Vector supportedCiphers;
    private CryptoManager manager;
    private String provider;

    public JSSE_SSLServer() throws IOException {
        this.port = this.DefaultServerPort = 29753;
        this.type = "SSLv3";
        this.configDir = "";
        this.bClientAuth = false;
        this.bVerbose = false;
        this.supportedCiphers = new Vector();
        this.provider = "SunJCE";
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setKeystore(String string) {
        this.configDir = string;
    }

    public String getKeystore() {
        return this.configDir;
    }

    public static void main(String[] stringArray) {
        try {
            new JSSE_SSLServer().startSSLServer(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startSSLServer(String[] stringArray) throws Exception {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        JSSE_SSLServer jSSE_SSLServer = new JSSE_SSLServer();
        if (stringArray.length <= 1) {
            System.out.println("USAGE: java JSSE_SSLServer [port] [TLS | SSLv3][ClientAuth = true | false][config directory] [keystore filename][NSS DB passwordFile][JCE || Mozilla-JSS || Sunpkcs11]");
            System.out.println("\nIf the second argument is TLS, it will start as a\nTLS server, otherwise, it will be started in SSLv3 mode.\nIf the third argument is true,it will require\nclient authentication as well.");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(i + " = " + stringArray[i]);
        }
        if (stringArray.length >= 1) {
            this.port = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            this.type = stringArray[1];
        }
        if (stringArray.length >= 3 && stringArray[2].equals("true")) {
            this.bClientAuth = true;
        }
        if (stringArray.length >= 4 && stringArray.length >= 5 && (string = (string2 = stringArray[3]) + "/" + stringArray[4]) != null) {
            jSSE_SSLServer.setKeystore(string);
        }
        if (stringArray.length >= 7 && stringArray.length >= 8) {
            if (stringArray[5].equalsIgnoreCase("Mozilla-JSS")) {
                if (stringArray.length >= 8) {
                    string3 = stringArray[7];
                }
                System.out.println("Initializing " + stringArray[5]);
                CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string2);
                initializationValues.removeSunProvider = false;
                CryptoManager.initialize(initializationValues);
                this.manager = CryptoManager.getInstance();
                this.manager.setPasswordCallback(new FilePasswordCallback(string3));
            } else if (stringArray[5].equalsIgnoreCase("Sunpkcs11")) {
                System.out.println("Sunpkcs11 requires JDK 1.5at this time JSS need to build with JDK 1.4.2");
            }
        }
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            System.out.println("Provider " + i + ": " + providerArray[i].getName());
        }
        try {
            System.out.println("creating SSLSockets:");
            SSLServerSocketFactory sSLServerSocketFactory = jSSE_SSLServer.getServerSocketFactory(this.type);
            if (sSLServerSocketFactory != null) {
                SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.port);
                sSLServerSocket.setSoTimeout(300000);
                System.out.println("Enable ciphers.");
                sSLServerSocket.setEnabledCipherSuites(sSLServerSocket.getSupportedCipherSuites());
                System.out.println("Create JSSE SSLServer");
                sSLServerSocket.setNeedClientAuth(this.bClientAuth);
                JSSE_SSLServer jSSE_SSLServer2 = new JSSE_SSLServer();
                int n = 0;
                try {
                    while (true) {
                        Socket socket = sSLServerSocket.accept();
                        socket.setSoTimeout(300000);
                        readWriteThread readWriteThread2 = new readWriteThread(socket, ++n);
                        readWriteThread2.start();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Exception caught in SSLServerSocket.accept():" + iOException.getMessage());
                    try {
                        sSLServerSocket.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                if (System.getProperty("java.vendor").equals("IBM Corporation")) {
                    System.out.println("Using IBM JDK: Cannot load keystore due to strong security encryption settings\nwith limited Jurisdiction policy files :\n http://www-1.ibm.com/support/docview.wss?uid=swg21169931");
                    System.exit(0);
                }
                System.out.println("unable to initialize JSSE_SocketFactory exiting!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to start JSSE_SSLServer: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("Main JSSE_SSLServer exiting.");
        System.exit(0);
    }

    SSLServerSocketFactory getServerSocketFactory(String string) {
        SSLContext sSLContext = null;
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        char[] cArray = "m1oZilla".toCharArray();
        SSLServerSocketFactory sSLServerSocketFactory = null;
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("java.home") + "/jre/lib/security/cacerts");
        String string2 = "SunX509";
        String string3 = System.getProperty("java.vendor");
        if (string3.equals("IBM Corporation")) {
            string2 = "IbmX509";
        }
        System.out.println("keystore loc: " + this.getKeystore());
        if (!string.equals("TLS") && !string.equals("SSLv3")) {
            System.out.println("type must equal 'TLS' or 'SSLv3'\n");
            System.exit(1);
        }
        try {
            sSLContext = SSLContext.getInstance(string);
            keyManagerFactory = KeyManagerFactory.getInstance(string2);
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(this.getKeystore()), cArray);
            keyManagerFactory.init(keyStore, cArray);
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            return sSLServerSocketFactory;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return sSLServerSocketFactory;
        }
    }

    private class readWriteThread
    extends Thread {
        private Socket socket = null;
        private int socketCntr = 0;

        public readWriteThread(Socket socket, int n) {
            this.socket = socket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                OutputStream outputStream;
                InputStream inputStream;
                block11: {
                    String string = null;
                    String string2 = null;
                    inputStream = this.socket.getInputStream();
                    outputStream = this.socket.getOutputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            if (string.equalsIgnoreCase("shutdown")) {
                                if (JSSE_SSLServer.this.bVerbose) {
                                    System.out.println("Client told  JSSE_SSLServer to Shutdown!");
                                }
                                inputStream.close();
                                outputStream.close();
                                this.socket.close();
                                System.exit(0);
                            }
                            string2 = "ServerSSLSocket- " + this.socketCntr;
                            if (JSSE_SSLServer.this.bVerbose) {
                                System.out.println("ServerSSLSocket-" + this.socketCntr + ": Received " + string);
                                System.out.println("Sending" + string2);
                            }
                            printWriter.println(string2);
                            printWriter.flush();
                        }
                        if (JSSE_SSLServer.this.bVerbose) {
                            System.out.println("ServerSSLSocket-" + this.socketCntr + " read null aborting connection.");
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        System.out.println("ServerSSLSocket-" + this.socketCntr + " timed out: " + socketTimeoutException.toString());
                    }
                    catch (IOException iOException) {
                        if (!JSSE_SSLServer.this.bVerbose) break block11;
                        iOException.printStackTrace();
                    }
                }
                inputStream.close();
                outputStream.close();
                this.socket.close();
                if (JSSE_SSLServer.this.bVerbose) {
                    System.out.println("ServerSSLSocket " + this.socketCntr + " has been Closed.");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

