/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_FileUploadServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String fServerCertNick = null;
    private String fServerHost = "localhost";
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private boolean TestInetAddress = false;
    private boolean success = true;
    public static int port = 29755;
    public static String usage = "\nUSAGE:\njava JSS_FileUploadServer [certdb path] [password file]\n[server_host_name] [cert nickname][testInetAddress: true|false]";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_FileUploadServer().doIt(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Exception caught: " + exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void doIt(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray[0].toLowerCase().indexOf("-h") != -1) {
            System.out.println(usage);
            System.exit(1);
        }
        int n = 0;
        try {
            if (stringArray[0].length() > 0 && !stringArray[0].equals(".")) {
                this.fCertDbPath = stringArray[0];
            }
            if (stringArray[1].length() > 0 && !stringArray[1].equals("passwords")) {
                this.fPasswordFile = stringArray[1];
            }
            if (stringArray[2].length() > 0 && !stringArray[2].equals("localhost")) {
                this.fServerHost = stringArray[2];
            }
            if (stringArray[3].length() > 0) {
                this.fServerCertNick = stringArray[3];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CryptoManager.initialize(this.fCertDbPath);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(this.fPasswordFile);
        cryptoToken.login(filePasswordCallback);
        if (stringArray[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        SSLSocket.enableSSL2Default(false);
        serverSock = this.TestInetAddress ? new SSLServerSocket(port, 5, InetAddress.getByName(this.fServerHost), null, true) : new SSLServerSocket(port, 5, null, null, true);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname(this.fServerCertNick);
        System.out.println("Server ready to accept connections");
        while (true) {
            sock = (SSLSocket)serverSock.accept();
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            readWriteThread readWriteThread2 = new readWriteThread(sock, ++n);
            readWriteThread2.start();
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_FileUploadServer boss;

        public HandshakeListener(String string, JSS_FileUploadServer jSS_FileUploadServer) {
            this.who = string;
            this.boss = jSS_FileUploadServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket socket = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sSLSocket, int n) {
            this.socket = sSLSocket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                Object var1_1 = null;
                Object var2_3 = null;
                boolean bl = false;
                String string = null;
                InputStream inputStream = this.socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                long l = new Date().getTime();
                while ((string = bufferedReader.readLine()) != null) {
                    long l2 = new Date().getTime();
                    System.out.print("Read " + string.getBytes().length + "bytes in " + (l2 - l) + "\n");
                    l = l2;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception caught in readWriteThread.run()\n");
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

