/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;

public class Debug {
    public static final String debugFieldName = "DEBUG";

    public static void setDebug(String className, boolean debug) throws ClassNotFoundException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> cl = Class.forName(className);
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(debugFieldName)) continue;
            fields[i].setAccessible(true);
            fields[i].setBoolean(null, debug);
            return;
        }
        throw new NoSuchFieldException(debugFieldName);
    }

    public static void setDebug(Properties props, String prefix) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String value;
            String className;
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || (className = key.substring(prefix.length())) == null || className.length() == 0 || (value = props.getProperty(key)) == null || value.length() == 0) continue;
            try {
                Debug.setDebug(className, Boolean.valueOf(value));
            }
            catch (NoSuchFieldException ex) {
                throw new NoSuchFieldException(className + "." + debugFieldName);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessException(className + "." + debugFieldName);
            }
        }
    }
}

