/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;

public class NoClusteredBroker
implements ClusteredBroker {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    String brokerName = null;
    MQAddress address = null;
    transient String instanceName = null;
    Integer status = new Integer(0);
    BrokerState state = BrokerState.INITIALIZING;
    UID brokerSessionUID = null;
    boolean isgen = false;

    public NoClusteredBroker(MQAddress url, UID id) {
        this.address = url;
        this.brokerSessionUID = id;
        this.brokerName = Globals.getBrokerID();
        this.instanceName = Globals.getConfigName();
        if (this.brokerName == null) {
            this.isgen = true;
            this.brokerName = "broker0";
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClusteredBroker)) {
            return false;
        }
        return this.getBrokerName().equals(((ClusteredBroker)o).getBrokerName());
    }

    @Override
    public int hashCode() {
        return this.getBrokerName().hashCode();
    }

    public String toString() {
        return this.brokerName + "* (" + this.address + ")";
    }

    @Override
    public String getBrokerName() {
        return this.brokerName;
    }

    @Override
    public MQAddress getBrokerURL() {
        return this.address;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void setInstanceName(String instName) {
        this.instanceName = instName;
    }

    @Override
    public void setBrokerURL(MQAddress address) throws Exception {
        this.address = address;
    }

    @Override
    public boolean isLocalBroker() {
        return true;
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized int getVersion() {
        return 0;
    }

    @Override
    public void setVersion(int version) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(int newstatus, Object userData) {
        if (BrokerStatus.getBrokerIsDown(newstatus)) {
            newstatus = BrokerStatus.setBrokerLinkIsDown(newstatus);
        } else if (BrokerStatus.getBrokerLinkIsDown(newstatus)) {
            newstatus = BrokerStatus.setBrokerIsDown(newstatus);
        } else if (BrokerStatus.getBrokerLinkIsUp(newstatus)) {
            newstatus = BrokerStatus.setBrokerIsUp(newstatus);
        } else if (BrokerStatus.getBrokerIsUp(newstatus)) {
            newstatus = BrokerStatus.setBrokerLinkIsUp(newstatus);
        }
        NoClusteredBroker noClusteredBroker = this;
        synchronized (noClusteredBroker) {
            this.status = new Integer(newstatus);
        }
        try {
            if (BrokerStatus.getBrokerIsUp(newstatus)) {
                this.setState(BrokerState.OPERATING);
            }
            if (BrokerStatus.getBrokerIsDown(newstatus)) {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerIsUp(boolean up, UID brokerSession, Object userData) {
        NoClusteredBroker noClusteredBroker = this;
        synchronized (noClusteredBroker) {
            if (up) {
                int newStatus = BrokerStatus.setBrokerIsUp(this.status);
                this.status = new Integer(newStatus);
            } else {
                int newStatus = BrokerStatus.setBrokerIsDown(this.status);
                this.status = new Integer(newStatus);
            }
        }
        try {
            if (up) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerLinkUp(boolean up, Object userData) {
        NoClusteredBroker noClusteredBroker = this;
        synchronized (noClusteredBroker) {
            int newStatus = 0;
            newStatus = up ? BrokerStatus.setBrokerLinkIsUp(BrokerStatus.setBrokerIsUp(this.status)) : BrokerStatus.setBrokerLinkIsDown(BrokerStatus.setBrokerIsDown(this.status));
            this.status = new Integer(newStatus);
        }
        try {
            if (up) {
                this.setState(BrokerState.OPERATING);
            } else {
                this.setState(BrokerState.SHUTDOWN_COMPLETE);
            }
        }
        catch (Exception ex) {
            this.logger.logStack(4, "Error setting state ", ex);
        }
    }

    @Override
    public void setBrokerInDoubt(boolean up, Object userData) {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".setBrokerInDoubt()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        NoClusteredBroker noClusteredBroker = this;
        synchronized (noClusteredBroker) {
            this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
        }
    }

    @Override
    public BrokerState getState() {
        return this.state;
    }

    @Override
    public void setState(BrokerState state) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        this.state = state;
    }

    @Override
    public boolean isConfigBroker() {
        return true;
    }

    @Override
    public synchronized UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    @Override
    public synchronized void setBrokerSessionUID(UID session) {
        this.brokerSessionUID = session;
    }

    @Override
    public boolean isBrokerIDGenerated() {
        return this.isgen;
    }

    @Override
    public String getNodeName() throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call: " + this.getClass().getName() + ".getNodeName()");
    }
}

