/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class HelloHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    private static boolean DEBUG;
    private static boolean ALLOW_C_CLIENTS;
    private static boolean CAN_RECONNECT;

    public static void DUMP(String title) {
        Globals.getLogger().log(4, title);
        Globals.getLogger().log(4, "------------------------");
        Globals.getLogger().log(4, "Number of connections is " + Globals.getConnectionManager().getNumConnections(null));
        List l = Globals.getConnectionManager().getConnectionList(null);
        for (int i = 0; i < l.size(); ++i) {
            Connection c = (Connection)l.get(i);
            Globals.getLogger().log(4, "\t" + i + "\t" + c.getConnectionUID() + " :" + c.getRemoteConnectionString());
        }
        Globals.getLogger().log(4, "------------------------");
    }

    public HelloHandler(ConnectionManager list) {
        this.connectionList = list;
    }

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        byte[] req;
        int status;
        Hashtable<String, Object> hash;
        Packet pkt;
        block101: {
            block100: {
                UID sessionUID;
                String destprov;
                UID expectedSessionID;
                Hashtable hello_props;
                String reason;
                block99: {
                    block98: {
                        HAMonitorService hamonitor;
                        HashSet<String> s;
                        UID brokerSessionID;
                        if (DEBUG) {
                            this.logger.log(1, "HelloHandler: handle() [ Received Hello Message]");
                        }
                        reason = null;
                        hello_props = null;
                        try {
                            hello_props = msg.getProperties();
                        }
                        catch (Exception ex) {
                            this.logger.logStack(16, "HELLO Packet.getProperties()", ex);
                            hello_props = new Hashtable();
                        }
                        boolean alreadyStarted = con.isStarted();
                        boolean alreadyAuthenticated = con.isAuthenticated();
                        int requestedProtocol = 0;
                        int highestProtocol = con.getHighestSupportedProtocol();
                        int lowestProtocol = 100;
                        String expectedClusterID = null;
                        expectedSessionID = null;
                        ConnectionUID oldCID = null;
                        Integer bufsize = null;
                        boolean badClientType = false;
                        destprov = null;
                        if (hello_props != null) {
                            Long longUID;
                            Integer level = (Integer)hello_props.get("JMQProtocolLevel");
                            String clientv = (String)hello_props.get("JMQVersion");
                            if (DEBUG) {
                                this.logger.log(8, "HelloHandler.handle(): Client[" + clientv + ", " + level + "] " + con);
                            }
                            requestedProtocol = level == null ? 100 : level;
                            bufsize = (Integer)hello_props.get("JMQSize");
                            if (bufsize == null) {
                                bufsize = (Integer)hello_props.get("JMQRBufferSize");
                            }
                            if ((longUID = (Long)hello_props.get("JMQStoreSession")) != null) {
                                expectedSessionID = new UID(longUID);
                            }
                            expectedClusterID = (String)hello_props.get("JMQClusterID");
                            Boolean reconnectable = (Boolean)hello_props.get("JMQReconnectable");
                            Boolean haclient = (Boolean)hello_props.get("JMQHAClient");
                            if (Globals.getHAEnabled() && haclient != null && haclient.booleanValue()) {
                                reconnectable = haclient;
                            }
                            String s2 = (String)hello_props.get("JMQUserAgent");
                            if (!ALLOW_C_CLIENTS && s2 != null && s2.indexOf("C;") != -1) {
                                badClientType = true;
                            }
                            if (s2 != null) {
                                con.addClientData("useragent", s2);
                            }
                            destprov = (String)hello_props.get("JMQDestinationProvider");
                            longUID = (Long)hello_props.get("JMQConnectionID");
                            if (longUID != null) {
                                this.logger.log(4, "Have old connectionUID");
                                oldCID = new ConnectionUID(longUID);
                                this.logger.log(8, "B1122", oldCID);
                                this.logger.log(4, "Checking for active connection");
                                Connection oldcon = Globals.getConnectionManager().getConnection(oldCID);
                                HelloHandler.DUMP("Before connection Destroy");
                                if (oldcon != null) {
                                    this.logger.log(4, "Destroying old connection " + oldCID);
                                    oldcon.destroyConnection(true, 3, "Destroying old connection with same connectionUID " + oldCID + " - reconnect is happening before connection was reaped");
                                }
                                HelloHandler.DUMP("After Connection Destroy");
                            }
                            con.getConnectionUID().setCanReconnect(reconnectable == null ? false : reconnectable);
                            Long interval = (Long)hello_props.get("JMQInterval");
                            long itime = interval == null ? 10000L : interval;
                            con.setReconnectInterval(itime);
                        } else {
                            requestedProtocol = 100;
                        }
                        int supportedProtocol = 0;
                        supportedProtocol = requestedProtocol > highestProtocol ? highestProtocol : (requestedProtocol < lowestProtocol ? lowestProtocol : requestedProtocol);
                        con.setClientProtocolVersion(supportedProtocol);
                        if (bufsize != null) {
                            this.logger.log(4, "Received JMQRBufferSize -" + bufsize);
                            con.setFlowCount(bufsize);
                        }
                        pkt = new Packet(con.useDirectBuffers());
                        pkt.setPacketType(11);
                        pkt.setConsumerID(msg.getConsumerID());
                        hash = new Hashtable<String, Object>();
                        reason = "unavailable";
                        status = 503;
                        if (con.getRemoteIP() == null) {
                            con.setRemoteIP(msg.getIP());
                        }
                        if ((alreadyAuthenticated || alreadyStarted) && !msg.getIndempotent()) {
                            status = 500;
                            reason = "Connection reuse not allowed";
                            if (alreadyAuthenticated) {
                                this.logger.log(16, "Internal Error:  received HELLO on already authenticated connection " + con.getRemoteConnectionString() + " " + con.getConnectionUID());
                            } else {
                                this.logger.log(16, "Internal Error:  received HELLO on already started connection " + con.getRemoteConnectionString() + " " + con.getConnectionUID());
                            }
                        } else if (badClientType) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0046"));
                            reason = "C clients not allowed on this version";
                            status = 503;
                        } else if (!CAN_RECONNECT && con.getConnectionUID().getCanReconnect()) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0047"));
                            reason = "Client Failover not allowed on this version";
                        } else if (requestedProtocol != supportedProtocol) {
                            this.logger.log(16, "B2052", (Object)Integer.toString(requestedProtocol), Integer.toString(supportedProtocol));
                            reason = "bad version";
                            status = 505;
                        } else if (con.getConnectionState() != -1) {
                            if (con.setConnectionState(1)) {
                                reason = null;
                                status = 200;
                            } else {
                                status = 503;
                            }
                        } else {
                            status = 503;
                        }
                        if (status == 200 && destprov != null) {
                            if (((IMQService)con.getService()).getServiceType() == 1) {
                                status = 400;
                                reason = "JMQDestinationProvider not supported on ADMIN service";
                                this.logger.log(16, reason);
                            } else if (!destprov.equals("GLASSFISH_MQ") && !destprov.equals("COHERENCE_MESSAGE_PATTERN")) {
                                status = 415;
                                reason = "Unsupported JMQDestinationProvider " + destprov;
                                this.logger.log(16, reason);
                            } else if (destprov.equals("COHERENCE_MESSAGE_PATTERN") && Globals.getCorePlugin(destprov) == null) {
                                status = 415;
                                reason = destprov + " not enabled";
                                this.logger.log(16, reason);
                            }
                        }
                        if ((brokerSessionID = Globals.getBrokerSessionID()) != null) {
                            hash.put("JMQBrokerSessionID", brokerSessionID.longValue());
                        }
                        String clusterID = null;
                        sessionUID = null;
                        Object supportedSessions = null;
                        ClusterManager cfg = Globals.getClusterManager();
                        if (cfg != null) {
                            clusterID = cfg.getClusterId();
                            sessionUID = cfg.getStoreSessionUID();
                            hash.put("JMQHA", cfg.isHA());
                            if (clusterID != null) {
                                hash.put("JMQClusterID", clusterID);
                            }
                            if (sessionUID != null) {
                                Globals.getDestinationList();
                                if (!DestinationList.isPartitionMode()) {
                                    hash.put("JMQStoreSession", sessionUID.longValue());
                                }
                            }
                            String list = null;
                            Iterator itr = null;
                            itr = ((IMQService)con.getService()).getServiceType() != 1 ? cfg.getKnownBrokers(false) : cfg.getKnownBrokers(true);
                            s = new HashSet<String>();
                            while (itr.hasNext()) {
                                ClusteredBroker cb = (ClusteredBroker)itr.next();
                                s.add(cb.getBrokerURL().toString());
                            }
                            itr = s.iterator();
                            while (itr.hasNext()) {
                                if (list == null) {
                                    list = itr.next().toString();
                                    continue;
                                }
                                list = list + "," + itr.next().toString();
                            }
                            if (list != null) {
                                hash.put("JMQBrokerList", list);
                            }
                        }
                        if ((hamonitor = Globals.getHAMonitorService()) != null && hamonitor.inTakeover() && ((IMQService)con.getService()).getServiceType() != 1) {
                            status = 408;
                            if (oldCID != null) {
                                this.logger.log(8, "B2193", oldCID);
                            } else {
                                this.logger.log(8, "B2193", con.getConnectionUID());
                            }
                        }
                        if (clusterID != null && expectedClusterID != null && !clusterID.equals(expectedClusterID)) {
                            status = 400;
                        } else if (!(expectedSessionID != null && sessionUID != null && expectedSessionID.equals(sessionUID) || expectedSessionID == null)) {
                            if (cfg == null) {
                                this.logger.log(16, "B3100", "Internal Error: Received session on non-clustered broker");
                                status = 404;
                            } else {
                                String ownerString;
                                ClusteredBroker owner = null;
                                s = cfg.getSupportedStoreSessionUIDs();
                                if (s.contains(expectedSessionID)) {
                                    owner = cfg.getLocalBroker();
                                }
                                if (owner == null && (ownerString = cfg.lookupStoreSessionOwner(expectedSessionID)) != null) {
                                    owner = cfg.getBroker(ownerString);
                                }
                                try {
                                    if (owner != null) {
                                        int stat;
                                        ClusteredBroker creator = null;
                                        String creatorString = cfg.getStoreSessionCreator(expectedSessionID);
                                        if (creatorString != null) {
                                            creator = cfg.getBroker(creatorString);
                                        }
                                        if (BrokerStatus.getBrokerInDoubt(stat = owner.getStatus()) || !BrokerStatus.getBrokerLinkIsUp(stat) || owner.getState() == BrokerState.FAILOVER_STARTED) {
                                            status = 408;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1255", expectedSessionID, owner));
                                        } else if (!owner.isLocalBroker()) {
                                            status = 301;
                                            hash.put("JMQStoreOwner", owner.getBrokerURL().toString());
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1256", expectedSessionID, owner));
                                        } else if (creator == null) {
                                            status = 404;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1257", expectedSessionID));
                                        } else if (creator.getState() == BrokerState.FAILOVER_STARTED) {
                                            status = 408;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1258", expectedSessionID));
                                        } else {
                                            hash.put("JMQStoreOwner", owner.getBrokerURL().toString());
                                        }
                                    } else {
                                        status = 404;
                                        this.logger.log(8, Globals.getBrokerResources().getKString("B1259", expectedSessionID));
                                    }
                                }
                                catch (Exception ex) {
                                    this.logger.log(16, "B2131", (Object)expectedSessionID.toString(), (Throwable)ex);
                                    status = 404;
                                }
                            }
                        }
                        if (!con.isAdminConnection() && Globals.getMemManager() != null) {
                            hash.put("JMQSize", new Integer(Globals.getMemManager().getJMQSize()));
                            hash.put("JMQBytes", new Long(Globals.getMemManager().getJMQBytes()));
                            hash.put("JMQMaxMsgBytes", new Long(Globals.getMemManager().getJMQMaxMsgBytes()));
                        }
                        hash.put("JMQService", con.getService().getName());
                        hash.put("JMQConnectionID", new Long(con.getConnectionUID().longValue()));
                        hash.put("JMQProtocolLevel", new Integer(supportedProtocol));
                        hash.put("JMQVersion", Globals.getVersion().getProductVersion());
                        IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                        if (IMQBasicConnection.getDumpPacket()) break block98;
                        IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                        if (!IMQBasicConnection.getDumpOutPacket()) break block99;
                    }
                    hash.put("JMQReqID", msg.getSysMessageID().toString());
                }
                try {
                    LicenseBase license = Globals.getCurrentLicense(null);
                    hash.put("JMQLicense", license.getProperty("imq.license_type"));
                    hash.put("JMQLicenseDesc", license.getProperty("description"));
                }
                catch (BrokerException ex) {
                    hash.put("JMQLicenseDesc", ex.toString());
                }
                try {
                    sessionUID = con.attachStorePartition(expectedSessionID);
                    Globals.getDestinationList();
                    if (DestinationList.isPartitionMode()) {
                        hash.put("JMQStoreSession", sessionUID.longValue());
                    }
                }
                catch (BrokerException e) {
                    status = e.getStatusCode();
                    reason = e.getMessage();
                    if (status == 404) {
                        this.logger.log(8, e.getMessage());
                    }
                    this.logger.logStack(32, e.getMessage(), e);
                }
                hash.put("JMQStatus", new Integer(status));
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                pkt.setProperties(hash);
                con.sendControlMessage(pkt);
                if (status != 200 && status != 301 && status != 404 && status != 408) {
                    con.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0063"));
                    this.connectionList.removeConnection(con.getConnectionUID(), false, 4, Globals.getBrokerResources().getKString("B0063"));
                    return true;
                }
                status = 503;
                String authType = null;
                if (hello_props != null) {
                    authType = (String)hello_props.get("JMQAuthType");
                }
                AccessController ac = con.getAccessController();
                pkt = new Packet(con.useDirectBuffers());
                pkt.setPacketType(38);
                pkt.setConsumerID(msg.getConsumerID());
                hash = new Hashtable();
                hash.put("JMQSequence", new Integer(msg.getSequence()));
                hash.put("JMQChallenge", true);
                Properties props = new Properties();
                props.setProperty("imq.clientIP", msg.getIPString());
                props.setProperty("imq.connectionID", con.getConnectionUID().toString());
                req = null;
                try {
                    AuthCacheData acd = ((IMQService)con.getService()).getAuthCacheData();
                    req = ac.getChallenge(msg.getSequence(), props, acd.getCacheData(), authType);
                    hash.put("JMQAuthType", ac.getAuthType());
                    if (con.setConnectionState(2)) {
                        status = 200;
                    }
                }
                catch (FailedLoginException e) {
                    this.logger.log(16, e.getMessage(), e);
                    status = 403;
                }
                catch (OutOfMemoryError err) {
                    throw err;
                }
                catch (Throwable w) {
                    this.logger.log(32, Globals.getBrokerResources().getKString("B3060") + " - " + w.getMessage(), w);
                    status = 403;
                }
                try {
                    if (destprov != null && !destprov.equals("GLASSFISH_MQ")) {
                        CoreLifecycleSpi clc = Globals.getCorePlugin(destprov);
                        ((IMQBasicConnection)con).setPacketRouter(clc.getPacketRouter());
                        con.setCoreLifecycle(clc);
                    }
                }
                catch (Exception e) {
                    status = 500;
                    this.logger.logStack(32, e.getMessage(), e);
                }
                hash.put("JMQStatus", new Integer(status));
                IMQBasicConnection cfr_ignored_2 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block100;
                IMQBasicConnection cfr_ignored_3 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block101;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        if (req != null) {
            pkt.setMessageBody(req);
        }
        con.sendControlMessage(pkt);
        if (DEBUG) {
            this.logger.log(4, "HelloHandler: handle() [ sent challenge ]:status=" + Status.getString(status));
        }
        if (status != 200 && status != 301 && status != 404 && status != 408) {
            con.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0063"));
            this.connectionList.removeConnection(con.getConnectionUID(), false, 4, Globals.getBrokerResources().getKString("B0063"));
        }
        return true;
    }

    static {
        LicenseBase license;
        DEBUG = false;
        ALLOW_C_CLIENTS = false;
        CAN_RECONNECT = false;
        try {
            license = Globals.getCurrentLicense(null);
            ALLOW_C_CLIENTS = license.getBooleanProperty("imq.enable_c_api", false);
        }
        catch (BrokerException ex) {
            ALLOW_C_CLIENTS = false;
        }
        try {
            license = Globals.getCurrentLicense(null);
            CAN_RECONNECT = license.getBooleanProperty("imq.enable_reconnect", false);
        }
        catch (BrokerException ex) {
            CAN_RECONNECT = false;
        }
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }
}

