/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.config;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.config.ConfigStore;
import com.sun.messaging.jmq.jmsserver.config.UpdateProperties;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class BrokerConfig
extends UpdateProperties {
    private static final String IMQ = "imq";
    public static final String CONFIG_VERSION_PROP = "imq.config.version";
    public static final String INSTANCECONFIG_VERSION_PROP = "imq.instanceconfig.version";
    public static final String CONFIG_VERSION = "300";
    private static final String JMQ_FallbackProperties = "imq.service.activelist=jms,admin\nimq.jms.protocoltype=tcp\nimq.jms.servicetype=NORMAL\nimq.jms.tcp.port=0\nimq.jms.tcp.backlog=100\nimq.jms.tcp.blocking=true\nimq.jms.tcp.useChannels=false\nimq.jms.min_threads=10\nimq.jms.max_threads=1000\nimq.jms.threadpool_model=dedicated\nimq.jmsdirect.servicetype=NORMAL\nimq.jmsdirect.handler_name=direct\nimq.mqdirect.servicetype=NORMAL\nimq.mqdirect.threadpool_model=dedicated\nimq.mqdirect.min_threads=10\nimq.mqdirect.max_threads=1000\nimq.mqdirect.handler_name=mqdirect\nimq.mqdirect2.servicetype=NORMAL\nimq.mqdirect2.handler_name=mqdirect2\nimq.ssljms.protocoltype=tls\nimq.ssljms.servicetype=NORMAL\nimq.ssljms.tls.port=0\nimq.ssljms.tls.backlog=100\nimq.ssljms.tcp.blocking=true\nimq.ssljms.tcp.useChannels=false\nimq.ssljms.min_threads=10\nimq.ssljms.max_threads=500\nimq.ssljms.threadpool_model=dedicated\nimq.keystore.file.dirpath=${imq.etchome}\nimq.keystore.file.name=keystore\nimq.keystore.password=\nimq.passfile.enabled=false\nimq.passfile.dirpath=${imq.etchome}\nimq.passfile.name=keypassfile\nimq.admin.protocoltype=tcp\nimq.admin.servicetype=ADMIN\nimq.admin.tcp.port=0\nimq.admin.tcp.backlog=5\nimq.admin.tcp.blocking=true\nimq.admin.tcp.useChannels=false\nimq.admin.min_threads=4\nimq.admin.max_threads=10\nimq.admin.threadpool_model=dedicated\nimq.httpjms.protocoltype=http\nimq.httpjms.servicetype=NORMAL\nimq.httpjms.http.servletHost=localhost\nimq.httpjms.http.servletPort=7675\nimq.httpjms.http.pullPeriod=-1\nimq.httpjms.http.connectionTimeout=300\nimq.httpjms.tcp.blocking=true\nimq.httpjms.tcp.useChannels=false\nimq.httpjms.threadpool_model=dedicated\nimq.httpjms.min_threads=10\nimq.httpjms.max_threads=500\nimq.httpsjms.protocoltype=https\nimq.httpsjms.servicetype=NORMAL\nimq.httpsjms.https.servletHost=localhost\nimq.httpsjms.https.servletPort=7674\nimq.httpsjms.https.pullPeriod=-1\nimq.httpjms.http.connectionTimeout=300\nimq.httpsjms.https.isHostTrusted=true\nimq.httpsjms.min_threads=10\nimq.httpsjms.max_threads=500\nimq.httpsjms.threadpool_model=dedicated\nimq.ssladmin.protocoltype=tls\nimq.ssladmin.servicetype=ADMIN\nimq.ssladmin.tls.port=0\nimq.ssladmin.tls.backlog=5\nimq.ssladmin.tcp.blocking=true\nimq.ssladmin.tcp.useChannels=false\nimq.ssladmin.min_threads=4\nimq.ssladmin.max_threads=10\nimq.ssladmin.threadpool_model=dedicated\nimq.protocol.tcp.inbufsz=2048\nimq.protocol.tcp.outbufsz=2048\nimq.protocol.tls.inbufsz=2048\nimq.protocol.tls.outbufsz=2048\nimq.protocol.http.inbufsz=2048\nimq.protocol.http.outbufsz=2048\nimq.protocol.https.inbufsz=2048\nimq.protocol.https.outbufsz=2048\nimq.protocol.tcp.nodelay=true\nimq.protocol.tls.nodelay=true\nimq.protocol.http.nodelay=true\nimq.protocol.https.nodelay=true\nimq.jmx.usePlatformMBeanServer=true\nimq.jmx.rmiregistry.start=false\nimq.jmx.rmiregistry.use=false\nimq.jmx.connector.list=jmxrmi,ssljmxrmi\nimq.jmx.connector.activelist=jmxrmi\nimq.jmx.connector.ssljmxrmi.useSSL=true\nimq.portmapper.port=7676\nimq.portmapper.bind=true\nimq.portmapper.backlog=50\nimq.portmapper.sotimeout=500\nimq.portmapper.solinger=5\nimq.message.expiration.interval=60\nimq.system.max_count=-1\nimq.system.max_size=-1\nimq.message.max_size=-1\nimq.persist.store=file\nimq.persist.file.message.vrfile.threshold_factor=0\nimq.persist.file.message.vrfile.threshold=0\nimq.persist.file.message.vrfile.growth_factor=50\nimq.persist.file.message.vrfile.initial_size=1m\nimq.persist.file.message.vrfile.block_size=256\nimq.persist.file.message.max_record_size=1m\nimq.persist.file.message.filepool.cleanratio=60\nimq.persist.file.destination.message.filepool.limit=100\nimq.persist.file.message.cleanup=false\nimq.persist.file.destination.file.size=1m\nimq.authentication.basic.user_repository=file\nimq.authentication.digest.user_repository=file\nimq.authentication.type=digest\nimq.authentication.client.response.timeout=180\nimq.user_repository.file.filename=passwd\nimq.user_repository.file.dirpath=${imq.instanceshome}${/}${imq.instancename}${/}etc\nimq.user_repository.ldap.grpsearch=false\nimq.user_repository.ldap.ssl_enabled=false\nimq.user_repository.ldap.ssl.socketfactory=com.sun.messaging.jmq.jmsserver.auth.ldap.TrustSSLSocketFactory\nimq.user_repository.ldap.timeout=180\nimq.accesscontrol.enabled=true\nimq.accesscontrol.type=file\nimq.accesscontrol.file.dirpath=${imq.instanceshome}${/}${imq.instancename}${/}etc\nimq.accesscontrol.file.filename=accesscontrol.properties\nimq.metrics.enabled=true\nimq.metrics.interval=0\nimq.metrics.topic.enabled=true\nimq.metrics.topic.interval=60\nimq.metrics.topic.persist=false\nimq.metrics.topic.timetolive=300\nimq.autocreate.topic=true\nimq.autocreate.queue=true\nimq.autocreate.queue.maxNumActiveConsumers=-1\nimq.autocreate.queue.maxNumBackupConsumers=0\nimq.queue.deliverypolicy=single\nimq.queue.rr.messageblock=5\nimq.restart.code=255\nimq.protocol.list=tcp\nimq.service.list=jms,admin,ssljms,httpjms,httpsjms,ssladmin\nimq.authentication.basic.properties=class,user_repository\nimq.authentication.basic.class=com.sun.messaging.jmq.jmsserver.auth.JMQBasicAuthenticationHandler\nimq.authentication.digest.properties=class,user_repository\nimq.authentication.digest.class=com.sun.messaging.jmq.jmsserver.auth.JMQDigestAuthenticationHandler\nimq.user_repository.file.properties=class,filename,userPrincipalClass,groupPrincipalClass,dirpath\nimq.user_repository.file.class=com.sun.messaging.jmq.jmsserver.auth.file.JMQFileUserRepository\nimq.user_repository.file.userPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQUser\nimq.user_repository.file.groupPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQGroup\nimq.user_repository.ldap.properties=class,server,principal,password,base,uidattr,usrformat,usrfilter,grpsearch,grpbase,gidattr,memattr,grpfilter,timeout,ssl.enabled,ssl.socketfactory,userPrincipalClass,groupPrincipalClass\nimq.user_repository.ldap.class=com.sun.messaging.jmq.jmsserver.auth.ldap.LdapUserRepository\nimq.user_repository.ldap.userPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQUser\nimq.user_repository.ldap.groupPrincipalClass=com.sun.messaging.jmq.auth.jaas.MQGroup\nimq.user_repository.jaas.properties=class,name,userPrincipalClass,groupPrincipalClass,subjectHelperClass,subjectHelperClass.props\nimq.user_repository.jaas.class=com.sun.messaging.jmq.jmsserver.auth.jaas.UserRepositoryImpl\nimq.accesscontrol.file.properties=class,filename,dirpath,url\nimq.accesscontrol.file.class=com.sun.messaging.jmq.jmsserver.auth.acl.JMQFileAccessControlModel\nimq.accesscontrol.jaas.properties=class,permissionFactory,permissionFactoryProvide,policyProvider\nimq.accesscontrol.jaas.class=com.sun.messaging.jmq.jmsserver.auth.acl.JAASAccessControlModel\nimq.log.file.class=com.sun.messaging.jmq.util.log.FileLogHandler\nimq.log.console.class=com.sun.messaging.jmq.util.log.StreamLogHandler\nimq.log.syslog.class=com.sun.messaging.jmq.util.log.SysLogHandler\nimq.log.destination.class=com.sun.messaging.jmq.jmsserver.service.DestinationLogHandler\nimq.log.destination.topic=mq.log.broker\nimq.log.jmx.class=com.sun.messaging.jmq.jmsserver.management.agent.JMXLogHandler\nimq.protocol.tcp.propertylist=port,backlog,useChannels,blocking,hostname\nimq.protocol.tcp.class=com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol\nimq.protocol.tls.propertylist=port,backlog,keystore,useChannels,blocking,hostname\nimq.protocol.tls.class=com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol\nimq.protocol.http.propertylist=servletHost,servletPort,pullPeriod,connectionTimeout,useChannels,blocking\nimq.protocol.http.class=com.sun.messaging.jmq.jmsserver.net.http.HTTPProtocol\nimq.protocol.https.propertylist=servletHost,servletPort,pullPeriod,connectionTimeout,isHostTrusted\nimq.protocol.https.class=com.sun.messaging.jmq.jmsserver.net.https.HttpsProtocol\nimq.service_handler.mqdirect.class=com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedServiceFactory\nimq.service_handler.mqdirect2.class=com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadServiceFactory\nimq.service_handler.dedicated.class=com.sun.messaging.jmq.jmsserver.service.imq.dedicated.DedicatedServiceFactory\nimq.service_handler.shared_old.class=com.sun.messaging.jmq.jmsserver.service.imq.group.GroupServiceFactory\nimq.service_handler.group_old.class=com.sun.messaging.jmq.jmsserver.service.imq.group.GroupServiceFactory\nimq.service_handler.direct.class=com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectServiceFactory\nimq.service_handler.shared.class=com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPServiceFactory\nimq.selectors.limit=16\nimq.cluster.port=0\nimq.cluster.masterbroker.enforce=true\nimq.cluster.locktimeout=60\nimq.cluster.sharecc.persist=jdbc\nimq.cluster.sharecc.persistCreate=true\nimq.memory.levels=green,yellow,orange,red\nimq.memory.hysteresis=1024\nimq.memory.overhead=10240\nimq.memory.gcdelta=1024\nimq.green.threshold=0\nimq.green.count=50000\nimq.green.gccount=0\nimq.green.gcitr=0\nimq.green.classname=com.sun.messaging.jmq.jmsserver.memory.levels.Green\nimq.yellow.threshold=60\nimq.yellow.classname=com.sun.messaging.jmq.jmsserver.memory.levels.Yellow\nimq.yellow.count=50\nimq.yellow.gccount=1\nimq.yellow.gcitr=1000\nimq.yellow.seconds=2\nimq.orange.threshold=80\nimq.orange.classname=com.sun.messaging.jmq.jmsserver.memory.levels.Orange\nimq.orange.count=1\nimq.orange.gccount=5\nimq.orange.gcitr=100\nimq.orange.seconds=1\nimq.red.threshold=90\nimq.red.classname=com.sun.messaging.jmq.jmsserver.memory.levels.Red\nimq.red.count=0\nimq.red.gccount=10\nimq.red.gcitr=5\nimq.red.seconds=10\nimq.cluster.manager.class=com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl\nimq.hacluster.jdbc.manager.class=com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl\nimq.hacluster.bdbsfs.manager.class=com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusterManagerImpl\nimq.cluster.migratable.bdb.manager.class=com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusterManagerImpl\nimq.cluster.heartbeat.class=com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatImpl\n";
    public static final String Logger_FallbackProperties = "handlers=java.util.logging.FileHandler, java.util.logging.ConsoleHandler, com.sun.messaging.jmq.jmsserver.management.agent.JMXLogHandler\n.level=INFO\njava.util.logging.FileHandler.level=ALL\njava.util.logging.FileHandler.formatter=com.sun.messaging.jmq.util.log.UniformLogFormatter\njava.util.logging.FileHandler.limit=268435456\njava.util.logging.FileHandler.pattern=${imq.instanceshome}${/}${imq.instancename}${/}log${/}log.txt\njava.util.logging.FileHandler.append=true\ncom.sun.enterprise.server.logging.GFFileHandler.file=${imq.instanceshome}${/}${imq.instancename}${/}log${/}log.txt\n)com.sun.enterprise.server.logging.GFFileHandler.formatter=com.sun.messaging.jmq.util.log.UniformLogFormatter\ncom.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes=268435456\ncom.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes=10080\ncom.sun.enterprise.server.logging.GFFileHandler.level = ALL\njava.util.logging.ConsoleHandler.formatter=com.sun.messaging.jmq.util.log.UniformLogFormatter\njava.util.logging.ConsoleHandler.level=INFO\nimq.log.jmx.output=ALL\nsun.os. patch.level=unknown\n";
    private static final String JMQ_prop_loc = CommGlobals.JMQ_LIB_HOME + File.separator + CommGlobals.JMQ_BROKER_PROP_LOC;
    private static final String default_loc = JMQ_prop_loc + "default.properties";
    private static final String install_loc = JMQ_prop_loc + "install.properties";
    private static final String ConfigStoreProperty = "imq.config.class";
    private static final String Default_Config_Store = "com.sun.messaging.jmq.jmsserver.config.FileConfigStore";
    Properties params = null;
    ConfigStore localconfig = null;
    Logger logger = null;

    public BrokerConfig(String configname, Properties params, boolean resetProp, Properties saveProps) throws BrokerException {
        if (params == null) {
            params = new Properties();
        }
        this.params = params;
        this.logger = CommGlobals.getLogger();
        this.logger.log(4, "B1001", CommGlobals.JMQ_HOME);
        Object is = null;
        try {
            this.load(new ByteArrayInputStream(JMQ_FallbackProperties.getBytes()));
        }
        catch (IOException ex1) {
            throw new BrokerException(CommGlobals.getBrokerResources().getString("B4117", "unable to load fallback properties"), ex1);
        }
        try {
            this.load(new ByteArrayInputStream(Logger_FallbackProperties.getBytes()));
        }
        catch (IOException ex1) {
            throw new BrokerException(CommGlobals.getBrokerResources().getString("B4117", "unable to load logger fallback properties"), ex1);
        }
        try {
            this.loadDefaultProperties(default_loc);
        }
        catch (IOException ex) {
            this.logger.log(16, "B2001", "default", default_loc, ex);
            this.logger.log(32, "B3001");
            return;
        }
        try {
            this.loadDefaultProperties(install_loc);
        }
        catch (Exception ex) {
            this.logger.log(16, "B2001", "install", install_loc, ex);
        }
        String configprop = super.getProperty(ConfigStoreProperty, Default_Config_Store);
        try {
            this.localconfig = (ConfigStore)Class.forName(configprop).newInstance();
        }
        catch (Exception ex) {
            this.logger.logStack(32, "B3002", configprop, (Throwable)ex);
        }
        if (this.localconfig != null) {
            Properties storedprops;
            Properties clusterprops;
            if (resetProp) {
                this.localconfig.clearProps(configname);
            }
            if ((clusterprops = this.localconfig.loadClusterProps(this, params, storedprops = this.localconfig.loadStoredProps(this, configname))) != null) {
                this.putAll((Map)clusterprops);
            }
            this.setStoredProperties(storedprops);
        }
        this.putAll((Map)System.getProperties());
        this.putAll((Map)params);
        if (saveProps != null) {
            this.setStoredProperties(saveProps);
        }
        this.checkProperties();
    }

    protected void checkProperties() {
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            char c;
            String value;
            String name = (String)keys.nextElement();
            if (name == null || (value = this.getProperty(name)) == null || value.length() <= 0 || !Character.isSpaceChar(c = value.charAt(value.length() - 1))) continue;
            Exception e = null;
            value = value.trim();
            try {
                this.updateProperty(name, value);
            }
            catch (Exception ex) {
                e = ex;
                this.put(name, value);
            }
            if (e == null) {
                this.logger.log(16, "B2072", (Object)name, value);
                continue;
            }
            this.logger.log(16, "B2072", name, value, e);
        }
    }

    @Override
    protected void saveUpdatedProperties(Properties props) throws IOException {
        if (this.localconfig == null) {
            this.logger.log(16, "B2002");
            return;
        }
        this.localconfig.storeProperties(this.storedprops);
    }

    public void reloadProps(String instancename, String[] propnames) throws BrokerException {
        this.reloadProps(instancename, propnames, true);
    }

    public void reloadProps(String instancename, String[] propnames, boolean overideparams) throws BrokerException {
        Properties sprops;
        if (this.localconfig == null) {
            return;
        }
        ArrayList<String> newpropnames = new ArrayList<String>();
        for (int i = 0; i < propnames.length; ++i) {
            if (overideparams) {
                this.remove(propnames[i]);
                continue;
            }
            if (this.params.get(propnames[i]) != null) continue;
            this.remove(propnames[i]);
            newpropnames.add(propnames[i]);
        }
        if (!overideparams) {
            propnames = newpropnames.toArray(new String[newpropnames.size()]);
        }
        if ((sprops = this.localconfig.reloadProps(instancename, propnames)) == null) {
            sprops = new Properties();
        }
        Properties clusterprops = this.localconfig.loadClusterProps(this, new Properties(), sprops);
        Properties cprops = new Properties();
        if (clusterprops != null) {
            String value = null;
            for (int i = 0; i < propnames.length; ++i) {
                value = clusterprops.getProperty(propnames[i]);
                if (value == null) continue;
                cprops.setProperty(propnames[i], value);
            }
        }
        cprops.putAll((Map<?, ?>)sprops);
        try {
            this.updateProperties(cprops, false);
        }
        catch (Exception ex) {
            this.putAll((Map)cprops);
        }
    }
}

