/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.SessionOp;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.DestinationSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.SessionOpSpi;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Session
implements EventBroadcaster,
EventListener {
    protected static boolean DEBUG = false;
    protected static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG;
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;
    public static final int NO_ACK_ACKNOWLEDGE = 32768;
    public static final int NONE = 0;
    protected Logger logger = Globals.getLogger();
    private int ackType = 0;
    private boolean isTransacted = false;
    private boolean isXATransacted = false;
    private TransactionUID currentTransactionID = null;
    SessionUID uid;
    Object sessionLock = new Object();
    EventBroadcastHelper evb = new EventBroadcastHelper();
    Map consumers = null;
    Map listeners = null;
    Set busyConsumers = null;
    boolean paused = false;
    int pausecnt = 0;
    boolean valid = false;
    private boolean busy = false;
    ConnectionUID parentCuid = null;
    transient String creator = null;
    transient CoreLifecycleSpi coreLifecycle = null;
    transient SessionOpSpi ssop = null;
    private static boolean NOACK_ENABLED = false;
    static Map ConsumerToSession;
    static Map allSessions;

    public static boolean isValidAckType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                return true;
            }
        }
        return false;
    }

    public SessionOpSpi getSessionOp() {
        return this.ssop;
    }

    public ConnectionUID getConnectionUID() {
        return this.parentCuid;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "All Sessions");
        Hashtable<String, Object> all = new Hashtable<String, Object>();
        Map map = allSessions;
        synchronized (map) {
            ht.put("allSessionCnt", String.valueOf(allSessions.size()));
            for (Session s : allSessions.values()) {
                all.put(String.valueOf(s.getSessionUID().longValue()), s.getDebugState());
            }
        }
        ht.put("allSessions", all);
        all = new Hashtable();
        map = ConsumerToSession;
        synchronized (map) {
            ht.put("ConsumerToSessionCnt", String.valueOf(ConsumerToSession.size()));
            for (Object o : ConsumerToSession.keySet()) {
                all.put(o.toString(), ConsumerToSession.get(o).toString());
            }
        }
        ht.put("ConsumerToSession", all);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "Session[" + this.uid.longValue() + "]");
        ht.put("uid", String.valueOf(this.uid.longValue()));
        ht.put("connection", String.valueOf(this.parentCuid.longValue()));
        ht.put("paused", String.valueOf(this.paused));
        ht.put("pausecnt", String.valueOf(this.pausecnt));
        ht.put("valid", String.valueOf(this.valid));
        ht.put("busy", String.valueOf(this.busy));
        ht.put("SessionOp", this.ssop.getDebugState());
        ht.put("consumerCnt", String.valueOf(this.consumers.size()));
        Vector<String> v = new Vector<String>();
        Object object = this.consumers;
        synchronized (object) {
            for (ConsumerUID cuid : this.consumers.keySet()) {
                v.add(String.valueOf(cuid.longValue()));
            }
        }
        ht.put("consumers", v);
        ht.put("busyConsumerCnt", String.valueOf(this.busyConsumers.size()));
        v = new Vector();
        object = this.busyConsumers;
        synchronized (object) {
            for (ConsumerUID cuid : this.busyConsumers) {
                v.add(String.valueOf(cuid.longValue()));
            }
        }
        ht.put("busyConsumers", v);
        return ht;
    }

    public Vector getDebugMessages(boolean full) {
        return this.ssop.getDebugMessages(full);
    }

    public int getNumPendingAcks(ConsumerUID uid) {
        return this.getPendingAcks(uid).size();
    }

    public List getPendingAcks(ConsumerUID uid) {
        return this.ssop.getPendingAcks(uid);
    }

    public void setAckType(int type) throws BrokerException {
        if (!Session.isValidAckType(type)) {
            throw new BrokerException("Internal Error: Invalid Ack Type :" + type, 400);
        }
        if (type == 32768 && !NOACK_ENABLED) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3122", Globals.getBrokerResources().getKString("B0058")), "B3122", null, 405);
        }
        this.ssop.checkAckType(type);
        this.ackType = type;
    }

    public int getConsumerCnt() {
        if (this.consumers == null) {
            return 0;
        }
        return this.consumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConsumers() {
        if (this.consumers == null) {
            return new ArrayList().iterator();
        }
        Map map = this.consumers;
        synchronized (map) {
            return new ArrayList(this.consumers.values()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConsumerUIDs() {
        if (this.consumers == null) {
            return new ArrayList();
        }
        Map map = this.consumers;
        synchronized (map) {
            return new ArrayList(this.consumers.keySet());
        }
    }

    public boolean isAutoAck(ConsumerUID uid) {
        if (this.isUnknown()) {
            return uid.isAutoAck();
        }
        return this.ackType == 1;
    }

    public boolean isUnknown() {
        return this.ackType == 0;
    }

    public boolean isClientAck(ConsumerUID uid) {
        if (this.isUnknown()) {
            return !uid.isAutoAck() && !uid.isDupsOK();
        }
        return this.ackType == 2;
    }

    public boolean isDupsOK(ConsumerUID uid) {
        if (this.isUnknown()) {
            return uid.isDupsOK();
        }
        return this.ackType == 3;
    }

    public boolean isUnsafeAck(ConsumerUID uid) {
        return this.isDupsOK(uid) || this.isNoAck(uid);
    }

    public boolean isNoAck(ConsumerUID uid) {
        if (this.isUnknown()) {
            return uid.isNoAck();
        }
        return this.ackType == 32768;
    }

    public boolean isTransacted() {
        return this.isTransacted;
    }

    public boolean isXATransacted() {
        return this.isXATransacted;
    }

    public TransactionUID getCurrentTransactionID() {
        return this.currentTransactionID;
    }

    public ConsumerUID getStoredIDForDetatchedConsumer(ConsumerUID cuid) {
        return ((SessionOp)this.ssop).getStoredIDForDetatchedConsumer(cuid);
    }

    public void debug(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.logger.log(8, prefix + "Session " + this.uid);
        this.logger.log(8, "Paused " + this.paused);
        this.logger.log(8, "pausecnt " + this.pausecnt);
        this.logger.log(8, "busy " + this.busy);
        this.logger.log(8, "ConsumerCnt " + this.consumers.size());
        this.logger.log(8, "BusyConsumerCnt " + this.consumers.size());
        for (ConsumerSpi c : this.consumers.values()) {
            c.debug("\t");
        }
    }

    private Session(ConnectionUID uid, String sysid, CoreLifecycleSpi clc) {
        this(new SessionUID(), uid, sysid, clc);
    }

    private Session(SessionUID uid, ConnectionUID cuid, String sysid, CoreLifecycleSpi clc) {
        this.uid = uid;
        this.parentCuid = cuid;
        this.consumers = Collections.synchronizedMap(new HashMap());
        this.listeners = Collections.synchronizedMap(new HashMap());
        this.busyConsumers = Collections.synchronizedSet(new LinkedHashSet());
        this.valid = true;
        this.creator = sysid;
        this.coreLifecycle = clc;
        this.ssop = this.coreLifecycle.newSessionOp(this);
        DEBUG = DEBUG || this.logger.getLevel() <= 4 || DEBUG_CLUSTER_MSG;
        this.logger.log(4, "Created new session " + uid + " on connection " + cuid);
    }

    public void dump(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.logger.log(8, prefix + " Session " + this.uid);
        this.logger.log(8, prefix + "---------------------------");
        this.logger.log(8, prefix + "busyConsumers (size) " + this.busyConsumers.size());
        this.logger.log(8, prefix + "busyConsumers (list) " + this.busyConsumers);
        this.logger.log(8, prefix + "consumers (size) " + this.consumers.size());
        this.logger.log(8, prefix + "consumers (list) " + this.consumers);
        this.logger.log(8, prefix + "---------------------------");
        Iterator itr = this.consumers.values().iterator();
        while (itr.hasNext()) {
            ((ConsumerSpi)itr.next()).dump(prefix + "\t");
        }
    }

    public SessionUID getSessionUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String reason) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.paused = true;
            ++this.pausecnt;
            if (DEBUG) {
                this.logger.log(8, "Session: Pausing " + this + "[" + this.pausecnt + "]" + reason);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String reason) {
        Object object = this.sessionLock;
        synchronized (object) {
            --this.pausecnt;
            if (this.pausecnt <= 0) {
                this.paused = false;
            }
            assert (this.pausecnt >= 0) : "Bad pause " + this;
            if (DEBUG) {
                this.logger.log(8, "Session: Resuming " + this + "[" + this.pausecnt + "]" + reason);
            }
        }
        this.checkState(null);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hasWork() {
        return this.busyConsumers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillNextPacket(Packet p, ConsumerUID cid) {
        if (this.paused) {
            return false;
        }
        ConsumerSpi consumer = (ConsumerSpi)this.consumers.get(cid);
        Object ref = null;
        Object object = this.sessionLock;
        synchronized (object) {
            ref = consumer.getAndFillNextPacket(p);
            if (ref == null) {
                return false;
            }
            return this.ssop.onMessageDelivery(consumer, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID fillNextPacket(Packet p) {
        if (this.paused) {
            return null;
        }
        ConsumerUID cid = null;
        ConsumerSpi consumer = null;
        while (!this.paused) {
            Set set = this.busyConsumers;
            synchronized (set) {
                if (this.busyConsumers.isEmpty()) {
                    break;
                }
                Iterator itr = this.busyConsumers.iterator();
                cid = (ConsumerUID)itr.next();
                consumer = (ConsumerSpi)this.consumers.get(cid);
                itr.remove();
            }
            assert (p != null);
            if (consumer == null) {
                return null;
            }
            Object ref = null;
            Object object = this.sessionLock;
            synchronized (object) {
                Set set2;
                if (this.paused) {
                    set2 = this.busyConsumers;
                    synchronized (set2) {
                        if (consumer.isBusy()) {
                            this.busyConsumers.add(cid);
                        }
                    }
                    return null;
                }
                ref = consumer.getAndFillNextPacket(p);
                set2 = this.busyConsumers;
                synchronized (set2) {
                    if (consumer.isBusy()) {
                        this.busyConsumers.add(cid);
                    }
                }
                if (ref == null) {
                    continue;
                }
                if (!this.ssop.onMessageDelivery(consumer, ref)) {
                    continue;
                }
            }
            this.checkState(null);
            return ref != null && cid != null ? cid : null;
        }
        this.checkState(null);
        return null;
    }

    public Object getBusyLock() {
        return this.busyConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Set set = this.busyConsumers;
        synchronized (set) {
            return this.busy;
        }
    }

    public String toString() {
        return "Session [" + this.uid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachConsumer(ConsumerSpi c) throws BrokerException {
        this.logger.log(4, "Attaching Consumer " + c.getConsumerUID() + " to Session " + this.uid);
        if (!this.valid) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4360", this.toString()));
        }
        c.attachToSession(this.getSessionUID());
        ConsumerUID cuid = c.getConsumerUID();
        cuid.setAckType(this.ackType);
        c.getStoredConsumerUID().setAckType(this.ackType);
        this.consumers.put(cuid, c);
        DestinationSpi d = c.getFirstDestination();
        this.listeners.put(cuid, c.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        if (c.isBusy()) {
            this.busyConsumers.add(cuid);
        }
        Map map = ConsumerToSession;
        synchronized (map) {
            ConsumerToSession.put(c.getConsumerUID(), this.getSessionUID());
        }
        this.checkState(null);
    }

    public ConsumerSpi detatchConsumer(ConsumerUID c, SysMessageID id, boolean idInTransaction, boolean redeliverPendingConsume, boolean redeliverAll) throws BrokerException {
        this.pause("Consumer.java: detatch consumer " + c);
        ConsumerSpi con = (ConsumerSpi)this.consumers.remove(c);
        if (con == null) {
            assert (con != null);
            this.resume("Consumer.java: bad removal " + c);
            throw new BrokerException("Detatching consumer " + c + " not currently attached " + "to " + this);
        }
        con.pause("Consumer.java: detatch consumer " + c + " DEAD");
        this.detatchConsumer(con, id, idInTransaction, redeliverPendingConsume, redeliverAll);
        this.resume("Consumer.java: detatch consumer " + c);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detatchConsumer(ConsumerSpi con, SysMessageID id, boolean idInTransaction, boolean redeliverPendingConsume, boolean redeliverAll) {
        if (DEBUG) {
            this.logger.log(8, "Detaching Consumer " + con.getConsumerUID() + " on connection " + con.getConnectionUID() + " from Session " + this.uid + " last id was " + id);
        }
        con.pause("Consumer.java: Detatch consumer 1 " + con);
        this.pause("Consumer.java: Detatch consumer A " + con);
        ConsumerUID c = con.getConsumerUID();
        ConsumerUID sid = con.getStoredConsumerUID();
        Object listener = this.listeners.remove(c);
        assert (listener != null);
        con.removeEventListener(listener);
        con.attachToSession(null);
        this.busyConsumers.remove(c);
        this.consumers.remove(c);
        this.checkState(null);
        Connection conn = Globals.getConnectionManager().getConnection(this.getConnectionUID());
        if (this.ssop.detachConsumer(con, id, idInTransaction, redeliverPendingConsume, redeliverAll, conn)) {
            Map map = ConsumerToSession;
            synchronized (map) {
                ConsumerToSession.remove(c);
            }
        }
        this.resume("Consumer.java: resuming after detatch " + con);
    }

    public Object ackInTransaction(ConsumerUID cuid, SysMessageID id, TransactionUID tuid, boolean isXA, int deliverCnt) throws BrokerException {
        if (!this.isTransacted) {
            this.isTransacted = true;
        }
        if (isXA && !this.isXATransacted) {
            this.isXATransacted = true;
        }
        this.currentTransactionID = tuid;
        return this.ssop.ackInTransaction(cuid, id, tuid, deliverCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Session session = this;
        synchronized (session) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        if (DEBUG) {
            this.logger.log(8, "Close Session " + this.uid);
        }
        Connection conn = Globals.getConnectionManager().getConnection(this.getConnectionUID());
        boolean old = false;
        if (conn != null && conn.getClientProtocolVersion() < 350) {
            old = true;
        }
        Iterator itr = null;
        Object object = this;
        synchronized (object) {
            itr = new HashSet(this.consumers.values()).iterator();
        }
        while (itr.hasNext()) {
            ConsumerSpi c = (ConsumerSpi)itr.next();
            itr.remove();
            this.detatchConsumer(c, null, false, old, false);
        }
        this.ssop.close(conn);
        object = ConsumerToSession;
        synchronized (object) {
            Iterator citr = ConsumerToSession.values().iterator();
            while (citr.hasNext()) {
                SessionUID suid = (SessionUID)citr.next();
                if (!suid.equals(this.uid)) continue;
                citr.remove();
            }
        }
        allSessions.remove(this.uid);
    }

    public Object handleUndeliverable(ConsumerUID cuid, SysMessageID id, int deliverCnt, boolean deliverCntUpdateOnly) throws BrokerException {
        ConsumerSpi c = this.coreLifecycle.getConsumer(cuid);
        return this.ssop.handleUndeliverable(c, id, deliverCnt, deliverCntUpdateOnly);
    }

    public Object handleDead(ConsumerUID cuid, SysMessageID id, RemoveReason deadReason, Throwable thr, String comment, int deliverCnt) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "handleDead[" + id + ", " + cuid + "]" + deadReason);
        }
        ConsumerSpi c = this.coreLifecycle.getConsumer(cuid);
        return this.ssop.handleDead(c, id, deadReason, thr, comment, deliverCnt);
    }

    public Object ackMessage(ConsumerUID cuid, SysMessageID id, boolean ackack) throws BrokerException {
        return this.ackMessage(cuid, id, null, null, null, ackack);
    }

    public Object ackMessage(ConsumerUID cuid, SysMessageID id, TransactionUID tuid, TransactionList translist, HashMap<TransactionBroker, Object> remoteNotified, boolean ackack) throws BrokerException {
        return this.ssop.ackMessage(cuid, id, tuid, translist, remoteNotified, ackack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAckMessage(ConsumerUID cuid, SysMessageID id, boolean ackack) throws BrokerException {
        this.ssop.postAckMessage(cuid, id, ackack);
        if (this.isValid() && this.consumers.get(cuid) == null && !this.ssop.hasDeliveredMessages(cuid)) {
            Map map = ConsumerToSession;
            synchronized (map) {
                ConsumerToSession.remove(cuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        ConsumerUID cuid = ((ConsumerSpi)target).getConsumerUID();
        if (type == EventType.BUSY_STATE_CHANGED) {
            Set set = this.busyConsumers;
            synchronized (set) {
                ConsumerSpi c = (ConsumerSpi)this.consumers.get(cuid);
                if (c != null && c.isBusy()) {
                    this.busyConsumers.add(cuid);
                }
            }
            this.checkState(null);
        } else assert (false) : " event is not valid ";
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) throws UnsupportedOperationException {
        if (type != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(listener, type, userData);
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) throws UnsupportedOperationException {
        if (type != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(listener, type, reason, userData);
    }

    @Override
    public Object removeEventListener(Object id) {
        return this.evb.removeEventListener(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason r) {
        boolean notify = false;
        boolean isBusy = false;
        Set set = this.busyConsumers;
        synchronized (set) {
            boolean bl = isBusy = !this.paused && this.busyConsumers.size() > 0;
            if (isBusy != this.busy) {
                this.busy = isBusy;
                notify = true;
            }
        }
        if (notify) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, r, this, !isBusy, isBusy);
        }
    }

    private void notifyChange(EventType type, Reason r, Object target, Object oldval, Object newval) {
        this.evb.notifyChange(type, r, target, oldval, newval);
    }

    public synchronized ConsumerSpi getConsumerOnSession(ConsumerUID uid) {
        return (ConsumerSpi)this.consumers.get(uid);
    }

    public static void clearSessions() {
        ConsumerToSession.clear();
        allSessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(ConsumerUID uid) {
        SessionUID suid = null;
        Map map = ConsumerToSession;
        synchronized (map) {
            suid = (SessionUID)ConsumerToSession.get(uid);
        }
        if (suid == null) {
            return null;
        }
        return Session.getSession(suid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll() {
        Map map = allSessions;
        synchronized (map) {
            Globals.getLogger().log(8, "Dumping active sessions");
            for (Object k : allSessions.keySet()) {
                Object v = allSessions.get(k);
                Globals.getLogger().log(8, "\t" + k + " : " + v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(ConnectionUID uid, String id, CoreLifecycleSpi clc) {
        Session s = new Session(uid, id, clc);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(s.getSessionUID(), s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(SessionUID uid, ConnectionUID cuid, String id, CoreLifecycleSpi clc) {
        Session s = new Session(uid, cuid, id, clc);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(s.getSessionUID(), s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(SessionUID uid) {
        Session s = null;
        Map map = allSessions;
        synchronized (map) {
            s = (Session)allSessions.remove(uid);
        }
        if (s == null) {
            return;
        }
        assert (s != null);
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(SessionUID uid) {
        Map map = allSessions;
        synchronized (map) {
            return (Session)allSessions.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(String creator) {
        if (creator == null) {
            return null;
        }
        Map map = allSessions;
        synchronized (map) {
            for (Session c : allSessions.values()) {
                if (!creator.equals(c.creator)) continue;
                return c;
            }
        }
        return null;
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            NOACK_ENABLED = license.getBooleanProperty("imq.enable_no_ack", false);
        }
        catch (BrokerException ex) {
            NOACK_ENABLED = false;
        }
        ConsumerToSession = new HashMap();
        allSessions = new HashMap();
    }
}

