/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.migration;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class TransactionAcknowledgement
implements Serializable {
    static final long serialVersionUID = 1518763750089861353L;
    private static Logger logger = Globals.getLogger();
    transient SysMessageID sysid = null;
    ConsumerUID iid = null;
    ConsumerUID sid = null;

    public TransactionAcknowledgement() {
    }

    public TransactionAcknowledgement(SysMessageID sysid, ConsumerUID iid, ConsumerUID sid) {
        this.sysid = sysid;
        this.iid = iid;
        this.sid = sid;
    }

    public ConsumerUID getConsumerUID() {
        return this.iid;
    }

    public ConsumerUID getStoredConsumerUID() {
        return this.sid;
    }

    public SysMessageID getSysMessageID() {
        return this.sysid;
    }

    public int hashCode() {
        return this.sysid.hashCode() + this.iid.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof TransactionAcknowledgement && this.hashCode() == o.hashCode();
    }

    public String toString() {
        return "[" + this.sysid.toString() + "]" + this.iid.toString() + ":" + this.sid.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.sysid.writeID(new DataOutputStream(s));
        s.writeObject(this.iid);
        s.writeObject(this.sid);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.sysid = new SysMessageID();
        this.sysid.readID(new DataInputStream(s));
        this.iid = (ConsumerUID)s.readObject();
        try {
            this.sid = (ConsumerUID)s.readObject();
        }
        catch (Exception ex) {
            logger.log(4, "ReadObject: old transaction format");
            this.sid = this.iid;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement obj = new com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement(this.sysid, this.iid, this.sid);
        return obj;
    }
}

