/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class TransactionUtil {
    private static final String[] transactionInfoMonitorItemNames = new String[]{"ClientID", "ConnectionString", "CreationTime", "NumAcks", "NumMsgs", "State", "StateLabel", "TransactionID", "User", "XID"};
    private static final String[] transactionInfoMonitorItemDesc = transactionInfoMonitorItemNames;
    private static final OpenType[] transactionInfoMonitorItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    private static CompositeType monitorCompType = null;

    public static int toExternalTransactionState(int internalTransactionState) {
        switch (internalTransactionState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return -1;
    }

    public static int toInternalTransactionState(int externalTransactionState) {
        switch (externalTransactionState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return -1;
    }

    public static String[] getTransactionIDs() {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        Vector transactions = tl.getTransactions(-1);
        if (transactions == null || transactions.size() == 0) {
            return null;
        }
        String[] ids = new String[transactions.size()];
        Enumeration e = transactions.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            TransactionUID tid = (TransactionUID)e.nextElement();
            long txnID = tid.longValue();
            ids[i] = Long.toString(txnID);
            ++i;
        }
        return ids;
    }

    public static CompositeData[] getTransactionInfo() throws BrokerException, OpenDataException {
        String[] ids = TransactionUtil.getTransactionIDs();
        if (ids == null) {
            return null;
        }
        CompositeData[] cds = new CompositeData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            cds[i] = TransactionUtil.getTransactionInfo(ids[i]);
        }
        return cds;
    }

    public static CompositeData getTransactionInfo(String transactionID) throws BrokerException, OpenDataException {
        CompositeData cd = null;
        TransactionUID tid = null;
        BrokerResources rb = Globals.getBrokerResources();
        if (transactionID == null) {
            throw new IllegalArgumentException(rb.getString("B4269"));
        }
        long longTid = 0L;
        try {
            longTid = Long.parseLong(transactionID);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(rb.getString("B4270", transactionID));
        }
        tid = new TransactionUID(longTid);
        if (tid == null) {
            throw new BrokerException(rb.getString("B4271", transactionID));
        }
        cd = TransactionUtil.getTransactionInfo(tid);
        return cd;
    }

    public static String getClientID(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        TransactionState ts = tl.retrieveState(tid);
        if (ts == null) {
            return null;
        }
        return ts.getClientID();
    }

    public static String getConnectionString(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        TransactionState ts = tl.retrieveState(tid);
        if (ts == null) {
            return null;
        }
        return ts.getConnectionString();
    }

    public static Long getCreationTime(TransactionUID tid) {
        long currentTime = System.currentTimeMillis();
        return new Long(currentTime - tid.age(currentTime));
    }

    public static Long getNumAcks(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        return new Long(tl.retrieveNConsumedMessages(tid));
    }

    public static Long getNumMsgs(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        return new Long(tl.retrieveNSentMessages(tid));
    }

    public static Integer getState(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        TransactionState ts = tl.retrieveState(tid);
        if (ts == null) {
            return null;
        }
        return new Integer(TransactionUtil.toExternalTransactionState(ts.getState()));
    }

    public static String getStateLabel(TransactionUID tid) {
        Integer i = TransactionUtil.getState(tid);
        if (i == null) {
            return null;
        }
        return com.sun.messaging.jms.management.server.TransactionState.toString(i);
    }

    public static String getUser(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        TransactionState ts = tl.retrieveState(tid);
        if (ts == null) {
            return null;
        }
        return ts.getUser();
    }

    public static String getXID(TransactionUID tid) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        if (tl == null) {
            return null;
        }
        JMQXid xid = tl.UIDToXid(tid);
        if (xid == null) {
            return null;
        }
        return xid.toString();
    }

    private static CompositeData getTransactionInfo(TransactionUID tid) throws OpenDataException {
        Object[] transactionInfoMonitorItemValues = new Object[]{TransactionUtil.getClientID(tid), TransactionUtil.getConnectionString(tid), TransactionUtil.getCreationTime(tid), TransactionUtil.getNumAcks(tid), TransactionUtil.getNumMsgs(tid), TransactionUtil.getState(tid), TransactionUtil.getStateLabel(tid), Long.toString(tid.longValue()), TransactionUtil.getUser(tid), TransactionUtil.getXID(tid)};
        CompositeDataSupport cd = null;
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("TransactionMonitorInfo", "TransactionMonitorInfo", transactionInfoMonitorItemNames, transactionInfoMonitorItemDesc, transactionInfoMonitorItemTypes);
        }
        cd = new CompositeDataSupport(monitorCompType, transactionInfoMonitorItemNames, transactionInfoMonitorItemValues);
        return cd;
    }
}

