/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;

public class ClusterTakeoverInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String brokerID = null;
    private UID storeSession = null;
    private UID brokerSession = null;
    private String brokerHost = null;
    private Long xid = null;
    private boolean fromTaker = true;
    private String taker = null;
    private Long timestamp = null;
    private boolean timedout = false;

    private ClusterTakeoverInfo(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker, boolean timedout) {
        this.brokerID = brokerID;
        this.storeSession = storeSession;
        this.brokerHost = brokerHost;
        this.brokerSession = brokerSession;
        this.xid = xid;
        this.fromTaker = fromTaker;
        this.timedout = timedout;
    }

    private ClusterTakeoverInfo(GPacket pkt) {
        assert (pkt.getType() == 41 || pkt.getType() == 39 || pkt.getType() == 43);
        this.pkt = pkt;
        this.brokerID = (String)pkt.getProp("brokerID");
        this.storeSession = new UID((Long)pkt.getProp("storeSession"));
        Long v = (Long)pkt.getProp("brokerSession");
        if (v != null) {
            this.brokerSession = new UID(v);
        }
        this.brokerHost = (String)pkt.getProp("brokerHost");
        this.taker = (String)pkt.getProp("taker");
        this.fromTaker = this.taker != null;
        this.timestamp = (Long)pkt.getProp("timestamp");
        if (this.timestamp != null) {
            this.timedout = this.timestamp.equals(new Long(0L));
        }
        this.xid = (Long)pkt.getProp("X");
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession) {
        return new ClusterTakeoverInfo(brokerID, storeSession, null, null, null, false, false);
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker) {
        return new ClusterTakeoverInfo(brokerID, storeSession, brokerHost, brokerSession, xid, fromTaker, false);
    }

    public static ClusterTakeoverInfo newInstance(String brokerID, UID storeSession, String brokerHost, UID brokerSession, Long xid, boolean fromTaker, boolean timedout) {
        return new ClusterTakeoverInfo(brokerID, storeSession, brokerHost, brokerSession, xid, fromTaker, timedout);
    }

    public static ClusterTakeoverInfo newInstance(GPacket pkt) {
        return new ClusterTakeoverInfo(pkt);
    }

    public GPacket getGPacket(short protocol) throws BrokerException {
        assert (protocol == 41 || protocol == 39 || protocol == 43);
        if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Broker is not running in HA mode"));
        }
        if (this.pkt != null) {
            assert (this.pkt.getType() == protocol);
            return this.pkt;
        }
        GPacket gp = GPacket.getInstance();
        gp.putProp("brokerID", this.brokerID);
        gp.putProp("storeSession", new Long(this.storeSession.longValue()));
        if (protocol == 41) {
            gp.setType(protocol);
            gp.setBit(1, false);
            return gp;
        }
        HAClusteredBroker cb = (HAClusteredBroker)Globals.getClusterManager().getLocalBroker();
        if (protocol == 39) {
            gp.setType((short)39);
            gp.setBit(1, false);
            gp.putProp("brokerSession", new Long(this.brokerSession.longValue()));
            gp.putProp("brokerHost", this.brokerHost);
            if (this.fromTaker) {
                this.taker = cb.getBrokerName();
                gp.putProp("taker", this.taker);
                gp.putProp("timestamp", new Long(cb.getHeartbeat()));
                gp.setBit(1, true);
            } else if (this.timedout) {
                gp.putProp("timestamp", new Long(0L));
            }
            gp.putProp("X", this.xid);
            return gp;
        }
        if (protocol == 43) {
            gp.setType((short)43);
            if (this.fromTaker) {
                gp.putProp("taker", cb.getBrokerName());
            }
            gp.setBit(1, false);
            gp.putProp("X", this.xid);
            return gp;
        }
        throw new BrokerException("Unknown protocol: " + protocol);
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    public UID getStoreSession() {
        return this.storeSession;
    }

    public Long getXid() {
        return this.xid;
    }

    public UID getBrokerSession() {
        return this.brokerSession;
    }

    public String getBrokerHost() {
        return this.brokerHost;
    }

    public String getTaker() {
        return this.taker;
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return this.timestamp;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public boolean isFromTaker() {
        return this.fromTaker;
    }

    public String toString() {
        if (this.pkt == null) {
            return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
        }
        if (this.pkt.getType() == 41) {
            return "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]";
        }
        if (this.pkt.getType() == 39) {
            String prefix = "";
            if (DEBUG) {
                if (this.getTaker() != null) {
                    prefix = this.getTaker() + "(" + (this.timestamp == null ? "" : "" + this.timestamp) + ":";
                }
                return prefix + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.getBrokerHost() + ", " + this.xid;
            }
            return prefix + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
        }
        return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(short protocol, int status, String reason) {
        assert (this.pkt != null);
        assert (protocol == 40);
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp("X", (Long)this.pkt.getProp("X"));
        gp.putProp("brokerID", this.pkt.getProp("brokerID"));
        gp.putProp("storeSession", this.pkt.getProp("storeSession"));
        gp.putProp("taker", this.pkt.getProp("taker"));
        gp.putProp("S", new Integer(status));
        if (reason != null) {
            gp.putProp("reason", reason);
        }
        return gp;
    }

    public static int getReplyStatus(GPacket reply) {
        return (Integer)reply.getProp("S");
    }

    public static String getReplyStatusReason(GPacket reply) {
        return (String)reply.getProp("reason");
    }

    public static Long getReplyXid(GPacket reply) {
        return (Long)reply.getProp("X");
    }

    public static String toString(GPacket reply) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\treplyStatus = ").append(Status.getString(ClusterTakeoverInfo.getReplyStatus(reply)));
        if (reply.getProp("reason") != null) {
            buf.append("\n\treason = ").append(ClusterTakeoverInfo.getReplyStatusReason(reply));
        }
        buf.append("[brokerID = ").append((String)reply.getProp("brokerID"));
        buf.append(", storeSession = ").append((Long)reply.getProp("storeSession"));
        buf.append("], ").append((Long)reply.getProp("X"));
        buf.append(" - ").append((String)reply.getProp("taker"));
        return buf.toString();
    }
}

