/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class ClusterTransferFileRequestInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String uuid = null;
    private String brokerID = null;
    private Long xid = null;

    private ClusterTransferFileRequestInfo(String brokerID, String uuid, Long xid) {
        this.brokerID = brokerID;
        this.uuid = uuid;
        this.xid = xid;
    }

    private ClusterTransferFileRequestInfo(GPacket pkt) {
        assert (pkt.getType() == 63);
        this.pkt = pkt;
    }

    public static ClusterTransferFileRequestInfo newInstance(String brokerID, String uuid, Long xid) {
        return new ClusterTransferFileRequestInfo(brokerID, uuid, xid);
    }

    public static ClusterTransferFileRequestInfo newInstance(GPacket pkt) {
        return new ClusterTransferFileRequestInfo(pkt);
    }

    public GPacket getGPacket() throws BrokerException {
        if (this.pkt != null) {
            return this.pkt;
        }
        GPacket gp = GPacket.getInstance();
        gp.putProp("uuid", this.uuid);
        gp.putProp("brokerID", this.brokerID);
        gp.putProp("X", this.xid);
        gp.setType((short)63);
        gp.setBit(1, true);
        return gp;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("uuid");
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("brokerID");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("X");
    }

    public GPacket getReplyGPacket(int status, String reason) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)64);
        gp.putProp("X", (Long)this.pkt.getProp("X"));
        gp.putProp("S", new Integer(status));
        if (reason != null) {
            gp.putProp("reason", reason);
        }
        return gp;
    }

    public static Long getReplyPacketXid(GPacket reply) {
        return (Long)reply.getProp("X");
    }

    public String toString() {
        if (this.pkt != null) {
            return "[brokerID=" + this.getBrokerID() + ", uuid=" + this.getUUID() + "]";
        }
        return "[brokerID=" + this.brokerID + ", uuid=" + this.uuid + "]";
    }
}

