/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.api;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;

public class TransactionInfo
implements Cloneable,
Externalizable {
    static final long serialVersionUID = 5642215309770752611L;
    private static boolean DEBUG = false;
    public static final int TXN_NOFLAG = 0;
    public static final int TXN_LOCAL = 1;
    public static final int TXN_CLUSTER = 2;
    public static final int TXN_REMOTE = 3;
    private int type = 0;
    private TransactionState state = null;
    private TransactionBroker[] txnBkrs = null;
    private BrokerAddress txnHomeBroker = null;
    private transient HashMap bkrMap = new HashMap();

    public TransactionInfo() {
    }

    public TransactionInfo(TransactionInfo tif) {
        this.type = tif.getType();
        this.state = new TransactionState(tif.getTransactionState());
        this.txnHomeBroker = tif.getTransactionHomeBroker();
        this.setTransactionBrokers(tif.getTransactionBrokers());
    }

    public TransactionInfo(TransactionState ts) {
        this(ts, null, null, 1);
    }

    public TransactionInfo(TransactionState ts, BrokerAddress homeBroker, TransactionBroker[] bkrs, int txnType) {
        if (ts == null) {
            throw new IllegalArgumentException("Null TransactionState specified");
        }
        this.type = txnType;
        this.state = ts;
        this.txnHomeBroker = homeBroker;
        this.setTransactionBrokers(bkrs);
    }

    public boolean isLocal() {
        return this.type == 1;
    }

    public boolean isRemote() {
        return this.type == 3;
    }

    public boolean isCluster() {
        return this.type == 2;
    }

    public void setType(int txnType) {
        this.type = txnType;
    }

    public int getType() {
        return this.type;
    }

    public TransactionState getTransactionState() {
        return this.state;
    }

    public int getTransactionStateValue() {
        return this.state.getState();
    }

    public void setTransactionBrokers(TransactionBroker[] bkrs) {
        if (!this.bkrMap.isEmpty()) {
            this.bkrMap.clear();
        }
        if (bkrs == null) {
            this.txnBkrs = null;
        } else {
            int size = bkrs.length;
            this.txnBkrs = new TransactionBroker[size];
            StringBuffer debugBuf = null;
            for (int i = 0; i < size; ++i) {
                TransactionBroker txnBkr;
                this.txnBkrs[i] = txnBkr = (TransactionBroker)bkrs[i].clone();
                if (DEBUG) {
                    if (debugBuf == null) {
                        debugBuf = new StringBuffer();
                    }
                    if (i > 0) {
                        debugBuf.append(",");
                    }
                    debugBuf.append(txnBkr);
                }
                this.bkrMap.put(txnBkr.getBrokerAddress(), txnBkr);
            }
            if (this.bkrMap.size() != size) {
                String emsg = "Unexpected Error: duplicate TransactionBroker object found " + size + " size in database, mapped to size " + this.bkrMap.size() + (debugBuf == null ? "" : ", bkrs=" + debugBuf.toString() + ", bkrMap=" + this.bkrMap);
                throw new IllegalArgumentException(emsg);
            }
        }
    }

    public TransactionBroker[] getTransactionBrokers() {
        return this.txnBkrs;
    }

    public BrokerAddress getTransactionHomeBroker() {
        return this.txnHomeBroker;
    }

    public void updateTransactionState(int ts) throws BrokerException {
        this.state.setState(ts);
    }

    public void updateBrokerState(TransactionBroker bkr) throws BrokerException {
        TransactionBroker txnBkr = (TransactionBroker)this.bkrMap.get(bkr.getBrokerAddress());
        if (txnBkr == null) {
            throw new BrokerException("TransactionBroker " + txnBkr + " could not be found in the store", 404);
        }
        txnBkr.copyState(bkr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.state = (TransactionState)in.readObject();
        this.txnHomeBroker = (BrokerAddress)in.readObject();
        this.txnBkrs = (TransactionBroker[])in.readObject();
        this.bkrMap = new HashMap();
        if (this.txnBkrs != null) {
            for (int i = 0; i < this.txnBkrs.length; ++i) {
                TransactionBroker txnBkr = this.txnBkrs[i];
                this.bkrMap.put(txnBkr.getBrokerAddress(), txnBkr);
            }
            if (this.bkrMap.size() != this.txnBkrs.length) {
                Globals.getLogger().log(16, "Internal Error: duplicate TransactionBroker object found");
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.bkrMap = new HashMap();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeObject(this.state);
        out.writeObject(this.txnHomeBroker);
        out.writeObject(this.txnBkrs);
    }

    public Object clone() {
        try {
            TransactionInfo newTxnInfo = (TransactionInfo)super.clone();
            if (this.state != null) {
                newTxnInfo.state = new TransactionState(this.state);
            }
            if (this.txnBkrs != null) {
                newTxnInfo.txnBkrs = (TransactionBroker[])this.txnBkrs.clone();
            }
            return newTxnInfo;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("This should never happen!");
        }
    }

    public String toString() {
        return new StringBuffer(128).append("TransactionInfo[type=").append(TransactionInfo.toString(this.type)).append(", state=").append(this.state).append(", home broker=").append(this.txnHomeBroker).append(", brokers=").append(Arrays.toString(this.txnBkrs)).append("]").toString();
    }

    public static String toString(int type) {
        switch (type) {
            case 0: {
                return "TXN_NOFLAG";
            }
            case 1: {
                return "TXN_LOCAL";
            }
            case 2: {
                return "TXN_CLUSTER";
            }
            case 3: {
                return "TXN_REMOTE";
            }
        }
        return "INVALID TYPE " + type;
    }
}

