/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.UID;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public final class BrokerCurrentFile {
    private static final String CURRENT_FILENAME = "current";
    private BrokerResources br = Globals.getBrokerResources();
    private File file = null;
    private RandomAccessFile raf = null;
    private FileLock lock = null;

    public BrokerCurrentFile(File bdbtop, boolean readonly) throws Exception {
        this.file = new File(bdbtop, CURRENT_FILENAME);
        if (readonly) {
            this.raf = new RandomAccessFile(this.file, "r");
            this.lock = this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
        } else {
            this.raf = new RandomAccessFile(this.file, "rwd");
            this.lock = this.raf.getChannel().tryLock();
        }
        if (this.lock == null) {
            throw new IOException(this.br.getKString("B4373", this.file.getPath()));
        }
    }

    protected void writeStoreSession(UID uid) throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.raf.seek(0L);
        this.raf.writeUTF(String.valueOf(uid.longValue()));
        this.raf.getChannel().force(true);
    }

    protected UID readStoreSession() throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.raf.length() == 0L) {
            return null;
        }
        this.raf.seek(0L);
        String v = this.raf.readUTF();
        UID uid = null;
        try {
            uid = new UID(Long.parseLong(v));
        }
        catch (NumberFormatException e) {
            String emsg = this.br.getKString("B1043", this.file.getPath());
            IOException ee = new IOException(emsg);
            ee.initCause(e);
            throw ee;
        }
        return uid;
    }

    protected void close() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            Globals.getLogger().log(16, this.br.getKString("B4374", this.file.getPath()));
        }
        try {
            this.raf.close();
        }
        catch (Exception e) {
            Globals.getLogger().log(16, this.br.getKString("B4375", this.file.getPath()));
        }
    }
}

