/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;

class MsgStore200
extends RandomAccessStore {
    private Packet msgToReturn = null;
    private ConsumerUID[] iidsToReturn = null;
    private int[] statesToReturn = null;
    private Enumeration msgenum = this.getEnumeration(false);
    private static FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };

    MsgStore200(File msgDir) throws BrokerException {
        super(msgDir, 0, 0, 0);
        if (Store.getDEBUG()) {
            this.logger.log(4, "Loading version 200 message store");
        }
    }

    boolean hasMoreMessages() {
        return this.msgenum.hasMoreElements();
    }

    Packet nextMessage() {
        return this.msgToReturn;
    }

    ConsumerUID[] nextCUIDs() {
        return this.iidsToReturn;
    }

    int[] nextStates() {
        return this.statesToReturn;
    }

    @Override
    Object parseData(byte[] data, byte[] attachment) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        this.msgToReturn = new Packet(false);
        this.msgToReturn.generateTimestamp(false);
        this.msgToReturn.generateSequenceNumber(false);
        this.msgToReturn.readPacket(bais);
        bais.close();
        int size = 0;
        if (attachment != null && attachment.length > 0) {
            ByteArrayInputStream bis = new ByteArrayInputStream(attachment);
            DataInputStream dis = new DataInputStream(bis);
            size = dis.readInt();
            this.iidsToReturn = new ConsumerUID[size];
            this.statesToReturn = new int[size];
            for (int i = 0; i < size; ++i) {
                this.iidsToReturn[i] = new ConsumerUID(dis.readLong());
                this.statesToReturn[i] = dis.readInt();
            }
            dis.close();
            bis.close();
        }
        SysMessageID mid = this.msgToReturn.getSysMessageID();
        if (Store.getDEBUG()) {
            this.logger.log(4, "loaded " + mid + " with " + size + " interest states");
        }
        return mid;
    }

    protected void close() {
        super.close(true);
    }

    @Override
    FilenameFilter getFilenameFilter() {
        return filenameFilter;
    }
}

