/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class PropertiesStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap propMap = new ConcurrentHashMap(64);
    private File backingFile = null;

    PropertiesStore() {
    }

    void updateProperty(String name, Object value) throws BrokerException {
        try {
            boolean updated = false;
            if (value == null) {
                Object old = this.propMap.remove(name);
                updated = old != null;
            } else {
                this.propMap.put(name, value);
                updated = true;
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4112", name);
            throw new BrokerException(this.br.getString("B4112", name), e);
        }
    }

    Object getProperty(String name) throws BrokerException {
        return this.propMap.get(name);
    }

    String[] getPropertyNames() throws BrokerException {
        Set keys = this.propMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    Properties getProperties() throws BrokerException {
        Properties props = new Properties();
        for (Map.Entry e : this.propMap.entrySet()) {
            props.put(e.getKey(), e.getValue());
        }
        return props;
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesStore.clearAll() called");
        }
        this.propMap.clear();
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesStore: closing, " + this.propMap.size() + " in-memory properties");
        }
        this.propMap.clear();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Properties", String.valueOf(this.propMap.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nProperties");
        out.println("----------");
        out.println("backing file: " + this.backingFile);
        Set entries = this.propMap.entrySet();
        for (Map.Entry entry : entries) {
            out.println((String)entry.getKey() + "=" + entry.getValue().toString());
        }
    }
}

