/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StoreSessionDAOImpl
extends BaseDAOImpl
implements StoreSessionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateIsCurrentSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String deleteByBrokerSQL;
    protected String deleteInactiveByBrokerSQL;
    protected String selectSQL;
    protected String selectIfOwnStoreSessionSQL;
    protected String selectAllSQL;
    protected String selectAllOldSessionsSQL;
    protected String selectCurrentSessionSQL;
    protected String selectPreviousSessionSQL;
    protected String selectIDsByBrokerSQL;
    protected String moveStoreSessionSQL;
    private volatile long localStoreSessionID = 0L;
    private FaultInjection fi = FaultInjection.getInjection();

    StoreSessionDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQSES41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.updateIsCurrentSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("IS_CURRENT").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?, ").append("CREATED_TS").append(" = ?, ").append("IS_CURRENT").append(" = 0").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteInactiveByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" AND NOT EXISTS (").append("SELECT 1 FROM ").append(dbMgr.getTableName("MQMSG41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(" UNION ").append("SELECT 1 FROM ").append(dbMgr.getTableName("MQTXN41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectIfOwnStoreSessionSQL = new StringBuffer(128).append("SELECT 1").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").append(" AND NOT EXISTS (").append(((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" ORDER BY ").append("BROKER_ID").append(", ").append("CREATED_TS").toString();
        this.selectAllOldSessionsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("CREATED_TS").append(", ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_CURRENT").append(" = 0").toString();
        this.selectCurrentSessionSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("IS_CURRENT").append(" = 1").toString();
        this.selectPreviousSessionSQL = new StringBuffer(128).append("SELECT sTbl.").append("ID").append(", sTbl.").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" sTbl, ").append(dbMgr.getTableName("MQBKR41")).append(" bTbl WHERE bTbl.").append("ID").append(" = ?").append(" AND bTbl.").append("ID").append(" = sTbl.").append("CREATED_BY").append(" AND bTbl.").append("TAKEOVER_BROKER").append(" = sTbl.").append("BROKER_ID").append(" ORDER BY sTbl.").append("CREATED_TS").append(" DESC").toString();
        this.selectIDsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.moveStoreSessionSQL = new StringBuffer(128).append(" UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ? ").append(" WHERE ").append("BROKER_ID").append(" = ? ").append(" AND ").append("ID").append(" = ?").append(" AND ").append("IS_CURRENT").append(" <> 1 ").append(" AND NOT EXISTS (").append(((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")").append(" AND NOT EXISTS (").append(((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQSES41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public long insert(Connection conn, String brokerID, long sessionID, boolean failExist) throws BrokerException {
        long l;
        block19: {
            Exception myex;
            PreparedStatement pstmt;
            block18: {
                if (sessionID == 0L) {
                    throw new BrokerException("B3044 Unexpected store session uid " + sessionID + " to add for broker " + brokerID);
                }
                boolean myConn = false;
                pstmt = null;
                String sql = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    long currentID = 0L;
                    sql = this.selectCurrentSessionSQL;
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, brokerID);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        currentID = rs.getLong(1);
                        if (failExist) {
                            throw new BrokerException("Unexpected current ID " + currentID + " already exists in table " + this.tableName + " for broker " + brokerID);
                        }
                        if (rs.next()) {
                            throw new BrokerException("Unexpected more than 1 current ID " + currentID + ", " + rs.getLong(1) + " exists in table " + this.tableName + " for broker " + brokerID);
                        }
                        if (currentID == 0L) {
                            throw new BrokerException("Unexpected current ID value " + currentID + " stored in table " + this.tableName + " for broker " + brokerID);
                        }
                    }
                    rs.close();
                    pstmt.close();
                    if (currentID == 0L) {
                        this.insert(conn, brokerID, sessionID, 1, brokerID, System.currentTimeMillis());
                        currentID = sessionID;
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    l = currentID;
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4276", String.valueOf(sessionID)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block19;
            }
            Util.close(null, pstmt, null, myex);
        }
        return l;
    }

    @Override
    public void insert(Connection conn, String brokerID, long sessionID, int isCurrent, String createdBy, long createdTS) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        String sql = this.insertSQL;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, sessionID);
            pstmt.setString(2, brokerID);
            pstmt.setInt(3, isCurrent);
            pstmt.setString(4, createdBy);
            pstmt.setLong(5, createdTS);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + sql + "]", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4276", String.valueOf(sessionID)), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public List<Long> takeover(Connection conn, String brokerID, String targetBrokerID) throws BrokerException {
        ArrayList<Long> list = new ArrayList<Long>();
        String sql = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (this.fi.FAULT_INJECTION) {
                this.fi.checkFaultAndThrowBrokerException("ha.takeover.switch_ss.exception", null);
                this.fi.checkFaultAndExit("ha.takeover.switch_ss.halt", null, 2, false);
            }
            sql = this.selectIDsByBrokerSQL;
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, targetBrokerID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                long ssid = rs.getLong(1);
                list.add(ssid);
            }
            rs.close();
            pstmt.close();
            pstmt = conn.prepareStatement(this.takeoverSQL);
            pstmt.setString(1, brokerID);
            pstmt.setLong(2, System.currentTimeMillis());
            pstmt.setString(3, targetBrokerID);
            int count = pstmt.executeUpdate();
            if (count != list.size()) {
                throw new BrokerException(this.br.getKString("B3174", targetBrokerID));
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080", rbe);
                }
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)e) : e;
                throw new BrokerException(this.br.getKString("B3174", targetBrokerID), ex);
            }
            catch (Throwable throwable) {
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(null, pstmt, null, myex);
        return list;
    }

    @Override
    public void delete(Connection conn, long id) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.deleteSQL);
            pstmt.setLong(1, id);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + this.deleteSQL + "]", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4277", String.valueOf(id)), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public void deleteByBrokerID(Connection conn, String brokerID) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.deleteByBrokerSQL);
            pstmt.setString(1, brokerID);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + this.deleteByBrokerSQL + "]", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByBrokerSQL + "]", (SQLException)e) : e;
            throw new BrokerException(this.br.getKString("B4280", brokerID), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(conn);
    }

    @Override
    public List<Long> deleteInactiveStoreSession(Connection conn) throws BrokerException {
        ArrayList<Long> arrayList;
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                ArrayList<Long> reaped = new ArrayList<Long>();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    String brokerID;
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    HashMap<Long, String> sessionMap = new HashMap<Long, String>();
                    long currentTime = System.currentTimeMillis();
                    pstmt = conn.prepareStatement(this.selectAllOldSessionsSQL);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long ssid = rs.getLong(1);
                        long takeoverTS = rs.getLong(2);
                        brokerID = rs.getString(3);
                        if (currentTime <= takeoverTS + 1800000L) continue;
                        sessionMap.put(new Long(ssid), brokerID);
                    }
                    rs.close();
                    if (!sessionMap.isEmpty()) {
                        pstmt.close();
                        pstmt = conn.prepareStatement(this.deleteInactiveByBrokerSQL);
                        for (Map.Entry entry : sessionMap.entrySet()) {
                            long ssid = (Long)entry.getKey();
                            brokerID = (String)entry.getValue();
                            try {
                                pstmt.setLong(1, ssid);
                                pstmt.setLong(2, ssid);
                                pstmt.setLong(3, ssid);
                                if (pstmt.executeUpdate() <= 0) continue;
                                reaped.add(ssid);
                                this.logger.log(8, this.br.getKString("B1254", String.valueOf(ssid), brokerID));
                            }
                            catch (SQLException e) {
                                SQLException ex = DBManager.wrapSQLException("[" + this.deleteInactiveByBrokerSQL + "]", e);
                                this.logger.logStack(32, "B4279", ssid, brokerID, ex);
                            }
                        }
                    }
                    arrayList = reaped;
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        throw new BrokerException(this.br.getKString("B4166", this.selectAllOldSessionsSQL), e);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
        return arrayList;
    }

    @Override
    public long getStoreSession(Connection conn, String brokerID) throws BrokerException {
        long sessionID;
        boolean isLocalBroker;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                DBManager dbMgr = DBManager.getDBManager();
                isLocalBroker = dbMgr.getBrokerID().equals(brokerID);
                if (isLocalBroker && this.localStoreSessionID > 0L) {
                    return this.localStoreSessionID;
                }
                sessionID = 0L;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectCurrentSessionSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        sessionID = rs.getLong(1);
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCurrentSessionSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4281", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        if (isLocalBroker && this.localStoreSessionID == 0L) {
            this.localStoreSessionID = sessionID;
        }
        return sessionID;
    }

    @Override
    public String getStoreSessionOwner(Connection conn, long id) throws BrokerException {
        String brokerID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                brokerID = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        brokerID = rs.getString("BROKER_ID");
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(id)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return brokerID;
    }

    @Override
    public boolean ifOwnStoreSession(Connection conn, long id, String brokerID) throws BrokerException {
        Exception myex;
        ResultSet rs;
        PreparedStatement pstmt;
        boolean myConn;
        block13: {
            boolean bl;
            block15: {
                block14: {
                    myConn = false;
                    pstmt = null;
                    rs = null;
                    myex = null;
                    try {
                        if (conn == null) {
                            conn = DBManager.getDBManager().getConnection(true);
                            myConn = true;
                        }
                        pstmt = conn.prepareStatement(this.selectIfOwnStoreSessionSQL);
                        pstmt.setLong(1, id);
                        pstmt.setString(2, brokerID);
                        pstmt.setString(3, brokerID);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block13;
                        bl = true;
                        if (!myConn) break block14;
                    }
                    catch (Exception e) {
                        try {
                            myex = e;
                            try {
                                if (conn != null && !conn.getAutoCommit()) {
                                    conn.rollback();
                                }
                            }
                            catch (SQLException rbe) {
                                this.logger.log(32, "B4080[" + this.selectIfOwnStoreSessionSQL + "]", rbe);
                            }
                            if (e instanceof BrokerException) {
                                throw (BrokerException)e;
                            }
                            Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectIfOwnStoreSessionSQL + "]", (SQLException)e) : e;
                            throw new BrokerException("[" + this.selectIfOwnStoreSessionSQL + "]", "(" + String.valueOf(id) + ", " + brokerID + "): " + ex.getMessage(), ex);
                        }
                        catch (Throwable throwable) {
                            if (myConn) {
                                Util.close(rs, pstmt, conn, myex);
                            } else {
                                Util.close(rs, pstmt, null, myex);
                            }
                            throw throwable;
                        }
                    }
                    Util.close(rs, pstmt, conn, myex);
                    break block15;
                }
                Util.close(rs, pstmt, null, myex);
            }
            return bl;
        }
        if (myConn) {
            Util.close(rs, pstmt, conn, myex);
        } else {
            Util.close(rs, pstmt, null, myex);
        }
        return false;
    }

    @Override
    public String getStoreSessionCreator(Connection conn, long id) throws BrokerException {
        String brokerID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                brokerID = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        brokerID = rs.getString("CREATED_BY");
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(id)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return brokerID;
    }

    @Override
    public Map getAllStoreSessions(Connection conn) throws BrokerException {
        HashMap<String, ArrayList<HABrokerInfo.StoreSession>> map;
        block14: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block13: {
                map = new HashMap<String, ArrayList<HABrokerInfo.StoreSession>>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectAllSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long id = rs.getLong(1);
                        String brokerID = rs.getString(2);
                        int isCurrent = rs.getInt(3);
                        String createdBy = rs.getString(4);
                        long createdTS = rs.getLong(5);
                        ArrayList<HABrokerInfo.StoreSession> sessionList = (ArrayList<HABrokerInfo.StoreSession>)map.get(brokerID);
                        if (sessionList == null) {
                            sessionList = new ArrayList<HABrokerInfo.StoreSession>();
                            map.put(brokerID, sessionList);
                        }
                        sessionList.add(new HABrokerInfo.StoreSession(id, brokerID, isCurrent, createdBy, createdTS));
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectAllSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4283"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block14;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return map;
    }

    @Override
    public List<Long> getStoreSessionsByBroker(Connection conn, String brokerID) throws BrokerException {
        ArrayList<Long> ids;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                ids = new ArrayList<Long>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectIDsByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long ssid = rs.getLong(1);
                        ids.add(ssid);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectIDsByBrokerSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectIDsByBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4282", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return ids;
    }

    @Override
    public void moveStoreSession(Connection conn, long storeSession, String targetBrokerID) throws BrokerException {
        block22: {
            Exception myex;
            PreparedStatement pstmt;
            block21: {
                boolean replaycheck = false;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                String sql = this.moveStoreSessionSQL;
                try {
                    DBManager dbmgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbmgr.getConnection(false);
                        myConn = true;
                    }
                    if (!this.ifOwnStoreSession(conn, storeSession, dbmgr.getBrokerID())) {
                        throw new BrokerException("XXXThis broker does not own partition " + storeSession, 304);
                    }
                    if (this.isCurrent(conn, storeSession)) {
                        throw new BrokerException("XXXCan't move this broker's primary partition " + storeSession, 304);
                    }
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, targetBrokerID);
                    pstmt.setString(2, dbmgr.getBrokerID());
                    pstmt.setLong(3, storeSession);
                    pstmt.setString(4, dbmgr.getBrokerID());
                    pstmt.setString(5, targetBrokerID);
                    int cnt = pstmt.executeUpdate();
                    if (cnt == 1) {
                        if (myConn) {
                            replaycheck = true;
                            conn.commit();
                        }
                    } else {
                        if (cnt == 0) {
                            BrokerDAO dao = dbmgr.getDAOFactory().getBrokerDAO();
                            if (dao.isBeingTakenOver(conn, targetBrokerID)) {
                                throw new BrokerException("Target broker " + targetBrokerID + " is in being taken over state", 304);
                            }
                            if (dao.isBeingTakenOver(conn, dbmgr.getBrokerID())) {
                                StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"), 304);
                                try {
                                    HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, dbmgr.getBrokerID());
                                    this.logger.log(32, this.br.getKString("B4117", bkrInfo.toString()), be);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                throw be;
                            }
                            throw new BrokerException("XXXMove partition " + storeSession + " to broker failed", 304);
                        }
                        throw new BrokerException("XXXMove partition " + storeSession + " to broker failed, unexpected affected row count " + cnt, 304);
                    }
                    if (!myConn) break block21;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                                replaycheck = false;
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException("XXXMove partition " + storeSession + " to broker failed", ex, replaycheck ? 500 : 304);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block22;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public boolean isCurrent(Connection conn, long id) throws BrokerException {
        boolean isCurrent;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                isCurrent = false;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = DBManager.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next() && rs.getInt("IS_CURRENT") == 1) {
                        isCurrent = true;
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(id)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return isCurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer strBuf = new StringBuffer(512);
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = DBManager.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.selectAllSQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                long createdTS = rs.getLong(5);
                strBuf.append("(").append("sessionID=").append(rs.getLong(1)).append(", brokerID=").append(rs.getString(2)).append(", isCurrent=").append(rs.getInt(3) == 1).append(", createdBy=").append(rs.getString(4)).append(", createdTS=").append(createdTS).append(createdTS > 0L ? " [" + new Date(createdTS) + "]" : "").append(")").append(BrokerResources.NL);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + this.selectAllSQL + "]", rbe);
            }
            this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)e);
        }
        finally {
            try {
                if (myConn) {
                    Util.close(rs, pstmt, conn, myex);
                } else {
                    Util.close(rs, pstmt, null, myex);
                }
            }
            catch (BrokerException be) {
                this.logger.log(32, be.getMessage(), be.getCause());
            }
        }
        map.put("Store Session(" + this.tableName + ")", strBuf.toString());
        return map;
    }

    protected static void checkStoreSessionOwner(Connection conn, Long storeSession, String brokerID) throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        String id = dbMgr.getDAOFactory().getStoreSessionDAO().getStoreSessionOwner(conn, storeSession);
        if (id == null) {
            throw new BrokerException("XXX Store session " + storeSession + " not found in store");
        }
        if (!id.equals(brokerID)) {
            throw new BrokerException("XXX Store session " + storeSession + " has owner broker " + id + ", not " + brokerID);
        }
    }
}

