/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordBaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ShareConfigRecordDAOImpl
extends ShareConfigRecordBaseDAOImpl
implements ShareConfigRecordDAO {
    protected String tableName = this.getDBManager().getTableName("MQSHARECC50");
    protected String insertSQLOracle;
    protected String selectSeqSQLOracle;
    protected String insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("UKEY").append(", ").append("CREATED_TS").append(", ").append("FLAG").append(") VALUES ( ?, ?, ?, ?, ?, ? )").toString();
    protected String insertResetRecordSQL;
    protected String insertResetRecordWithLockSQL;
    protected String selectTypeFlagByMaxSeqUKeySQL;
    protected String selectMaxSeqFlagUKeySQL;
    protected String selectRecordsSinceSQL;
    protected String selectSinceWithResetRecordSQL;
    protected String selectAllSQL;
    protected String selectSeqByUUIDSQL;
    protected String updateResetRecordUUIDSQL;
    protected String setResetRecordFLAGNULLSQL;
    protected String selectResetRecordUUIDSQL;
    protected String selectLockIDSQL;
    protected String updateLockIDSQL;

    ShareConfigRecordDAOImpl() throws BrokerException {
        this.insertSQLOracle = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("UKEY").append(", ").append("CREATED_TS").append(", ").append("FLAG").append(") VALUES (" + this.tableName + "_seq.NEXTVAL, ?, ?, ?, ?, ?, ? )").toString();
        this.selectSeqSQLOracle = new StringBuffer(128).append("SELECT ").append(this.tableName + "_seq.CURRVAL ").append("FROM DUAL").toString();
        this.insertResetRecordSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("UKEY").append(", ").append("CREATED_TS").append(") VALUES ( 1, ?, ?, ?, ?, ? )").toString();
        this.insertResetRecordWithLockSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("UKEY").append(", ").append("CREATED_TS").append(", ").append("LOCK_ID").append(") VALUES ( 1, ?, ?, ?, ?, ?, ? )").toString();
        this.selectTypeFlagByMaxSeqUKeySQL = new StringBuffer(128).append("SELECT ").append("TYPE").append(", ").append("FLAG").append(" FROM ").append(this.tableName).append(" WHERE ").append("SEQ").append(" IN (").append(" SELECT MAX(").append("SEQ").append(") ").append("FROM ").append(this.tableName).append(" WHERE ").append("UKEY").append(" = ? )").toString();
        this.selectMaxSeqFlagUKeySQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(", ").append("FLAG").append(" FROM ").append(this.tableName).append(" WHERE ").append("UKEY").append(" = ? ").append(" AND ").append("SEQ").append(" = ").append("(SELECT MAX(").append("SEQ").append(") ").append(" FROM ").append(this.tableName).append(" WHERE ").append("UKEY").append(" = ? )").toString();
        this.selectSinceWithResetRecordSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("SEQ").append(" > ?").append(" OR ").append("TYPE").append(" = ").append(31).append(" ORDER BY ").append("SEQ").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(", ").append("LOCK_ID").append(" FROM ").append(this.tableName).append(" ORDER BY ").append("SEQ").toString();
        this.selectSeqByUUIDSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(" FROM ").append(this.tableName).append(" WHERE ").append("UUID").append(" = ?").toString();
        this.selectLockIDSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.updateResetRecordUUIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("UUID").append(" = ?").append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.setResetRecordFLAGNULLSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("FLAG").append(" = NULL").append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.selectResetRecordUUIDSQL = new StringBuffer(128).append("SELECT ").append("UUID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.updateLockIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ? ").append(" WHERE ").append("TYPE").append(" = ").append(31).append(" AND ").append("LOCK_ID").append(" = ? ").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQSHARECC50";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public ChangeRecordInfo insert(Connection conn, ChangeRecordInfo rec) throws BrokerException {
        ChangeRecordInfo changeRecordInfo;
        block28: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block27: {
                String sql = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    Integer flag;
                    Integer flag2;
                    CommDBManager mgr = this.getDBManager();
                    if (conn == null) {
                        conn = mgr.getConnection(mgr.isDerby() || mgr.isDB2());
                        myConn = true;
                    }
                    String resetUUID = rec.getResetUUID();
                    if (rec.isDuraAddRecord() && (flag2 = this.hasLastSeqForUKeyType(conn, rec.getUKey(), rec.getType())) != null) {
                        String emsg = this.br.getKString("B1482", rec.getUKey()) + "[" + rec.getType() + "]" + ChangeRecordInfo.getFlagString(flag2);
                        this.logger.log(8, emsg);
                        if (flag2.intValue() != rec.getFlag()) {
                            throw new BrokerException(emsg);
                        }
                    }
                    sql = mgr.isOracle() ? this.insertSQLOracle : this.insertSQL;
                    pstmt = mgr.supportsGetGeneratedKey() ? (mgr.isPostgreSQL() || mgr.isDB2() ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql, new String[]{"SEQ"})) : conn.prepareStatement(sql);
                    pstmt.setString(1, rec.getUUID());
                    Util.setBytes(pstmt, 2, rec.getRecord());
                    pstmt.setInt(3, rec.getType());
                    pstmt.setString(4, rec.getUKey());
                    pstmt.setLong(5, rec.getTimestamp());
                    pstmt.setInt(6, rec.getFlag());
                    pstmt.executeUpdate();
                    Long seq = null;
                    if (mgr.supportsGetGeneratedKey()) {
                        rs = pstmt.getGeneratedKeys();
                        if (rs.next()) {
                            seq = new Long(rs.getLong(1));
                        }
                    } else if (mgr.isOracle()) {
                        Statement st = conn.createStatement();
                        rs = st.executeQuery(this.selectSeqSQLOracle);
                        if (rs.next()) {
                            seq = new Long(rs.getLong(1));
                        }
                        rs.close();
                        rs = null;
                        st.close();
                    } else {
                        seq = this.getSequenceByUUID(conn, rec.getUUID());
                    }
                    if (seq == null) {
                        throw new BrokerException(this.br.getKString("B4320", rec));
                    }
                    String currResetUUID = this.getResetRecordUUID(conn);
                    if (resetUUID != null && !currResetUUID.equals(resetUUID)) {
                        throw new BrokerException(this.br.getKString("B4321", "[" + resetUUID + ", " + currResetUUID + "]"), 412);
                    }
                    if (myConn && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    if (rec.isDuraAddRecord() && (flag = this.checkLastUKeyHasSeq(conn, rec.getUKey(), seq)) != null) {
                        String emsg = this.br.getKString("B1482", rec.getUKey()) + "[" + rec.getType() + "]" + ChangeRecordInfo.getFlagString(flag);
                        this.logger.log(8, emsg);
                        if (flag.intValue() != rec.getFlag()) {
                            throw new BrokerException(emsg);
                        }
                    }
                    if (resetUUID == null) {
                        rec.setResetUUID(currResetUUID);
                    }
                    rec.setSeq(seq);
                    changeRecordInfo = rec;
                    if (!myConn) break block27;
                }
                catch (Exception e) {
                    try {
                        Exception ex;
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        throw new BrokerException(this.br.getKString("B4325", rec.toString(), ex.getMessage()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, pstmt, conn, myex);
                break block28;
            }
            this.closeSQLObjects(rs, pstmt, null, myex);
        }
        return changeRecordInfo;
    }

    /*
     * Loose catch block
     */
    @Override
    public void insertResetRecord(Connection conn, ChangeRecordInfo rec, String lockID) throws BrokerException {
        block29: {
            Exception myex;
            PreparedStatement pstmt;
            block26: {
                String sql = null;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = this.getDBManager().getConnection(false);
                        myConn = true;
                    }
                    if (!this.hasResetRecord(conn)) {
                        int count;
                        sql = this.insertResetRecordSQL;
                        if (lockID != null) {
                            sql = this.insertResetRecordWithLockSQL;
                        }
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, rec.getUUID());
                        Util.setBytes(pstmt, 2, rec.getRecord());
                        pstmt.setInt(3, 31);
                        pstmt.setString(4, rec.getUKey());
                        pstmt.setLong(5, rec.getTimestamp());
                        if (lockID != null) {
                            pstmt.setString(6, lockID);
                        }
                        if ((count = pstmt.executeUpdate()) == 1) {
                            this.setResetRecordUUID(conn, rec.getUUID());
                        } else if (!this.hasResetRecord(conn) || lockID != null) {
                            throw new BrokerException("Unexpected affected row count " + count + " on  " + sql);
                        }
                    } else if (lockID != null) {
                        String m = this.br.getKString("B3266", this.getDBManager().getClusterID());
                        throw new BrokerException(m, "B3266", null, 301);
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block26;
                }
                catch (Exception e) {
                    block27: {
                        block30: {
                            block28: {
                                myex = e;
                                try {
                                    if (conn != null && !conn.getAutoCommit()) {
                                        conn.rollback();
                                    }
                                }
                                catch (SQLException rbe) {
                                    this.logger.log(32, "B4080", rbe);
                                }
                                if (!this.hasResetRecord(conn)) break block27;
                                if (lockID != null) {
                                    String m = this.br.getKString("B3266", this.getDBManager().getClusterID());
                                    throw new BrokerException(m, "B3266", null, 301);
                                }
                                myex = null;
                                if (!myConn) break block28;
                                this.closeSQLObjects(null, pstmt, conn, myex);
                                break block30;
                            }
                            this.closeSQLObjects(null, pstmt, null, myex);
                        }
                        return;
                    }
                    try {
                        Exception ex;
                        block31: {
                            break block31;
                            {
                                catch (Exception e2) {
                                    this.logger.log(32, this.br.getKString("B3268", e2.getMessage()));
                                }
                            }
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + this.insertResetRecordSQL + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        throw new BrokerException(this.br.getKString("B4324", ex.getMessage()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(null, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, pstmt, conn, myex);
                break block29;
            }
            this.closeSQLObjects(null, pstmt, null, myex);
        }
    }

    public boolean hasResetRecord(Connection conn) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            if ((rs = (pstmt = conn.prepareStatement(this.selectAllSQL)).executeQuery()).next()) {
                int typ = rs.getInt(4);
                if (typ == 31) {
                    String lock = rs.getString(6);
                    if (lock != null) {
                        this.getDBManager().throwTableLockedException(lock);
                    }
                    boolean bl = true;
                    return bl;
                }
                throw new BrokerException("Unexpected 1st record type " + typ + " for first record in database table " + this.getTableName());
            }
            boolean typ = false;
            return typ;
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4326", ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(null, pstmt, null, myex);
            }
        }
    }

    public void setResetRecordUUID(Connection conn, String uuid) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.updateResetRecordUUIDSQL);
            pstmt.setString(1, uuid);
            if (pstmt.executeUpdate() < 1) {
                throw new BrokerException("Unexpected affected row count for " + this.updateResetRecordUUIDSQL);
            }
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + this.updateResetRecordUUIDSQL + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4327", uuid, ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
    }

    public void setResetRecordFLAGNULL(Connection conn) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            if ((pstmt = conn.prepareStatement(this.setResetRecordFLAGNULLSQL)).executeUpdate() < 1) {
                throw new BrokerException("Unexpected affected row count for " + this.setResetRecordFLAGNULLSQL);
            }
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + this.setResetRecordFLAGNULLSQL + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4328", "FLAG", ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
    }

    public String getResetRecordUUID(Connection conn) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(this.selectResetRecordUUIDSQL);
            rs = pstmt.executeQuery();
            String uuid = null;
            if (rs.next()) {
                uuid = rs.getString(1);
            }
            if (uuid == null) {
                throw new BrokerException("No reset record found in database table " + this.getTableName());
            }
            String string = uuid;
            return string;
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + this.selectResetRecordUUIDSQL + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4329", ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
    }

    @Override
    public List<ChangeRecordInfo> getRecords(Connection conn, Long seq, String resetUUID, boolean canReset) throws BrokerException {
        List<ChangeRecordInfo> records;
        block24: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block23: {
                records = new ArrayList();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                String selectSQL = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = this.getDBManager().getConnection(false);
                        myConn = true;
                    }
                    if (seq == null || resetUUID == null) {
                        records = this.getAllRecords(conn, null);
                    } else {
                        selectSQL = this.selectSinceWithResetRecordSQL;
                        pstmt = conn.prepareStatement(selectSQL);
                        pstmt.setLong(1, seq);
                        rs = pstmt.executeQuery();
                        long seqv = -1L;
                        String uuidv = null;
                        byte[] buf = null;
                        int typv = 0;
                        long tsv = -1L;
                        ChangeRecordInfo cri = null;
                        boolean loadfail = false;
                        boolean reseted = false;
                        boolean foundreset = false;
                        String newResetUUID = null;
                        while (rs.next()) {
                            try {
                                seqv = rs.getLong(1);
                                uuidv = rs.getString(2);
                                buf = Util.readBytes(rs, 3);
                                typv = rs.getInt(4);
                                tsv = rs.getLong(5);
                                if (typv == 31) {
                                    foundreset = true;
                                    if (uuidv.equals(resetUUID)) continue;
                                    newResetUUID = uuidv;
                                    reseted = true;
                                    break;
                                }
                                cri = new ChangeRecordInfo(seqv, uuidv, buf, typv, null, tsv);
                                cri.setResetUUID(resetUUID);
                                cri.setIsSelectAll(false);
                                ((ArrayList)records).add(cri);
                            }
                            catch (IOException e) {
                                loadfail = true;
                                this.getDBManager();
                                IOException ex = CommDBManager.wrapIOException("[" + this.selectAllSQL + "]", e);
                                this.logger.logStack(32, "B4123", String.valueOf(seq), (Throwable)ex);
                            }
                        }
                        if (!foundreset) {
                            throw new BrokerException("Unexpected: shared database table " + this.getTableName() + " has no reset record", 412);
                        }
                        if (reseted) {
                            if (!canReset) {
                                throw new BrokerException(this.br.getKString("B4321", "[" + resetUUID + ", " + newResetUUID + "]"), 412);
                            }
                            this.logger.log(8, this.br.getKString("B1364", "[" + resetUUID + ", " + newResetUUID + "]"));
                            records = this.getAllRecords(conn, null);
                        }
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block23;
                }
                catch (Exception e) {
                    try {
                        Exception ex;
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + selectSQL + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        throw new BrokerException(this.br.getKString("B4330", ex.getMessage()), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, pstmt, conn, myex);
                break block24;
            }
            this.closeSQLObjects(rs, pstmt, null, myex);
        }
        return records;
    }

    public ArrayList<ChangeRecordInfo> getAllRecords(Connection conn, String query) throws BrokerException {
        String sql = query == null ? this.selectAllSQL : query;
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            long seqv = -1L;
            String uuidv = null;
            byte[] buf = null;
            int typv = 0;
            long tsv = -1L;
            ChangeRecordInfo cri = null;
            boolean foundreset = false;
            while (rs.next()) {
                try {
                    seqv = rs.getLong(1);
                    uuidv = rs.getString(2);
                    buf = Util.readBytes(rs, 3);
                    typv = rs.getInt(4);
                    if (typv == 31) {
                        foundreset = true;
                    }
                    tsv = rs.getLong(5);
                    cri = new ChangeRecordInfo(seqv, uuidv, buf, typv, null, tsv);
                    cri.setIsSelectAll(true);
                    records.add(cri);
                }
                catch (IOException e) {
                    this.getDBManager();
                    IOException ex = CommDBManager.wrapIOException("[" + this.selectAllSQL + "]", e);
                    this.logger.logStack(32, "B4123", String.valueOf(seqv), (Throwable)ex);
                    throw new BrokerException(ex.getMessage(), 412);
                }
            }
            if (!foundreset) {
                throw new BrokerException("Unexpected: shared cluster change record table [" + (query == null ? this.getTableName() : sql) + "] has no reset record", 412);
            }
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + sql + "]", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4331" + "[" + (query == null ? this.getTableName() : sql) + "]", ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
        return records;
    }

    private Long getSequenceByUUID(Connection conn, String uuid) throws BrokerException {
        Long seq;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                seq = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    if (conn == null) {
                        conn = this.getDBManager().getConnection(true);
                        myConn = true;
                    }
                    pstmt = conn.prepareStatement(this.selectSeqByUUIDSQL);
                    pstmt.setString(1, uuid);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        long seqv = rs.getLong(1);
                        seq = new Long(seqv);
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        Exception ex;
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + this.selectSeqByUUIDSQL + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        Object[] args = new String[]{"SEQ", String.valueOf(seq), ex.getMessage()};
                        throw new BrokerException(this.br.getKString("B4332", args), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, pstmt, conn, myex);
                break block15;
            }
            this.closeSQLObjects(rs, pstmt, null, myex);
        }
        return seq;
    }

    private Integer hasLastSeqForUKeyType(Connection conn, String ukey, int type) throws BrokerException {
        Integer n;
        block22: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block19: {
                String sql;
                boolean myConn;
                block17: {
                    Integer n2;
                    block21: {
                        block18: {
                            block15: {
                                Integer n3;
                                block20: {
                                    block16: {
                                        myConn = false;
                                        pstmt = null;
                                        rs = null;
                                        myex = null;
                                        sql = this.selectTypeFlagByMaxSeqUKeySQL;
                                        if (conn == null) {
                                            conn = this.getDBManager().getConnection(true);
                                            myConn = true;
                                        }
                                        pstmt = conn.prepareStatement(sql);
                                        pstmt.setString(1, ukey);
                                        rs = pstmt.executeQuery();
                                        if (rs.next()) break block15;
                                        n3 = null;
                                        if (!myConn) break block16;
                                        this.closeSQLObjects(rs, pstmt, conn, myex);
                                        break block20;
                                    }
                                    this.closeSQLObjects(rs, pstmt, null, myex);
                                }
                                return n3;
                            }
                            int t = rs.getInt(1);
                            int flag = rs.getInt(2);
                            if (t != type) break block17;
                            n2 = flag;
                            if (!myConn) break block18;
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                            break block21;
                        }
                        this.closeSQLObjects(rs, pstmt, null, myex);
                    }
                    return n2;
                }
                try {
                    n = null;
                    if (!myConn) break block19;
                }
                catch (Exception e) {
                    try {
                        Exception ex;
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        throw new BrokerException(this.br.getKString("B4411", ukey + "[" + String.valueOf(type) + "]") + ": " + ex.toString(), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, pstmt, conn, myex);
                break block22;
            }
            this.closeSQLObjects(rs, pstmt, null, myex);
        }
        return n;
    }

    private Integer checkLastUKeyHasSeq(Connection conn, String ukey, long expectedSeq) throws BrokerException {
        Integer n;
        block22: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block19: {
                int flag;
                String sql;
                boolean myConn;
                block17: {
                    Integer n2;
                    block21: {
                        block18: {
                            block15: {
                                Integer n3;
                                block20: {
                                    block16: {
                                        myConn = false;
                                        pstmt = null;
                                        rs = null;
                                        myex = null;
                                        sql = this.selectMaxSeqFlagUKeySQL;
                                        if (conn == null) {
                                            conn = this.getDBManager().getConnection(true);
                                            myConn = true;
                                        }
                                        pstmt = conn.prepareStatement(sql);
                                        pstmt.setString(1, ukey);
                                        pstmt.setString(2, ukey);
                                        rs = pstmt.executeQuery();
                                        if (rs.next()) break block15;
                                        n3 = null;
                                        if (!myConn) break block16;
                                        this.closeSQLObjects(rs, pstmt, conn, myex);
                                        break block20;
                                    }
                                    this.closeSQLObjects(rs, pstmt, null, myex);
                                }
                                return n3;
                            }
                            long s = rs.getLong(1);
                            flag = rs.getInt(2);
                            if (s != expectedSeq) break block17;
                            n2 = null;
                            if (!myConn) break block18;
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                            break block21;
                        }
                        this.closeSQLObjects(rs, pstmt, null, myex);
                    }
                    return n2;
                }
                try {
                    n = flag;
                    if (!myConn) break block19;
                }
                catch (Exception e) {
                    try {
                        Exception ex;
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        if (e instanceof SQLException) {
                            this.getDBManager();
                            ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
                        } else {
                            ex = e;
                        }
                        throw new BrokerException(this.br.getKString("B4411", ukey + "[" + expectedSeq + "]") + ": " + ex.toString(), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(rs, pstmt, conn, myex);
                        } else {
                            this.closeSQLObjects(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(rs, pstmt, conn, myex);
                break block22;
            }
            this.closeSQLObjects(rs, pstmt, null, myex);
        }
        return n;
    }

    @Override
    public String getLockID(Connection conn) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        String sql = this.selectLockIDSQL;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(true);
                myConn = true;
            }
            if (!(rs = (pstmt = conn.prepareStatement(sql)).executeQuery()).next()) {
                String string = "";
                return string;
            }
            String string = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080:" + sql, rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4415", ex.getMessage()), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
    }

    @Override
    public void updateLockID(Connection conn, String newLockID, String oldLockID) throws BrokerException {
        boolean myConn = false;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        String sql = this.updateLockIDSQL;
        try {
            if (conn == null) {
                conn = this.getDBManager().getConnection(false);
                myConn = true;
            }
            pstmt = conn.prepareStatement(sql);
            Util.setString(pstmt, 1, newLockID);
            pstmt.setString(2, oldLockID);
            int cnt = pstmt.executeUpdate();
            if (cnt != 0) {
                return;
            }
            if (this.hasResetRecord(conn)) {
                String m = this.br.getKString("B3266", this.getDBManager().getClusterID());
                throw new BrokerException(m, "B3266", null, 301);
            }
            return;
        }
        catch (Exception e) {
            Exception ex;
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080:" + sql, rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e);
            } else {
                ex = e;
            }
            throw new BrokerException(this.br.getKString("B4416", oldLockID, newLockID) + ": " + ex.getMessage(), ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(rs, pstmt, conn, myex);
            } else {
                this.closeSQLObjects(rs, pstmt, null, myex);
            }
        }
    }

    @Override
    public void insertAll(List<ChangeRecordInfo> recs, String oldTableName) throws BrokerException {
        Connection conn = null;
        Exception myex = null;
        try {
            conn = this.getDBManager().getConnection(false);
            ChangeRecordInfo rec2 = null;
            for (ChangeRecordInfo rec2 : recs) {
                this.insert(conn, rec2);
            }
            conn.commit();
        }
        catch (Exception e) {
            myex = e;
            String emsg = this.br.getKString("B4417", oldTableName, e.getMessage());
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[" + emsg + "]:" + rbe, rbe);
            }
            Exception ex = e;
            if (e instanceof SQLException) {
                this.getDBManager();
                ex = CommDBManager.wrapSQLException("[" + emsg + "]", (SQLException)e);
            }
            throw new BrokerException(emsg, ex);
        }
        finally {
            this.closeSQLObjects(null, null, conn, myex);
        }
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuffer buf = new StringBuffer();
        List records = null;
        try {
            records = this.getAllRecords(conn, null);
            Iterator itr = ((ArrayList)records).iterator();
            ChangeRecordInfo rec = null;
            while (itr.hasNext()) {
                rec = (ChangeRecordInfo)itr.next();
                buf.append(rec.toString()).append("\n");
            }
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("Cluster Config Change Records:\n", buf.toString());
        if (records != null) {
            map.put("Count", ((ArrayList)records).size());
        }
        return map;
    }
}

