/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.portunif.PortMapperMessageFilter;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.portunif.PUService;
import com.sun.messaging.portunif.PUServiceCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PortMapper
implements Runnable,
ConfigListener,
PortMapperClientHandler,
PUServiceCallback {
    private static final int PORTMAPPER_VERSION_MAX_LEN = 128;
    public static final int PORTMAPPER_DEFAULT_PORT = 7676;
    public static final String SERVICE_NAME = "portmapper";
    public static final String HOSTNAME_PROPERTY = "imq.portmapper.hostname";
    private static final String IMQHOSTNAME_PROPERTY = "imq.hostname";
    private static final String PORT_PROPERTY = "imq.portmapper.port";
    public static final String BIND_PROPERTY = "imq.portmapper.bind";
    private static final String BACKLOG_PROPERTY = "imq.portmapper.backlog";
    private static final String SOTIMEOUT_PROPERTY = "imq.portmapper.sotimeout";
    private static final String SOLINGER_PROPERTY = "imq.portmapper.solinger";
    public static final String SSL_ENABLED_PROPERTY = "imq.portmapper.tls.enabled";
    public static final boolean SSL_ENABLED_PROPERTY_DEFAULT = false;
    public static final String TCP_ALLOWED_HOSTNAMES_PROPERTY = "imq.portmapper.tls.tcpAllowHostNames";
    private List<InetAddress> allowedHosts = Collections.synchronizedList(new ArrayList());
    private static boolean DEBUG = false;
    private BrokerResources rb = null;
    private BrokerConfig bc = Globals.getConfig();
    protected Logger logger = null;
    protected PortMapperTable portMapTable = null;
    private ServerSocket serverSocket = null;
    private int port = 7676;
    private boolean doBind = true;
    private int backlog = 100;
    private int sotimeout = 100;
    private int solinger = -1;
    private InetAddress bindAddr = null;
    private String hostname = null;
    private HashMap portmapperMap = null;
    private MQAddress mqaddress = null;
    private boolean sslEnabled = false;
    private boolean running = true;
    private static MQServerSocketFactory ssf = (MQServerSocketFactory)MQServerSocketFactory.getDefault();

    public boolean getDEBUG() {
        return DEBUG;
    }

    public void updateProperties() {
        this.portmapperMap = new HashMap();
        if (Globals.getBrokerID() != null) {
            this.portmapperMap.put("brokerid", Globals.getBrokerID());
        }
        if (Globals.getBrokerSessionID() != null) {
            this.portmapperMap.put("sessionid", Globals.getBrokerSessionID().toString());
            String tmp = Globals.getConfig().getProperty("imq.home");
            if (tmp != null && !tmp.equals("")) {
                this.portmapperMap.put("imqhome", tmp);
            }
            if ((tmp = Globals.getConfig().getProperty("imq.varhome")) != null && !tmp.equals("")) {
                this.portmapperMap.put("imqvarhome", tmp);
            }
        }
        this.updateServiceProperties(SERVICE_NAME, this.portmapperMap);
    }

    public PortMapper(String instance) {
        if (!this.bc.getBooleanProperty("imq.portmapper.reuseAddress", true)) {
            ssf.setReuseAddress(false);
        }
        if (this.bc.getBooleanProperty(SSL_ENABLED_PROPERTY, false)) {
            this.sslEnabled = true;
        }
        this.portMapTable = new PortMapperTable();
        this.portMapTable.setBrokerInstanceName(instance);
        this.portMapTable.setPacketVersion(String.valueOf(301));
        this.logger = Globals.getLogger();
        this.rb = Globals.getBrokerResources();
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", this.port, this.portmapperMap);
        this.addService("cluster_discovery", "tcp", "CLUSTER_DISCOVERY", 0, null);
        this.bc.addListener(PORT_PROPERTY, this);
        this.bc.addListener(BACKLOG_PROPERTY, this);
    }

    public void destroy() {
        this.running = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException ex) {
            this.logger.logStack(8, "Error closing portmapper", ex);
        }
        this.serverSocket = null;
        PUService pu = Globals.getPUService();
        if (pu != null) {
            try {
                pu.destroy();
            }
            catch (IOException ex) {
                this.logger.logStack(8, "Error closing Grizzly PU service transport", ex);
            }
        }
    }

    public void configure(BrokerConfig params) throws PropertyUpdateException {
        this.doBind = params.getBooleanProperty(BIND_PROPERTY, true);
        String value = params.getProperty(HOSTNAME_PROPERTY);
        if (value == null || value.trim().length() == 0) {
            value = params.getProperty(IMQHOSTNAME_PROPERTY);
        }
        this.validate(HOSTNAME_PROPERTY, value);
        this.update(HOSTNAME_PROPERTY, value, true);
        value = params.getProperty(PORT_PROPERTY);
        this.validate(PORT_PROPERTY, value);
        this.update(PORT_PROPERTY, value, true);
        value = params.getProperty(BACKLOG_PROPERTY);
        this.validate(BACKLOG_PROPERTY, value);
        this.update(BACKLOG_PROPERTY, value, true);
        value = params.getProperty(SOTIMEOUT_PROPERTY);
        if (value != null) {
            this.validate(SOTIMEOUT_PROPERTY, value);
            this.update(SOTIMEOUT_PROPERTY, value, true);
        }
        if ((value = params.getProperty(SOLINGER_PROPERTY)) != null) {
            this.validate(SOLINGER_PROPERTY, value);
            this.update(SOLINGER_PROPERTY, value, true);
        }
    }

    private synchronized void setPort(int port, boolean initOnly) {
        PUService pu;
        if (port == this.port) {
            return;
        }
        this.port = port;
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", port, this.portmapperMap);
        LockFile lf = LockFile.getCurrentLockFile();
        try {
            if (lf != null) {
                lf.updatePort(port);
            }
        }
        catch (IOException e) {
            this.logger.log(16, "B3088", e);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((pu = Globals.getPUService()) != null) {
            try {
                pu.rebind(new InetSocketAddress(this.bindAddr, port), this.backlog);
            }
            catch (IOException e) {
                this.logger.logStack(32, Globals.getBrokerResources().getKString("B4446", (this.bindAddr == null ? "" : this.bindAddr.getHostAddress()) + ":" + port), e);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    private synchronized void setHostname(String hostname, boolean initOnly) throws PropertyUpdateException {
        PUService pu;
        MQAddress mqaddr = null;
        try {
            String h = hostname;
            if (hostname != null && hostname.equals("*")) {
                h = null;
            }
            mqaddr = MQAddress.getMQAddress(h, this.getPort());
        }
        catch (Exception e) {
            throw new PropertyUpdateException(2, hostname + ": " + e.toString(), e);
        }
        if (hostname == null || hostname.equals("*") || hostname.trim().length() == 0) {
            PUService pu2;
            this.hostname = null;
            this.bindAddr = null;
            this.mqaddress = mqaddr;
            if (!initOnly && (pu2 = Globals.getPUService()) != null) {
                try {
                    pu2.rebind(new InetSocketAddress(this.bindAddr, this.port), this.backlog);
                }
                catch (IOException e) {
                    this.logger.logStack(32, Globals.getBrokerResources().getKString("B4446", (this.bindAddr == null ? "" : this.bindAddr.getHostAddress()) + ":" + this.port), e);
                }
            }
            return;
        }
        if (hostname.equals(this.hostname)) {
            return;
        }
        try {
            if (Globals.isConfigForCluster()) {
                String hn = hostname;
                if (hn != null && hn.equals("localhost")) {
                    hn = null;
                }
                this.bindAddr = BrokerMQAddress.resolveBindAddress(hn, true);
                mqaddr = MQAddress.getMQAddress(this.bindAddr.getHostAddress(), this.getPort());
            } else {
                this.bindAddr = InetAddress.getByName(hostname);
            }
        }
        catch (Exception e) {
            throw new PropertyUpdateException(2, this.rb.getString("B3150", hostname), e);
        }
        this.hostname = hostname;
        this.mqaddress = mqaddr;
        LockFile lf = LockFile.getCurrentLockFile();
        try {
            if (lf != null) {
                lf.updateHostname(this.mqaddress.getHostName());
            }
        }
        catch (IOException e) {
            this.logger.log(16, "B3088", e);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!initOnly && (pu = Globals.getPUService()) != null) {
            try {
                pu.rebind(new InetSocketAddress(this.bindAddr, this.port), this.backlog);
            }
            catch (IOException e) {
                this.logger.logStack(32, Globals.getBrokerResources().getKString("B4446", (this.bindAddr == null ? "" : this.bindAddr.getHostAddress()) + ":" + this.port), e);
            }
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public MQAddress getMQAddress() {
        return this.mqaddress;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public PortMapperTable getPortMapTable() {
        return this.portMapTable;
    }

    private synchronized void setBacklog(int backlog, boolean initOnly) {
        PUService pu;
        this.backlog = backlog;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!initOnly && (pu = Globals.getPUService()) != null) {
            try {
                pu.setBacklog(backlog);
            }
            catch (IOException e) {
                this.logger.logStack(16, "Failed to set PU service backlog to " + backlog, e);
            }
        }
    }

    public synchronized void addService(String name, String protocol, String type, int port, HashMap props) {
        PortMapperEntry pme = new PortMapperEntry();
        pme.setName(name);
        pme.setProtocol(protocol);
        pme.setType(type);
        pme.setPort(port);
        if (props != null) {
            pme.addProperties(props);
        }
        this.portMapTable.add(pme);
    }

    public synchronized void updateServicePort(String name, int port) {
        PortMapperEntry pme = this.portMapTable.get(name);
        if (pme != null) {
            pme.setPort(port);
        }
    }

    public synchronized void updateServiceProperties(String name, HashMap props) {
        PortMapperEntry pme = this.portMapTable.get(name);
        if (pme != null) {
            pme.addProperties(props);
        }
    }

    public synchronized void addService(String name, PortMapperEntry pme) {
        this.portMapTable.add(pme);
    }

    public synchronized void removeService(String name) {
        this.portMapTable.remove(name);
    }

    public synchronized Map getServices() {
        return this.portMapTable.getServices();
    }

    public synchronized String toString() {
        return this.portMapTable.toString();
    }

    public synchronized void bind() throws Exception {
        PUService pu = Globals.getPUService();
        if (this.sslEnabled && pu == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3311", "imq.portmapper.tls.enabled=true", "imq.portunif.enabled=true"));
        }
        if (this.doBind) {
            if (pu == null) {
                this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
            } else {
                try {
                    pu.register(PortMapperMessageFilter.configurePortMapperProtocol(pu, this), this);
                    if (this.sslEnabled) {
                        Properties props = KeystoreUtil.getDefaultSSLContextConfig("Broker[portpapper]", null);
                        pu.registerSSL(PortMapperMessageFilter.configurePortMapperSSLProtocol(pu, this, props, true), this);
                    }
                    pu.bind(new InetSocketAddress(this.bindAddr, this.port), this.backlog);
                    this.logger.logToAll(8, Globals.getBrokerResources().getKString("B1499", "[" + (this.bindAddr == null ? "" : this.bindAddr) + ":" + this.port + "]" + (this.sslEnabled ? "TCP/SSL/TLS" : "TCP")));
                }
                catch (Exception e) {
                    String emsg = "PU service failed to init";
                    this.logger.logStack(32, emsg, e);
                    throw new BrokerException(emsg);
                }
            }
        } else if (pu != null) {
            throw new BrokerException("imq.portunif.enabled=true setting not allowed if nobind");
        }
    }

    public synchronized void startPUService() throws Exception {
        List hosts;
        PUService pu = Globals.getPUService();
        if (pu == null) {
            return;
        }
        if (this.sslEnabled && (hosts = Globals.getConfig().getList(TCP_ALLOWED_HOSTNAMES_PROPERTY)) != null) {
            for (String host : hosts) {
                this.allowedHosts.add(BrokerMQAddress.createAddress(host, 7676).getHost());
            }
        }
        pu.start();
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private ServerSocket createPortMapperServerSocket(int port, InetAddress bindAddr) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = ssf.createServerSocket(port, this.backlog, bindAddr);
        }
        catch (BindException e) {
            this.logger.log(32, "B3068", (Object)SERVICE_NAME, String.valueOf(port));
            return null;
        }
        catch (IOException e) {
            this.logger.log(32, "B3022", SERVICE_NAME, new Integer(port), e);
            return null;
        }
        Object[] args = new Object[]{SERVICE_NAME, "tcp [ " + port + ", " + this.backlog + ", " + (bindAddr != null ? bindAddr.getHostAddress() : "*") + " ]", new Integer(1), new Integer(1)};
        this.logger.log(8, "B1004", args);
        return serverSocket;
    }

    @Override
    public void run() {
        int restartCode = BrokerStateHandler.getRestartCode();
        String restartOOMsg = this.rb.getKString("B0081");
        String acceptOOMsg = this.rb.getKString("B0079");
        Socket connection = null;
        boolean oom = false;
        try {
            if (this.serverSocket == null) {
                this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
            }
            if (DEBUG && this.serverSocket != null) {
                this.logger.log(4, "PortMapper: " + this.serverSocket + " " + MQServerSocketFactory.serverSocketToString(this.serverSocket) + ", backlog=" + this.backlog + "");
            }
            boolean firstpass = true;
            while (this.running) {
                if (this.serverSocket == null) {
                    this.logger.log(32, "B3070");
                    return;
                }
                try {
                    connection = this.serverSocket.accept();
                    firstpass = true;
                }
                catch (SocketException e) {
                    block47: {
                        if (e instanceof BindException || e instanceof ConnectException || e instanceof NoRouteToHostException) {
                            this.logger.log(32, "B3069", e);
                            PortMapper.sleep(1);
                            continue;
                        }
                        if (!this.running) {
                            break;
                        }
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException ioe) {
                        }
                        catch (NullPointerException ioe) {
                            if (this.running) break block47;
                            break;
                        }
                    }
                    this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
                    continue;
                }
                catch (IOException e) {
                    this.logger.logStack(32, "B3069", e);
                    PortMapper.sleep(1);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    block48: {
                        if (!this.running) {
                            break;
                        }
                        if (firstpass) {
                            firstpass = false;
                            Globals.handleGlobalError(e, acceptOOMsg);
                            PortMapper.sleep(1);
                            continue;
                        }
                        Broker.getBroker().exit(restartCode, restartOOMsg, BrokerEvent.Type.RESTART, null, false, false, true);
                        try {
                            try {
                                if (connection != null) {
                                    connection.close();
                                }
                                if (this.serverSocket != null) {
                                    this.serverSocket.close();
                                }
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            if (oom && this.running) {
                                this.logger.log(32, restartOOMsg);
                                Broker.getBroker().exit(restartCode, restartOOMsg, BrokerEvent.Type.RESTART, null, false, false, true);
                            }
                            if (this.running) {
                                this.logger.log(8, "B0082");
                            }
                        }
                        catch (OutOfMemoryError e3) {
                            if (!this.running) break block48;
                            Broker.getBroker().exit(restartCode, restartOOMsg, BrokerEvent.Type.RESTART, null, false, false, true);
                        }
                    }
                    return;
                }
                this.handleSocket(connection);
            }
        }
        catch (OutOfMemoryError e) {
            oom = true;
            throw e;
        }
        finally {
            block49: {
                try {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e) {}
                    if (oom && this.running) {
                        this.logger.log(32, restartOOMsg);
                        Broker.getBroker().exit(restartCode, restartOOMsg, BrokerEvent.Type.RESTART, null, false, false, true);
                    }
                    if (this.running) {
                        this.logger.log(8, "B0082");
                    }
                }
                catch (OutOfMemoryError e) {
                    if (!this.running) break block49;
                    Broker.getBroker().exit(restartCode, restartOOMsg, BrokerEvent.Type.RESTART, null, false, false, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSocket(Socket socket) {
        String connOOMsg = this.rb.getKString("B0080");
        if (!socket.isConnected()) {
            this.logger.log(4, "PortMapper: accepted client connection (" + socket.toString() + ") that is" + " no longer connected. Ignoring.");
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            PortMapper e = this;
            synchronized (e) {
                socket.setSoTimeout(this.sotimeout);
                if (this.solinger > 0) {
                    socket.setSoLinger(true, this.solinger);
                }
                InputStream is = socket.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuffer version = new StringBuffer();
                try {
                    int c;
                    int cnt = 0;
                    Character cc = null;
                    Character cr = Character.valueOf('\r');
                    Character lf = Character.valueOf('\n');
                    while ((c = br.read()) >= 0 && !(cc = Character.valueOf((char)c)).equals(cr) && !cc.equals(lf)) {
                        version.append((char)c);
                        if (++cnt <= 128) continue;
                        throw new IOException(Globals.getBrokerResources().getKString("B2286", String.valueOf(cnt), SERVICE_NAME));
                    }
                }
                catch (SocketTimeoutException e2) {
                    // empty catch block
                }
                this.portMapTable.write(socket.getOutputStream());
                try {
                    int n = 0;
                    while (br.readLine() != null && ++n < 5) {
                    }
                }
                catch (SocketTimeoutException e3) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            InetAddress ia = socket.getInetAddress();
            this.logger.logStack(16, "B3164", ia.getHostAddress(), (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            if (!this.running) {
                return;
            }
            this.logger.log(16, connOOMsg);
            try {
                socket.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            Globals.handleGlobalError(e, connOOMsg);
            PortMapper.sleep(1);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void handleRequest(SocketChannel clientSocketChannel) {
        if (this.doBind) {
            throw new IllegalStateException("Should not call PortMapper.handleRequest() unless Broker has been started with the -noBind argument");
        }
        this.handleSocket(clientSocketChannel.socket());
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
        if (!(name.equals(PORT_PROPERTY) || name.equals(BACKLOG_PROPERTY) || name.equals(SOLINGER_PROPERTY) || name.equals(HOSTNAME_PROPERTY) || name.equals(SOTIMEOUT_PROPERTY))) {
            throw new PropertyUpdateException(this.rb.getString("B4028", name));
        }
        if (name.equals(HOSTNAME_PROPERTY)) {
            if (value == null || value.trim().length() == 0 || value.equals("*")) {
                return;
            }
            try {
                if (Globals.isConfigForCluster()) {
                    BrokerMQAddress.resolveBindAddress(value, true);
                } else {
                    InetAddress.getByName(value);
                }
            }
            catch (Exception e) {
                throw new PropertyUpdateException(2, this.rb.getKString("B3151", value, name) + ": " + e.toString(), e);
            }
            return;
        }
        int n = this.getIntProperty(name, value);
        if (name.equals(PORT_PROPERTY)) {
            if (n == this.port) {
                return;
            }
            if (n == 0) {
                throw new PropertyUpdateException(2, this.rb.getString("B4027", name + "=" + value));
            }
            if (this.isDoBind()) {
                try {
                    PortMapper.canBind(n, this.bindAddr);
                }
                catch (BindException e) {
                    throw new PropertyUpdateException(this.rb.getKString("B3068", SERVICE_NAME, String.valueOf(value)) + "\n" + e.toString());
                }
                catch (IOException e) {
                    throw new PropertyUpdateException(this.rb.getKString("B3022", SERVICE_NAME, String.valueOf(value)) + "\n" + e.toString());
                }
            }
        }
    }

    @Override
    public boolean update(String name, String value) {
        return this.update(name, value, false);
    }

    private boolean update(String name, String value, boolean initOnly) {
        try {
            if (name.equals(PORT_PROPERTY)) {
                this.setPort(this.getIntProperty(name, value), initOnly);
                if (this.mqaddress != null) {
                    this.mqaddress = MQAddress.getMQAddress(this.mqaddress.getHostName() + ":" + this.getPort());
                }
            } else if (name.equals(BACKLOG_PROPERTY)) {
                this.setBacklog(this.getIntProperty(name, value), initOnly);
            } else if (name.equals(SOTIMEOUT_PROPERTY)) {
                this.sotimeout = this.getIntProperty(name, value);
            } else if (name.equals(SOLINGER_PROPERTY)) {
                this.solinger = this.getIntProperty(name, value);
            } else {
                this.setHostname(value, initOnly);
            }
        }
        catch (Exception e) {
            this.logger.log(32, this.rb.getString("B4027", name + "=" + value), e);
            return false;
        }
        return true;
    }

    public int getIntProperty(String name, String value) throws PropertyUpdateException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyUpdateException(this.rb.getString("B4027", name + "=" + value));
        }
    }

    public static void sleep(int nseconds) {
        try {
            Thread.sleep((long)nseconds * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void canBind(int port, InetAddress bindAddr) throws IOException {
        ServerSocket ss = null;
        ss = ssf.createServerSocket(port, 0, bindAddr);
        ss.close();
    }

    public boolean isDoBind() {
        return this.doBind;
    }

    @Override
    public boolean allowConnection(InetSocketAddress sa, boolean ssl) {
        if (DEBUG) {
            this.logger.log(8, "PortMapper.alllowConnection(" + sa + ", " + ssl + "), sslEnabled=" + this.sslEnabled + ",  allowedHosts=" + this.allowedHosts + ", broker=" + Globals.getBrokerInetAddress());
        }
        if (!this.sslEnabled) {
            return true;
        }
        if (ssl) {
            return true;
        }
        if (sa.getAddress().equals(Globals.getBrokerInetAddress())) {
            return true;
        }
        if (sa.getAddress().isLoopbackAddress()) {
            return true;
        }
        if (this.allowedHosts.contains(sa.getAddress())) {
            return true;
        }
        ClusterManager cm = Globals.getClusterManager();
        Iterator itr = cm.getConfigBrokers();
        ClusteredBroker cb = null;
        BrokerMQAddress addr = null;
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            addr = (BrokerMQAddress)cb.getBrokerURL();
            if (DEBUG) {
                this.logger.log(8, "PortMapper.allowConnection(" + sa + "), check configured cluster broker " + addr);
            }
            if (!addr.getHost().equals(sa.getAddress())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void logInfo(String msg) {
        this.logger.log(8, msg);
    }

    @Override
    public void logWarn(String msg, Throwable e) {
        if (e != null) {
            this.logger.logStack(16, msg, e);
        } else {
            this.logger.log(16, msg);
        }
    }

    @Override
    public void logError(String msg, Throwable e) {
        this.logger.logStack(32, msg, e);
    }
}

