/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.api;

import com.sun.messaging.bridge.api.BridgeBaseContext;
import com.sun.messaging.jmq.util.RuntimeFaultInjection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaultInjection
extends RuntimeFaultInjection {
    private static BridgeBaseContext _bc = null;
    private Logger _logger = null;
    private static FaultInjection _fault = null;
    public static final String STAGE_1 = "1";
    public static final String STAGE_2 = "2";
    public static final String FAULT_XA_START_1 = "xa.start.1";
    public static final String FAULT_XA_START_2 = "xa.start.2";
    public static final String FAULT_XA_END_1 = "xa.end.1";
    public static final String FAULT_XA_END_2 = "xa.end.2";
    public static final String FAULT_XA_PREPARE_1 = "xa.prepare.1";
    public static final String FAULT_XA_PREPARE_2 = "xa.prepare.2";
    public static final String FAULT_XA_COMMIT_1 = "xa.commit.1";
    public static final String FAULT_XA_COMMIT_2 = "xa.commit.2";
    public static final String FAULT_XA_ROLLBACK_1 = "xa.rollback.1";
    public static final String FAULT_XA_ROLLBACK_2 = "xa.rollback.2";
    public static final String FAULT_XA_RECOVER_1 = "xa.recover.1";
    public static final String FAULT_RECEIVE_1 = "receive.1";
    public static final String FAULT_RECEIVE_2 = "receive.2";
    public static final String FAULT_TRANSFORM_2 = "transform.2";
    public static final String FAULT_SEND_1 = "send.1";
    public static final String FAULT_SEND_2 = "send.2";
    public static final String FAULT_DMQ_SEND_1 = "dmq.send.1";
    public static final String FAULT_DMQ_TRANSFORM_2 = "dmq.transform.2";
    public static final String FAULT_ACK_1 = "ack.1";
    public static final String FAULT_ACK_2 = "ack.2";
    public static final String DMQ_NAME_PROP = "dmqName";
    public static final String CFREF_PROP = "cfref";
    private static final String SLEEP_INTERVAL_PROP = "mqSleepInterval";
    private static final int SLEEP_INTERVAL_DEFAULT = 60;

    public static void setBridgeBaseContext(BridgeBaseContext bc) {
        _bc = bc;
    }

    public void setLogger(Logger l) {
        this._logger = l;
    }

    public static FaultInjection getInjection() {
        if (_fault == null) {
            _fault = new FaultInjection();
        }
        return _fault;
    }

    public FaultInjection() {
        this.setProcessName(_bc.isEmbeded() ? "BROKER" : "PROCESS");
    }

    @Override
    protected void exit(int exitCode) {
        this.logWarn("EXIST JVM from bridge is not supported", null);
    }

    @Override
    protected String sleepIntervalPropertyName() {
        return SLEEP_INTERVAL_PROP;
    }

    @Override
    protected int sleepIntervalDefault() {
        return 60;
    }

    @Override
    protected void logInfo(String msg, Throwable t) {
        Logger logger;
        if (_bc != null) {
            _bc.logInfo(msg, t);
        }
        if ((logger = this._logger) != null) {
            if (t == null) {
                logger.log(Level.INFO, msg);
            } else {
                logger.log(Level.INFO, msg, t);
            }
        }
    }

    @Override
    protected void logWarn(String msg, Throwable t) {
        Logger logger;
        if (_bc != null) {
            _bc.logWarn(msg, t);
        }
        if ((logger = this._logger) != null) {
            if (t == null) {
                logger.log(Level.WARNING, msg);
            } else {
                logger.log(Level.WARNING, msg, t);
            }
        }
    }
}

