/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class DestroyDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DestroyDestinationHandler.getDEBUG();

    public DestroyDestinationHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Destroying destination: " + cmd_props);
        }
        String destination = (String)cmd_props.get("JMQDestination");
        Integer destType = (Integer)cmd_props.get("JMQDestType");
        int status = 200;
        String errMsg = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            try {
                boolean ok;
                if (destType == null) {
                    throw new Exception("B4088");
                }
                Globals.getAuditSession().destinationOperation(con.getUserName(), con.remoteHostString(), "destroy destination", DestType.isQueue(destType) ? "queue" : "topic", destination);
                Destination[] ds = DestinationList.removeDestination(null, destination, DestType.isQueue(destType), this.rb.getString("B0066"));
                Destination d = ds[0];
                boolean bl = ok = d != null;
                if (!ok) {
                    status = 500;
                    String subError = this.rb.getString("B3128", this.getDestinationType(destType), destination);
                    errMsg = this.rb.getString("B4087", destination, subError);
                }
            }
            catch (Exception ex) {
                status = 500;
                errMsg = this.rb.getString("B4087", destination, DestroyDestinationHandler.getMessageFromException(ex));
                if (ex instanceof BrokerException) {
                    this.logger.logStack(16, "B4087", destination, "", ex);
                }
                this.logger.logStack(16, "B4087", destination, "", ex);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        DestroyDestinationHandler.setProperties(reply, 13, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

