/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConsumerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class ConsumerManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getConsumerInfoByIDSignature;
    private static MBeanParameterInfo[] numWildcardConsumersSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConsumers() {
        return new Integer(ConsumerUtil.getNumConsumersNoChildren());
    }

    public Integer getNumWildcardConsumers() throws MBeanException {
        int n = Consumer.getNumWildcardConsumers();
        return new Integer(n);
    }

    public Integer getNumWildcardConsumers(String wildcard) throws MBeanException {
        int numWildcardConsumers = Consumer.getNumWildcardConsumers();
        if (numWildcardConsumers <= 0) {
            return new Integer(0);
        }
        Iterator consumers = Consumer.getWildcardConsumers();
        if (consumers == null) {
            return new Integer(0);
        }
        int count = 0;
        while (consumers.hasNext()) {
            ConsumerUID cid = (ConsumerUID)consumers.next();
            Consumer oneCon = Consumer.getConsumer(cid);
            if (wildcard != null) {
                DestinationUID id = oneCon.getDestinationUID();
                if (!id.getName().equals(wildcard)) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return new Integer(count);
    }

    public String[] getConsumerWildcards() throws MBeanException {
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        int numWildcardConsumers = Consumer.getNumWildcardConsumers();
        if (numWildcardConsumers <= 0) {
            return null;
        }
        Iterator consumers = Consumer.getWildcardConsumers();
        if (consumers == null) {
            return null;
        }
        while (consumers.hasNext()) {
            ConsumerUID cid = (ConsumerUID)consumers.next();
            Consumer oneCon = Consumer.getConsumer(cid);
            if (!oneCon.isWildcard()) continue;
            DestinationUID id = oneCon.getDestinationUID();
            al.add(id.getName());
        }
        if (al.size() > 0) {
            list = new String[al.size()];
            list = al.toArray(list);
        }
        return list;
    }

    public String[] getConsumerIDs() {
        return ConsumerUtil.getConsumerIDs();
    }

    public CompositeData[] getConsumerInfo() throws MBeanException {
        CompositeData[] cds = null;
        try {
            cds = ConsumerUtil.getConsumerInfo();
        }
        catch (Exception e) {
            this.handleOperationException("getConsumerInfo", e);
        }
        return cds;
    }

    public CompositeData getConsumerInfoByID(String consumerID) throws MBeanException {
        CompositeData cd = null;
        try {
            cd = ConsumerUtil.getConsumerInfo(consumerID);
        }
        catch (Exception e) {
            this.handleOperationException("getConsumerInfoByID", e);
        }
        return cd;
    }

    @Override
    public String getMBeanName() {
        return "ConsumerManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1075");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1069"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumWildcardConsumers", Integer.class.getName(), mbr.getString("MB1253"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("consumerID", String.class.getName(), mbr.getString("MB1074"));
        getConsumerInfoByIDSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1251"));
        numWildcardConsumersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1070"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConsumerInfo", mbr.getString("MB1071"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getConsumerInfoByID", mbr.getString("MB1072"), getConsumerInfoByIDSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getConsumerWildcards", mbr.getString("MB1254"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getNumWildcardConsumers", mbr.getString("MB1255"), numWildcardConsumersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

