/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.bridge.api.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreSessionReaperListener;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.RetrySQLRecoverableException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore")
@Singleton
public class JDBCStore
extends Store
implements DBConstants,
PartitionedStore {
    private static boolean DEBUG = JDBCStore.getDEBUG();
    public static final String LOCK_STORE_PROP = "imq.persist.jdbc.lockstore.enabled";
    public static final String ENABLE_STORED_PROC_PROP = "imq.persist.jdbc.enableStoredProc";
    public static final boolean ENABLE_STORED_PROC = Globals.getConfig().getBooleanProperty("imq.persist.jdbc.enableStoredProc", false);
    public static final int STORED_PROC_VERSION = 500;
    private static final String MSG_ENUM_USE_CURSOR_PROP = "imq.persist.jdbc.msgEnumUseResultSetCursor";
    public static final int OLD_STORE_VERSION_350 = 350;
    public static final int OLD_STORE_VERSION_370 = 370;
    public static final int OLD_STORE_VERSION_400 = 400;
    public static final int STORE_VERSION = 410;
    DBManager dbmgr;
    DAOFactory daoFactory;
    private HashMap pendingDeleteDsts = new HashMap(5);
    private HashMap takeoverLockMap = new HashMap();
    private StoreSessionReaperTask sessionReaper = null;
    private boolean msgEnumUseCursor = true;
    private List<Enumeration> dataEnums = Collections.synchronizedList(new ArrayList());
    private UID partitionid = PartitionedStore.DEFAULT_UID;
    private static final String PARTITION_MODE_PROP = "imq.persist.partitionMode.enabled";
    private static final boolean PARTITION_MODE_DEFAULT = false;
    private static final String PARTITION_MIGRATABLE_PROP = "imq.persist.jdbc.partitionMigratable";
    private static final boolean PARTITION_MIGRATABLE_DEFAULT = false;
    private static final String INIT_NUM_PARTITION_PROP = "imq.persist.jdbc.initialNumPartitions";
    private static final int INIT_NUM_PARTITION_DEFAULT = 1;
    private int initialNumPartitions = 1;
    private static final String PARTITION_STORE_CLASS_PROP = "imq.persist.jdbc.storePartitionClass";
    private static final String PARTITION_STORE_CLASS_DEFAULT = "com.sun.messaging.jmq.jmsserver.persist.partition.jdbc.JDBCStorePartition";
    private boolean partitionMode = false;
    private boolean partitionMigratable = false;
    private Class partitionClass = null;
    private static final String partitionClassStr = Globals.getConfig().getProperty("imq.persist.jdbc.storePartitionClass", "com.sun.messaging.jmq.jmsserver.persist.partition.jdbc.JDBCStorePartition");
    private LinkedHashMap<UID, PartitionedStore> partitionStores = new LinkedHashMap();
    private List<PartitionListener> partitionListeners = new ArrayList<PartitionListener>();
    private List<StoreSessionReaperListener> sessionReaperListeners = new ArrayList<StoreSessionReaperListener>();
    private ReentrantLock partitionLock = new ReentrantLock();
    private FaultInjection FI = FaultInjection.getInjection();

    public JDBCStore() throws BrokerException {
        String user;
        this.partitionMode = StoreManager.isConfiguredPartitionMode(false);
        if (this.partitionMode && !Globals.getHAEnabled()) {
            this.partitionMode = false;
            logger.log(16, br.getKString("B2219", "imq.persist.partitionMode.enabled=true"));
        }
        if (this.partitionMode) {
            try {
                this.partitionClass = Class.forName(partitionClassStr);
            }
            catch (Exception e) {
                throw new BrokerException(e.getMessage(), e);
            }
            int val = config.getIntProperty(INIT_NUM_PARTITION_PROP, 1);
            if (val > 0) {
                this.initialNumPartitions = val;
            }
            this.partitionMigratable = config.getBooleanProperty(PARTITION_MIGRATABLE_PROP, false);
            String reskey = "B1446";
            if (this.partitionMigratable) {
                reskey = "B1447";
            }
            String str = "";
            if (this.initialNumPartitions > 1) {
                str = "[imq.persist.jdbc.initialNumPartitions=" + this.initialNumPartitions + "]";
            }
            logger.log(8, br.getKString(reskey, this.getStoreType()) + str);
        }
        this.dbmgr = DBManager.getDBManager();
        this.daoFactory = this.dbmgr.getDAOFactory();
        String url = this.dbmgr.getOpenDBURL();
        if (url == null) {
            url = "not specified";
        }
        if ((user = this.dbmgr.getUser()) == null) {
            user = "not specified";
        }
        Object[] msgArgs = new String[]{String.valueOf(410), this.dbmgr.getBrokerID(), url, user};
        logger.logToAll(8, br.getString("B1067", msgArgs));
        if (this.createStore) {
            logger.log(8, "B1170");
        } else {
            logger.log(8, "B1171");
        }
        this.msgEnumUseCursor = config.getBooleanProperty(MSG_ENUM_USE_CURSOR_PROP, !this.dbmgr.isHADB());
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            if (!this.checkStore(conn)) {
                this.closeDB(false);
                return;
            }
            if (Globals.getHAEnabled()) {
                try {
                    long period = 86400000L;
                    long delay = 60000L + (long)(Math.random() * 240000.0);
                    this.sessionReaper = new StoreSessionReaperTask(this);
                    Globals.getTimer().schedule((TimerTask)this.sessionReaper, delay, period);
                    logger.log(8, br.getKString("B1486") + "[delay=" + delay + ", period=" + period + "]");
                }
                catch (IllegalStateException e) {
                    logger.logStack(16, br.getKString("B2284"), e);
                }
            } else if (config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                this.dbmgr.lockTables(conn, true);
            }
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
        this.dbmgr.setStoreInited(true);
        if (DEBUG) {
            logger.log(4, "JDBCStore instantiated.");
        }
    }

    @Override
    public void checkPartitionMode() throws BrokerException {
    }

    @Override
    public final int getStoreVersion() {
        return 410;
    }

    @Override
    public Map<String, String> getClusterMatchProperties() throws BrokerException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.partitionMode) {
            map.put(PARTITION_MODE_PROP, "true");
            if (this.partitionMigratable) {
                map.put(PARTITION_MIGRATABLE_PROP, "true");
            }
        }
        if (Globals.getHAEnabled()) {
            map.put("imq.persist.store", this.getStoreType());
        }
        return map;
    }

    @Override
    public void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        if (this.partitionMode) {
            throw new BrokerException("B3044" + " JDBCStore.storeMessage(,,,,,): unexpected call for partition mode ");
        }
        if (iids.length == 0 || iids.length != states.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        this.storeMessage(dst, message, iids, states, this.getStoreSession(), true);
    }

    @Override
    public void storeMessage(DestinationUID dst, Packet message, boolean sync) throws BrokerException {
        if (this.partitionMode) {
            throw new BrokerException("B3044" + " JDBCStore.storeMessage(,,,): unexpected call for partition mode ");
        }
        this.storeMessage(dst, message, null, null, this.getStoreSession(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, long storeSessionID, boolean checkMsgExist) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeMessageInternal(dst, message, iids, states, storeSessionID, checkMsgExist);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeMessageInternal(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, long storeSessionID, boolean checkMsgExist) throws BrokerException {
        if (message == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            if (iids == null) {
                logger.log(8, "JDBCStore.storeMessageInternal(" + dst + ", " + message.getSysMessageID().getUniqueName() + ", " + iids + ", " + states + ", " + storeSessionID + ", " + checkMsgExist + ")");
            } else {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < iids.length; ++i) {
                    buf.append("[consumer=" + iids[i] + ", state=" + states[i] + "], ");
                }
                logger.log(8, "JDBCStore.storeMessageInternal(" + dst + ", " + message.getSysMessageID().getUniqueName() + ", " + buf.toString() + storeSessionID + ", " + checkMsgExist + ")");
            }
        }
        boolean replaycheck = false;
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getMessageDAO().insert(null, dst, message, iids, states, storeSessionID, message.getTimestamp(), checkMsgExist, replaycheck);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                replaycheck = retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        super.checkClosedAndSetInProgress();
        try {
            this.moveMessageInternal(message, from, to, iids, states, sync);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void moveMessageInternal(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        if (message == null || from == null || to == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(8, "JDBCStore.moveMessageInternal(" + message.getSysMessageID().getUniqueName() + ", " + from + ", " + to + ", " + iids + ", " + states + ", " + sync + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getMessageDAO().moveMessage(null, message, from, to, iids, states);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync, boolean onRollback) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.removeMessageInternal(dID, mID, sync, onRollback);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeMessageInternal(DestinationUID dID, SysMessageID mID, boolean sync, boolean onRollback) throws BrokerException {
        if (mID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.removeMessageInternal(" + dID + ", " + mID.getUniqueName() + ", " + sync + ", " + onRollback + ")");
        }
        boolean replaycheck = false;
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getMessageDAO().delete(null, dID, mID, replaycheck);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                replaycheck = retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void removeAllMessages(Destination dst, boolean sync) throws IOException, BrokerException {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.removeAllMessages(" + dst.getUniqueName() + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().deleteByDestinationBySession(null, dst.getDestinationUID(), null);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Enumeration messageEnumeration(Destination dst) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.messageEnumerationInternal(dst, null);
            return enumeration;
        }
        catch (RuntimeException e) {
            this.setInProgress(false);
            throw e;
        }
        catch (BrokerException e) {
            this.setInProgress(false);
            throw e;
        }
        finally {
            if (!this.msgEnumUseCursor) {
                this.setInProgress(false);
            }
        }
    }

    public boolean getMessageEnumUseCursor() {
        return this.msgEnumUseCursor;
    }

    public Enumeration messageEnumerationInternal(Destination dst, Long storeSession) throws BrokerException {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(8, "JDBCStore.messageEnumerationInternal(" + dst.getUniqueName() + ", " + storeSession + ")");
        }
        String brokerID = this.dbmgr.getBrokerID();
        if (!this.msgEnumUseCursor) {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    return this.daoFactory.getMessageDAO().messageEnumeration(dst, brokerID, storeSession);
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        Enumeration en = null;
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    en = this.daoFactory.getMessageDAO().messageEnumerationCursor(dst, brokerID, storeSession);
                    this.dataEnums.add(en);
                    return en;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            if (en != null) {
                this.dataEnums.remove(en);
                ((MessageEnumeration)en).close();
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(Enumeration en) {
        if (!(en instanceof MessageEnumeration)) {
            return;
        }
        try {
            this.closeEnumerationInternal(en);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void closeEnumerationInternal(Enumeration en) {
        this.dataEnums.remove(en);
        ((MessageEnumeration)en).close();
    }

    @Override
    public int getMessageCount(String brokerID) throws BrokerException {
        if (brokerID == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getMessageCount() called for broker: " + brokerID);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    int n = this.daoFactory.getMessageDAO().getMessageCount(null, brokerID);
                    return n;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMessageStorageInfo(Destination dst) throws BrokerException {
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.getMessageStorageInfoInternal(dst, null);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getMessageStorageInfoInternal(Destination dst, Long storeSession) throws BrokerException {
        if (dst == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(8, "JDBCStore.getMessageStorageInfoInternal(" + dst.getUniqueName() + ", " + storeSession + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getMessageDAO().getMessageStorageInfo(null, dst, storeSession);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    @Override
    public Packet getMessage(DestinationUID dID, SysMessageID mID) throws BrokerException {
        if (mID == null) {
            throw new NullPointerException();
        }
        return this.getMessage(dID, mID.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet getMessage(DestinationUID dID, String mID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Packet packet = this.getMessageInternal(dID, mID);
            return packet;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Packet getMessageInternal(DestinationUID dID, String mID) throws BrokerException {
        if (mID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getMessageInternal(" + dID + ", " + mID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getMessageDAO().getMessage(null, dID, mID);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterestStates(DestinationUID dID, SysMessageID mID, ConsumerUID[] iids, int[] states, boolean sync, Packet msg) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeInterestStatesInternal(dID, mID, iids, states, sync, msg);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeInterestStatesInternal(DestinationUID dID, SysMessageID mID, ConsumerUID[] iids, int[] states, boolean sync, Packet msg) throws BrokerException {
        if (mID == null || iids == null || states == null) {
            throw new NullPointerException();
        }
        if (iids.length == 0 || iids.length != states.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeInterestStatesInternal(" + dID + ", " + mID.getUniqueName() + ", " + iids + ", " + states + ")");
        }
        boolean replaycheck = false;
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getConsumerStateDAO().insert(null, dID.toString(), mID, iids, states, true, replaycheck);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                replaycheck = retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int state, boolean sync, TransactionUID txid, boolean isLastAck) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateInterestStateInternal(dID, mID, iID, state, sync, txid, isLastAck);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestStateInternal(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int state, boolean sync, TransactionUID txid, boolean isLastAck) throws BrokerException {
        if (mID == null || iID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateInterestStateInternal(" + dID + ", " + mID.getUniqueName() + ", " + iID.toString() + ", " + state + ", " + sync + ", " + txid + ", " + isLastAck + ")");
        }
        boolean replaycheck = false;
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getConsumerStateDAO().updateState(null, dID, mID, iID, state, replaycheck);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                replaycheck = retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    public void updateInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int newState, int expectedState) throws BrokerException {
        if (mID == null || iID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateInterestState() called with message: " + mID.getUniqueName() + ", consumer: " + iID.toString() + ", state=" + newState + ", expected: " + expectedState);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, dID, mID, iID, newState, expectedState);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            int n = this.getInterestStateInternal(dID, mID, iID);
            return n;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int getInterestStateInternal(DestinationUID dID, SysMessageID mID, ConsumerUID iID) throws BrokerException {
        if (mID == null || dID == null || iID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getInterestStateInternal(" + dID + ", " + mID.getUniqueName() + ", " + iID + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(conn, dID.toString(), mID.getUniqueName());
                    int n = this.daoFactory.getConsumerStateDAO().getState(conn, mID, iID);
                    return n;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getInterestStates(DestinationUID dID, SysMessageID mID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.getInterestStatesInternal(dID, mID);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getInterestStatesInternal(DestinationUID dID, SysMessageID mID) throws BrokerException {
        if (mID == null || dID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getInterestStatesInternal(" + dID + ", " + mID.getUniqueName() + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getConsumerStateDAO().getStates(conn, mID);
                    return hashMap;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID dID, SysMessageID mID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.getConsumerUIDsInternal(dID, mID);
            return consumerUIDArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public ConsumerUID[] getConsumerUIDsInternal(DestinationUID dID, SysMessageID mID) throws BrokerException {
        if (mID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getConsumerUIDsInternal(" + dID + ", " + mID.getUniqueName() + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().checkMessage(conn, dID.toString(), mID.getUniqueName());
                    ConsumerUID[] consumerUIDArray = this.daoFactory.getConsumerStateDAO().getConsumerUIDs(conn, mID).toArray(new ConsumerUID[0]);
                    return consumerUIDArray;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    @Override
    public void storeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (interest == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeInterest(" + interest.getConsumerUID().toString() + ", " + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().insert(null, interest, System.currentTimeMillis());
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (interest == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeInterest() called with interest: " + interest.getConsumerUID().toString());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().delete(null, interest);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Consumer[] consumerArray = this.daoFactory.getConsumerDAO().getAllConsumers(null).toArray(new Consumer[0]);
                    return consumerArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDestination(Destination destination, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeDestinationInternal(destination, this.getStoreSession());
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeDestination(Destination destination, long storeSession) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeDestinationInternal(destination, storeSession);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeDestinationInternal(Destination destination, long storeSessionID) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeDestinationInternal(" + destination.getUniqueName() + ", " + storeSessionID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getDestinationDAO().insert(null, destination, storeSessionID, 0L, System.currentTimeMillis());
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDestination(Destination destination, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateDestinationInternal(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateDestinationInternal(Destination destination) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateDestinationInternal(" + destination.getUniqueName() + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getDestinationDAO().update(null, destination);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(Destination destination, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.removeDestinationInternal(destination, null);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestinationInternal(Destination destination, Long storeSessionID) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.removeDestinationInternal(" + destination.getUniqueName() + ", " + storeSessionID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                boolean isDeleted = this.daoFactory.getDestinationDAO().delete(null, destination, storeSessionID);
                if (destination.isAutoCreated() && Globals.getHAEnabled() && storeSessionID == null) {
                    DestinationUID dstID = destination.getDestinationUID();
                    HashMap hashMap = this.pendingDeleteDsts;
                    synchronized (hashMap) {
                        if (isDeleted) {
                            this.pendingDeleteDsts.remove(dstID);
                        } else {
                            this.pendingDeleteDsts.put(dstID, destination.getType());
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapAutoCreatedDestinations() throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.reapAutoCreatedDestinations() called");
        }
        if (!Globals.getHAEnabled()) {
            return;
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HashMap hashMap = this.pendingDeleteDsts;
                    synchronized (hashMap) {
                        if (!this.pendingDeleteDsts.isEmpty()) {
                            DestinationDAO dao = this.daoFactory.getDestinationDAO();
                            Iterator itr = this.pendingDeleteDsts.entrySet().iterator();
                            while (itr.hasNext()) {
                                int type;
                                Map.Entry e = itr.next();
                                DestinationUID dst = (DestinationUID)e.getKey();
                                if (!dao.delete(null, dst, type = ((Integer)e.getValue()).intValue())) continue;
                                logger.log(4, "Auto-created destination " + dst + " has been removed from HA Store");
                                itr.remove();
                            }
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination(DestinationUID id) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Destination destination = this.getDestinationInternal(id);
            return destination;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination getDestinationInternal(DestinationUID id) throws BrokerException {
        if (id == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getDestinationInternal(" + id + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getDestinationDAO().getDestination(null, id.toString());
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination[] getAllDestinations() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.getAllDestinationsInternal(this.dbmgr.getBrokerID(), null);
            return destinationArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination[] getAllDestinations(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.getAllDestinationsInternal(brokerID, null);
            return destinationArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Destination[] getAllDestinationsInternal(Long storeSessionID) throws BrokerException {
        return this.getAllDestinationsInternal(this.dbmgr.getBrokerID(), storeSessionID);
    }

    public Destination[] getAllDestinationsInternal(String brokerID, Long storeSessionID) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getAllDestinationsInternal(" + brokerID + ", " + storeSessionID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getDestinationDAO().getAllDestinations(null, brokerID).toArray(new Destination[0]);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeTransactionInternal(id, ts, sync, this.getStoreSession());
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransactionInternal(TransactionUID id, TransactionState ts, boolean sync, long storeSession) throws BrokerException {
        if (id == null || ts == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeTransactionInternal(" + id + ", " + ts + ", " + sync + ", " + storeSession + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getTransactionDAO().insert(null, id, ts, storeSession);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(TransactionUID id, boolean removeAcks, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.removeTransactionInternal(id, removeAcks, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransactionInternal(TransactionUID id, boolean removeAcks, boolean sync) throws BrokerException {
        if (id == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.removeTransactionInternal(" + id + ", " + removeAcks + ", " + sync + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    if (removeAcks) {
                        this.daoFactory.getConsumerStateDAO().clearTransaction(conn, id);
                    }
                    this.daoFactory.getTransactionDAO().delete(conn, id);
                    conn.commit();
                    return;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        try {
                            retry.assertShouldRetry(e, conn);
                        }
                        catch (RetrySQLRecoverableException ee) {
                            try {
                                Util.close(null, null, conn, ee);
                                conn = this.dbmgr.getConnection(false);
                            }
                            catch (Exception eee) {
                                logger.logStack(16, eee.getMessage(), eee);
                                conn = null;
                                if (e instanceof BrokerException) {
                                    throw (BrokerException)e;
                                }
                                throw new BrokerException(e.getMessage(), e);
                            }
                        }
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionState(TransactionUID id, TransactionState ts, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateTransactionStateInternal(id, ts, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateTransactionStateInternal(TransactionUID id, TransactionState ts, boolean sync) throws BrokerException {
        if (id == null || ts == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateTransactionStateInternal(" + id + ", " + ts + ", " + sync + ")");
        }
        boolean replaycheck = false;
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getTransactionDAO().updateTransactionState(null, id, ts, replaycheck);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                replaycheck = retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionStateWithWork(TransactionUID id, TransactionState ts, TransactionWork txnwork, boolean sync) throws BrokerException {
        if (this.partitionMode) {
            throw new BrokerException("B3044" + " JDBCStore.updateTransactionStateWithWork(): Unexpected call for partition mode");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.updateTransactionStateWithWorkInternal(id, ts, txnwork, this.getStoreSession(), sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateTransactionStateWithWorkInternal(TransactionUID tid, TransactionState ts, TransactionWork txnwork, long storeSessionID, boolean sync) throws BrokerException {
        if (tid == null || ts == null || txnwork == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateTransactionStateInternal(" + tid + ", " + ts + ", " + ", " + txnwork + ", " + sync + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            Util.RetryStrategy retry = null;
            while (true) {
                boolean inside = false;
                try {
                    List<TransactionWorkMessageAck> txnacks;
                    for (TransactionWorkMessage txnmsg : txnwork.getSentMessages()) {
                        Packet m = txnmsg.getMessage();
                        if (m == null) continue;
                        inside = true;
                        this.daoFactory.getMessageDAO().insert(conn, txnmsg.getDestUID(), m, null, null, storeSessionID, m.getTimestamp(), true, false);
                        inside = false;
                    }
                    if (this.FI.FAULT_INJECTION) {
                        try {
                            this.FI.checkFaultAndThrowBrokerException("txn.persist_work.1_5", null);
                        }
                        catch (BrokerException e) {
                            this.FI.unsetFault("txn.persist_work.1_5");
                            throw e;
                        }
                    }
                    if ((txnacks = txnwork.getMessageAcknowledgments()) != null) {
                        for (TransactionWorkMessageAck txnack : txnacks) {
                            TransactionAcknowledgement ta = txnack.getTransactionAcknowledgement();
                            if (ta == null) continue;
                            inside = true;
                            this.daoFactory.getConsumerStateDAO().updateTransaction(conn, ta.getSysMessageID(), ta.getStoredConsumerUID(), tid);
                            inside = false;
                        }
                    }
                    inside = true;
                    this.daoFactory.getTransactionDAO().updateTransactionState(conn, tid, ts, false);
                    inside = false;
                    conn.commit();
                    return;
                }
                catch (Exception e) {
                    try {
                        if (!inside) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException rbe) {
                                logger.logStack(16, "B4080", rbe);
                            }
                        }
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        try {
                            retry.assertShouldRetry(e, conn);
                        }
                        catch (RetrySQLRecoverableException ee) {
                            try {
                                Util.close(null, null, conn, ee);
                                conn = this.dbmgr.getConnection(false);
                            }
                            catch (Exception eee) {
                                logger.logStack(16, eee.getMessage(), eee);
                                conn = null;
                                if (e instanceof BrokerException) {
                                    throw (BrokerException)e;
                                }
                                throw new BrokerException(e.getMessage(), e);
                            }
                        }
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.getAllTransactionStatesInternal(null);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionStatesInternal(Long storeSession) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getAllTransactionStatesInternal(" + storeSession + ")");
        }
        String brokerID = this.dbmgr.getBrokerID();
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionStatesByBroker(null, brokerID, storeSession);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllRemoteTransactionStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.getAllRemoteTransactionStatesInternal(null);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllRemoteTransactionStatesInternal(Long storeSession) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getAllRemoteTransactionStatesInternal(" + storeSession + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getRemoteTransactionStatesByBroker(null, this.dbmgr.getBrokerID(), storeSession);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeTransactionAckInternal(tid, ack, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransactionAckInternal(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (tid == null || ack == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeTransactionAckInternal(" + tid + ", " + ack + ", " + sync + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getConsumerStateDAO().updateTransaction(null, ack.getSysMessageID(), ack.getStoredConsumerUID(), tid);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionAck(TransactionUID tid, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.removeTransactionAckInternal(tid, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransactionAckInternal(TransactionUID tid, boolean sync) throws BrokerException {
        if (tid == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.removeTransactionAckInternal(" + tid + ", " + sync + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getConsumerStateDAO().clearTransaction(null, tid);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.getAllTransactionAcksInternal(null);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public HashMap getAllTransactionAcksInternal(Long storeSession) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getAllTransactionAcksInternal(" + storeSession + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getConsumerStateDAO().getAllTransactionAcks(null);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID id) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.getTransactionAcksInternal(id);
            return transactionAcknowledgementArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionAcknowledgement[] getTransactionAcksInternal(TransactionUID id) throws BrokerException {
        if (id == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.getTransactionAcksInternal(" + id + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getConsumerStateDAO().getTransactionAcks(null, id).toArray(new TransactionAcknowledgement[0]);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    public void storeTransaction(TransactionUID tid, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        this.storeTransaction(tid, txnInfo, this.getStoreSession());
    }

    protected void storeTransaction(TransactionUID tid, TransactionInfo txnInfo, long storeSessionID) throws BrokerException {
        if (tid == null || txnInfo == null) {
            throw new NullPointerException();
        }
        int type = 0;
        BrokerAddress txnHomeBroker = null;
        TransactionBroker[] txnBrokers = null;
        if (txnInfo.isCluster()) {
            type = 2;
            txnBrokers = txnInfo.getTransactionBrokers();
        } else if (txnInfo.isRemote()) {
            type = 3;
            txnHomeBroker = txnInfo.getTransactionHomeBroker();
        } else if (txnInfo.isLocal()) {
            type = 1;
        } else {
            String errorMsg = "Illegal transaction type: " + txnInfo.getType();
            logger.log(32, "B3100", errorMsg);
            throw new BrokerException(br.getKString("B3100", errorMsg));
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, tid, txnInfo.getTransactionState(), txnHomeBroker, txnBrokers, type, storeSessionID);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClusterTransaction(TransactionUID tid, TransactionState ts, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeClusterTransactionInternal(tid, ts, txnBrokers, sync, this.getStoreSession());
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeClusterTransactionInternal(TransactionUID tid, TransactionState ts, TransactionBroker[] txnBrokers, boolean sync, long storeSession) throws BrokerException {
        if (tid == null || ts == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeClusterTransactionInternal(" + tid + ", " + ts + ", " + txnBrokers + ", " + sync + ", " + storeSession + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getTransactionDAO().insert(null, tid, ts, null, txnBrokers, 2, storeSession);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransaction(TransactionUID tid, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateClusterTransactionInternal(tid, txnBrokers, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateClusterTransactionInternal(TransactionUID tid, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (tid == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateClusterTransactionInternal(" + tid + ", " + txnBrokers + ", " + sync + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getTransactionDAO().updateTransactionBrokers(null, tid, txnBrokers);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID tid, int expectedTxnState, TransactionBroker txnBroker, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateClusterTransactionBrokerStateInternal(tid, expectedTxnState, txnBroker, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateClusterTransactionBrokerStateInternal(TransactionUID tid, int expectedTxnState, TransactionBroker txnBroker, boolean sync) throws BrokerException {
        if (tid == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateClusterTransactionBrokerStateInternal(" + tid + ", " + expectedTxnState + ", " + txnBroker + ", " + sync + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                this.daoFactory.getTransactionDAO().updateTransactionBrokerState(null, tid, expectedTxnState, txnBroker);
                return;
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRemoteTransaction(TransactionUID tid, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.updateRemoteTransactionInternal(tid, txnAcks, txnHomeBroker, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateRemoteTransactionInternal(TransactionUID tid, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        if (tid == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.updateRemoteTransactionInternal(" + tid + ", " + txnAcks + ", " + txnHomeBroker + ", " + sync + ")");
        }
        if (!Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in non-HA mode");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    if (txnAcks != null && txnAcks.length > 0) {
                        for (TransactionAcknowledgement ack : txnAcks) {
                            if (!ack.shouldStore()) continue;
                            this.daoFactory.getConsumerStateDAO().updateTransaction(conn, ack.getSysMessageID(), ack.getStoredConsumerUID(), tid);
                        }
                    }
                    this.daoFactory.getTransactionDAO().updateTransactionHomeBroker(conn, tid, txnHomeBroker);
                    conn.commit();
                    return;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRemoteTransaction(TransactionUID tid, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            this.storeRemoteTransactionInternal(tid, ts, txnAcks, txnHomeBroker, sync, this.getStoreSession());
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeRemoteTransactionInternal(TransactionUID tid, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync, long storeSession) throws BrokerException {
        if (tid == null) {
            throw new NullPointerException();
        }
        if (Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in HA mode");
        }
        if (DEBUG) {
            logger.log(8, "JDBCStore.storeRemoteTransactionInternal(" + tid + ", " + ts + ", " + txnAcks + ", " + txnHomeBroker + ", " + sync + ")");
        }
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(conn, tid, ts, txnHomeBroker, null, 3, storeSession);
                    if (txnAcks != null && txnAcks.length > 0) {
                        for (TransactionAcknowledgement ack : txnAcks) {
                            if (!ack.shouldStore()) continue;
                            this.daoFactory.getConsumerStateDAO().updateTransaction(conn, ack.getSysMessageID(), ack.getStoredConsumerUID(), tid);
                        }
                    }
                    conn.commit();
                    return;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (BrokerException e2) {
                        myex = e2;
                        throw e2;
                    }
                }
                break;
            }
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    @Override
    public void updateProperty(String name, Object value, boolean sync) throws BrokerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.updateProperty() called with name: " + name);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getPropertyDAO().update(null, name, value);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Object getProperty(String name) throws BrokerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getProperty() called with name: " + name);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Object object = this.daoFactory.getPropertyDAO().getProperty(null, name);
                    return object;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    String[] stringArray = this.daoFactory.getPropertyDAO().getPropertyNames(null).toArray(new String[0]);
                    return stringArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Properties properties = this.daoFactory.getPropertyDAO().getProperties(null);
                    return properties;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeConfigChangeRecord(long createdTime, byte[] recordData, boolean sync) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeConfigChangeRecord() called");
        }
        if (createdTime <= 0L) {
            String ts = String.valueOf(createdTime);
            logger.log(32, "B3074", ts);
            throw new BrokerException(br.getKString("B3074", ts));
        }
        if (recordData == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().insert(null, recordData, createdTime);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timeStamp) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    ArrayList arrayList = (ArrayList)this.daoFactory.getConfigRecordDAO().getRecordsSince(null, timeStamp);
                    return arrayList;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List<ChangeRecordInfo> list = this.daoFactory.getConfigRecordDAO().getAllRecords(null);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void clearAllConfigChangeRecords(boolean sync) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().deleteAll(null);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll(boolean sync) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        Connection conn = null;
        Exception myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    if (Globals.getHAEnabled()) {
                        this.daoFactory.getTransactionDAO().deleteAll(conn);
                        this.daoFactory.getDestinationDAO().deleteAll(conn);
                        this.daoFactory.getConsumerStateDAO().deleteAll(conn);
                        this.daoFactory.getMessageDAO().deleteAll(conn);
                        this.daoFactory.getTMLogRecordDAOJMSBG().deleteAll(conn);
                        this.daoFactory.getJMSBGDAO().deleteAll(conn);
                    } else {
                        List daos = this.daoFactory.getAllDAOs();
                        for (BaseDAO dao : daos) {
                            if (dao instanceof VersionDAO || dao instanceof BrokerDAO || dao instanceof StoreSessionDAO) continue;
                            dao.deleteAll(conn);
                        }
                    }
                    conn.commit();
                    return;
                }
                catch (Exception e) {
                    try {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    catch (Exception e2) {
                        myex = e2;
                        throw new BrokerException(br.getKString("B4081"), e2);
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, conn, myex);
            }
            finally {
                this.setInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean cleanup) {
        this.setClosedAndWait();
        if (this.partitionMode) {
            PartitionedStore pstore2 = null;
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                for (PartitionedStore pstore2 : this.partitionStores.values()) {
                    pstore2.close();
                }
            }
        }
        this.closeDB(true);
        this.dbmgr.setStoreInited(false);
        if (DEBUG) {
            logger.log(8, "JDBCStore.close(" + cleanup + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeWaitOnClose() {
        Iterator<Enumeration> itr = null;
        List<Enumeration> list = this.dataEnums;
        synchronized (list) {
            itr = this.dataEnums.iterator();
            Enumeration en = null;
            while (itr.hasNext()) {
                en = itr.next();
                if (!(en instanceof MessageEnumeration)) continue;
                ((MessageEnumeration)en).cancel();
            }
        }
        if (this.dbmgr != null) {
            this.dbmgr.setIsClosing();
        }
    }

    @Override
    public long getBrokerHeartbeat(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getBrokerDAO().getHeartbeat(null, brokerID);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllHeartbeats(null);
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Long updateBrokerHeartbeat(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Long l = this.daoFactory.getBrokerDAO().updateHeartbeat(null, brokerID);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr, 2000L, 4, true);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Long updateBrokerHeartbeat(String brokerID, long lastHeartbeat) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Long l = this.daoFactory.getBrokerDAO().updateHeartbeat(null, brokerID, lastHeartbeat);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr, 2000L, 4, false, true);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void addBrokerInfo(String brokerID, String URL2, BrokerState state, int version, long sessionID, long heartbeat) throws BrokerException {
        this.checkClosedAndSetInProgress();
        ArrayList<UID> additionalSessions = null;
        if (this.partitionMode) {
            additionalSessions = new ArrayList<UID>();
            for (int i = 0; i < this.initialNumPartitions - 1; ++i) {
                additionalSessions.add(new UID());
            }
        }
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, brokerID, null, URL2, version, state.intValue(), sessionID, heartbeat, additionalSessions);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void addBrokerInfo(HABrokerInfo bkrInfo, boolean sync) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, bkrInfo.getId(), bkrInfo.getTakeoverBrokerID(), bkrInfo.getUrl(), bkrInfo.getVersion(), bkrInfo.getState(), null, bkrInfo.getHeartbeat(), null);
                    List sessions = bkrInfo.getAllSessions();
                    if (sessions != null && !sessions.isEmpty()) {
                        StoreSessionDAO dao = this.daoFactory.getStoreSessionDAO();
                        for (HABrokerInfo.StoreSession ses : sessions) {
                            dao.insert(null, ses.getBrokerID(), ses.getID(), ses.getIsCurrent(), ses.getCreatedBy(), ses.getCreatedTS());
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public UID updateBrokerInfo(String brokerID, int updateType, Object oldValue, Object newValue) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    UID uID = this.daoFactory.getBrokerDAO().update(null, brokerID, updateType, oldValue, newValue);
                    return uID;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HABrokerInfo getBrokerInfo(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().getBrokerInfo(null, brokerID);
                    return hABrokerInfo;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllBrokerInfos(boolean loadSession) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfos(null, loadSession);
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllBrokerInfoByState(BrokerState state) throws BrokerException {
        if (state == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    HashMap hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfosByState(null, state);
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreSessionOwner(long sessionID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    String string = this.daoFactory.getStoreSessionDAO().getStoreSessionOwner(null, sessionID);
                    return string;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public boolean ifOwnStoreSession(long sessionID, String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getStoreSessionDAO().ifOwnStoreSession(null, sessionID, brokerID);
                    return bl;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreSessionCreator(long sessionID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    String string = this.daoFactory.getStoreSessionDAO().getStoreSessionCreator(null, sessionID);
                    return string;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public boolean updateBrokerState(String brokerID, BrokerState newState, BrokerState expectedState, boolean local) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    boolean bl = this.daoFactory.getBrokerDAO().updateState(null, brokerID, newState, expectedState, local);
                    return bl;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr, 2000L, 5, false, true);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public BrokerState getBrokerState(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    BrokerState brokerState = this.daoFactory.getBrokerDAO().getState(null, brokerID);
                    return brokerState;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(this.dbmgr, 2000L, 5, true);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Object[] getAllBrokerStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    Object[] objectArray = this.daoFactory.getBrokerDAO().getAllStates(null);
                    return objectArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void getTakeOverLock(String brokerID, String targetBrokerID, long lastHeartbeat, BrokerState expectedState, long newHeartbeat, BrokerState newState, boolean force, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TakeoverStoreInfo takeOverBrokerStore(String brokerID, String targetBrokerID, TakingoverTracker tracker) throws BrokerException {
        this.checkClosedAndSetInProgress();
        tracker.setStage_BEFORE_TAKE_STORE();
        this.partitionLock.lock();
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(false);
            BrokerDAO brokerDAO = this.daoFactory.getBrokerDAO();
            HABrokerInfo bkrInfo = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    bkrInfo = brokerDAO.getBrokerInfo(conn, targetBrokerID);
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
            if (bkrInfo == null) {
                String errorMsg = br.getKString("B3169", targetBrokerID);
                logger.log(32, "B3100", errorMsg);
                throw new BrokerException(br.getKString("B3100", errorMsg));
            }
            TakeoverStoreInfo takeoverInfo = null;
            HashMap hashMap = this.takeoverLockMap;
            synchronized (hashMap) {
                takeoverInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(targetBrokerID);
            }
            if (takeoverInfo == null || !brokerID.equals(bkrInfo.getTakeoverBrokerID())) {
                logger.log(32, "B3173", targetBrokerID);
                throw new BrokerException(br.getKString("B3173", targetBrokerID));
            }
            tracker.setStoreSession(bkrInfo.getSessionID());
            retry = null;
            while (true) {
                try {
                    DestinationDAO dstDAO = this.daoFactory.getDestinationDAO();
                    List dstList = dstDAO.getAllLocalDestinations(conn, targetBrokerID);
                    takeoverInfo.setDestinationList(dstList);
                    Object[] args = new String[]{String.valueOf(dstList.size()), targetBrokerID, dstList.toString()};
                    logger.log(8, br.getString("B1291", args));
                    MessageDAO msgDAO = this.daoFactory.getMessageDAO();
                    Map msgMap = msgDAO.getMsgIDsAndDstIDsByBroker(conn, targetBrokerID);
                    takeoverInfo.setMessageMap(msgMap);
                    logger.log(8, br.getString("B1292", msgMap.size(), targetBrokerID));
                    TransactionDAO txnDAO = this.daoFactory.getTransactionDAO();
                    List txnList = txnDAO.getTransactionsByBroker(conn, targetBrokerID);
                    takeoverInfo.setTransactionList(txnList);
                    logger.log(8, br.getString("B1293", txnList.size(), targetBrokerID));
                    List remoteTxnList = txnDAO.getRemoteTransactionsByBroker(conn, targetBrokerID);
                    takeoverInfo.setRemoteTransactionList(remoteTxnList);
                    logger.log(8, br.getString("B1294", remoteTxnList.size(), targetBrokerID));
                    tracker.setStage_BEFORE_DB_SWITCH_OWNER();
                    StoreSessionDAO sesDAO = this.daoFactory.getStoreSessionDAO();
                    List<Long> sesList = sesDAO.takeover(conn, brokerID, targetBrokerID);
                    takeoverInfo.setTakeoverStoreSessionList(sesList);
                    Object[] args2 = new String[]{String.valueOf(sesList.size()), targetBrokerID, sesList.toString()};
                    logger.log(8, br.getString("B1295", args2));
                    if (!brokerDAO.updateState(conn, targetBrokerID, BrokerState.FAILOVER_COMPLETE, BrokerState.FAILOVER_STARTED, false)) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException rbe) {
                            logger.logStack(32, "B4080", rbe);
                        }
                        throw new BrokerException("Unable to update state to " + BrokerState.FAILOVER_COMPLETE + " for broker " + targetBrokerID);
                    }
                    conn.commit();
                    tracker.setStage_AFTER_DB_SWITCH_OWNER();
                    Object object = this.takeoverLockMap;
                    synchronized (object) {
                        this.takeoverLockMap.remove(targetBrokerID);
                    }
                    tracker.setStage_AFTER_TAKE_STORE();
                    if (this.partitionMode) {
                        this.addPartitionStores(sesList);
                    }
                    object = takeoverInfo;
                    return object;
                }
                catch (Exception e) {
                    try {
                        try {
                            if (retry == null) {
                                retry = new Util.RetryStrategy();
                            }
                            retry.assertShouldRetry(e);
                            continue;
                        }
                        catch (Throwable thr) {
                            logger.logToAll(8, "B1169", targetBrokerID);
                            HABrokerInfo savedInfo = takeoverInfo.getSavedBrokerInfo();
                            try {
                                retry = null;
                                while (true) {
                                    try {
                                        brokerDAO.update(conn, targetBrokerID, 3, brokerID, savedInfo);
                                        brokerDAO.update(conn, targetBrokerID, 4, brokerID, savedInfo);
                                        logger.log(8, br.getKString("B1334", targetBrokerID, BrokerState.getState(savedInfo.getState()).toString() + "[StoreSession:" + savedInfo.getSessionID() + "]"));
                                        conn.commit();
                                        HashMap args = this.takeoverLockMap;
                                        synchronized (args) {
                                            this.takeoverLockMap.remove(targetBrokerID);
                                        }
                                    }
                                    catch (Exception e2) {
                                        if (retry == null) {
                                            retry = new Util.RetryStrategy();
                                        }
                                        retry.assertShouldRetry(e2);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e3) {
                                logger.logStack(32, "B3171", targetBrokerID, (Throwable)e3);
                            }
                            throw new BrokerException(br.getKString("B3172", targetBrokerID), thr);
                        }
                    }
                    catch (BrokerException e4) {
                        myex = e4;
                        throw e4;
                    }
                }
                break;
            }
        }
        finally {
            try {
                Util.close(null, null, conn, myex);
            }
            finally {
                this.partitionLock.unlock();
                this.setInProgress(false);
            }
        }
    }

    public void updateTransactionAccessedTime(TransactionUID txnID, long accessedTime) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateAccessedTime(null, txnID, accessedTime);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionState getTransactionState(TransactionUID txnID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.getTransactionStateInternal(txnID);
            return transactionState;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionState getTransactionStateInternal(TransactionUID txnID) throws BrokerException {
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionState(null, txnID);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID tid) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.getRemoteTransactionHomeBrokerInternal(tid);
            return brokerAddress;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public BrokerAddress getRemoteTransactionHomeBrokerInternal(TransactionUID tid) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getRemoteTransactionHomeBrokerInternal(" + tid + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionHomeBroker(null, tid);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID tid) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.getClusterTransactionBrokersInternal(tid);
            return transactionBrokerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionBroker[] getClusterTransactionBrokersInternal(TransactionUID tid) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getClusterTransactionBrokersInternal(" + tid + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionBrokers(null, tid);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    public long getTransactionAccessedTime(TransactionUID txnID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getTransactionDAO().getAccessedTime(null, txnID);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInfo getTransactionInfo(TransactionUID txnID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.getTransactionInfoInternal(txnID);
            return transactionInfo;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public TransactionInfo getTransactionInfoInternal(TransactionUID txnID) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getTransactionInfoInternal(" + txnID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionInfo(null, txnID);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    protected Collection getTransactions(String brokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List list = this.daoFactory.getTransactionDAO().getTransactionsByBroker(null, brokerID);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getTransactionUsageInfo(TransactionUID txnID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            int[] nArray = this.getTransactionUsageInfoInternal(txnID);
            return nArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int[] getTransactionUsageInfoInternal(TransactionUID txnID) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getTransactionUsageInfoInternal(" + txnID + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getTransactionDAO().getTransactionUsageInfo(null, txnID);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            long l = this.getDestinationConnectedTimeInternal(destination);
            return l;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public long getDestinationConnectedTimeInternal(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "JDBCStore.getDestinationConnectedTimeInternal(" + destination.getUniqueName() + ")");
        }
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getDestinationDAO().getDestinationConnectedTime(null, destination.getUniqueName());
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID dst, SysMessageID mID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            boolean bl = this.hasMessageBeenAckedInternal(dst, mID);
            return bl;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public boolean hasMessageBeenAckedInternal(DestinationUID dst, SysMessageID mID) throws BrokerException {
        Util.RetryStrategy retry = null;
        while (true) {
            try {
                return this.daoFactory.getMessageDAO().hasMessageBeenAcked(null, dst, mID);
            }
            catch (Exception e) {
                if (retry == null) {
                    retry = new Util.RetryStrategy();
                }
                retry.assertShouldRetry(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDB(boolean unlock) {
        Connection conn = null;
        Exception myex = null;
        try {
            if (unlock) {
                conn = this.dbmgr.getConnection(true);
                if (!Globals.getHAEnabled() && config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                    this.dbmgr.lockTables(conn, false);
                }
            }
        }
        catch (Exception e) {
            myex = e;
            logger.log(16, "B4103", e);
        }
        finally {
            try {
                Util.close(null, null, conn, myex);
            }
            catch (Exception e) {}
        }
        this.dbmgr.close();
    }

    @Override
    public String getStoreType() {
        return "jdbc";
    }

    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    @Override
    public Hashtable getDebugState() throws BrokerException {
        String url = this.dbmgr.getOpenDBURL();
        String bid = "(" + this.dbmgr.getBrokerID() + ")";
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        t.put("JDBC-based store", url + bid);
        t.put("Store version", String.valueOf(410));
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Iterator itr = this.daoFactory.getAllDAOs().iterator();
            while (itr.hasNext()) {
                t.putAll(((BaseDAO)itr.next()).getDebugInfo(conn));
            }
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
        t.put(this.dbmgr.toString(), this.dbmgr.getDebugState());
        return t;
    }

    @Override
    public boolean isHADBStore() {
        if (this.dbmgr != null) {
            return this.dbmgr.isHADB();
        }
        return false;
    }

    @Override
    public void resetConnectionPool() throws BrokerException {
        if (this.dbmgr != null) {
            this.dbmgr.resetConnectionPool();
        }
        throw new BrokerException("JDBCStore not inited !");
    }

    public void compactDestination(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    private boolean checkStore(Connection conn) throws BrokerException {
        boolean status = true;
        int oldStoreVersion = -1;
        if (this.checkOldStoreVersion(conn, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
            oldStoreVersion = 400;
        } else if (this.checkOldStoreVersion(conn, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
            oldStoreVersion = 370;
        } else if (this.checkOldStoreVersion(conn, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
            oldStoreVersion = 350;
        }
        boolean foundNewStore = false;
        int storeVersion = 0;
        try {
            storeVersion = this.daoFactory.getVersionDAO().getStoreVersion(conn);
        }
        catch (BrokerException e) {
            logger.log(16, e.getMessage(), e.getCause());
        }
        if (storeVersion > 0) {
            boolean bl = foundNewStore = storeVersion == 410;
            if (foundNewStore) {
                DBTool.updateStoreVersion410IfNecessary(conn, this.dbmgr);
                if (this.dbmgr.checkStoreExists(conn) == -1) {
                    logger.log(32, "B3213");
                    throw new BrokerException(br.getKString("B3213"));
                }
            } else {
                String found = String.valueOf(storeVersion);
                String expected = String.valueOf(410);
                logger.log(32, "B3092", (Object)found, expected);
                throw new BrokerException(br.getKString("B3092", found, expected));
            }
            if (oldStoreVersion > 0 && !this.removeStore) {
                logger.logToAll(8, "B1111");
            }
        }
        if (foundNewStore) {
            if (this.removeStore) {
                try {
                    DBTool.dropTables(conn, false, this.dbmgr);
                }
                catch (SQLException e) {
                    throw new BrokerException(br.getKString("B3121", this.dbmgr.getOpenDBURL()), e);
                }
                status = false;
            } else if (this.resetStore) {
                this.clearAll(true);
            }
        } else {
            boolean createNew = false;
            if (this.createStore) {
                createNew = true;
            }
            boolean dropOld = false;
            String dropMsg = null;
            if (oldStoreVersion > 0) {
                if (this.removeStore) {
                    dropOld = true;
                    dropMsg = "B1112";
                } else if (this.resetStore) {
                    createNew = true;
                    dropOld = true;
                    dropMsg = "B1113";
                } else {
                    logger.logToAll(8, "B1109", new Integer(oldStoreVersion));
                    if (this.upgradeNoBackup && !Broker.getBroker().force) {
                        this.getConfirmation();
                    }
                    if (!Globals.getHAEnabled()) {
                        new UpgradeStore(this, oldStoreVersion).upgradeStore(conn);
                        return status;
                    }
                }
            }
            if (!createNew) {
                logger.log(32, "B3132");
                throw new BrokerException(br.getKString("B3132"));
            }
            if (dropOld) {
                logger.logToAll(8, dropMsg);
                try {
                    DBTool.dropTables(conn, this.dbmgr.getTableNames(oldStoreVersion), false, false, this.dbmgr);
                }
                catch (Exception e) {
                    logger.logToAll(32, "B3133", e);
                    throw new BrokerException(br.getKString("B3133"), e);
                }
            }
            if (createNew) {
                logger.logToAll(8, "B1114");
                try {
                    DBTool.createTables(conn);
                }
                catch (Exception e) {
                    String url = this.dbmgr.getCreateDBURL();
                    if (url == null || url.length() == 0) {
                        url = this.dbmgr.getOpenDBURL();
                    }
                    String msg = br.getKString("B3073", url);
                    logger.logToAll(32, msg + ": " + e);
                    logger.logStack(32, msg, e);
                    throw new BrokerException(msg, e);
                }
            }
        }
        return status;
    }

    private long getStoreSession() throws BrokerException {
        if (Globals.getHAEnabled()) {
            return Globals.getStoreSession().longValue();
        }
        StoreSessionDAO sessionDAO = this.daoFactory.getStoreSessionDAO();
        return sessionDAO.getStoreSession(null, this.dbmgr.getBrokerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkOldStoreVersion(Connection conn, String vTable, String vColumn, int version) throws BrokerException {
        try {
            selectSQL = "SELECT " + vColumn + " FROM " + vTable;
            stmt = null;
            rs = null;
            myex = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(selectSQL);
                if (!rs.next()) ** GOTO lbl19
                storeVersion = rs.getInt(1);
                if (storeVersion == version) {
                    var10_12 = true;
                    return var10_12;
                }
                found = String.valueOf(storeVersion);
                expected = String.valueOf(version);
                JDBCStore.logger.log(32, "B3125", (Object)found, expected);
                throw new BrokerException(JDBCStore.br.getKString("B3125", found, expected));
lbl19:
                // 1 sources

                JDBCStore.logger.log(32, "B3131", vTable);
                throw new BrokerException(JDBCStore.br.getKString("B3131", vTable));
            }
            catch (SQLException e) {
                myex = e;
                JDBCStore.logger.log(4, "Assume old store does not exist because : " + e.getMessage());
                return false;
            }
            finally {
                Util.close(rs, stmt, null, myex);
            }
        }
        catch (Exception e) {
            JDBCStore.logger.log(32, "B4114", e);
            throw new BrokerException(JDBCStore.br.getKString("B4114"), e);
        }
    }

    boolean resetMessage() {
        return this.resetMessage;
    }

    boolean resetInterest() {
        return this.resetInterest;
    }

    @Override
    public void storeTMLogRecord(String xid, byte[] logRecord, String name, boolean sync, java.util.logging.Logger logger_) throws DupKeyException, Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (logRecord == null) {
            throw new IllegalArgumentException("null logRecord");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeTMLogRecord(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.storeTMLogRecord(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().insert(null, xid, logRecord, name, logger_);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateTMLogRecord(String xid, byte[] logRecord, UpdateOpaqueDataCallback callback, String name, boolean addIfNotExist, boolean sync, java.util.logging.Logger logger_) throws Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (logRecord == null) {
            throw new IllegalArgumentException("null logRecord");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (callback == null) {
            throw new IllegalArgumentException("null callback");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateTMLogRecord(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.updateTMLogRecord(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().updateLogRecord(null, xid, logRecord, name, callback, addIfNotExist, logger_);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeTMLogRecord(String xid, String name, boolean sync, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeTMLogRecord(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.removeTMLogRecord(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().delete(null, xid, name, logger_);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public byte[] getTMLogRecord(String xid, String name, java.util.logging.Logger logger_) throws Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTMLogRecord(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getTMLogRecord(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    byte[] byArray = this.daoFactory.getTMLogRecordDAOJMSBG().getLogRecord(null, xid, name, logger_);
                    return byArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public long getTMLogRecordUpdatedTime(String xid, String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTMLogRecordUpdatedTime(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getTMLogRecordUpdatedTime(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getTMLogRecordDAOJMSBG().getUpdatedTime(null, xid, name, logger_);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public long getTMLogRecordCreatedTime(String xid, String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTMLogRecordCreatedTime(" + xid + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getTMLogRecordcreatedTime(" + xid + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getTMLogRecordDAOJMSBG().getCreatedTime(null, xid, name, logger_);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List getTMLogRecordsByName(String name, java.util.logging.Logger logger_) throws Exception {
        return this.getLogRecordsByNameByBroker(name, this.dbmgr.getBrokerID(), logger_);
    }

    public List getLogRecordsByNameByBroker(String name, String brokerID, java.util.logging.Logger logger_) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTMLogRecordsByNameByBroker(" + name + ", " + brokerID + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getTMLogRecordsByNameByBroker(" + name + ", " + brokerID + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List list = this.daoFactory.getTMLogRecordDAOJMSBG().getLogRecordsByNameByBroker(null, name, brokerID, logger_);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List getNamesByBroker(String brokerID, java.util.logging.Logger logger_) throws Exception {
        if (brokerID == null) {
            throw new IllegalArgumentException("null brokerID");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTMNamesByBroker(" + brokerID + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getTMNamesByBroker(" + brokerID + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List list = this.daoFactory.getTMLogRecordDAOJMSBG().getNamesByBroker(null, brokerID, logger_);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void addJMSBridge(String name, boolean sync, java.util.logging.Logger logger_) throws DupKeyException, Exception {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.addJMSBridge(" + name + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.addJMSBridge(" + name + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getJMSBGDAO().insert(null, name, logger_);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List getJMSBridges(java.util.logging.Logger logger_) throws Exception {
        return this.getJMSBridgesByBroker(this.dbmgr.getBrokerID(), logger_);
    }

    @Override
    public List getJMSBridgesByBroker(String brokerID, java.util.logging.Logger logger_) throws Exception {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getJMSBridgesByBroker(" + brokerID + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getJMSBridges(" + brokerID + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    List list = this.daoFactory.getJMSBGDAO().getNamesByBroker(null, brokerID, logger_);
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public long getJMSBridgeUpdatedTime(String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getJMSBridgeUpdatedTime(" + name + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getJMSBridgeUpdatedTime(" + name + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getJMSBGDAO().getUpdatedTime(null, name, logger_);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public long getJMSBridgeCreatedTime(String name, java.util.logging.Logger logger_) throws KeyNotFoundException, Exception {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getJMSbridgeCreatedTime(" + name + ")");
            Util.logExt(logger_, Level.FINE, "JDBCStore.getJMSBridgeCreatedTime(" + name + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    long l = this.daoFactory.getJMSBGDAO().getCreatedTime(null, name, logger_);
                    return l;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void closeJMSBridgeStore() throws Exception {
    }

    @Override
    public LoadException getLoadDestinationException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return null;
    }

    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync) throws IOException, BrokerException {
        this.removeMessage(dID, mID, sync, false);
    }

    @Override
    public void init(Store store, UID id, boolean isPrimrary) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by JDBCStore class");
    }

    @Override
    public boolean getPartitionModeEnabled() {
        return this.partitionMode;
    }

    @Override
    public boolean isPartitionMigratable() {
        return this.partitionMigratable;
    }

    public String toString() {
        return "[" + this.getStoreType() + "]";
    }

    public int hashCode() {
        return this.partitionid.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof PartitionedStore)) {
            return false;
        }
        return this.getPartitionID().equals(((PartitionedStore)anObject).getPartitionID());
    }

    @Override
    public UID getPartitionID() {
        return this.partitionid;
    }

    @Override
    public boolean isPrimaryPartition() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionsReady() throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            this.partitionsReady = true;
        }
        this.initPartitionStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionedStore> getAllStorePartitions() throws BrokerException {
        LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
        synchronized (linkedHashMap) {
            return new ArrayList<PartitionedStore>(this.partitionStores.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionedStore getStorePartition(UID id) throws BrokerException {
        PartitionedStore ps = null;
        this.checkClosedAndSetInProgress();
        try {
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                ps = this.partitionStores.get(id);
            }
            if (ps == null) {
                throw new BrokerException(br.getKString("B4399", id), 404);
            }
        }
        finally {
            this.setInProgress(false);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionDeparture(UID partitionID, String targetBrokerID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            if (!this.partitionMode) {
                throw new BrokerException("Broker store not partition mode", 412);
            }
            if (!this.partitionMigratable) {
                throw new BrokerException("Broker store partition not migratable", 412);
            }
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.closedLock;
            synchronized (linkedHashMap) {
                if (!this.partitionsReady) {
                    throw new BrokerException("Store partitions init not ready yet", 412);
                }
            }
            linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                PartitionedStore pstore = (PartitionedStore)this.partitionStores.remove(partitionID);
                if (pstore == null) {
                    String emsg = "Departure partition " + partitionID + " does not exist in this broker";
                    throw new BrokerException(emsg, 404);
                }
                this.notifyPartitionRemoved(partitionID, targetBrokerID);
                if (!pstore.isClosed()) {
                    throw new BrokerException("Departure partition " + partitionID + " not closed");
                }
            }
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    this.daoFactory.getStoreSessionDAO().moveStoreSession(null, partitionID.longValue(), targetBrokerID);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public List<PartitionedStore> partitionArrived(UID partitionID) throws BrokerException {
        PartitionedStore pstore = null;
        this.checkClosedAndSetInProgress();
        boolean locked = false;
        try {
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.closedLock;
            // MONITORENTER : linkedHashMap
            if (!this.partitionsReady) {
                throw new BrokerException("Store partitions init not ready yet", 412);
            }
            // MONITOREXIT : linkedHashMap
            if (!this.partitionMode) {
                throw new BrokerException("Broker store not partition mode", 405);
            }
            if (partitionID != null) {
                linkedHashMap = this.partitionStores;
                // MONITORENTER : linkedHashMap
                pstore = this.partitionStores.get(partitionID);
                if (pstore != null) {
                    logger.log(8, "Arrived partition " + partitionID + " has already been loaded in store");
                    ArrayList<PartitionedStore> p = new ArrayList<PartitionedStore>();
                    p.add(pstore);
                    ArrayList<PartitionedStore> arrayList = p;
                    // MONITOREXIT : linkedHashMap
                    return arrayList;
                }
                // MONITOREXIT : linkedHashMap
            }
            Util.RetryStrategy retry = null;
            while (true) {
                block26: {
                    try {
                        if (partitionID != null) {
                            String brokerID = this.daoFactory.getStoreSessionDAO().getStoreSessionOwner(null, partitionID.longValue());
                            if (brokerID != null && brokerID.equals(this.dbmgr.getBrokerID())) {
                                ArrayList<Long> l = new ArrayList<Long>();
                                l.add(partitionID.longValue());
                                List<PartitionedStore> list = this.addPartitionStores(l);
                                return list;
                            }
                            String emsg = br.getKString("B4397", partitionID);
                            throw new BrokerException(emsg, 405);
                        }
                        if (this.partitionLock.tryLock()) break block26;
                    }
                    catch (Exception e) {
                        if (retry == null) {
                            retry = new Util.RetryStrategy();
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    throw new BrokerException("Broker takeover in process, retry operation later", 449);
                }
                locked = true;
                List<Long> sessions = this.dbmgr.getDAOFactory().getStoreSessionDAO().getStoreSessionsByBroker(null, this.dbmgr.getBrokerID());
                ArrayList<Long> l = new ArrayList<Long>();
                Object object = this.partitionStores;
                // MONITORENTER : object
                Iterator<Long> itr = sessions.iterator();
                while (true) {
                    if (!itr.hasNext()) {
                        // MONITOREXIT : object
                        object = this.addPartitionStores(l);
                        return object;
                    }
                    Long s = itr.next();
                    if (this.partitionStores.get(new UID(s)) != null) continue;
                    l.add(s);
                }
                break;
            }
        }
        finally {
            if (locked) {
                this.partitionLock.unlock();
            }
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PartitionedStore> addPartitionStores(List<Long> storeSessions) throws BrokerException {
        ArrayList<PartitionedStore> loaded = new ArrayList<PartitionedStore>();
        UID uid = null;
        PartitionedStore ps = null;
        try {
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                Iterator<Long> itr = storeSessions.iterator();
                while (itr.hasNext()) {
                    uid = new UID(itr.next());
                    if (this.partitionStores.get(uid) != null) {
                        throw new BrokerException(br.getKString("B4398", uid));
                    }
                    logger.log(8, br.getKString("B1448", uid));
                    ps = Globals.isNucleusManagedBroker() ? (PartitionedStore)Globals.getHabitat().getService(PartitionedStore.class, partitionClassStr, new Annotation[0]) : (PartitionedStore)this.partitionClass.newInstance();
                    ps.init(this, uid, uid.longValue() == this.getStoreSession());
                    this.partitionStores.put(uid, ps);
                    loaded.add(ps);
                    this.notifyPartitionAdded(uid);
                }
            }
            return loaded;
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPartitionStores() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            if (!this.partitionMode) {
                this.partitionStores.put(this.getPartitionID(), this);
                return;
            }
            Object object = this.closedLock;
            synchronized (object) {
                if (!this.partitionsReady) {
                    throw new BrokerException("IllegalState: store partitions not ready");
                }
            }
            List<Long> sessions = new ArrayList<Long>();
            sessions.add(this.getStoreSession());
            this.addPartitionStores(sessions);
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    sessions = this.dbmgr.getDAOFactory().getStoreSessionDAO().getStoreSessionsByBroker(null, this.dbmgr.getBrokerID());
                    logger.log(8, br.getKString("B1449", sessions.size()));
                    sessions.remove(this.getStoreSession());
                    this.addPartitionStores(sessions);
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy();
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionedStore getPrimaryPartition() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            if (!this.partitionMode) {
                JDBCStore jDBCStore = this;
                return jDBCStore;
            }
            if (this.partitionStores.size() == 0) {
                throw new BrokerException("IllegalStateException: partition store not ready");
            }
            PartitionedStore partitionedStore = this.partitionStores.get(new UID(this.getStoreSession()));
            return partitionedStore;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPartitionRemoved(UID partitionID, String removedToBroker) {
        LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
        synchronized (linkedHashMap) {
            Iterator<PartitionListener> itr = this.partitionListeners.iterator();
            while (itr.hasNext()) {
                itr.next().partitionRemoved(partitionID, this, removedToBroker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPartitionAdded(UID partitionID) {
        LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
        synchronized (linkedHashMap) {
            Iterator<PartitionListener> itr = this.partitionListeners.iterator();
            while (itr.hasNext()) {
                itr.next().partitionAdded(partitionID, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionListener(PartitionListener listener) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                this.partitionListeners.add(listener);
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePartitionListener(PartitionListener listener) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            LinkedHashMap<UID, PartitionedStore> linkedHashMap = this.partitionStores;
            synchronized (linkedHashMap) {
                this.partitionListeners.remove(listener);
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStoreSessionReaperListener(StoreSessionReaperListener listener) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            List<StoreSessionReaperListener> list = this.sessionReaperListeners;
            synchronized (list) {
                this.sessionReaperListeners.add(listener);
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStoreSessionReaperListener(StoreSessionReaperListener listener) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            List<StoreSessionReaperListener> list = this.sessionReaperListeners;
            synchronized (list) {
                this.sessionReaperListeners.remove(listener);
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    static class StoreSessionReaperTask
    extends TimerTask {
        private boolean canceled = false;
        Logger logger = Globals.getLogger();
        JDBCStore store = null;

        public StoreSessionReaperTask(JDBCStore store) {
            this.store = store;
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StoreSessionReaperTask storeSessionReaperTask = this;
            synchronized (storeSessionReaperTask) {
                if (this.canceled) {
                    return;
                }
            }
            try {
                List<Long> reaped;
                if (!this.store.partitionMode) {
                    StoreSessionDAO sesDAO = this.store.daoFactory.getStoreSessionDAO();
                    reaped = sesDAO.deleteInactiveStoreSession(null);
                    if (reaped.size() == 0) {
                        this.store.notifyPartitionRemoved(null, null);
                    } else {
                        Iterator<Long> itr = reaped.iterator();
                        while (itr.hasNext()) {
                            this.store.notifyPartitionRemoved(new UID(itr.next()), null);
                        }
                    }
                }
                ArrayList moretasks = null;
                reaped = this.store.sessionReaperListeners;
                synchronized (reaped) {
                    moretasks = new ArrayList(this.store.sessionReaperListeners);
                }
                Iterator itr = moretasks.iterator();
                while (itr.hasNext()) {
                    ((StoreSessionReaperListener)itr.next()).runStoreSessionTask();
                }
            }
            catch (Exception e) {
                this.logger.logStack(32, "B3177", e);
            }
        }
    }
}

