/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketPayload;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacketVariableHeader;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;

public class GrizzlyMQPacket
extends Packet {
    public GrizzlyMQPacket(boolean useDirect) {
        super(useDirect);
    }

    protected static int parsePacketSize(Buffer buf) throws IOException {
        int magic = buf.getInt();
        if (magic != 469754818) {
            throw new StreamCorruptedException("Bad packet magic number: " + magic + ". Expecting: " + 469754818);
        }
        buf.position(buf.position() + 4);
        return buf.getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeReadBufs(Buffer buffer) {
        if (this.version != 103 && this.version != 200 && this.version != 301) {
            this.propertyOffset = 72;
            this.propertySize = 0;
            this.versionMismatch = true;
        }
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        int position = byteBuffer.position();
        int limit = byteBuffer.limit();
        try {
            int newLimit;
            int size = 0;
            this.nBufs = 0;
            size = this.propertyOffset - 72;
            if (size > 0) {
                newLimit = byteBuffer.position() + size;
                byteBuffer.limit(newLimit);
                this.varBuf = byteBuffer.slice();
                Buffers.setPositionLimit((ByteBuffer)byteBuffer, (int)newLimit, (int)limit);
            }
            if ((size = this.propertySize) > 0) {
                newLimit = byteBuffer.position() + size;
                byteBuffer.limit(newLimit);
                this.propBuf = byteBuffer.slice();
                Buffers.setPositionLimit((ByteBuffer)byteBuffer, (int)newLimit, (int)limit);
            }
            if ((size = this.packetSize - this.propertyOffset - this.propertySize) > 0) {
                newLimit = byteBuffer.position() + size;
                byteBuffer.limit(newLimit);
                this.bodyBuf = byteBuffer.slice();
                Buffers.setPositionLimit((ByteBuffer)byteBuffer, (int)newLimit, (int)limit);
            }
        }
        finally {
            int delta = byteBuffer.position() - position;
            Buffers.setPositionLimit((ByteBuffer)byteBuffer, (int)position, (int)limit);
            buffer.position(buffer.position() + delta);
        }
    }

    @Override
    public void reset() {
        this.version = (short)301;
        this.magic = 469754818;
        this.packetType = 0;
        this.packetSize = 0;
        this.expiration = 0L;
        this.propertyOffset = 0;
        this.propertySize = 0;
        this.encryption = 0;
        this.priority = (byte)5;
        this.bitFlags = 0;
        this.consumerID = 0L;
        this.transactionID = 0L;
        this.readInProgress = false;
        this.headerBytesRead = 0;
        this.ropBytesRead = 0;
        this.bufferDirty = false;
        this.sysMessageID.clear();
        if (this.fixedBuf != null) {
            this.fixedBuf.clear();
        } else {
            this.fixedBuf = this.allocateBuffer(72);
        }
        this.varBuf = null;
        this.propBuf = null;
        this.bodyBuf = null;
        if (this.packetVariableHeader != null) {
            ((GrizzlyMQPacketVariableHeader)this.packetVariableHeader).reset();
        } else {
            this.packetVariableHeader = new GrizzlyMQPacketVariableHeader();
        }
        if (this.packetPayload != null) {
            this.packetPayload.reset();
        } else {
            this.packetPayload = new PacketPayload();
        }
    }
}

