/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.net.MalformedURLException;
import java.util.HashMap;

public class MQAddress
extends com.sun.messaging.jmq.io.MQAddress {
    protected static final HashMap handlers = new HashMap();
    private static final String TCP_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";
    private static final String SSL_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLStreamHandler";
    private static final String HTTP_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.http.HTTPStreamHandler";
    private static final String DIRECT_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.direct.DirectStreamHandler";

    protected MQAddress() {
    }

    public static MQAddress createMQAddress(String addr) throws MalformedURLException {
        MQAddress ret = new MQAddress();
        ret.initialize(addr);
        return ret;
    }

    public String getHandlerClass() {
        if (this.isHTTP) {
            return HTTP_HANDLER;
        }
        if (this.schemeName.equalsIgnoreCase("mqtcp")) {
            return TCP_HANDLER;
        }
        if (this.schemeName.equalsIgnoreCase("mqssl")) {
            return SSL_HANDLER;
        }
        if (this.schemeName.equalsIgnoreCase("direct")) {
            return DIRECT_HANDLER;
        }
        String ret = (String)handlers.get(this.serviceName);
        if (Debug.debug) {
            ConnectionImpl.getConnectionLogger().info("Handler class: " + ret);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        MQAddress addr = MQAddress.createMQAddress(args[0]);
        System.out.println("schemeName = " + addr.getSchemeName());
        if (addr.getIsHTTP()) {
            System.out.println("URL = " + addr.getURL());
        } else {
            System.out.println("host = " + addr.getHostName());
            System.out.println("port = " + addr.getPort());
        }
        System.out.println("serviceName = " + addr.getServiceName());
        System.out.println("handlerClass = " + addr.getHandlerClass());
        System.out.println("isFinal = " + addr.isServicePortFinal());
        System.out.println("properties = " + addr.props);
    }

    static {
        handlers.put("jms", TCP_HANDLER);
        handlers.put("ssljms", SSL_HANDLER);
        handlers.put("httpjms", HTTP_HANDLER);
        handlers.put("httpsjms", HTTP_HANDLER);
        handlers.put("admin", TCP_HANDLER);
        handlers.put("ssladmin", SSL_HANDLER);
        handlers.put("httpadmin", HTTP_HANDLER);
        handlers.put("httpsadmin", HTTP_HANDLER);
        handlers.put("direct", DIRECT_HANDLER);
    }
}

