/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.NamedImpl;

public class AliasDescriptor<T>
extends AbstractActiveDescriptor<T> {
    private static final long serialVersionUID = 2609895430798803508L;
    private final ServiceLocator locator;
    private ActiveDescriptor<T> descriptor;
    private final String contract;
    private Set<Annotation> qualifiers;
    private boolean initialized = false;
    private static final Set<Type> EMPTY_CONTRACT_SET = new HashSet<Type>();
    private static final Set<Annotation> EMPTY_ANNOTATION_SET = new HashSet<Annotation>();

    public AliasDescriptor(ServiceLocator locator, ActiveDescriptor<T> descriptor, String contract, String name) {
        super(EMPTY_CONTRACT_SET, null, name, EMPTY_ANNOTATION_SET, descriptor.getDescriptorType(), descriptor.getDescriptorVisibility(), descriptor.getRanking(), descriptor.isProxiable(), descriptor.getClassAnalysisName(), descriptor.getMetadata());
        this.locator = locator;
        this.descriptor = descriptor;
        this.contract = contract;
        this.addAdvertisedContract(contract);
        super.setScope(descriptor.getScope());
    }

    @Override
    public Class<?> getImplementationClass() {
        this.ensureInitialized();
        return this.descriptor.getImplementationClass();
    }

    @Override
    public T create(ServiceHandle<?> root) {
        this.ensureInitialized();
        return this.locator.getServiceHandle(this.descriptor).getService();
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String getImplementation() {
        return this.descriptor.getImplementation();
    }

    @Override
    public Set<Type> getContractTypes() {
        this.ensureInitialized();
        return super.getContractTypes();
    }

    @Override
    public Class<? extends Annotation> getScopeAnnotation() {
        this.ensureInitialized();
        return this.descriptor.getScopeAnnotation();
    }

    @Override
    public Set<Annotation> getQualifierAnnotations() {
        this.ensureInitialized();
        if (this.qualifiers == null) {
            this.qualifiers = new HashSet<Annotation>(this.descriptor.getQualifierAnnotations());
            if (this.getName() != null) {
                this.qualifiers.add(new NamedImpl(this.getName()));
            }
        }
        return this.qualifiers;
    }

    @Override
    public List<Injectee> getInjectees() {
        this.ensureInitialized();
        return this.descriptor.getInjectees();
    }

    @Override
    public void dispose(T instance) {
        this.ensureInitialized();
        this.descriptor.dispose(instance);
    }

    public ActiveDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    private synchronized void ensureInitialized() {
        if (!this.initialized) {
            if (!this.descriptor.isReified()) {
                this.descriptor = this.locator.reifyDescriptor(this.descriptor);
            }
            if (this.contract == null) {
                this.initialized = true;
                return;
            }
            HK2Loader loader = this.descriptor.getLoader();
            Class<?> contractType = null;
            try {
                if (loader != null) {
                    contractType = loader.loadClass(this.contract);
                } else {
                    Class<?> ic = this.descriptor.getImplementationClass();
                    ClassLoader cl = null;
                    if (ic != null) {
                        cl = ic.getClassLoader();
                    }
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    contractType = cl.loadClass(this.contract);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            super.addContractType(contractType);
            this.initialized = true;
        }
    }
}

