/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import java.util.logging.Level;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

class TransactedSubscriber
implements MessageListener {
    private String _subid = null;
    private StompTransactedSession _parent = null;
    private MessageConsumer _subscriber = null;
    private String _duraName = null;

    public TransactedSubscriber(String subid, MessageConsumer sub, String duraname, StompTransactedSession parent) throws Exception {
        this._subid = subid;
        this._subscriber = sub;
        this._parent = parent;
        this._duraName = duraname;
        this._subscriber.setMessageListener(this);
    }

    public String getDuraName() {
        return this._duraName;
    }

    public void startMessageDelivery() throws Exception {
        this._subscriber.setMessageListener(this);
    }

    @Override
    public void onMessage(Message msg) {
        try {
            this._parent._logger.log(Level.FINE, "onMessage message " + msg.getJMSMessageID() + " for STOMP subscriber " + this._subid);
            this._parent.enqueue(this._subid, msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void close() throws Exception {
        this._subscriber.close();
    }
}

