/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Password {
    private static boolean DEBUG = Boolean.getBoolean("imq.debug.com.sun.messaging.jmq.util.Password");
    private static boolean useNative = false;
    private static final String library = "imqutil";

    private native String getHiddenPassword();

    public boolean echoPassword() {
        return !this.hasJavaConsole() && !useNative;
    }

    private boolean hasJavaConsole() {
        try {
            Class<?> consolec = Class.forName("java.io.Console");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String getPasswordFromJavaConsole() {
        if (DEBUG) {
            System.err.println("use java.io.Console");
        }
        try {
            Class<?> consolec = Class.forName("java.io.Console");
            Method sysm = System.class.getMethod("console", null);
            Method consolem = consolec.getMethod("readPassword", null);
            Object console = sysm.invoke(null, (Object[])null);
            if (console == null) {
                throw new Exception("Console not available");
            }
            char[] password = (char[])consolem.invoke(console, (Object[])null);
            if (password == null) {
                return null;
            }
            String pw = new String(password);
            Arrays.fill(password, ' ');
            password = null;
            return pw;
        }
        catch (Throwable e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private String getClearTextPassword() {
        String s = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            s = in.readLine();
        }
        catch (IOException exc) {
            System.err.println("Caught exception when reading passwd: " + exc);
        }
        return s;
    }

    public String getPassword() {
        if (this.hasJavaConsole()) {
            return this.getPasswordFromJavaConsole();
        }
        if (useNative) {
            return this.getHiddenPassword();
        }
        return this.getClearTextPassword();
    }

    public static void main(String[] args) {
        boolean clearText = false;
        boolean normal = false;
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("-c")) {
                clearText = true;
            }
            if (args[0].equalsIgnoreCase("-n")) {
                normal = true;
            }
        }
        Password pw = new Password();
        System.out.print("Enter password: ");
        String s = normal ? pw.getPassword() : (clearText ? pw.getClearTextPassword() : pw.getHiddenPassword());
        System.err.println("");
        System.out.println("Password enterd is: " + s);
    }

    static {
        try {
            System.loadLibrary(library);
            useNative = true;
        }
        catch (Throwable ex) {
            useNative = false;
        }
    }
}

