/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.admin;

import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.AdminInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class DestinationInfo
extends AdminInfo
implements Serializable {
    static final long serialVersionUID = 7043096792121903858L;
    public int nMessages;
    public long nMessageBytes;
    public int nConsumers;
    public int nProducers;
    public int naConsumers;
    public int nfConsumers;
    public boolean autocreated;
    public int destState;
    public String name;
    public int type;
    public int fulltype;
    public int maxMessages;
    public long maxMessageBytes;
    public long maxMessageSize;
    public int destScope;
    public int destLimitBehavior;
    public int maxPrefetch;
    public int destCDP;
    public int maxActiveConsumers;
    public int maxFailoverConsumers;
    public int maxProducers;
    public int maxNumSharedConsumers;
    public int sharedConsumerFlowLimit;
    public boolean useDMQ;
    public int nUnackMessages;
    public int nInDelayMessages;
    public long nInDelayMessageBytes;
    public int nTxnMessages;
    public long nTxnMessageBytes;
    public Hashtable consumerWildcards;
    public Hashtable producerWildcards;
    public boolean validateXMLSchemaEnabled;
    public String XMLSchemaUriList;
    public boolean reloadXMLSchemaOnFailure;
    public int nRemoteMessages;
    public long nRemoteMessageBytes;
    public static final int NAME = 1;
    public static final int TYPE = 2;
    public static final int MAX_MESSAGES = 4;
    public static final int MAX_MESSAGE_BYTES = 8;
    public static final int MAX_MESSAGE_SIZE = 16;
    public static final int DEST_SCOPE = 32;
    public static final int DEST_LIMIT = 64;
    public static final int DEST_PREFETCH = 128;
    public static final int DEST_CDP = 256;
    public static final int MAX_ACTIVE_CONSUMERS = 512;
    public static final int MAX_FAILOVER_CONSUMERS = 1024;
    public static final int MAX_PRODUCERS = 2048;
    public static final int MAX_SHARED_CONSUMERS = 4096;
    public static final int SHARE_FLOW_LIMIT = 8192;
    public static final int USE_DMQ = 16384;
    public static final int VALIDATE_XML_SCHEMA_ENABLED = 32768;
    public static final int XML_SCHEMA_URI_LIST = 65536;
    public static final int RELOAD_XML_SCHEMA_ON_FAILURE = 131072;

    public DestinationInfo() {
        this.reset();
    }

    @Override
    public void reset() {
        this.name = null;
        this.type = 0;
        this.nMessages = 0;
        this.nMessageBytes = 0L;
        this.nConsumers = 0;
        this.nfConsumers = 0;
        this.autocreated = false;
        this.maxMessages = 0;
        this.maxMessageBytes = 0L;
        this.maxMessageSize = 0L;
        this.destState = 0;
        this.destScope = 0;
        this.destLimitBehavior = 0;
        this.maxPrefetch = 0;
        this.destCDP = 0;
        this.maxActiveConsumers = 0;
        this.maxFailoverConsumers = 0;
        this.maxProducers = 0;
        this.maxNumSharedConsumers = 0;
        this.sharedConsumerFlowLimit = 0;
        this.useDMQ = true;
        this.nUnackMessages = 0;
        this.nTxnMessages = 0;
        this.nTxnMessageBytes = 0L;
        this.consumerWildcards = null;
        this.producerWildcards = null;
        this.validateXMLSchemaEnabled = false;
        this.XMLSchemaUriList = null;
        this.reloadXMLSchemaOnFailure = false;
        this.nRemoteMessages = 0;
        this.nRemoteMessageBytes = 0L;
    }

    public String toString() {
        return this.name + ": " + DestType.toString(this.type) + ", " + this.nConsumers + " consumers, " + this.nMessages + " messages (" + this.maxMessages + " max), " + this.nMessageBytes + " bytes (" + this.maxMessageBytes + "max)";
    }

    public void setName(String name) {
        this.name = name;
        this.setModified(1);
    }

    public void setType(int type) {
        this.type = type;
        this.setModified(2);
    }

    public void setMaxMessages(int n) {
        this.maxMessages = n;
        this.setModified(4);
    }

    public void setMaxMessageBytes(long n) {
        this.maxMessageBytes = n;
        this.setModified(8);
    }

    public void setMaxMessageSize(long n) {
        this.maxMessageSize = n;
        this.setModified(16);
    }

    public void setScope(int n) {
        this.destScope = n;
        this.setModified(32);
    }

    public void setLimitBehavior(int n) {
        this.destLimitBehavior = n;
        this.setModified(64);
    }

    public void setPrefetch(int n) {
        this.maxPrefetch = n;
        this.setModified(128);
    }

    public void setClusterDeliveryPolicy(int n) {
        this.destCDP = n;
        this.setModified(256);
    }

    public void setScope(boolean local) {
        this.destScope = local ? 0 : 1;
        this.setModified(32);
    }

    public boolean isDestinationLocal() {
        return this.destScope == 0;
    }

    public void setMaxActiveConsumers(int num) {
        this.maxActiveConsumers = num;
        this.setModified(512);
    }

    public void setMaxFailoverConsumers(int num) {
        this.maxFailoverConsumers = num;
        this.setModified(1024);
    }

    public void setMaxProducers(int num) {
        this.maxProducers = num;
        this.setModified(2048);
    }

    public void setMaxNumSharedConsumers(int num) {
        this.maxNumSharedConsumers = num;
        this.setModified(4096);
    }

    public void setSharedConsumerFlowLimit(int num) {
        this.sharedConsumerFlowLimit = num;
        this.setModified(8192);
    }

    public void setUseDMQ(boolean b) {
        this.useDMQ = b;
        this.setModified(16384);
    }

    public boolean useDMQ() {
        return this.useDMQ;
    }

    public void setValidateXMLSchemaEnabled(boolean b) {
        this.validateXMLSchemaEnabled = b;
        this.setModified(32768);
    }

    public boolean validateXMLSchemaEnabled() {
        return this.validateXMLSchemaEnabled;
    }

    public void setXMLSchemaUriList(String s) {
        this.XMLSchemaUriList = s;
        this.setModified(65536);
    }

    public void setReloadXMLSchemaOnFailure(boolean b) {
        this.reloadXMLSchemaOnFailure = b;
        this.setModified(131072);
    }

    public boolean reloadXMLSchemaOnFailure() {
        return this.reloadXMLSchemaOnFailure;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.fulltype == 0) {
            this.fulltype = this.type;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultWriteObject();
    }
}

