/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap
implements Map {
    String name = "Unknown";
    HashMap baseMap = new HashMap();
    private ReferenceQueue myqueue = new ReferenceQueue();
    private transient Collection values = null;
    private transient Set entrySet = null;

    public WeakValueHashMap(String name) {
        this.name = name;
    }

    public String toString() {
        return "WeakValueHashMap(" + this.name + ")";
    }

    private void cleanupMap() {
        Reference r;
        while ((r = this.myqueue.poll()) != null) {
            MyWeakValueReference wr = (MyWeakValueReference)r;
            this.baseMap.remove(wr.getOriginalKey());
        }
    }

    @Override
    public int size() {
        this.cleanupMap();
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanupMap();
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        WeakReference k = (WeakReference)this.baseMap.get(key);
        return k != null && !k.isEnqueued();
    }

    @Override
    public boolean containsValue(Object value) {
        this.cleanupMap();
        return this.baseMap.containsValue(value);
    }

    public Object get(Object key) {
        this.cleanupMap();
        Reference ref = (Reference)this.baseMap.get(key);
        return ref == null ? null : (ref.isEnqueued() ? null : ref.get());
    }

    public Object put(Object key, Object value) {
        this.cleanupMap();
        MyWeakValueReference ref = new MyWeakValueReference(key, value, this.myqueue);
        WeakReference oldref = this.baseMap.put(key, ref);
        return oldref == null ? null : (oldref.isEnqueued() ? null : oldref.get());
    }

    public Object remove(Object key) {
        this.cleanupMap();
        WeakReference ref = (WeakReference)this.baseMap.remove(key);
        return ref == null ? null : ref.get();
    }

    public void putAll(Map t) {
        this.cleanupMap();
        this.baseMap.putAll(t);
    }

    @Override
    public void clear() {
        this.cleanupMap();
        this.baseMap.clear();
    }

    public Set keySet() {
        this.cleanupMap();
        return this.baseMap.keySet();
    }

    public Collection values() {
        this.cleanupMap();
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        this.cleanupMap();
        Set vs = this.entrySet;
        return vs != null ? vs : (this.entrySet = new EntrySet());
    }

    @Override
    public boolean equals(Object o) {
        this.cleanupMap();
        if (o instanceof WeakValueHashMap) {
            return this.baseMap.equals(((WeakValueHashMap)o).baseMap);
        }
        return this.baseMap.equals(o);
    }

    @Override
    public int hashCode() {
        this.cleanupMap();
        return this.baseMap.hashCode();
    }

    public static void main(String[] args) {
        int i;
        WeakValueHashMap hm = new WeakValueHashMap("test");
        Object key1 = new Object();
        Object key2 = new Object();
        String value1 = "value1";
        String value2 = "value2";
        hm.put(key1, value1);
        hm.put(key2, value2);
        for (i = 0; i < 10; ++i) {
            System.gc();
        }
        System.out.println("K1 get " + hm.get(key1));
        System.out.println("K2 get " + hm.get(key2));
        value2 = null;
        value1 = null;
        for (i = 0; i < 100; ++i) {
            System.gc();
        }
        System.out.println("K1 get " + hm.get(key1));
        System.out.println("K2 get " + hm.get(key2));
    }

    static class WeakValueEntry
    implements Map.Entry {
        Object key = null;
        Object value = null;

        public WeakValueEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new newEntryIterator(WeakValueHashMap.this.baseMap.entrySet().iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueHashMap.this.containsKey(e.getKey());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakValueHashMap.this.clear();
        }
    }

    private class newEntryIterator
    implements Iterator {
        Map.Entry nextentry = null;
        Iterator itr = null;

        public newEntryIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            if (this.nextentry != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            Map.Entry mentry = (Map.Entry)this.itr.next();
            WeakReference nextref = (WeakReference)mentry.getValue();
            while (nextref.isEnqueued()) {
                this.itr.remove();
                mentry = (Map.Entry)this.itr.next();
                nextref = (WeakReference)mentry.getValue();
            }
            if (nextref != null) {
                this.nextentry = new WeakValueEntry(mentry.getKey(), nextref.get());
            }
            return this.nextentry != null;
        }

        public Object next() {
            if (this.nextentry == null && !this.hasNext()) {
                return null;
            }
            Map.Entry returnval = this.nextentry;
            this.nextentry = null;
            return returnval;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator(WeakValueHashMap.this.baseMap.values().iterator());
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakValueHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakValueHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private static class ValueIterator
    implements Iterator {
        WeakReference next = null;
        Iterator itr = null;

        public ValueIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            this.next = (WeakReference)this.itr.next();
            while (this.next.isEnqueued()) {
                this.itr.remove();
                if (this.itr.hasNext()) {
                    this.next = (WeakReference)this.itr.next();
                    continue;
                }
                this.next = null;
                break;
            }
            return this.next != null;
        }

        public Object next() {
            if (this.next == null && !this.hasNext()) {
                return null;
            }
            while (this.next.isEnqueued()) {
                this.itr.remove();
                this.next = null;
                if (this.hasNext()) continue;
            }
            Object refval = this.next == null ? null : this.next.get();
            this.next = null;
            return refval;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static class MyWeakValueReference
    extends WeakReference {
        Object mykey = null;

        public MyWeakValueReference(Object key, Object value, ReferenceQueue q) {
            super(value, q);
            this.mykey = key;
        }

        public int hashCode() {
            return this.mykey.hashCode();
        }

        public Object getOriginalKey() {
            return this.mykey;
        }

        public String toString() {
            return this.mykey.toString();
        }
    }
}

