/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.FrameParseException;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class StompFrameMessage {
    private Logger _logger = null;
    private static final String STOMP_VERSION = "1.0";
    protected static final String HEADER_SEPERATOR = ":";
    private static final String NEWLINESTR = "\n";
    private static final byte NEWLINE_BYTE = 10;
    private static final byte NULL_BYTE = 0;
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    protected static final int MIN_COMMAND_LEN = 3;
    protected static final int MAX_COMMAND_LEN = 1024;
    protected static final int MAX_HEADER_LEN = 10240;
    private static final int MAX_HEADERS = 1000;
    private Command _command = Command.UNKNOWN;
    private ArrayList<String> _requiredHeaders = new ArrayList();
    private LinkedHashMap<String, String> _headers = new LinkedHashMap();
    private Integer _contentLength = null;
    protected ParseStage _parseStage = ParseStage.COMMAND;
    private int _byteBufferPosition = 0;
    private ByteArrayOutputStream _bao = null;
    private byte[] _body = null;
    private Exception _parseException = null;
    private boolean _fatalERROR = false;
    private StompBridgeResources _sbr = null;

    protected StompFrameMessage(Command cmd) {
        this._logger = StompServer.getLogger();
        this._command = cmd;
        this._sbr = StompServer.getStompBridgeResources();
        switch (cmd) {
            case CONNECT: {
                this._requiredHeaders.add("login".toString());
                this._requiredHeaders.add("passcode".toString());
                break;
            }
            case SEND: {
                this._requiredHeaders.add("destination".toString());
            }
        }
    }

    protected void setFatalERROR() {
        this._fatalERROR = true;
    }

    public boolean isFatalERROR() {
        return this._fatalERROR;
    }

    protected Exception getParseException() {
        return this._parseException;
    }

    public Command getCommand() {
        return this._command;
    }

    protected void addHeader(String key, String val) {
        this._headers.put(key, val);
    }

    protected LinkedHashMap<String, String> getHeaders() {
        return this._headers;
    }

    protected String getHeader(String key) {
        return this._headers.get(key);
    }

    protected byte[] getBody() {
        if (this._body != null) {
            return this._body;
        }
        if (this._bao == null) {
            return new byte[0];
        }
        this._body = this._bao.toByteArray();
        return this._body;
    }

    protected String getBodyText() throws FrameParseException {
        String text = "";
        if (this._body != null) {
            try {
                if (this._body != null) {
                    return new String(this._body, "UTF-8");
                }
            }
            catch (Exception e) {
                throw new FrameParseException(e.getMessage(), e);
            }
        }
        if (this._bao == null) {
            return text;
        }
        this._body = this._bao.toByteArray();
        try {
            text = new String(this._body, "UTF-8");
            return text;
        }
        catch (Exception e) {
            throw new FrameParseException(this._sbr.getKString("BSS4010", (Object)this.getCommand(), e.getMessage()));
        }
    }

    private void writeByteToBody(byte b) throws Exception {
        if (this._bao == null) {
            this._bao = this.getContentLength() != -1 ? new ByteArrayOutputStream(this.getContentLength()) : new ByteArrayOutputStream();
        }
        this._bao.write(b);
    }

    protected void setBody(byte[] data) {
        this._body = data;
    }

    protected void writeExceptionToBody(Throwable t) throws Exception {
        if (this._bao == null) {
            this._bao = new ByteArrayOutputStream();
        }
        t.printStackTrace(new PrintStream((OutputStream)this._bao, true, "UTF-8"));
        this.addHeader("content-length", String.valueOf(this.getBodySize()));
    }

    private int getBodySize() {
        if (this._bao == null) {
            return 0;
        }
        return this._bao.size();
    }

    protected void setNextParseStage(ParseStage s) {
        this._parseStage = s;
        if (s == ParseStage.BODY) {
            for (String key : this._requiredHeaders) {
                if (this._headers.get(key) != null || this._parseException != null) continue;
                this._parseException = new FrameParseException(this._sbr.getKString("BSS4011", key, (Object)this.getCommand()));
                this._logger.log(Level.SEVERE, this._parseException.getMessage());
            }
        }
        if (s == ParseStage.DONE) {
            try {
                if (this._bao != null) {
                    this._bao.close();
                }
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in closing ByteArrayOutputStream:" + e.getMessage());
            }
        }
    }

    protected ParseStage getNextParseStage() {
        return this._parseStage;
    }

    private void setByteBufferPosition(int pos) {
        this._byteBufferPosition = pos;
    }

    protected int getByteBufferPosition() {
        return this._byteBufferPosition;
    }

    protected int getContentLength() {
        int len;
        block4: {
            if (this._contentLength != null) {
                return this._contentLength;
            }
            String val = this._headers.get("content-length");
            if (val == null) {
                return -1;
            }
            len = -1;
            try {
                len = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException e) {
                if (this._parseException != null) break block4;
                this._parseException = new FrameParseException(this._sbr.getKString("BSS4012", val, "content-length"));
                len = -1;
                this._logger.log(Level.SEVERE, this._parseException.getMessage());
            }
        }
        this._contentLength = new Integer(len);
        return len;
    }

    public Buffer marshall(MemoryManager mm) throws IOException {
        BufferOutputStream bos = new BufferOutputStream(mm);
        DataOutputStream dos = new DataOutputStream(bos);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append((Object)this.getCommand());
        sbuf.append(NEWLINESTR);
        for (String key : this._headers.keySet()) {
            sbuf.append(key);
            sbuf.append(HEADER_SEPERATOR);
            sbuf.append(this._headers.get(key));
            sbuf.append(NEWLINESTR);
        }
        sbuf.append(NEWLINESTR);
        dos.write(sbuf.toString().getBytes("UTF-8"));
        dos.write(this.getBody());
        dos.write(END_OF_FRAME);
        dos.flush();
        dos.close();
        bos.close();
        Buffer bb = bos.getBuffer();
        bb.flip();
        return bb;
    }

    public void parseHeader(Buffer buf) throws Exception {
        String header = null;
        int pos = buf.position();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "in parseHeader: position=" + buf.position() + ", remaining=" + buf.remaining());
        }
        try {
            while (buf.hasRemaining()) {
                byte[] line = StompFrameMessage.parseLine(buf, 10240);
                if (line == null) {
                    return;
                }
                header = new String(line, "UTF-8");
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "parseHeader: got line byte-length=" + line.length + ", header=:" + header + ", header-length=" + header.length() + ", position=" + buf.position());
                }
                if (header.trim().length() == 0) {
                    this.setNextParseStage(ParseStage.BODY);
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.log(Level.FINEST, "parseHeader: DONE - position=" + buf.position());
                    }
                    return;
                }
                int index = header.indexOf(HEADER_SEPERATOR);
                if (index == -1) {
                    if (this._parseException == null) {
                        this._parseException = new FrameParseException(this._sbr.getKString("BSS4013", header));
                        this._logger.log(Level.SEVERE, this._parseException.getMessage());
                    }
                    index = header.length() - 1;
                }
                String key = header.substring(0, index).trim();
                String val = header.substring(index + 1, header.length()).trim();
                this.addHeader(key, val);
                if (this._headers.size() <= 1000) continue;
                throw new FrameParseException(this._sbr.getKString("BSS4014", 1000));
            }
        }
        catch (Exception e) {
            if (e instanceof FrameParseException) {
                throw e;
            }
            throw new FrameParseException(this._sbr.getKString("BSS4015", header, e.getMessage()), e);
        }
    }

    public void readBody(Buffer buf) throws Exception {
        int clen = this.getContentLength();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "in readBody:contentLen=" + this._contentLength + ", position=" + buf.position() + ", remaining=" + buf.remaining() + ", bodySize=" + this.getBodySize());
        }
        while (buf.hasRemaining()) {
            if (clen != -1 && clen == this.getBodySize()) {
                this._logger.log(Level.FINEST, "Body has beed read!");
                this.setNextParseStage(ParseStage.NULL);
                return;
            }
            byte b = buf.get();
            if (b == 0 && clen == -1) {
                byte bb;
                int pos;
                if (buf.hasRemaining()) {
                    pos = buf.position();
                    bb = buf.get();
                    if (bb != 10 && bb != 13) {
                        buf.position(pos);
                    }
                }
                if (buf.hasRemaining()) {
                    pos = buf.position();
                    bb = buf.get();
                    if (bb != 10) {
                        buf.position(pos);
                    }
                }
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "readBody: DONE - position=" + buf.position() + ", remaining=" + buf.remaining());
                }
                this.setNextParseStage(ParseStage.DONE);
                return;
            }
            this.writeByteToBody(b);
        }
        this._logger.log(Level.FINEST, "leaving readBody(): BODY_SIZE=" + this.getBodySize());
    }

    public void readNULL(Buffer buf) throws Exception {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "in readNULL:" + buf.position() + HEADER_SEPERATOR + buf.remaining());
        }
        if (buf.remaining() <= 0) {
            return;
        }
        byte b = buf.get();
        if (b != 0) {
            throw new FrameParseException(this._sbr.getKString("BSS4016", "content-length " + this.getContentLength()));
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "got NULL readNULL:" + buf.position() + HEADER_SEPERATOR + buf.remaining());
        }
        this.setNextParseStage(ParseStage.DONE);
    }

    public String toString() {
        return (Object)((Object)this._command) + "[" + this._headers + "]";
    }

    public static StompFrameMessage parseCommand(Buffer buf) throws Exception {
        Logger logger = StompServer.logger();
        StompFrameMessage message = null;
        String cmd = "";
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "parseCommand: pos:remaining[" + buf.position() + HEADER_SEPERATOR + buf.remaining() + "]");
        }
        try {
            while (cmd.trim().length() == 0) {
                byte[] line = StompFrameMessage.parseLine(buf, 1024);
                if (line == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "parseCommand: position[" + buf.position() + "] command line not found");
                    }
                    return null;
                }
                cmd = new String(line, "UTF-8");
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, "parseCommand: got line:" + cmd + ", position=" + buf.position());
            }
            if (cmd.startsWith(Command.CONNECT.toString())) {
                message = new StompFrameMessage(Command.CONNECT);
            } else if (cmd.startsWith(Command.SEND.toString())) {
                message = new StompFrameMessage(Command.SEND);
            } else if (cmd.startsWith(Command.SUBSCRIBE.toString())) {
                message = new StompFrameMessage(Command.SUBSCRIBE);
            } else if (cmd.startsWith(Command.ACK.toString())) {
                message = new StompFrameMessage(Command.ACK);
            } else if (cmd.startsWith(Command.UNSUBSCRIBE.toString())) {
                message = new StompFrameMessage(Command.UNSUBSCRIBE);
            } else if (cmd.startsWith(Command.BEGIN.toString())) {
                message = new StompFrameMessage(Command.BEGIN);
            } else if (cmd.startsWith(Command.COMMIT.toString())) {
                message = new StompFrameMessage(Command.COMMIT);
            } else if (cmd.startsWith(Command.ABORT.toString())) {
                message = new StompFrameMessage(Command.ABORT);
            } else if (cmd.startsWith(Command.DISCONNECT.toString())) {
                message = new StompFrameMessage(Command.DISCONNECT);
            } else {
                message = new StompFrameMessage(Command.ERROR);
                String emsg = StompServer.getStompBridgeResources().getKString("BSS4038", cmd);
                message._parseException = new FrameParseException(emsg);
                logger.log(Level.SEVERE, emsg);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "parseCommand: DONE - cmd=" + cmd + ", position=" + buf.position());
            }
            message.setNextParseStage(ParseStage.HEADER);
        }
        catch (Exception e) {
            if (e instanceof FrameParseException) {
                throw e;
            }
            throw new FrameParseException(e.getMessage(), e);
        }
        return message;
    }

    private static byte[] parseLine(Buffer buf, int maxbytes) throws Exception {
        Logger logger = StompServer.logger();
        byte[] line = new byte[maxbytes];
        int pos = buf.position();
        boolean foundline = false;
        int i = 0;
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (b == 10) {
                foundline = true;
                break;
            }
            line[i++] = b;
            if (i < maxbytes - 1) continue;
            throw new FrameParseException(StompServer.getStompBridgeResources().getKString("BSS4017", maxbytes));
        }
        if (!foundline) {
            buf.position(pos);
            return null;
        }
        byte[] tmp = new byte[i];
        System.arraycopy(line, 0, tmp, 0, i);
        return tmp;
    }

    protected static enum ParseStage {
        COMMAND,
        HEADER,
        BODY,
        NULL,
        DONE;

    }

    public static enum AckHeader {

        static final String MESSAGEID = "message-id";
    }

    public static enum ConnectedHeader {

        static final String SESSION = "session";
    }

    public static enum ErrorHeader {

        static final String MESSAGE = "message";
    }

    public static enum ConnectHeader {

        static final String LOGIN = "login";
        static final String PASSCODE = "passcode";
        static final String CLIENTID = "client-id";
        static final String VERSION = "version";
    }

    public static enum UnsubscribeHeader {

        static final String DESTINATION = "destination";
        static final String ID = "id";
    }

    public static enum AckMode {

        static final String AUTO = "auto";
        static final String CLIENT = "client";
    }

    public static enum SubscribeHeader {

        static final String DESTINATION = "destination";
        static final String SELECTOR = "selector";
        static final String ACK = "ack";
        static final String ID = "id";
        static final String DURASUBNAME = "durable-subscriber-name";
        static final String NOLOCAL = "no-local";
    }

    public static enum MessageHeader {

        static final String DESTINATION = "destination";
        static final String MESSAGEID = "message-id";
        static final String TIMESTAMP = "timestamp";
        static final String EXPIRES = "expires";
        static final String PRORITY = "priority";
        static final String REDELIVERED = "redelivered";
        static final String TYPE = "type";
        static final String REPLYTO = "reply-to";
        static final String CORRELATIONID = "correlation-id";
        static final String SUBSCRIPTION = "subscription";
    }

    public static enum SendHeader {

        static final String DESTINATION = "destination";
        static final String EXPIRES = "expires";
        static final String PRIORITY = "priority";
        static final String TYPE = "type";
        static final String PERSISTENT = "persistent";
        static final String REPLYTO = "reply-to";
        static final String CORRELATIONID = "correlation-id";
    }

    public static enum ResponseCommonHeader {

        static final String RECEIPTID = "receipt-id";
    }

    public static enum CommonHeader {

        static final String RECEIPT = "receipt";
        static final String TRANSACTION = "transaction";
        static final String CONTENTLENGTH = "content-length";
    }

    public static enum Command {
        CONNECT,
        SEND,
        DISCONNECT,
        SUBSCRIBE,
        UNSUBSCRIBE,
        BEGIN,
        COMMIT,
        ABORT,
        ACK,
        UNKNOWN,
        CONNECTED,
        MESSAGE,
        RECEIPT,
        ERROR;

    }
}

