/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdException;
import com.sun.messaging.jmq.admin.apps.broker.CommonHelpPrinter;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import com.sun.messaging.jmq.util.PassfileObfuscatorImpl;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CommonCmdRunnerUtil {
    private static AdminResources ar = Globals.getAdminResources();

    public static void printBrokerBusyEvent(CommonCmdStatusEvent be) {
        int numRetriesAttempted = be.getNumRetriesAttempted();
        int maxNumRetries = be.getMaxNumRetries();
        long retryTimeount = be.getRetryTimeount();
        Object[] args = new Object[]{Integer.toString(numRetriesAttempted), Integer.toString(maxNumRetries), Long.toString(retryTimeount)};
        String s = ar.getString("A1350", args);
        CommonGlobals.stdOutPrintln(s);
    }

    public static String getTimeString(long millis) {
        String ret = null;
        if (millis < 1000L) {
            ret = millis + " milliseconds";
        } else if (millis < 60000L) {
            long seconds = millis / 1000L;
            ret = seconds + " seconds";
        } else if (millis < 3600000L) {
            long mins = millis / 60000L;
            ret = mins + " minutes";
        } else {
            ret = "> 1 hour";
        }
        return ret;
    }

    public static String getRateString(long latest, long previous, float secs) {
        String rateString = "";
        long diff = latest - previous;
        long rate = (long)((float)diff / secs);
        rateString = rate == 0L ? (diff != 0L ? "< 1" : "0") : Long.toString(rate);
        return rateString;
    }

    public static String displayInKBytes(long l) {
        if (l == 0L) {
            return "0";
        }
        if (l < 1024L) {
            return "< 1";
        }
        return Long.toString(l / 1024L);
    }

    public static void printDebugHash(Hashtable hash) {
        DebugPrinter dbp = new DebugPrinter(hash, 4);
        dbp.println();
        dbp.close();
    }

    public static String getBrokerHost(String brokerHostPort) {
        String host = brokerHostPort;
        if (brokerHostPort == null) {
            return null;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            host = brokerHostPort.substring(0, i);
        }
        if (host == null || host.equals("")) {
            return null;
        }
        return host;
    }

    public static int getBrokerPort(String brokerHostPort) throws BrokerAdminException {
        int port = -1;
        if (brokerHostPort == null) {
            return port;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            try {
                port = Integer.parseInt(brokerHostPort.substring(i + 1));
            }
            catch (Exception e) {
                throw new BrokerAdminException(8);
            }
        }
        return port;
    }

    public static void printBrokerAdminException(BrokerAdminException bae, String brokerHostPortOption, boolean debugMode) {
        Exception e = bae.getLinkedException();
        int type = bae.getType();
        switch (type) {
            case 0: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", bae.getBrokerHost(), bae.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                CommonGlobals.stdErrPrintln(ar.getString("A3139", brokerHostPortOption));
                break;
            }
            case 1: {
                CommonGlobals.stdErrPrintln(ar.getString("A3121"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 2: {
                CommonGlobals.stdErrPrintln(ar.getString("A3122"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 3: {
                CommonGlobals.stdErrPrintln(ar.getString("A3123"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 4: {
                CommonGlobals.stdErrPrintln(ar.getString("A3124"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 5: {
                CommonGlobals.stdErrPrintln(ar.getString("A3125"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 6: {
                CommonGlobals.stdErrPrintln(ar.getString("A3126"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 7: {
                CommonGlobals.stdErrPrintln(ar.getString("A3127"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                break;
            }
            case 8: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3128"));
                break;
            }
            case 11: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", bae.getBrokerHost(), bae.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                CommonGlobals.stdErrPrintln(ar.getString("A3140"));
                break;
            }
            case 12: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", bae.getBrokerHost(), bae.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                CommonGlobals.stdErrPrintln(ar.getString("A3141"));
                break;
            }
            case 15: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", bae.getBrokerHost(), bae.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(bae, debugMode);
                CommonGlobals.stdErrPrintln(ar.getString("A3154"));
                break;
            }
            case 16: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3167", bae.getBrokerAddress()));
            }
        }
    }

    private static void printBrokerAdminExceptionDetails(BrokerAdminException bae, boolean debugMode) {
        Exception e = bae.getLinkedException();
        String s = bae.getBrokerErrorStr();
        if (s != null) {
            CommonGlobals.stdErrPrintln(s);
        }
        if (e != null) {
            String msg = e.getMessage();
            String s2 = e.toString();
            if (s2 != null) {
                CommonGlobals.stdErrPrintln(s2);
            } else if (msg != null) {
                CommonGlobals.stdErrPrintln(msg);
            }
            if (debugMode) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void printCommonCmdException(CommonCmdException bce) {
        Exception ex = bce.getLinkedException();
        int type = bce.getType();
        switch (type) {
            case 10006: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3161", ex));
                break;
            }
            default: {
                CommonGlobals.stdErrPrintln("Unknown exception caught: " + type);
            }
        }
    }

    public static String getUserInput(String question) {
        return CommonCmdRunnerUtil.getUserInput(question, null);
    }

    public static String getUserInput(String question, String defaultResponse) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            CommonGlobals.stdOutPrint(question);
            String s = in.readLine();
            if (s.equals("") && defaultResponse != null) {
                s = defaultResponse;
            }
            return s;
        }
        catch (IOException ex) {
            CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3081"));
            return null;
        }
    }

    public static String getPassword() {
        Password pw = new Password();
        if (pw.echoPassword()) {
            CommonGlobals.stdOutPrintln(ar.getString("A2015"));
        }
        CommonGlobals.stdOutPrint(ar.getString("A1621"));
        return pw.getPassword();
    }

    public static void printBrokerInfo(BrokerAdminConn broker, MultiColumnPrinter mcp) {
        mcp.setNumCol(2);
        mcp.setGap(4);
        mcp.setBorder("-");
        Object[] row = new String[2];
        row[0] = ar.getString("A1440");
        row[1] = ar.getString("A1441");
        mcp.addTitle((String[])row);
        row[0] = broker.getBrokerHost();
        row[1] = broker.getBrokerPort();
        mcp.add(row);
        mcp.println();
    }

    public static void printAttrs(Properties targetAttrs, boolean printTitle, MultiColumnPrinter mcp) {
        Object[] row = new String[2];
        if (printTitle) {
            mcp.setNumCol(2);
            mcp.setGap(4);
            mcp.setBorder("-");
            row[0] = "Property Name";
            row[1] = "Property Value";
            mcp.addTitle((String[])row);
        } else {
            mcp.setNumCol(2);
            mcp.setGap(4);
        }
        Enumeration<?> e = targetAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = targetAttrs.getProperty(propName);
            row[0] = propName;
            row[1] = value;
            mcp.add(row);
        }
        mcp.println();
    }

    public static String checkNullAndReturnPrint(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public static String checkNullAndReturnPrintTimestamp(Long timestamp) {
        if (timestamp != null) {
            Date d = new Date(timestamp);
            DateFormat df = DateFormat.getDateTimeInstance(3, 2);
            String ts = df.format(d);
            return ts;
        }
        return "";
    }

    public static BrokerAdminConn promptForAuthentication(BrokerAdminConn broker) {
        String usernameValue = broker.getUserName();
        String passwordValue = broker.getPassword();
        boolean carriageReturnNeeded = false;
        if (usernameValue == null) {
            broker.setUserName(CommonCmdRunnerUtil.getUserInput(ar.getString("A1620")));
            carriageReturnNeeded = true;
        }
        if (passwordValue == null) {
            String passwd = CommonCmdRunnerUtil.getPassword();
            broker.setPassword(passwd);
            carriageReturnNeeded = false;
        }
        if (carriageReturnNeeded) {
            CommonGlobals.stdOutPrintln("");
        }
        return broker;
    }

    public static String getPasswordFromFile(String passfile, String passwdPropNameInPassFile, Properties cmdProps) throws CommonCmdException {
        if (passfile != null) {
            String ret = null;
            try {
                Properties props = new Properties();
                PassfileObfuscatorImpl po = new PassfileObfuscatorImpl();
                InputStream fis = po.retrieveObfuscatedFile(passfile, "imq");
                props.load(fis);
                ret = props.getProperty(passwdPropNameInPassFile);
                fis.close();
                if (ret == null) {
                    throw new RuntimeException(ar.getString("A3162", passwdPropNameInPassFile, passfile));
                }
                String keystorepwd = props.getProperty("imq.keystore.password");
                if (keystorepwd != null) {
                    System.setProperty("imqKeyStorePassword", keystorepwd);
                }
                if (!po.isObfuscated(passfile, "imq")) {
                    Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2016", passfile, "'imqusermgr encode'"));
                    Globals.stdErrPrintln("");
                }
            }
            catch (Exception e) {
                CommonCmdException bce = new CommonCmdException(10006);
                bce.setProperties(cmdProps);
                bce.setLinkedException(e);
                throw bce;
            }
            return ret;
        }
        return null;
    }

    public static void handleArgsParsingExceptions(OptionException e, String optionAdminPasswd, String toolName) {
        String option = e.getOption();
        if (e instanceof UnrecognizedOptionException) {
            if (optionAdminPasswd != null && option.equals(optionAdminPasswd)) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3006", option));
            } else {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3001", option, toolName));
            }
        } else if (e instanceof InvalidBasePropNameException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3002", option));
        } else if (e instanceof InvalidHardCodedValueException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3003", option));
        } else if (e instanceof MissingArgException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3004", option, toolName));
        } else if (e instanceof BadNameValueArgException) {
            BadNameValueArgException bnvae = (BadNameValueArgException)e;
            String badArg = bnvae.getArg();
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3005", badArg, option));
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3000"));
        }
    }

    public static void printBanner() {
        Version version = new Version(false);
        CommonGlobals.stdOutPrintln(version.getBanner(false));
    }

    public static void printVersion() {
        Version version = new Version(false);
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
    }

    public static void handleCommonCheckOptionsExceptions(CommonCmdException e, String cmd, String cmdArg, CommonHelpPrinter hp) {
        String errorString = e.getErrorString();
        String badValue = e.getBadValue();
        String[] validCmdArgs = e.getValidCmdArgs();
        int type = e.getType();
        switch (type) {
            case 10000: {
                CommonCmdRunnerUtil.printBanner();
                hp.printShortHelp(1);
                break;
            }
            case 10001: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3021", cmd));
                break;
            }
            case 10003: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3101", cmd, cmdArg));
                if (validCmdArgs == null) break;
                CommonGlobals.stdErrPrintln(ar.getString("A3102", cmd));
                for (int i = 0; i < validCmdArgs.length; ++i) {
                    CommonGlobals.stdErrPrintln("\t" + validCmdArgs[i]);
                }
                break;
            }
            case 10004: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3118", errorString));
                break;
            }
            case 10005: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3158", errorString));
                break;
            }
            case 10007: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3165", badValue));
                break;
            }
            default: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3020"));
            }
        }
    }
}

