/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.util.BytesField;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.apps.console.util.SpecialValueField;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class BrokerDestPropsDialog
extends AdminDialog
implements ActionListener,
ListSelectionListener,
BrokerConstants {
    private static final int UNLIMITED_VALUE_0 = 0;
    private static final int UNLIMITED_VALUE_NEG1 = -1;
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private static String[] columnNames;
    private JTabbedPane tabbedPane;
    private JPanel basicPanel;
    private JPanel durPanel;
    private JLabel destNameValue;
    private JLabel destTypeValue;
    private JLabel destStateValue;
    private JLabel curNumProducers;
    private LabelledComponent curNumProducersLabelC;
    private JLabel curNumActive;
    private LabelledComponent curNumActiveLabelC;
    private JLabel curNumFailover;
    private LabelledComponent curNumFailoverLabelC;
    private JLabel curNumMesgsValue;
    private JLabel curNumMesgBytesValue;
    private IntegerField activeConsumerIF;
    private LabelledComponent activeConsumerLabelC;
    private SpecialValueField activeConsumerSF;
    private IntegerField failoverConsumerIF;
    private LabelledComponent failoverConsumerLabelC;
    private SpecialValueField failoverConsumerSF;
    private IntegerField maxProducerIF;
    private LabelledComponent maxProducerLabelC;
    private SpecialValueField maxProducerSF;
    private BytesField mesgSizeLimitBF;
    private LabelledComponent mesgSizeLimitLabelC;
    private SpecialValueField mesgSizeLimitSF;
    IntegerField mesgLimitIF;
    SpecialValueField mesgLimitSF;
    private LabelledComponent mesgLimitLabelC;
    BytesField maxSizePerMsgBF;
    SpecialValueField maxSizePerMsgSF;
    private PropsTableModel model;
    private JTable table;
    private JScrollPane scrollPane;
    private JButton deleteButton;
    private JButton purgeButton;
    private JComboBox limitBehaviorCb;
    private JCheckBox useDMQCkb;
    private DestinationInfo destInfo;
    private Vector durables;
    private int selectedRow = -1;
    private String selectedDurName = null;
    private String selectedClientID = null;
    private boolean resetScrollbarPolicy = true;

    public BrokerDestPropsDialog(Frame parent) {
        super(parent, acr.getString("A1408"), 81);
        this.setHelpId("broker_destination_properties");
    }

    @Override
    public void doClose() {
        this.hide();
        this.reset();
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doClear() {
    }

    @Override
    public void doCancel() {
        this.hide();
    }

    @Override
    public void doOK() {
        BrokerAdminEvent bae = new BrokerAdminEvent(this, 7);
        DestinationInfo destInfo = this.getUpdateDestinationInfo();
        bae.setDestinationInfo(destInfo);
        bae.setOKAction(true);
        this.fireAdminEventDispatched(bae);
    }

    private DestinationInfo getUpdateDestinationInfo() {
        boolean useDMQ;
        int limitBehavior;
        int activeConsumers = -1;
        int failoverConsumers = -1;
        int maxProducers = -1;
        long mesgSizeLimitValue = -1L;
        int mesgLimitValue = -1;
        long maxSizePerMsgValue = -1L;
        DestinationInfo updateDestInfo = new DestinationInfo();
        if (DestType.isQueue(this.destInfo.type)) {
            activeConsumers = this.activeConsumerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.activeConsumerIF.getText());
            if (activeConsumers != this.destInfo.maxActiveConsumers) {
                updateDestInfo.setMaxActiveConsumers(activeConsumers);
            }
            if ((failoverConsumers = this.failoverConsumerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.failoverConsumerIF.getText())) != this.destInfo.maxFailoverConsumers) {
                updateDestInfo.setMaxFailoverConsumers(failoverConsumers);
            }
        }
        if ((maxProducers = this.maxProducerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.maxProducerIF.getText())) != this.destInfo.maxProducers) {
            updateDestInfo.setMaxProducers(maxProducers);
        }
        if ((mesgSizeLimitValue = this.mesgSizeLimitSF.isSpecialValueSet() ? -1L : this.mesgSizeLimitBF.getValue()) != this.destInfo.maxMessageBytes) {
            updateDestInfo.setMaxMessageBytes(mesgSizeLimitValue);
        }
        if ((mesgLimitValue = this.mesgLimitSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.mesgLimitIF.getText())) != this.destInfo.maxMessages) {
            updateDestInfo.setMaxMessages(mesgLimitValue);
        }
        if ((maxSizePerMsgValue = this.maxSizePerMsgSF.isSpecialValueSet() ? -1L : this.maxSizePerMsgBF.getValue()) != this.destInfo.maxMessageSize) {
            updateDestInfo.setMaxMessageSize(maxSizePerMsgValue);
        }
        if ((limitBehavior = this.getLimitBehavValue((String)this.limitBehaviorCb.getSelectedItem())) != this.destInfo.destLimitBehavior) {
            updateDestInfo.setLimitBehavior(limitBehavior);
        }
        if ((useDMQ = this.useDMQCkb.isSelected()) != this.destInfo.useDMQ()) {
            updateDestInfo.setUseDMQ(useDMQ);
        }
        return updateDestInfo;
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(acr.getString("A1503"), this.makeBasicTab());
        this.tabbedPane.addTab(acr.getString("A1504"), this.makeDurTab());
        workPanel.add(this.tabbedPane);
        return workPanel;
    }

    private JPanel makeBasicTab() {
        LabelledComponent tmpLabelC;
        int i = 0;
        JPanel basicPanel = new JPanel();
        GridBagLayout basicGridbag = new GridBagLayout();
        GridBagConstraints basicConstraints = new GridBagConstraints();
        basicPanel.setLayout(basicGridbag);
        basicConstraints.gridx = 0;
        basicConstraints.anchor = 17;
        basicConstraints.fill = 0;
        basicConstraints.insets = new Insets(10, 0, 10, 0);
        basicConstraints.ipadx = 0;
        basicConstraints.ipady = 0;
        basicConstraints.weightx = 1.0;
        LabelledComponent[] lvpItems = new LabelledComponent[3];
        this.destNameValue = new JLabel();
        lvpItems[0] = tmpLabelC = new LabelledComponent(acr.getString("A1424"), this.destNameValue);
        this.destTypeValue = new JLabel();
        lvpItems[1] = tmpLabelC = new LabelledComponent(acr.getString("A1425"), this.destTypeValue);
        this.destStateValue = new JLabel();
        lvpItems[2] = tmpLabelC = new LabelledComponent(acr.getString("A1463") + ":", this.destStateValue);
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 0;
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 3);
        basicGridbag.setConstraints(lvp, basicConstraints);
        basicPanel.add(lvp);
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 1;
        basicConstraints.insets = new Insets(0, 0, 0, 0);
        basicConstraints.fill = 2;
        JSeparator separator = new JSeparator();
        basicGridbag.setConstraints(separator, basicConstraints);
        basicPanel.add(separator);
        basicConstraints.gridwidth = 1;
        basicConstraints.fill = 0;
        lvpItems = new LabelledComponent[5];
        this.curNumMesgsValue = new JLabel();
        tmpLabelC = new LabelledComponent(acr.getString("A1435"), this.curNumMesgsValue);
        lvpItems[i++] = tmpLabelC;
        this.curNumMesgBytesValue = new JLabel();
        tmpLabelC = new LabelledComponent(acr.getString("A1436"), (JComponent)this.curNumMesgBytesValue, acr.getString("A1221"));
        lvpItems[i++] = tmpLabelC;
        this.curNumProducers = new JLabel();
        this.curNumProducersLabelC = new LabelledComponent(acr.getString("A1467"), this.curNumProducers);
        lvpItems[i++] = this.curNumProducersLabelC;
        this.curNumActive = new JLabel();
        this.curNumActiveLabelC = new LabelledComponent(acr.getString("A1464"), this.curNumActive);
        lvpItems[i++] = this.curNumActiveLabelC;
        this.curNumFailover = new JLabel();
        this.curNumFailoverLabelC = new LabelledComponent(acr.getString("A1465"), this.curNumFailover);
        lvpItems[i++] = this.curNumFailoverLabelC;
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 2;
        basicConstraints.insets = new Insets(10, 0, 10, 0);
        lvp = new LabelValuePanel(lvpItems, 4, 5);
        basicGridbag.setConstraints(lvp, basicConstraints);
        basicPanel.add(lvp);
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 3;
        basicConstraints.insets = new Insets(0, 0, 0, 0);
        basicConstraints.fill = 2;
        separator = new JSeparator();
        basicGridbag.setConstraints(separator, basicConstraints);
        basicPanel.add(separator);
        basicConstraints.gridwidth = 1;
        basicConstraints.fill = 0;
        i = 0;
        lvpItems = new LabelledComponent[6];
        this.mesgLimitIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.mesgLimitSF = new SpecialValueField(this.mesgLimitIF, acr.getString("A1433"));
        this.mesgLimitLabelC = new LabelledComponent(acr.getString("A1431"), (JComponent)this.mesgLimitSF, 0);
        lvpItems[i++] = this.mesgLimitLabelC;
        this.mesgSizeLimitBF = new BytesField(0L, Long.MAX_VALUE, 11);
        this.mesgSizeLimitSF = new SpecialValueField(this.mesgSizeLimitBF, acr.getString("A1433"));
        this.mesgSizeLimitLabelC = new LabelledComponent(acr.getString("A1430"), (JComponent)this.mesgSizeLimitSF, 0);
        lvpItems[i++] = this.mesgSizeLimitLabelC;
        this.maxSizePerMsgBF = new BytesField(0L, Long.MAX_VALUE, 11);
        this.maxSizePerMsgSF = new SpecialValueField(this.maxSizePerMsgBF, acr.getString("A1433"));
        tmpLabelC = new LabelledComponent(acr.getString("A1432"), (JComponent)this.maxSizePerMsgSF, 0);
        lvpItems[i++] = tmpLabelC;
        this.maxProducerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.maxProducerSF = new SpecialValueField(this.maxProducerIF, acr.getString("A1433"));
        this.maxProducerLabelC = new LabelledComponent(acr.getString("A1466"), (JComponent)this.maxProducerSF, 0);
        lvpItems[i++] = this.maxProducerLabelC;
        this.activeConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.activeConsumerSF = new SpecialValueField(this.activeConsumerIF, acr.getString("A1433"));
        this.activeConsumerLabelC = new LabelledComponent(acr.getString("A1459"), (JComponent)this.activeConsumerSF, 0);
        lvpItems[i++] = this.activeConsumerLabelC;
        this.failoverConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.failoverConsumerSF = new SpecialValueField(this.failoverConsumerIF, acr.getString("A1433"));
        this.failoverConsumerLabelC = new LabelledComponent(acr.getString("A1460"), (JComponent)this.failoverConsumerSF, 0);
        lvpItems[i++] = this.failoverConsumerLabelC;
        lvp = new LabelValuePanel(lvpItems, 4, 5);
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 4;
        basicConstraints.insets = new Insets(10, 0, 10, 0);
        basicGridbag.setConstraints(lvp, basicConstraints);
        basicPanel.add(lvp);
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 5;
        basicConstraints.insets = new Insets(0, 0, 0, 0);
        basicConstraints.fill = 2;
        separator = new JSeparator();
        basicGridbag.setConstraints(separator, basicConstraints);
        basicPanel.add(separator);
        basicConstraints.gridwidth = 1;
        basicConstraints.fill = 0;
        i = 0;
        lvpItems = new LabelledComponent[2];
        this.limitBehaviorCb = new JComboBox<String>(BKR_LIMIT_BEHAV_VALID_VALUES);
        tmpLabelC = new LabelledComponent(acr.getString("A1469"), this.limitBehaviorCb);
        lvpItems[i++] = tmpLabelC;
        this.useDMQCkb = new JCheckBox();
        tmpLabelC = new LabelledComponent(acr.getString("A1470"), this.useDMQCkb);
        lvpItems[i++] = tmpLabelC;
        basicConstraints.gridx = 0;
        basicConstraints.gridy = 6;
        basicConstraints.insets = new Insets(10, 0, 10, 0);
        lvp = new LabelValuePanel(lvpItems, 4, 2);
        basicGridbag.setConstraints(lvp, basicConstraints);
        basicPanel.add(lvp);
        return basicPanel;
    }

    private JPanel makeDurTab() {
        JPanel durPanel = new JPanel();
        GridBagLayout durGridbag = new GridBagLayout();
        GridBagConstraints durConstraints = new GridBagConstraints();
        durPanel.setLayout(durGridbag);
        int colWidth = 0;
        int tmpWidth = 0;
        int maxWidth = 0;
        for (int i = 0; i < columnNames.length; ++i) {
            JLabel tmpLabel = new JLabel(columnNames[i]);
            tmpWidth = tmpLabel.getPreferredSize().width;
            if (tmpWidth <= maxWidth) continue;
            maxWidth = tmpWidth;
        }
        colWidth = maxWidth * columnNames.length;
        this.model = new PropsTableModel();
        this.table = new JTable(this.model);
        int w2 = this.table.getColumnModel().getTotalColumnWidth();
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.table, 22, 30);
        this.table.setPreferredScrollableViewportSize(new Dimension(colWidth, 21 * this.table.getRowHeight()));
        durConstraints.gridx = 0;
        durConstraints.gridy = 0;
        durGridbag.setConstraints(this.scrollPane, durConstraints);
        durPanel.add(this.scrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.deleteButton = new JButton(acr.getString("A1133"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this);
        buttonPanel.add(this.deleteButton);
        this.purgeButton = new JButton(acr.getString("A1114"));
        this.purgeButton.setEnabled(false);
        this.purgeButton.addActionListener(this);
        buttonPanel.add(this.purgeButton);
        durConstraints.gridx = 0;
        durConstraints.gridy = 1;
        durConstraints.anchor = 13;
        durConstraints.insets = new Insets(0, 5, 0, 0);
        durGridbag.setConstraints(buttonPanel, durConstraints);
        durPanel.add(buttonPanel);
        return durPanel;
    }

    public void show(DestinationInfo destInfo, Vector durables) {
        int value;
        this.destInfo = destInfo;
        this.durables = durables;
        this.reset();
        if (DestType.isQueue(destInfo.type)) {
            this.tabbedPane.setEnabledAt(1, false);
            this.setActiveConsumersEnabled(true);
            this.setFailoverConsumersEnabled(true);
            this.curNumFailoverLabelC.setEnabled(true);
            this.curNumFailover.setEnabled(true);
            value = destInfo.maxActiveConsumers;
            if (value != -1) {
                this.activeConsumerIF.setText(String.valueOf(value));
            }
            this.checkUnlimitedNeg1(this.activeConsumerSF, value);
            value = destInfo.maxFailoverConsumers;
            if (value != -1) {
                this.failoverConsumerIF.setText(String.valueOf(value));
            }
            this.checkUnlimitedNeg1(this.failoverConsumerSF, value);
            this.curNumActiveLabelC.setLabelText(acr.getString("A1464"));
            this.curNumActive.setText(String.valueOf(destInfo.naConsumers));
        } else if (DestType.isTopic(destInfo.type)) {
            this.tabbedPane.setEnabledAt(1, true);
            this.setActiveConsumersEnabled(false);
            this.setFailoverConsumersEnabled(false);
            this.curNumFailoverLabelC.setEnabled(false);
            this.curNumFailover.setEnabled(false);
            this.curNumActiveLabelC.setLabelText(acr.getString("A1468"));
            this.curNumActive.setText(String.valueOf(destInfo.nConsumers));
        }
        this.destNameValue.setText(destInfo.name);
        this.destTypeValue.setText(BrokerAdminUtil.getDestinationType(destInfo.type));
        this.destStateValue.setText(BrokerAdminUtil.getDestinationState(destInfo.destState));
        this.curNumProducers.setText(String.valueOf(destInfo.nProducers));
        this.curNumFailover.setText(String.valueOf(destInfo.nfConsumers));
        this.curNumMesgsValue.setText(String.valueOf(destInfo.nMessages));
        this.curNumMesgBytesValue.setText(String.valueOf(destInfo.nMessageBytes));
        value = destInfo.maxProducers;
        if (value != -1) {
            this.maxProducerIF.setText(String.valueOf(value));
        }
        this.checkUnlimitedNeg1(this.maxProducerSF, value);
        long lvalue = destInfo.maxMessageBytes;
        if (lvalue != -1L) {
            this.mesgSizeLimitBF.setText(String.valueOf(lvalue));
        }
        this.checkBothUnlimited(this.mesgSizeLimitSF, lvalue);
        value = destInfo.maxMessages;
        if (value != -1) {
            this.mesgLimitIF.setText(String.valueOf(value));
        }
        this.checkBothUnlimited(this.mesgLimitSF, value);
        lvalue = destInfo.maxMessageSize;
        if (lvalue != -1L) {
            this.maxSizePerMsgBF.setText(String.valueOf(lvalue));
        }
        this.checkBothUnlimited(this.maxSizePerMsgSF, lvalue);
        String svalue = DestLimitBehavior.getString(destInfo.destLimitBehavior);
        this.limitBehaviorCb.setSelectedItem(svalue);
        if (destInfo.useDMQ()) {
            this.useDMQCkb.setSelected(true);
        } else {
            this.useDMQCkb.setSelected(false);
        }
        if (DestType.isTopic(destInfo.type)) {
            this.model.fireTableDataChanged();
            this.clearSelection();
        }
        if (this.resetScrollbarPolicy) {
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.resetScrollbarPolicy = false;
        }
        Dimension d = this.table.getPreferredScrollableViewportSize();
        int prefWidth = d.width;
        int totalWidth = this.table.getColumnModel().getTotalColumnWidth();
        if (prefWidth < totalWidth) {
            d.width = totalWidth;
            this.table.setPreferredScrollableViewportSize(d);
        }
        super.show();
    }

    public void refresh(Vector durables) {
        this.durables = durables;
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.clearSelection();
    }

    private void setActiveConsumersEnabled(boolean enable) {
        this.activeConsumerLabelC.setEnabled(enable);
        this.activeConsumerSF.setSpecialValueSet(enable);
        this.activeConsumerIF.setEnabled(enable);
    }

    private void setFailoverConsumersEnabled(boolean enable) {
        this.failoverConsumerLabelC.setEnabled(enable);
        this.failoverConsumerSF.setSpecialValueSet(enable);
        this.failoverConsumerIF.setEnabled(enable);
    }

    private void reset() {
        this.destNameValue.setText("");
        this.destTypeValue.setText("");
        this.destStateValue.setText("");
        this.curNumActive.setText("");
        this.curNumFailover.setText("");
        this.curNumMesgsValue.setText("");
        this.curNumMesgBytesValue.setText("");
        this.activeConsumerSF.setEnabled(true);
        this.activeConsumerSF.setSpecialValueSet(true);
        this.activeConsumerIF.setText("0");
        this.failoverConsumerSF.setEnabled(true);
        this.failoverConsumerSF.setSpecialValueSet(true);
        this.failoverConsumerIF.setText("0");
        this.mesgSizeLimitSF.setEnabled(true);
        this.mesgSizeLimitSF.setSpecialValueSet(true);
        this.mesgSizeLimitBF.setText("0");
        this.mesgSizeLimitBF.setUnit(0);
        this.mesgLimitSF.setEnabled(true);
        this.mesgLimitSF.setSpecialValueSet(true);
        this.mesgLimitIF.setText("0");
        this.maxSizePerMsgSF.setEnabled(true);
        this.maxSizePerMsgSF.setSpecialValueSet(true);
        this.maxSizePerMsgBF.setText("0");
        this.maxSizePerMsgBF.setUnit(0);
        this.limitBehaviorCb.setSelectedItem(BKR_LIMIT_BEHAV_VALID_VALUES[0]);
        this.useDMQCkb.setSelected(true);
        this.clearSelection();
        this.deleteButton.setEnabled(false);
        this.purgeButton.setEnabled(false);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void clearSelection() {
        if (this.table != null) {
            this.table.clearSelection();
        }
        this.deleteButton.setEnabled(false);
        this.purgeButton.setEnabled(false);
        this.selectedRow = -1;
        this.selectedDurName = null;
        this.selectedClientID = null;
    }

    private void doDelete() {
        if (this.selectedRow > -1 && this.selectedDurName != null && this.selectedClientID != null) {
            BrokerAdminEvent bae = new BrokerAdminEvent(this, 5);
            bae.setDurableName(this.selectedDurName);
            bae.setClientID(this.selectedClientID);
            bae.setOKAction(false);
            this.fireAdminEventDispatched(bae);
        }
    }

    private void doPurge() {
        if (this.selectedRow > -1 && this.selectedDurName != null && this.selectedClientID != null) {
            BrokerAdminEvent bae = new BrokerAdminEvent(this, 10);
            bae.setDurableName(this.selectedDurName);
            bae.setClientID(this.selectedClientID);
            bae.setOKAction(false);
            this.fireAdminEventDispatched(bae);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.deleteButton) {
            this.doDelete();
        } else if (source == this.purgeButton) {
            this.doPurge();
        } else {
            super.actionPerformed(e);
        }
    }

    private void checkUnlimited0(SpecialValueField sf, long val) {
        if (this.valueIsUnlimited0(val)) {
            sf.setSpecialValueSet(true);
        } else {
            sf.setSpecialValueSet(false);
        }
    }

    private void checkUnlimitedNeg1(SpecialValueField sf, long val) {
        if (this.valueIsUnlimitedNeg1(val)) {
            sf.setSpecialValueSet(true);
        } else {
            sf.setSpecialValueSet(false);
        }
    }

    private void checkBothUnlimited(SpecialValueField sf, long val) {
        if (this.valueIsUnlimited0(val) || this.valueIsUnlimitedNeg1(val)) {
            sf.setSpecialValueSet(true);
        } else {
            sf.setSpecialValueSet(false);
        }
    }

    private boolean valueIsUnlimited0(long val) {
        return val == 0L;
    }

    private boolean valueIsUnlimitedNeg1(long val) {
        return val == -1L;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String durable;
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        boolean isAdjusting = e.getValueIsAdjusting();
        if (isAdjusting) {
            if (lsm.isSelectionEmpty()) {
                this.deleteButton.setEnabled(false);
                this.purgeButton.setEnabled(false);
            } else {
                this.selectedRow = lsm.getMinSelectionIndex();
                this.selectedDurName = (String)this.model.getValueAt(this.selectedRow, 0);
                this.selectedClientID = (String)this.model.getValueAt(this.selectedRow, 1);
            }
        }
        if ((durable = (String)this.model.getValueAt(this.selectedRow, 2)) != null && durable.trim().toLowerCase().equals("true")) {
            this.deleteButton.setEnabled(true);
            this.purgeButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.purgeButton.setEnabled(false);
        }
    }

    private int getLimitBehavValue(String limitBehavStr) {
        int ret = -1;
        if (limitBehavStr == null) {
            return ret;
        }
        if (limitBehavStr.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            ret = 0;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_OLDEST)) {
            ret = 1;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            ret = 2;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            ret = 3;
        }
        return ret;
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = ar.getString("A1434");
        stringArray2[1] = ar.getString("A1431");
        stringArray2[2] = ar.getString("A1435");
        stringArray2[3] = ar.getString("A1432");
        stringArray2[4] = ar.getString("A1433");
        columnNames = stringArray2;
    }

    class PropsTableModel
    extends AbstractTableModel {
        PropsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (BrokerDestPropsDialog.this.durables == null) {
                return 0;
            }
            return BrokerDestPropsDialog.this.durables.size();
        }

        @Override
        public String getColumnName(int col) {
            return columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (BrokerDestPropsDialog.this.durables == null) {
                return "";
            }
            int i = 0;
            Enumeration e = BrokerDestPropsDialog.this.durables.elements();
            while (e.hasMoreElements()) {
                DurableInfo durInfo = (DurableInfo)e.nextElement();
                if (col == 0 && i == row) {
                    return durInfo.name == null ? "" : durInfo.name;
                }
                if (col == 1 && i == row) {
                    return durInfo.clientID == null ? "" : durInfo.clientID;
                }
                if (col == 2 && i == row) {
                    return String.valueOf(durInfo.isDurable);
                }
                if (col == 3 && i == row) {
                    return new Integer(durInfo.nMessages).toString();
                }
                if (col == 4 && i == row) {
                    if (durInfo.isActive) {
                        AdminResources adminResources = ar;
                        ar;
                        return adminResources.getString("A1510");
                    }
                    AdminResources adminResources = ar;
                    ar;
                    return adminResources.getString("A1511");
                }
                ++i;
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

