/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SupportUtil {
    public static Hashtable getAllStackTracesAsMap() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            Class<Thread> tclass = Thread.class;
            Method m = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.keySet().iterator();
            String retstr = "";
            while (itr.hasNext()) {
                Thread thr = (Thread)itr.next();
                StackTraceElement[] stes = (StackTraceElement[])map.get(thr);
                String name = thr + " 0x" + Long.toHexString(thr.hashCode());
                Vector<String> value = new Vector<String>();
                for (int i = 0; i < stes.length; ++i) {
                    value.add(stes[i].toString());
                }
                ht.put(name, value);
            }
        }
        catch (Throwable thr) {
            ht.put("error", "Can not getStackTrace " + thr);
        }
        return ht;
    }

    public static String getAllStackTraces(String prefix) {
        try {
            Class<Thread> tclass = Thread.class;
            Method m = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.keySet().iterator();
            String retstr = "";
            while (itr.hasNext()) {
                Thread thr = (Thread)itr.next();
                StackTraceElement[] stes = (StackTraceElement[])map.get(thr);
                retstr = retstr + prefix + thr + " 0x" + Long.toHexString(thr.hashCode()) + "\n";
                for (int i = 0; i < stes.length; ++i) {
                    retstr = retstr + prefix + "\t" + stes[i] + "\n";
                }
                retstr = retstr + "\n";
            }
            return retstr;
        }
        catch (Throwable thr) {
            return prefix + "Can not getStackTrace " + thr;
        }
    }

    public static String getStackTrace(String prefix) {
        Thread thr = Thread.currentThread();
        try {
            Class<Thread> tclass = Thread.class;
            Method m = Thread.class.getMethod("getStackTrace", new Class[0]);
            StackTraceElement[] stes = (StackTraceElement[])m.invoke((Object)thr, new Object[0]);
            String retstr = "";
            retstr = retstr + prefix + thr + " 0x" + Long.toHexString(thr.hashCode()) + "\n";
            for (int i = 0; i < stes.length; ++i) {
                retstr = retstr + prefix + "\t" + stes[i] + "\n";
            }
            return retstr;
        }
        catch (Throwable t) {
            return prefix + "Can not getStackTrace " + t;
        }
    }
}

