/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.tunnel.servlet.HttpTunnelServlet;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLinkTable;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpsTunnelServlet
extends HttpTunnelServlet {
    @Override
    public void init() throws ServletException {
        this.servletContext = this.getServletContext();
        this.startTime = new Date();
        this.servletName = "HttpsTunnelServlet";
        try {
            this.linkTable = new ServerLinkTable(this.getServletConfig(), true);
            this.inService = true;
        }
        catch (Exception e) {
            this.initException = e;
            this.servletContext.log(this.servletName + ": initialization failed, " + e);
        }
    }

    @Override
    public void handleTest(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=UTF-8 ");
            PrintWriter pw = response.getWriter();
            pw.println("<HTML>");
            pw.println("<HEAD>");
            pw.println("<TITLE> JMQ HTTPS Tunneling Servlet </TITLE>");
            pw.println("</HEAD>");
            pw.println("<BODY>");
            if (this.inService) {
                pw.println("HTTPS tunneling servlet ready.<BR>");
                pw.println("Servlet Start Time : " + this.startTime + " <BR>");
                pw.println("Accepting secured connections from brokers on port : " + this.linkTable.getServletPort() + " <P>");
                Vector slist = this.linkTable.getServerList();
                pw.println("Total available brokers = " + slist.size() + "<BR>");
                pw.println("Broker List : <BR>");
                pw.println("<BLOCKQUOTE><PRE>");
                for (int i = 0; i < slist.size(); ++i) {
                    pw.println((String)slist.elementAt(i));
                }
                pw.println("</PRE></BLOCKQUOTE>");
            } else {
                pw.println(new Date() + "<br>");
                pw.println("HTTPS Tunneling servlet cannot be started.<br>");
                if (this.initException != null) {
                    pw.println("    " + this.initException);
                }
            }
            pw.println("</BODY>");
            pw.println("</HTML>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

